/* Copyright (C) 1991, 1993 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* uniq.c */
/* A cheap MS-DOS substitute for just enough of the Unix uniq utility. */
#include <stdio.h>
#include <string.h>

/*
 * Usage:
	uniq [input [output]]
 * Eliminates any line in the input that is equal to the previous line.
 */

main(int argc, char *argv[])
{	FILE *in = stdin, *out = stdout;
#define N 200
	char x[N+1], y[N+1];
	char *a = x, *b = y, *t;
	if ( argc > 1 )
	{	in = fopen(argv[1], "r");
		if ( in == 0 )
		{	printf("Can't open input file %s\n", argv[1]);
			exit(1);
		}
	}
	if ( argc > 2 )
	{	out = fopen(argv[2], "w");
		if ( out == 0 )
		{	printf("Can't open output file %s\n", argv[2]);
			if ( in != stdin ) fclose(in);
			exit(1);
		}
	}
	b[0] = 0;
	while ( (*a = 0), fgets(a, N, in), !feof(in) )
	   {	if ( strcmp(a, b) ) fputs(a, out);
		t = a, a = b, b = t;
	   }
	if ( *a && strcmp(a, b) ) fputs(a, out);
	if ( in != stdin ) fclose(in);
	if ( out != stdout ) fclose(out);
	return 0;
}
