/*
 *
 *	A DCL driver for GNU "CC".  It accepts a CLD syntax identical to
 *	VAX-11 "C".
 *
 *	Since GCC consists of more than 1 pass we have to do the parsing
 *	here and have a DCL Command (.COM) file do the real work -- so that
 *	multiple images can be invoked WITHOUT having to resort to LIB$SPAWN.
 */

#include <stddef.h>
#include <string.h>
#define GLOBAL 1
#define LOCAL 0
char *Input_Files[100];		/* Input file specifications */
char *Defines[100];		/* /DEFINE specifications    */
char *Includes[100];		/* /INCLUDE specifications   */
char *Undefines[100];		/* /UNDEFINE specifications  */
char *Scans[100];		/* List of files to scan     */
char *Debug;			/* /DEBUG specification	     */
char *Object =0;		/* Object file name	     */
char *List_File =0;		/* List file name	     */
char *Assembly_File =0;		/* Assembly file name	     */
int Optimize;			/* Do optimized compile	     */
int G_Float=0; 			/* Use G double precision floating */
int Machine_Code=0;		/* Output assembly lang	     */
int Verbose=0;			/* Make noise while compiling*/
int Plus=0;			/* Use C++ compiler	     */
int Show=0;			/* Show options		     */
int Profile=0;			/* Use compiler profiler     */
int Warn=0;			/* Generate warning messages */
int Case_Hack=1;		/* Hack symbols with upper case*/
int List=0;			/* Save preprocessor output  */
int Version=0;			/* Show compiler version number */
int Generate_Object=0;		/* Shoule we generate obj?   */
int Ndefines=0;			/* Number of defines	     */
int Nincludes=0;		/* Number of incude specs    */
int Nundefines=0;		/* Number of undefines       */
int Nscans=0;			/* Number of files to scan   */
char cc1_Options[256];		/* Options for the CC1 pass  */
char cpp_Options[256];		/* Options for the CPP pass  */
char gas_Options[256];		/* Options for the GAS pass  */


/*
 *	Save a string in dynamic memory
 */
char *savestr(String)
register char *String;
{
	register char *cp,*New_String;

	/*
	 *	Allocate it
	 */
	New_String = (char *)malloc(strlen(String)+1);
	/*
	 *	Copy it
	 */
	cp = New_String;
	while((*cp++ = *String++) != 0) ;
	/*
	 *	Return it
	 */
	return(New_String);
}


/*
 *	Do the parsing
 */
checkswitches(int flag)
{
	register char *cp,*cp1;
	char Temp[256];
	/*
	 *	Do the /DEFINE qualifier
	 */
	if (cli_present("VCG$DEFINE",0,flag)) {
		while(cli_get_value("VCG$DEFINE",Temp,sizeof(Temp))) {
					Defines[Ndefines++] = savestr(Temp);
#ifdef	notdef
					Euniceify(&Defines[Ndefines-1]);
#endif	notdef
		}
	}
	/*
	 *	Do the /DEBUG qualifier
	 */
	if (cli_present("VCG$DEBUG",0,flag)) {
		/*
		 *	Get the value (Default = ALL)
		 */
		if (!cli_get_value("VCG$DEBUG",Temp,sizeof(Temp)))
			strcpy(Temp,"ALL");
		/*
		 *	Save it
		 */
		Debug = savestr(Temp);
	}
	/*
	 *	Do the "/INCLUDE_DIRECTORY" qualifier
	 */
	if (cli_present("VCG$INCLUDE",0,flag)) {
		while(cli_get_value("VCG$INCLUDE",Temp,sizeof(Temp)))
					Includes[Nincludes++] = savestr(Temp);
	}
	/*
	 *	Do the /MACHINE_CODE qualifier
	 */
	if(Machine_Code = cli_present("VCG$MACHINE",Machine_Code,flag)){
	  if(Assembly_File) free(Assembly_File);	
	  if (cli_get_value("VCG$MACHINE",Temp,sizeof(Temp)))
				Assembly_File = savestr(Temp);
	  else Assembly_File = 0;
	};
	/*
	 *	Do the /OBJECT qualifier
	 */
	if(Generate_Object=cli_present("VCG$OBJECT",Generate_Object,flag)){
	  if(Object) free(Object);
	  if (cli_get_value("VCG$OBJECT",Temp,sizeof(Temp)))
				Object = savestr(Temp);
		else Object = 0;
	  };
	/*
	 *	Do the /UNDEFINE qualifier
	 */
	if (cli_present("VCG$UNDEFINE",0,flag)) {
		while(cli_get_value("VCG$UNDEFINE",Temp,sizeof(Temp))) {
					Undefines[Nundefines++] = savestr(Temp);
#ifdef	notdef
					Euniceify(&Undefines[Nundefines-1]);
#endif	notdef
		}
	}
	/*
	 *	Do the /SCAN qualifier
	 */
	if (cli_present("VCG$SCAN",0,flag)) {
		while(cli_get_value("VCG$SCAN",Temp,sizeof(Temp))) {
					Scans[Nscans++] = savestr(Temp);
		}
	}
	/*
	 *	Do the /CC1_OPTIONS qualifier
	 */
	if (cli_present("VCG$CC1_OPTIONS",0,flag))
		cli_get_value("VCG$CC1_OPTIONS",cc1_Options,sizeof(cc1_Options));
	/*
	 *	Do the /VERBOSE qualifier
	 */
	Case_Hack = cli_present("VCG$CASE_HACK",Case_Hack,flag);
	Warn = cli_present("VCG$WARNING",Warn,flag);
	Version = cli_present("VCG$VERSION",Version,flag);
	Plus = cli_present("VCG$PLUS",Plus,flag);
	if (cli_present("VCG$PROFILE",0,flag)) {
		if(!cli_get_value("VCG$PROFILE",Temp,sizeof(Temp))) 
			Profile = 1;	/* all */
		else{
		if(!strncmp(Temp,"ALL",strlen(Temp))) Profile = 3;
		if(!strncmp(Temp,"BLOCK",strlen(Temp))) Profile = 2;
		if(!strncmp(Temp,"FUNCTION",strlen(Temp))) Profile = 1;
		};
	};
	if (cli_present("VCG$SHOW",0,flag)) {
		if(!cli_get_value("VCG$SHOW",Temp,sizeof(Temp))) 
			Show = 3;	/* all */
		else{
		if(!strncmp(Temp,"ALL",strlen(Temp))) Show = 3;
		if(!strncmp(Temp,"RULES",strlen(Temp))) Show = 2;
		if(!strncmp(Temp,"DEFINITIONS",strlen(Temp))) Show = 1;
		if(!strncmp(Temp,"NONE",strlen(Temp))) Show = 0;
		};
	};
	Verbose= cli_present("VCG$VERBOSE",Verbose,flag);
	G_Float = cli_present("VCG$G_FLOAT",G_Float,flag);
	if(List = cli_present("VCG$LISTING",List,flag)){
	  if(List_File) free(List_File);
	  if (cli_get_value("VCG$LISTING",Temp,sizeof(Temp)))
				List_File = savestr(Temp);
		else List_File = 0;
	};
	Optimize = cli_present("VCG$OPTIM",Optimize,flag);
}

int mystrcat(char* string,char * append){
	char* pnt, *pnt1;
	pnt = string + strlen(string);	/* point to null */
	pnt1 = append;
	while(*pnt1){
		if(*pnt1 == '"') *pnt++ = '"';	/* double quotes */
		*pnt++ = *pnt1++;
		};
	*pnt = '\0';	/* and terminate the string */
}

char* locate(char* target, char* source){
	char* pnt, *pnt1;
	pnt=source;
	while(*pnt){
	if(!strncmp(pnt,target,strlen(target))) return pnt;
	pnt++;
	};
	return 0;
}	
/*
 *	Do the parsing
 */
main()
{
	register char *cp,*cp1;
	int i;
	char Temp[256];
	/* 
	 * create the default name for the scratch files
	 */
	strcpy(Temp,"GCC_");
	sprintf(&Temp[4],"%8x.CPP",getpid());
	for(i=4;i<12;i++) if(Temp[i] == ' ') Temp[i]='0';
	List_File = savestr(Temp);
	strcpy(&Temp[12],".S");
	Assembly_File = savestr(Temp);
	/*
	 *	Get the Input files
	 */
	i = 0;
	checkswitches(GLOBAL);
	while(cli_get_value("VCG$INPUT",Temp,sizeof(Temp))){
				Input_Files[i++] = savestr(Temp);
				checkswitches(LOCAL);};
	/* find the name of the source file */
	cp = (char*) strchr(Input_Files[0],']');
	cp1 = (char*) strchr(Input_Files[0],':');
	if(!cp) cp=cp1;
	if(cp1 < cp && !cp1) cp = cp1;
	if(!cp) cp = Input_Files[0];
	  else
	    cp++;	/* skip delimiter */
	cp1 = Temp;
	while(*cp != '.' && *cp != ';' && *cp != '\0')
	  *cp1++ = *cp++;
	/* Next check to see if we need to change the name of the list file*/
	if(Show){
		Generate_Object = 0;
		Machine_Code =0;
		if(!List && List_File) {
			free(List_File);
			List_File = 0;	/* force the selection of a new name */
			};
		List = 1;
		switch (Show){
			case 1:
				strcat(cpp_Options,"-d ");
				if(!List_File){
				   strcpy(cp1,".DEF");
				   List_File = savestr(Temp);
				   };
				break;
			case 2:
				strcat(cpp_Options,"\"-MM\" ");
				if(!List_File){
				   strcpy(cp1,".");
				   List_File = savestr(Temp);
				   };
				break;
			case 3:
				strcat(cpp_Options,"\"-M\" ");
				if(!List_File){
				   strcpy(cp1,".");
				   List_File = savestr(Temp);
				   };
				break;
			};
		};
	/* Next check and see if we need to supply default file names */
	if(!List_File){
	   strcpy(cp1,".CPP");
	   List_File = savestr(Temp);
	   };
	if(!Assembly_File){
	   strcpy(cp1,".S");
	   Assembly_File = savestr(Temp);
	   };
	if(!Object){
	   strcpy(cp1,".OBJ");
	   Object = savestr(Temp);
	   };
	/* now process some of the commands here, to generate switches for the various phases of the compiler */
	if( !Generate_Object && !Machine_Code && !List){
		printf("%%GCC-I-NOOUTPUT No output was requested.\n");
		exit(0);
		};
	strcat(cpp_Options,"\"-D__GNUC__\" ");
/*	if (List) strcat(cpp_Options,"\"-C\" "); */
	if (G_Float) strcat(cc1_Options,"-mg ");
	if (Optimize) strcat(cc1_Options,"-opt ");
	if(Debug){
		if(Plus) strcat(cc1_Options,"\"-G0\" ");
			else strcat(cc1_Options,"\"-G\" ");
		};
	if(Optimize && Debug) printf("%%GCC-I-DEBUG Caution: /debug specified with optimization enabled.\n");
	if(Warn) {
		strcat(cc1_Options,"\"-Wall\" ");
		strcat(cpp_Options,"\"-Wall\" ");
		};
	if(Version){
		strcat(cc1_Options,"-version ");
		strcat(cpp_Options,"-v ");
		};
	if(Profile & 1) strcat(cc1_Options,"-p ");
	if(Profile & 2) strcat(cc1_Options,"-a ");
	if(!Verbose) strcat(cc1_Options,"-quiet ");
	if(!Case_Hack) strcat(gas_Options,"-h ");
	if(Plus) {
		strcat(gas_Options,"-+ ");
		strcat(cpp_Options," -+ \"-D__GNUG__\" \"-D__cplusplus\" ");
		};
	if(Verbose && Plus) strcat(gas_Options,"\"-H\" ");
	if( cp = locate("-mdont-save-r2-r5",cc1_Options)){
		cp1 = cp+17;
		while(*cp1) *cp++ = *cp1++;
		*cp = '\0';
		strcat(cc1_Options," -fcall-used-r2 -fcall-used-r3 -fcall-used-r4 -fcall-used-r5 ");
	};
	if(cp = locate("-mpcc-alignment",cc1_Options)){
		cp1 = cp+15;
		while(*cp1) *cp++ = *cp1++;
		*cp = '\0';
		strcat(cpp_Options," \"-DPCC_ALIGNMENT\" ");
	} else {
		strcat(cc1_Options,"-mvaxc-alignment ");
	};
	/*
	 *	Generate the command
	 */
	cp = Temp;

	/* Invoke the .COM file */
	cp1 = "@GNU_CC:[000000]GCC";
	while(*cp1) *cp++ = *cp1++;

	/* P1 = File to compile */
	*cp++ = ' ';
	cp1 = Input_Files[0];
	while(*cp1) *cp++ = *cp1++;

	/* P2 = Options */
	*cp++ = ' ';
	*cp++ = '"';
	if (Plus==1) *cp++ = 'P';
	if (List == 1) *cp++ = 'L';
	if (Generate_Object == 1) *cp++ = '*';
	if (Machine_Code)*cp++ = 'M';
	if (Verbose) *cp++ = 'V';
	*cp++ = '"';

	/* P3 = Name of object file */
	*cp++ = ' ';
	if(Object != (char*) NULL) {cp1 = Object;
			while(*cp1) *cp++ = *cp1++;
	} else {
		*cp++ = '"';
		*cp++ = '"';
	}

	/* P4 = Name of listing file */
	*cp++ = ' ';
	if(List_File != (char*) NULL) {cp1 = List_File;
			while(*cp1) *cp++ = *cp1++;
	} else {
		*cp++ = '"';
		*cp++ = '"';
	}

	/* P5 = Name of assembly file */
	*cp++ = ' ';
	if( Assembly_File != (char*) NULL) {cp1 = Assembly_File;
			while(*cp1) *cp++ = *cp1++;
	} else {
		*cp++ = '"';
		*cp++ = '"';
	}

	/* Defines */
	i=0;
	while(Defines[i]){
		strcat(cpp_Options,"\"-D");
		mystrcat(cpp_Options,Defines[i]);
		strcat(cpp_Options,"\" ");
		i++;
		};

	/* Scans */
	i=0;
	while(Scans[i]){
		strcat(cpp_Options,"\"-i");
		mystrcat(cpp_Options,Scans[i]);
		strcat(cpp_Options,"\" ");
		i++;
		};

	/* Undefines */
	i=0;
	while(Undefines[i]){
		strcat(cpp_Options,"\"-U");
		mystrcat(cpp_Options,Undefines[i]);
		strcat(cpp_Options,"\" ");
		i++;
		};

	/* Include directories */
	i=0;
	while(Includes[i]){
		strcat(cpp_Options,"\"-I");
		mystrcat(cpp_Options,Includes[i]);
		strcat(cpp_Options,"\" ");
		i++;
		};

/*
 * The symbols are assigned in this way, since we do not have to worry about
 * DCL parsing them.  This reduces the complexity, since we do not have to
 * double the single quotes, treble the double quotes, etc.
 *
 * Any single quotes within an include, define, undefine, or scan will be
 * doubled up, since we do require these to be passed along.
 */

	lib_set_symbol("cc1_Options",cc1_Options);
	lib_set_symbol("cpp_Options",cpp_Options);
	lib_set_symbol("gas_Options",gas_Options);

	/*
	 *	Do it
	 */
	lib_do_command(Temp, cp - Temp);
}


/*
 *	Execute the given DCL command
 */
lib_do_command(Text,Size)
char *Text;
int Size;
{
	struct {int Size; char *Ptr;} Descr;

	Descr.Ptr = Text;
	Descr.Size = Size;
	lib$do_command(&Descr);
}

lib_set_symbol(Symbol,Text)
char * Symbol;
char *Text;
{
	int i;
	struct {int Size; char *Ptr;} Symbol_Descr, Text_Descr;
	Symbol_Descr.Ptr = Symbol;
	Symbol_Descr.Size = strlen(Symbol);
	Text_Descr.Ptr = Text;
	Text_Descr.Size = strlen(Text);
	i=1;
	lib$set_symbol(&Symbol_Descr,&Text_Descr,&i);
}


/************		DCL PARSING ROUTINES		**********/

#define CLI$_ABSENT	0x381f0
#define CLI$_NEGATED	0x381f8
#define CLI$_LOCNEG	0x38230
#define CLI$_PRESENT	0x3fd19
#define CLI$_DEFAULTED	0x3fd21
#define CLI$_LOCPRES	0x3fd31
#define CLI$_COMMA	0x3fd39

/*
 *	See if "NAME" is present, absent or negated.
 */
int cli_present(char *Name, int oldflag, int gblflag)
{
	int flagstatus;
	struct {int Size; char *Ptr;} Descr;

	Descr.Ptr = Name;
	Descr.Size = strlen(Name);
	flagstatus=cli$present(&Descr);
	switch(flagstatus){
		case CLI$_ABSENT :
			return oldflag;
		case CLI$_NEGATED:
			if(gblflag == LOCAL) return oldflag;
		case CLI$_LOCNEG:
			return 0;
		case CLI$_PRESENT:
		case CLI$_DEFAULTED:
			if(gblflag == LOCAL) return oldflag;
		case CLI$_LOCPRES:
			return 1;
	};
}

/*
 *	Get value of "NAME"
 */
int cli_get_value(Name,Buffer,Size)
char *Name;
char *Buffer;
{
	struct {int Size; char *Ptr;} Descr1,Descr2;

	Descr1.Ptr = Name;
	Descr1.Size = strlen(Name);
	Descr2.Ptr = Buffer;
	Descr2.Size = Size-1;
	if (cli$get_value(&Descr1,&Descr2,&Descr2.Size) & 1) {
		Buffer[Descr2.Size] = 0;
		return(1);
	}
	return(0);
}


#ifdef	notdef
/*
 *	TEMPORARY:  Fixup define/undefine strings for Eunice command line
 *			processing
 */
Euniceify(sp)
char **sp;
{
#define	isupper(c) ((c >= 'A') && (c <= 'Z'))
#define tolower(c) (c - 'A' + 'a')
	register char *cp,*cp1;
	char Local[512];

	cp = *sp;
	cp1 = Local;
	while(*cp) {
		if (isupper(*cp)) {
			*cp1++ = '^';
			*cp1 = tolower(*cp);
		} else {
			*cp1 = *cp;
		}
		cp++;
		cp1++;
	}
	*cp1++ = 0;
	cp = (char *)malloc(strlen(Local)+1);
	strcpy(cp,Local);
	*sp = cp;
}
#endif	notdef
