/*
 *	VAX-11 "C" runtime compatible signal definitions
 */

#ifndef	NSIG
#define NSIG	32		/* number of signals */

#define	SIGHUP	1		/* hangup */
#define	SIGINT	2		/* interrupt */
#define	SIGQUIT	3		/* quit */
#define	SIGILL	4		/* illegal instruction (not reset when caught) */
#define	ILL_RESAD_FAULT	0x0	/* reserved addressing mode fault */
#define	ILL_PRIVIN_FAULT 0x1	/* privilidged instruction fault */
#define	ILL_RESOP_FAULT	0x2	/* reserved operand fault */
#define	SIGTRAP	5		/* trace trap (not reset when caught) */
#define	SIGIOT	6		/* IOT instruction */
#define	SIGEMT	7		/* EMT instruction */
#define	SIGFPE	8		/* floating point exception */
#define	FPE_INTOVF_TRAP 0x1
#define	FPE_INTDIV_TRAP 0x2
#define	FPE_FLTOVF_TRAP 0x3
#define	FPE_FLTDIV_TRAP 0x4
#define	FPE_FLTUND_TRAP 0x5
#define	FPE_DECOVF_TRAP 0x6
#define	FPE_SUBRNG_TRAP 0x7
#define FPE_FLTOVF_FAULT 0x8
#define FPE_FLTDIV_FAULT 0x9
#define FPE_FLTUND_FAULT 0xa
#define	SIGKILL	9		/* kill (cannot be caught or ignored) */
#define	SIGBUS	10		/* bus error */
#define	SIGSEGV	11		/* segmentation violation */
#define SIGSYS	12		/* bad argument to system call */
#define SIGPIPE	13		/* write to a pipe with no one to read it */
#define SIGALRM	14		/* alarm clock */
#define SIGTERM	15		/* software termination signal from kill */


struct	sigvec
{
	int	(*sv_handler)();	/* handler address */
	int	sv_mask;		/* mask of signals to be blocked */
	int	sv_onstack;		/* flag to indicate signal stack */
};

struct	sigcontext
{
	int	sc_onstack;		/* signal stack flag to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* stack pointerto restore */
	int	sc_pc;			/* pc to return to */
	int	sc_ps;			/* psl to restore */
};

struct	sigstack
{
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

#define sigmask(n) ((unsigned long) 1 << ((n) - 1))

#ifdef COMPILING_LIBGXX_TESTS
void	(*signal())(),(*ssignal())();
#else
int	(*signal())(),(*ssignal())();
#endif

#define	BADSIG	(int (*)())-1
#define	SIG_DFL	(int (*)())0	/* default */
#define SIG_IGN	(int (*)())1	/* ignore */

#endif	NSIG


