/*
 *	This defines a VAX-11 "C" runtime compatible stdio interface
 */
#ifndef __STDIO_DEFINED
#define __STDIO_DEFINED

/*
 *	The maximum number of files we can have open at a time
 */
#define _NFILE 20

/*
 *	STDIO buffer size (sure wish it could be 1Kb)
 */
#ifndef BUFSIZ
#define BUFSIZ 512
#endif
/*
 *	This is what the VAX-11 "C" runtime stdio FILE structure looks like
 */
struct	_iobuf 	{
	int	_cnt;			/* # of characters in the buffer */
	char	*_ptr;			/* Pointer into the buffer	 */
	char	*_base;			/* Pointer to start of buffer	 */
	char	_flag;			/* STDIO flags			 */
#define	_IOREAD		01			/* Open for reading	 */
#define	_IOWRT		02			/* Open for writing	 */
#define	_IONBF		04			/* No buffer		 */
#define	_IOMYBUF	010			/* Using "my" buffer	 */
#define	_IOEOF		020			/* At End Of File	 */
#define	_IOERR		040			/* I/O error has occured */
#define	_IOSTRG		0100			/* Doing I/O to a string */
#define	_IORW		0200			/* Open for read/write	 */
	char	_file;			/* File descriptor		 */
	};

/*
 *	Instead of passing around pointers to _iobuf structures, VAX-11 "C"
 *	passes around pointers to pointers.
 */
typedef struct _iobuf *FILE;

/*
 *	Also, stdin/stdout/stderr need to be defined
 *	[We also use a hack here that makes the GCC assembler modify
 *	 the psect attributes to match those of the VAX-11 "C" runtime]
 */
extern FILE *stdin __asm("_$$PsectAttributes_NOSHR$$stdin");
extern FILE *stdout __asm("_$$PsectAttributes_NOSHR$$stdout");
extern FILE *stderr __asm("_$$PsectAttributes_NOSHR$$stderr");

/*
 *	Define NULL and EOF
 */
#define	NULL		0
#define	EOF		(-1)

/*
 *	Define the stdio macros
 */
#define getc(p)		fgetc(p)
#define getchar()	fgetc(stdin)
#define putc(x,p)	fputc(x,p)
#define putchar(x)	fputc(x,stdout)
#define feof(p)		(((*p)->_flag&_IOEOF)!=0)
#define ferror(p)	(((*p)->_flag&_IOERR)!=0)
#define fileno(p)	((*p)->_file)
#define clearerr(p)	((*p)->_flag &= ~(_IOERR|_IOEOF))

/*
 *	Declare stdio routines
 */
FILE	*fopen();
FILE	*fdopen();
FILE	*freopen();
char	*fgets();
long	ftell();

#endif	__STDIO_DEFINED
