;;;; Emacs 19 compatibility functions for use in Emacs 18.55
;;;; $Id: emacs-19.el,v 1.7 1991/01/31 14:09:46 sk Exp $

;; These functions are used in dired.el, but are also of general
;; interest, so you may want to add this to your .emcas:
;; 
;; (autoload 'make-directory "emacs-19" "Remove a directory." t)
;; (autoload 'remove-directory "emacs-19" "Make a directory." t)
;; (autoload 'diff "emacs-19" "Diff two files." t)

;; We need this functions in diff:
(autoload 'shell-quote "dired")		; actually belongs into simple.el
(autoload 'latest-backup-file "dired")	; actually belongs into files.el

(defun remove-directory (fn)
  "Remove a directory."
  (interactive 
   (list (expand-file-name (read-file-name "Remove directory: " nil nil 'confirm)))) 
  (if (file-directory-p fn)
      (call-process "rmdir" nil nil nil fn)
    (error "Not a directory: %s" fn))
  (if (file-exists-p fn)
      (error "Could not remove directory %s" fn)))

(defun make-directory (fn)
  "Make a directory."
  (interactive (list (expand-file-name (read-file-name "Make directory: "))))
  (if (file-exists-p fn)
      (error "Cannot make directory %s: file already exists" fn)
    (call-process "mkdir" nil nil nil fn))
  (or (file-directory-p fn)
      (error "Could not make directory %s" fn)))

;; variable so that rcs-diff or whatever can let-bind it.
;; diff would then have to provide a way to insert into a given buffer (?)
;; and run synchronously (?)
(defvar diff-program "diff"
  "*Program used for function diff (which see).")

(defvar diff-switches nil
  "*If non-nil, a string specifying switches to be be passed to diff.
A list of strings (or nil) means that the commandline can be edited
after inserting the strings in the list.") 

(defun diff (fn1 fn2 &optional edit)
  "Diff two files FN1 and FN2.
Optional third (prefix) arg EDIT means commandline is editable in minibuffer.
See also variable diff-switches."
  (interactive "fDiff: \nfDiff %s with: \nP")
  (or (and (stringp fn1)
	   (stringp fn2))
      (error  "diff: arguments must be strings: %s %s" fn1 fn2))
  (let ((command (concat diff-program " "
			  (if (stringp diff-switches)
			       diff-switches
			    (if (listp diff-switches)
				(mapconcat 'identity diff-switches " ")
			      ""))
			  " "
			  (shell-quote (expand-file-name fn1))
			  " "
			  (shell-quote (expand-file-name fn2)))))
    (if (or edit (listp diff-switches))
	(setq command (read-string ": " command)))
    (require 'compile "compile")
    (compile1 command "No more diff's" "diff")))

(defun diff-backup (file &optional edit)
  "Diff FILE with its backup file.
Uses the latest backup, if there are several numerical backups.
If FILE is a backup, diff it with its original.
The backup file is the first file given to `diff'.
Prefix arg lets you edit the diff switches.  See the command `diff'."
  (interactive "fBackup Diff: \nP")
  (let (bak ori)
    (if (backup-file-name-p file)
	(setq bak file
	      ori (file-name-sans-versions file))
      (setq bak (or (latest-backup-file file)
		    (error "File has no backup: %s" file))
	    ori file))
    (diff bak ori edit)))

(defun vms-read-directory (dirname switches buffer)
  ;; Dired calls this function only in the current buffer
  ;; dired-ls gets redefined in dired-vms.el to work under VMS.
  (and buffer
       (not (eq buffer (current-buffer)))
       (error "Must be called in current buffer"))
  (dired-ls dirname switches nil t))

(provide 'emacs-19)
