import optparse
import sys

class SolfegeOptionParser(optparse.OptionParser):
    def __init__(self):
        optparse.OptionParser.__init__(self)
        self.add_option('-v', '--version', action='store_true', dest='version')
        self.add_option('-w', '--warranty', action='store_true', dest='warranty',
            help=_('Show warranty and copyright.'))
        self.add_option('--no-splash', action='store_false', dest='no_splash',
            help=_('Do not show the startup window.'),
            default=False)
        self.add_option('--verbose-sound-init', action='store_true',
            default=False,
            dest='verbose_sound_init',
            help=_('Display more info about the sound setup.'))
        self.add_option('--no-sound', action='store_true', dest='no_sound',
            default=False,
            help=_('Do not play any sounds. Instead some data is printed to standard output. Use this for debugging and porting.'))
        self.add_option('--debug', action='store_true', dest='debug',
            help=_('Include features used by the Solfege developers to debug the program.'))
        self.add_option('--disable-exception-handler', action='store_true',
            dest='disable_exception_handler',
            help=_("Disable the exception handling in Gui.standard_exception_handler."))
        self.add_option('--no-random', action='store_true', dest='no_random',
            help=_('For debugging only: Select questions from lesson files in sequential order.'))
        self.add_option('--enable-gtkhtml', action='store_true', 
            dest='enable_gtkhtml',
            help=_('Run using gtkhtml2 instead of the built in HTML viewer.'))
        self.add_option('--no-cairo-widgets', action='store_true',
            dest='no_cairo_widgets',
            help=_("Do not use the cairo version of input widgets, even if we run gtk+ 2.8.0 or newer."))
        self.add_option('--show-gtk-warnings', action='store_true',
            dest='show_gtk_warnings',
            help=_('Show GtkWarnings and PangoWarnings in the traceback window.'))
    def print_help(self, outfile=None):
        if outfile is None:
            outfile = sys.stdout
        encoding = outfile.encoding
        if not encoding:
            encoding = "iso-8859-1"
        outfile.write(self.format_help().encode(encoding, 'replace'))



