/* ex: set ro ft=c: -*- mode: c; buffer-read-only: t -*- */
#line 2458 "gen-dynapi.pl"
/*****************************************************************************/
/*  LibreDWG - free implementation of the DWG file format                    */
/*                                                                           */
/*  Copyright (C) 2018-2020 Free Software Foundation, Inc.                   */
/*                                                                           */
/*  This library is free software, licensed under the terms of the GNU       */
/*  General Public License as published by the Free Software Foundation,     */
/*  either version 3 of the License, or (at your option) any later version.  */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.    */
/*****************************************************************************/

/*
 * dynapi.c: dynamic access to all object and field names and types
 * written by Reini Urban
 * generated by src/gen-dynapi.pl from include/dwg.h, do not modify.
 */

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "common.h"
#include "dynapi.h"
#define DWG_LOGLEVEL loglevel
#include "logging.h"
#include "decode.h"
#include "dwg.h"
#include "bits.h"

#ifndef _DWG_API_H_
Dwg_Object *dwg_obj_generic_to_object (const void *restrict obj,
                                       int *restrict error);
#endif

/* from typedef struct _dwg_header_variables: (sorted by name) */
static const Dwg_DYNAPI_field _dwg_header_variables_fields[] = {
  { "ACADMAINTVER",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, ACADMAINTVER),
    0,0,0, 90 },
  { "ANGBASE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, ANGBASE),
    0,0,0, 50 },
  { "ANGDIR",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ANGDIR),
    0,0,0, 70 },
  { "APPID_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, APPID_CONTROL_OBJECT),
    1,0,0, 0 },
  { "ATTDIA",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ATTDIA),
    0,0,0, 70 },
  { "ATTMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, ATTMODE),
    0,0,0, 70 },
  { "ATTREQ",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ATTREQ),
    0,0,0, 70 },
  { "AUNITS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, AUNITS),
    0,0,0, 70 },
  { "AUPREC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, AUPREC),
    0,0,0, 70 },
  { "BLIPMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, BLIPMODE),
    0,0,0, 70 },
  { "BLOCK_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, BLOCK_CONTROL_OBJECT),
    1,0,0, 0 },
  { "BLOCK_RECORD_MSPACE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, BLOCK_RECORD_MSPACE),
    1,0,0, 0 },
  { "BLOCK_RECORD_PSPACE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, BLOCK_RECORD_PSPACE),
    1,0,0, 0 },
  { "CAMERADISPLAY",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, CAMERADISPLAY),
    0,0,0, 290 },
  { "CAMERAHEIGHT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CAMERAHEIGHT),
    0,0,0, 40 },
  { "CECOLOR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, CECOLOR),
    0,0,0, 62 },
  { "CELTSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CELTSCALE),
    0,0,0, 40 },
  { "CELTYPE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CELTYPE),
    1,0,0, 6 },
  { "CELWEIGHT",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_header_variables, CELWEIGHT),
    0,0,0, 370 },
  { "CEPSNTYPE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, CEPSNTYPE),
    0,0,0, 380 },
  { "CHAMFERA",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERA),
    0,0,0, 40 },
  { "CHAMFERB",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERB),
    0,0,0, 40 },
  { "CHAMFERC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERC),
    0,0,0, 40 },
  { "CHAMFERD",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CHAMFERD),
    0,0,0, 40 },
  { "CLAYER",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CLAYER),
    1,0,0, 8 },
  { "CMATERIAL",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CMATERIAL),
    1,0,0, 347 },
  { "CMLJUST",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, CMLJUST),
    0,0,0, 70 },
  { "CMLSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, CMLSCALE),
    0,0,0, 40 },
  { "CMLSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CMLSTYLE),
    1,0,0, 2 },
  { "COORDS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, COORDS),
    0,0,0, 70 },
  { "CPSNID",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, CPSNID),
    1,0,0, 390 },
  { "CSHADOW",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, CSHADOW),
    0,0,0, 280 },
  { "DELOBJ",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DELOBJ),
    0,0,0, 70 },
  { "DGNFRAME",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, DGNFRAME),
    0,0,0, 280 },
  { "DICTIONARY_ACAD_GROUP",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_ACAD_GROUP),
    1,0,0, 0 },
  { "DICTIONARY_ACAD_MLINESTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_ACAD_MLINESTYLE),
    1,0,0, 0 },
  { "DICTIONARY_COLOR",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_COLOR),
    1,0,0, 0 },
  { "DICTIONARY_LAYOUT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_LAYOUT),
    1,0,0, 0 },
  { "DICTIONARY_LIGHTLIST",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_LIGHTLIST),
    1,0,0, 0 },
  { "DICTIONARY_MATERIAL",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_MATERIAL),
    1,0,0, 0 },
  { "DICTIONARY_NAMED_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_NAMED_OBJECT),
    1,0,0, 0 },
  { "DICTIONARY_PLOTSETTINGS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_PLOTSETTINGS),
    1,0,0, 0 },
  { "DICTIONARY_PLOTSTYLENAME",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_PLOTSTYLENAME),
    1,0,0, 0 },
  { "DICTIONARY_VISUALSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DICTIONARY_VISUALSTYLE),
    1,0,0, 0 },
  { "DIMADEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMADEC),
    0,0,0, 70 },
  { "DIMALT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMALT),
    0,0,0, 70 },
  { "DIMALTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTD),
    0,0,0, 70 },
  { "DIMALTF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMALTF),
    0,0,0, 40 },
  { "DIMALTMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMALTMZF),
    0,0,0, 0 },
  { "DIMALTMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMALTMZS),
    1,1,1, 1 },
  { "DIMALTRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMALTRND),
    0,0,0, 40 },
  { "DIMALTTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTTD),
    0,0,0, 70 },
  { "DIMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTTZ),
    0,0,0, 70 },
  { "DIMALTU",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTU),
    0,0,0, 70 },
  { "DIMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMALTZ),
    0,0,0, 70 },
  { "DIMAPOST",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, DIMAPOST),
    1,1,1, 1 },
  { "DIMAPOST_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMAPOST_T),
    1,1,1, 0 },
  { "DIMARCSYM",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMARCSYM),
    0,0,0, 70 },
  { "DIMASO",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMASO),
    0,0,0, 70 },
  { "DIMASSOC",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, DIMASSOC),
    0,0,0, 280 },
  { "DIMASZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMASZ),
    0,0,0, 40 },
  { "DIMATFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMATFIT),
    0,0,0, 70 },
  { "DIMAUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMAUNIT),
    0,0,0, 70 },
  { "DIMAZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMAZIN),
    0,0,0, 70 },
  { "DIMBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMBLK),
    1,0,0, 1 },
  { "DIMBLK1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMBLK1),
    1,0,0, 1 },
  { "DIMBLK1_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMBLK1_T),
    1,1,1, 0 },
  { "DIMBLK2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMBLK2),
    1,0,0, 1 },
  { "DIMBLK2_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMBLK2_T),
    1,1,1, 0 },
  { "DIMBLK_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMBLK_T),
    1,1,1, 0 },
  { "DIMCEN",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMCEN),
    0,0,0, 40 },
  { "DIMCLRD",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMCLRD),
    0,0,0, 70 },
  { "DIMCLRD_C",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, DIMCLRD_C),
    0,0,0, 0 },
  { "DIMCLRE",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMCLRE),
    0,0,0, 70 },
  { "DIMCLRE_C",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, DIMCLRE_C),
    0,0,0, 0 },
  { "DIMCLRT",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMCLRT),
    0,0,0, 70 },
  { "DIMCLRT_C",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, DIMCLRT_C),
    0,0,0, 0 },
  { "DIMDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMDEC),
    0,0,0, 70 },
  { "DIMDLE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMDLE),
    0,0,0, 40 },
  { "DIMDLI",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMDLI),
    0,0,0, 40 },
  { "DIMDSEP",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMDSEP),
    0,0,0, 70 },
  { "DIMEXE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMEXE),
    0,0,0, 40 },
  { "DIMEXO",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMEXO),
    0,0,0, 40 },
  { "DIMFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMFIT),
    0,0,0, 70 },
  { "DIMFRAC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMFRAC),
    0,0,0, 70 },
  { "DIMFXL",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMFXL),
    0,0,0, 40 },
  { "DIMFXLON",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMFXLON),
    0,0,0, 70 },
  { "DIMGAP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMGAP),
    0,0,0, 40 },
  { "DIMJOGANG",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMJOGANG),
    0,0,0, 40 },
  { "DIMJUST",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMJUST),
    0,0,0, 70 },
  { "DIMLDRBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLDRBLK),
    1,0,0, 1 },
  { "DIMLFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMLFAC),
    0,0,0, 40 },
  { "DIMLIM",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMLIM),
    0,0,0, 70 },
  { "DIMLTEX1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLTEX1),
    1,0,0, 6 },
  { "DIMLTEX2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLTEX2),
    1,0,0, 6 },
  { "DIMLTYPE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMLTYPE),
    1,0,0, 6 },
  { "DIMLUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMLUNIT),
    0,0,0, 70 },
  { "DIMLWD",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_header_variables, DIMLWD),
    0,0,0, 70 },
  { "DIMLWE",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_header_variables, DIMLWE),
    0,0,0, 70 },
  { "DIMMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMMALTTZ),
    0,0,0, 0 },
  { "DIMMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMMALTZ),
    0,0,0, 0 },
  { "DIMMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMMZF),
    0,0,0, 0 },
  { "DIMMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMMZS),
    1,1,1, 1 },
  { "DIMPOST",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, DIMPOST),
    1,1,1, 1 },
  { "DIMPOST_T",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, DIMPOST_T),
    1,1,1, 0 },
  { "DIMRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMRND),
    0,0,0, 40 },
  { "DIMSAH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSAH),
    0,0,0, 70 },
  { "DIMSAV",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSAV),
    0,0,0, 0 },
  { "DIMSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMSCALE),
    0,0,0, 40 },
  { "DIMSD1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSD1),
    0,0,0, 70 },
  { "DIMSD2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSD2),
    0,0,0, 70 },
  { "DIMSE1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSE1),
    0,0,0, 70 },
  { "DIMSE2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSE2),
    0,0,0, 70 },
  { "DIMSHO",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSHO),
    0,0,0, 70 },
  { "DIMSOXD",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMSOXD),
    0,0,0, 70 },
  { "DIMSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMSTYLE),
    1,0,0, 2 },
  { "DIMSTYLE_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMSTYLE_CONTROL_OBJECT),
    1,0,0, 0 },
  { "DIMTAD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTAD),
    0,0,0, 70 },
  { "DIMTDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTDEC),
    0,0,0, 70 },
  { "DIMTFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTFAC),
    0,0,0, 40 },
  { "DIMTFILL",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTFILL),
    0,0,0, 70 },
  { "DIMTFILLCLR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, DIMTFILLCLR),
    0,0,0, 70 },
  { "DIMTIH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTIH),
    0,0,0, 70 },
  { "DIMTIX",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTIX),
    0,0,0, 70 },
  { "DIMTM",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTM),
    0,0,0, 40 },
  { "DIMTMOVE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTMOVE),
    0,0,0, 70 },
  { "DIMTOFL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTOFL),
    0,0,0, 70 },
  { "DIMTOH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTOH),
    0,0,0, 70 },
  { "DIMTOL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTOL),
    0,0,0, 70 },
  { "DIMTOLJ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTOLJ),
    0,0,0, 70 },
  { "DIMTP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTP),
    0,0,0, 40 },
  { "DIMTSZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTSZ),
    0,0,0, 40 },
  { "DIMTVP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTVP),
    0,0,0, 40 },
  { "DIMTXSTY",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DIMTXSTY),
    1,0,0, 7 },
  { "DIMTXT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, DIMTXT),
    0,0,0, 40 },
  { "DIMTXTDIRECTION",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMTXTDIRECTION),
    0,0,0, 70 },
  { "DIMTZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMTZIN),
    0,0,0, 70 },
  { "DIMUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMUNIT),
    0,0,0, 70 },
  { "DIMUPT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DIMUPT),
    0,0,0, 70 },
  { "DIMZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DIMZIN),
    0,0,0, 70 },
  { "DISPSILH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, DISPSILH),
    0,0,0, 70 },
  { "DRAGMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, DRAGMODE),
    0,0,0, 70 },
  { "DRAGVS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, DRAGVS),
    1,0,0, 349 },
  { "DWFFRAME",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, DWFFRAME),
    0,0,0, 280 },
  { "DWGCODEPAGE",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, DWGCODEPAGE),
    1,1,1, 3 },
  { "ELEVATION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, ELEVATION),
    0,0,0, 40 },
  { "ENDCAPS",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ENDCAPS),
    0,0,0, 280 },
  { "EXTMAX",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, EXTMAX),
    1,0,0, 30 },
  { "EXTMIN",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, EXTMIN),
    1,0,0, 30 },
  { "EXTNAMES",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, EXTNAMES),
    0,0,0, 290 },
  { "FACETRES",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, FACETRES),
    0,0,0, 0 },
  { "FILLETRAD",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, FILLETRAD),
    0,0,0, 40 },
  { "FILLMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, FILLMODE),
    0,0,0, 70 },
  { "FINGERPRINTGUID",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, FINGERPRINTGUID),
    1,1,1, 2 },
  { "FLAGS",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, FLAGS),
    0,0,0, 0 },
  { "GRIDMODE",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, GRIDMODE),
    0,0,0, 0 },
  { "GRIDUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, GRIDUNIT),
    1,0,0, 0 },
  { "HALOGAP",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, HALOGAP),
    0,0,0, 280 },
  { "HANDLING",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, HANDLING),
    0,0,0, 70 },
  { "HANDSEED",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, HANDSEED),
    1,0,0, 5 },
  { "HIDETEXT",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, HIDETEXT),
    0,0,0, 280 },
  { "HYPERLINKBASE",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_header_variables, HYPERLINKBASE),
    1,1,1, 1 },
  { "INDEXCTL",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, INDEXCTL),
    0,0,0, 280 },
  { "INSBASE",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, INSBASE),
    1,0,0, 30 },
  { "INSUNITS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, INSUNITS),
    0,0,0, 70 },
  { "INTERFERECOLOR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_header_variables, INTERFERECOLOR),
    0,0,0, 62 },
  { "INTERFEREOBJVS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, INTERFEREOBJVS),
    1,0,0, 345 },
  { "INTERFEREVPVS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, INTERFEREVPVS),
    1,0,0, 346 },
  { "INTERSECTIONCOLOR",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, INTERSECTIONCOLOR),
    0,0,0, 70 },
  { "INTERSECTIONDISPLAY",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, INTERSECTIONDISPLAY),
    0,0,0, 280 },
  { "ISOLINES",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, ISOLINES),
    0,0,0, 0 },
  { "JOINSTYLE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, JOINSTYLE),
    0,0,0, 280 },
  { "LATITUDE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LATITUDE),
    0,0,0, 40 },
  { "LAYER_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LAYER_CONTROL_OBJECT),
    1,0,0, 0 },
  { "LENSLENGTH",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LENSLENGTH),
    0,0,0, 40 },
  { "LIGHTGLYPHDISPLAY",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, LIGHTGLYPHDISPLAY),
    0,0,0, 280 },
  { "LIMCHECK",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, LIMCHECK),
    0,0,0, 70 },
  { "LIMMAX",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_header_variables, LIMMAX),
    1,0,0, 20 },
  { "LIMMIN",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_header_variables, LIMMIN),
    1,0,0, 20 },
  { "LOFTANG1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTANG1),
    0,0,0, 40 },
  { "LOFTANG2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTANG2),
    0,0,0, 40 },
  { "LOFTMAG1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTMAG1),
    0,0,0, 40 },
  { "LOFTMAG2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LOFTMAG2),
    0,0,0, 40 },
  { "LOFTNORMALS",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, LOFTNORMALS),
    0,0,0, 280 },
  { "LOFTPARAM",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, LOFTPARAM),
    0,0,0, 70 },
  { "LONGITUDE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LONGITUDE),
    0,0,0, 40 },
  { "LTSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, LTSCALE),
    0,0,0, 40 },
  { "LTYPE_BYBLOCK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_BYBLOCK),
    1,0,0, 0 },
  { "LTYPE_BYLAYER",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_BYLAYER),
    1,0,0, 0 },
  { "LTYPE_CONTINUOUS",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_CONTINUOUS),
    1,0,0, 0 },
  { "LTYPE_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, LTYPE_CONTROL_OBJECT),
    1,0,0, 0 },
  { "LUNITS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, LUNITS),
    0,0,0, 70 },
  { "LUPREC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, LUPREC),
    0,0,0, 70 },
  { "LWDISPLAY",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, LWDISPLAY),
    0,0,0, 290 },
  { "MAXACTVP",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, MAXACTVP),
    0,0,0, 70 },
  { "MEASUREMENT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, MEASUREMENT),
    0,0,0, 70 },
  { "MENU",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, MENU),
    1,1,1, 1 },
  { "MIRRTEXT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, MIRRTEXT),
    0,0,0, 70 },
  { "NORTHDIRECTION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, NORTHDIRECTION),
    0,0,0, 40 },
  { "OBSCOLOR",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, OBSCOLOR),
    0,0,0, 70 },
  { "OBSLTYPE",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, OBSLTYPE),
    0,0,0, 280 },
  { "OLESTARTUP",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, OLESTARTUP),
    0,0,0, 290 },
  { "ORTHOMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, ORTHOMODE),
    0,0,0, 70 },
  { "OSMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, OSMODE),
    0,0,0, 70 },
  { "PDMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PDMODE),
    0,0,0, 70 },
  { "PDSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PDSIZE),
    0,0,0, 40 },
  { "PELEVATION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PELEVATION),
    0,0,0, 40 },
  { "PELLIPSE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PELLIPSE),
    0,0,0, 0 },
  { "PEXTMAX",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PEXTMAX),
    1,0,0, 30 },
  { "PEXTMIN",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PEXTMIN),
    1,0,0, 30 },
  { "PICKSTYLE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PICKSTYLE),
    0,0,0, 70 },
  { "PINSBASE",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PINSBASE),
    1,0,0, 30 },
  { "PLIMCHECK",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PLIMCHECK),
    0,0,0, 70 },
  { "PLIMMAX",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_header_variables, PLIMMAX),
    1,0,0, 20 },
  { "PLIMMIN",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_header_variables, PLIMMIN),
    1,0,0, 20 },
  { "PLINEGEN",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PLINEGEN),
    0,0,0, 70 },
  { "PLINEWID",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PLINEWID),
    0,0,0, 40 },
  { "PROJECTNAME",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, PROJECTNAME),
    1,1,1, 1 },
  { "PROXYGRAPHICS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PROXYGRAPHICS),
    0,0,0, 70 },
  { "PSLTSCALE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PSLTSCALE),
    0,0,0, 70 },
  { "PSOLHEIGHT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PSOLHEIGHT),
    0,0,0, 40 },
  { "PSOLWIDTH",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PSOLWIDTH),
    0,0,0, 40 },
  { "PSTYLEMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, PSTYLEMODE),
    0,0,0, 290 },
  { "PSVPSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, PSVPSCALE),
    0,0,0, 40 },
  { "PUCSBASE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, PUCSBASE),
    1,0,0, 2 },
  { "PUCSNAME",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, PUCSNAME),
    1,0,0, 2 },
  { "PUCSORG",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORG),
    1,0,0, 30 },
  { "PUCSORGBACK",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGBACK),
    1,0,0, 30 },
  { "PUCSORGBOTTOM",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGBOTTOM),
    1,0,0, 30 },
  { "PUCSORGFRONT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGFRONT),
    1,0,0, 30 },
  { "PUCSORGLEFT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGLEFT),
    1,0,0, 30 },
  { "PUCSORGRIGHT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGRIGHT),
    1,0,0, 30 },
  { "PUCSORGTOP",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSORGTOP),
    1,0,0, 30 },
  { "PUCSORTHOREF",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, PUCSORTHOREF),
    1,0,0, 2 },
  { "PUCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, PUCSORTHOVIEW),
    0,0,0, 70 },
  { "PUCSXDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSXDIR),
    1,0,0, 30 },
  { "PUCSYDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, PUCSYDIR),
    1,0,0, 30 },
  { "QTEXTMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, QTEXTMODE),
    0,0,0, 70 },
  { "REALWORLDSCALE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, REALWORLDSCALE),
    0,0,0, 290 },
  { "REGENMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, REGENMODE),
    0,0,0, 70 },
  { "REQUIREDVERSIONS",	"BLL", sizeof (BITCODE_BLL),  OFF (struct _dwg_header_variables, REQUIREDVERSIONS),
    0,0,0, 160 },
  { "SAVEIMAGES",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SAVEIMAGES),
    0,0,0, 0 },
  { "SHADEDGE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SHADEDGE),
    0,0,0, 70 },
  { "SHADEDIF",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SHADEDIF),
    0,0,0, 70 },
  { "SHADOWPLANELOCATION",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, SHADOWPLANELOCATION),
    0,0,0, 40 },
  { "SHOWHIST",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, SHOWHIST),
    0,0,0, 280 },
  { "SKETCHINC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, SKETCHINC),
    0,0,0, 40 },
  { "SKPOLY",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, SKPOLY),
    0,0,0, 70 },
  { "SNAPANG",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_header_variables, SNAPANG),
    0,0,0, 0 },
  { "SNAPBASE",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, SNAPBASE),
    1,0,0, 0 },
  { "SNAPISOPAIR",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, SNAPISOPAIR),
    0,0,0, 0 },
  { "SNAPMODE",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, SNAPMODE),
    0,0,0, 0 },
  { "SNAPSTYL",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_header_variables, SNAPSTYL),
    0,0,0, 0 },
  { "SNAPUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, SNAPUNIT),
    1,0,0, 0 },
  { "SOLIDHIST",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, SOLIDHIST),
    0,0,0, 280 },
  { "SORTENTS",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, SORTENTS),
    0,0,0, 280 },
  { "SPLFRAME",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, SPLFRAME),
    0,0,0, 70 },
  { "SPLINESEGS",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SPLINESEGS),
    0,0,0, 70 },
  { "SPLINETYPE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SPLINETYPE),
    0,0,0, 70 },
  { "STEPSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, STEPSIZE),
    0,0,0, 40 },
  { "STEPSPERSEC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, STEPSPERSEC),
    0,0,0, 40 },
  { "STYLESHEET",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, STYLESHEET),
    1,1,1, 1 },
  { "STYLE_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, STYLE_CONTROL_OBJECT),
    1,0,0, 0 },
  { "SURFTAB1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFTAB1),
    0,0,0, 70 },
  { "SURFTAB2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFTAB2),
    0,0,0, 70 },
  { "SURFTYPE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFTYPE),
    0,0,0, 70 },
  { "SURFU",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFU),
    0,0,0, 70 },
  { "SURFV",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, SURFV),
    0,0,0, 70 },
  { "TDCREATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDCREATE),
    1,0,0, 40 },
  { "TDINDWG",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDINDWG),
    1,0,0, 40 },
  { "TDUCREATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUCREATE),
    1,0,0, 40 },
  { "TDUPDATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUPDATE),
    1,0,0, 40 },
  { "TDUSRTIMER",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUSRTIMER),
    1,0,0, 40 },
  { "TDUUPDATE",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_header_variables, TDUUPDATE),
    1,0,0, 40 },
  { "TEXTQLTY",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TEXTQLTY),
    0,0,0, 0 },
  { "TEXTSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, TEXTSIZE),
    0,0,0, 40 },
  { "TEXTSTYLE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, TEXTSTYLE),
    1,0,0, 7 },
  { "THICKNESS",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, THICKNESS),
    0,0,0, 40 },
  { "TILEMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, TILEMODE),
    0,0,0, 70 },
  { "TILEMODELIGHTSYNCH",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, TILEMODELIGHTSYNCH),
    0,0,0, 280 },
  { "TIMEZONE",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, TIMEZONE),
    0,0,0, 70 },
  { "TRACEWID",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, TRACEWID),
    0,0,0, 40 },
  { "TREEDEPTH",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TREEDEPTH),
    0,0,0, 70 },
  { "TSTACKALIGN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TSTACKALIGN),
    0,0,0, 0 },
  { "TSTACKSIZE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, TSTACKSIZE),
    0,0,0, 0 },
  { "UCSBASE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCSBASE),
    1,0,0, 2 },
  { "UCSNAME",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCSNAME),
    1,0,0, 2 },
  { "UCSORG",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORG),
    1,0,0, 30 },
  { "UCSORGBACK",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGBACK),
    1,0,0, 30 },
  { "UCSORGBOTTOM",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGBOTTOM),
    1,0,0, 30 },
  { "UCSORGFRONT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGFRONT),
    1,0,0, 30 },
  { "UCSORGLEFT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGLEFT),
    1,0,0, 30 },
  { "UCSORGRIGHT",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGRIGHT),
    1,0,0, 30 },
  { "UCSORGTOP",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSORGTOP),
    1,0,0, 30 },
  { "UCSORTHOREF",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCSORTHOREF),
    1,0,0, 2 },
  { "UCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, UCSORTHOVIEW),
    0,0,0, 70 },
  { "UCSXDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSXDIR),
    1,0,0, 30 },
  { "UCSYDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_header_variables, UCSYDIR),
    1,0,0, 30 },
  { "UCS_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, UCS_CONTROL_OBJECT),
    1,0,0, 0 },
  { "UNITMODE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, UNITMODE),
    0,0,0, 70 },
  { "USERI1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI1),
    0,0,0, 70 },
  { "USERI2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI2),
    0,0,0, 70 },
  { "USERI3",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI3),
    0,0,0, 70 },
  { "USERI4",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI4),
    0,0,0, 70 },
  { "USERI5",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, USERI5),
    0,0,0, 70 },
  { "USERR1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR1),
    0,0,0, 40 },
  { "USERR2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR2),
    0,0,0, 40 },
  { "USERR3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR3),
    0,0,0, 40 },
  { "USERR4",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR4),
    0,0,0, 40 },
  { "USERR5",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, USERR5),
    0,0,0, 40 },
  { "USRTIMER",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, USRTIMER),
    0,0,0, 70 },
  { "VERSIONGUID",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, VERSIONGUID),
    1,1,1, 2 },
  { "VIEWCTR",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_header_variables, VIEWCTR),
    1,0,0, 0 },
  { "VIEWSIZE",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_header_variables, VIEWSIZE),
    0,0,0, 0 },
  { "VIEW_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VIEW_CONTROL_OBJECT),
    1,0,0, 0 },
  { "VISRETAIN",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, VISRETAIN),
    0,0,0, 70 },
  { "VPORT_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VPORT_CONTROL_OBJECT),
    1,0,0, 0 },
  { "VX_CONTROL_OBJECT",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VX_CONTROL_OBJECT),
    1,0,0, 0 },
  { "VX_TABLE_RECORD",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, VX_TABLE_RECORD),
    1,0,0, 0 },
  { "WIREFRAME",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, WIREFRAME),
    0,0,0, 0 },
  { "WORLDVIEW",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, WORLDVIEW),
    0,0,0, 70 },
  { "XCLIPFRAME",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_header_variables, XCLIPFRAME),
    0,0,0, 290 },
  { "XEDIT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, XEDIT),
    0,0,0, 290 },
  { "_3DDWFPREC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, _3DDWFPREC),
    0,0,0, 40 },
  { "bitsize",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_header_variables, bitsize),
    0,0,0, 0 },
  { "bitsize_hi",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_header_variables, bitsize_hi),
    0,0,0, 0 },
  { "size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_header_variables, size),
    0,0,0, 0 },
  { "unknown_0",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_0),
    0,0,0, 0 },
  { "unknown_1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_1),
    0,0,0, 0 },
  { "unknown_10",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_10),
    0,0,0, 0 },
  { "unknown_11",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_header_variables, unknown_11),
    0,0,0, 0 },
  { "unknown_12",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_12),
    0,0,0, 0 },
  { "unknown_13",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_13),
    0,0,0, 0 },
  { "unknown_14",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_14),
    0,0,0, 0 },
  { "unknown_14b",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_14b),
    0,0,0, 0 },
  { "unknown_15",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_15),
    0,0,0, 0 },
  { "unknown_16",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_16),
    0,0,0, 0 },
  { "unknown_17",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_17),
    0,0,0, 0 },
  { "unknown_2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_2),
    0,0,0, 0 },
  { "unknown_20",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_header_variables, unknown_20),
    1,0,0, 0 },
  { "unknown_21",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_21),
    0,0,0, 0 },
  { "unknown_22",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_22),
    0,0,0, 0 },
  { "unknown_23",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_23),
    0,0,0, 0 },
  { "unknown_3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_header_variables, unknown_3),
    0,0,0, 0 },
  { "unknown_54",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_54),
    0,0,0, 0 },
  { "unknown_55",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_55),
    0,0,0, 0 },
  { "unknown_56",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_56),
    0,0,0, 0 },
  { "unknown_57",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_header_variables, unknown_57),
    0,0,0, 0 },
  { "unknown_8",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_8),
    0,0,0, 0 },
  { "unknown_9",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_header_variables, unknown_9),
    0,0,0, 0 },
  { "unknown_text1",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text1),
    1,1,1, 0 },
  { "unknown_text2",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text2),
    1,1,1, 0 },
  { "unknown_text3",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text3),
    1,1,1, 0 },
  { "unknown_text4",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_header_variables, unknown_text4),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_entity_3DFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_3DFACE, parent),
    1,1,0, 0 },
  { "has_no_flags",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DFACE, has_no_flags),
    0,0,0, 0 },
  { "z_is_zero",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DFACE, z_is_zero),
    0,0,0, 0 },
  { "corner1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner1),
    1,0,0, 10 },
  { "corner2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner2),
    1,0,0, 11 },
  { "corner3",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner3),
    1,0,0, 12 },
  { "corner4",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DFACE, corner4),
    1,0,0, 13 },
  { "invis_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_3DFACE, invis_flags),
    0,0,0, 70 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_3DSOLID: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DSOLID_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_3DSOLID, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_3DSOLID, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_3DSOLID, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_3DSOLID, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_3DSOLID, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_3DSOLID, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_3DSOLID, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_3DSOLID, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_3DSOLID, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_entity_3DSOLID, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_3DSOLID, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_3DSOLID, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_3DSOLID, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_3DSOLID, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_3DSOLID, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_3DSOLID, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_3DSOLID, acis_empty_bit),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ALIGNMENTPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ALIGNMENTPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ALIGNMENTPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ARC: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ARC_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ARC, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC, center),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC, radius),
    0,0,0, 40 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_ARC, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_ARC, extrusion),
    0,0,0, 210 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC, start_angle),
    0,0,0, 50 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC, end_angle),
    0,0,0, 51 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ARCALIGNEDTEXT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ARCALIGNEDTEXT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, parent),
    1,1,0, 0 },
  { "text_size",	"D2T", sizeof (BITCODE_D2T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, text_size),
    1,1,1, 42 },
  { "xscale",	"D2T", sizeof (BITCODE_D2T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, xscale),
    1,1,1, 41 },
  { "char_spacing",	"D2T", sizeof (BITCODE_D2T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, char_spacing),
    1,1,1, 43 },
  { "style",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, style),
    1,1,1, 7 },
  { "t2",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, t2),
    1,1,1, 2 },
  { "t3",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, t3),
    1,1,1, 3 },
  { "text_value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, text_value),
    1,1,1, 1 },
  { "offset_from_arc",	"D2T", sizeof (BITCODE_D2T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, offset_from_arc),
    1,1,1, 44 },
  { "right_offset",	"D2T", sizeof (BITCODE_D2T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, right_offset),
    1,1,1, 45 },
  { "left_offset",	"D2T", sizeof (BITCODE_D2T),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, left_offset),
    1,1,1, 46 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, center),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, radius),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, start_angle),
    0,0,0, 50 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, end_angle),
    0,0,0, 51 },
  { "extrusion",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, extrusion),
    1,0,0, 210 },
  { "color",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, color),
    0,0,0, 90 },
  { "is_reverse",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, is_reverse),
    0,0,0, 70 },
  { "text_direction",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, text_direction),
    0,0,0, 71 },
  { "alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, alignment),
    0,0,0, 72 },
  { "text_position",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, text_position),
    0,0,0, 73 },
  { "font_19",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, font_19),
    0,0,0, 74 },
  { "bs2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, bs2),
    0,0,0, 75 },
  { "is_underlined",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, is_underlined),
    0,0,0, 76 },
  { "bs1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, bs1),
    0,0,0, 77 },
  { "font",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, font),
    0,0,0, 78 },
  { "is_shx",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, is_shx),
    0,0,0, 79 },
  { "wizard_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, wizard_flag),
    0,0,0, 280 },
  { "arc_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ARCALIGNEDTEXT, arc_handle),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ARC_DIMENSION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ARC_DIMENSION_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ARC_DIMENSION, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ARC_DIMENSION, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_ARC_DIMENSION, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_ARC_DIMENSION, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ARC_DIMENSION, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ARC_DIMENSION, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_ARC_DIMENSION, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARC_DIMENSION, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ARC_DIMENSION, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_ARC_DIMENSION, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ARC_DIMENSION, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ARC_DIMENSION, block),
    1,0,0, 0 },
  { "xline1_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, xline1_pt),
    1,0,0, 13 },
  { "xline2_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, xline2_pt),
    1,0,0, 14 },
  { "center_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, center_pt),
    1,0,0, 15 },
  { "is_partial",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, is_partial),
    0,0,0, 70 },
  { "arc_start_param",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, arc_start_param),
    0,0,0, 41 },
  { "arc_end_param",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ARC_DIMENSION, arc_end_param),
    0,0,0, 42 },
  { "has_leader",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ARC_DIMENSION, has_leader),
    0,0,0, 71 },
  { "leader1_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, leader1_pt),
    1,0,0, 16 },
  { "leader2_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ARC_DIMENSION, leader2_pt),
    1,0,0, 17 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ATTDEF: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ATTDEF_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ATTDEF, parent),
    1,1,0, 0 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ATTDEF, elevation),
    0,0,0, 30 },
  { "ins_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTDEF, ins_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTDEF, alignment_pt),
    1,0,0, 11 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_ATTDEF, extrusion),
    0,0,0, 210 },
  { "thickness",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, thickness),
    0,0,0, 39 },
  { "oblique_angle",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, oblique_angle),
    0,0,0, 51 },
  { "rotation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, rotation),
    0,0,0, 50 },
  { "height",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, height),
    0,0,0, 40 },
  { "width_factor",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTDEF, width_factor),
    0,0,0, 41 },
  { "default_value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ATTDEF, default_value),
    1,1,1, 1 },
  { "generation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, generation),
    0,0,0, 71 },
  { "horiz_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, horiz_alignment),
    0,0,0, 72 },
  { "vert_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, vert_alignment),
    0,0,0, 74 },
  { "dataflags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, dataflags),
    0,0,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, class_version),
    0,0,0, 280 },
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, type),
    0,0,0, 70 },
  { "tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ATTDEF, tag),
    1,1,1, 2 },
  { "field_length",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, field_length),
    0,0,0, 0 },
  { "flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, flags),
    0,0,0, 0 },
  { "lock_position_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ATTDEF, lock_position_flag),
    0,0,0, 0 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTDEF, style),
    1,0,0, 7 },
  { "mtext_handles",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTDEF, mtext_handles),
    1,0,0, 340 },
  { "annotative_data_size",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, annotative_data_size),
    0,0,0, 70 },
  { "annotative_data_bytes",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, annotative_data_bytes),
    0,0,0, 0 },
  { "annotative_app",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTDEF, annotative_app),
    1,0,0, 0 },
  { "annotative_short",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTDEF, annotative_short),
    0,0,0, 0 },
  { "attdef_class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTDEF, attdef_class_version),
    0,0,0, 0 },
  { "prompt",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ATTDEF, prompt),
    1,1,1, 3 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ATTRIB: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ATTRIB_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ATTRIB, parent),
    1,1,0, 0 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ATTRIB, elevation),
    0,0,0, 30 },
  { "ins_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTRIB, ins_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_ATTRIB, alignment_pt),
    1,0,0, 11 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_ATTRIB, extrusion),
    0,0,0, 210 },
  { "thickness",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, thickness),
    0,0,0, 39 },
  { "oblique_angle",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, oblique_angle),
    0,0,0, 51 },
  { "rotation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, rotation),
    0,0,0, 50 },
  { "height",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, height),
    0,0,0, 40 },
  { "width_factor",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_ATTRIB, width_factor),
    0,0,0, 41 },
  { "text_value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ATTRIB, text_value),
    1,1,1, 1 },
  { "generation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, generation),
    0,0,0, 71 },
  { "horiz_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, horiz_alignment),
    0,0,0, 72 },
  { "vert_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, vert_alignment),
    0,0,0, 74 },
  { "dataflags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, dataflags),
    0,0,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, class_version),
    0,0,0, 280 },
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, type),
    0,0,0, 70 },
  { "tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_ATTRIB, tag),
    1,1,1, 2 },
  { "field_length",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, field_length),
    0,0,0, 0 },
  { "flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, flags),
    0,0,0, 0 },
  { "lock_position_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_ATTRIB, lock_position_flag),
    0,0,0, 0 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTRIB, style),
    1,0,0, 7 },
  { "mtext_handles",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTRIB, mtext_handles),
    1,0,0, 340 },
  { "annotative_data_size",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, annotative_data_size),
    0,0,0, 70 },
  { "annotative_data_bytes",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_ATTRIB, annotative_data_bytes),
    0,0,0, 0 },
  { "annotative_app",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_ATTRIB, annotative_app),
    1,0,0, 0 },
  { "annotative_short",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_ATTRIB, annotative_short),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_BASEPOINTPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BASEPOINTPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_BASEPOINTPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_BLOCK: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCK_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_BLOCK, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_BLOCK, name),
    1,1,1, 2 },
  { "filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_BLOCK, filename),
    1,1,1, 4 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_CAMERA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CAMERA_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_CAMERA, parent),
    1,1,0, 0 },
  { "view",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_CAMERA, view),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_CIRCLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CIRCLE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_CIRCLE, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_CIRCLE, center),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_CIRCLE, radius),
    0,0,0, 40 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_CIRCLE, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_CIRCLE, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_abstractentity_UNDERLAY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNDERLAY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_abstractentity_UNDERLAY, parent),
    1,1,0, 0 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_abstractentity_UNDERLAY, extrusion),
    0,0,0, 210 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_abstractentity_UNDERLAY, ins_pt),
    1,0,0, 10 },
  { "scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_abstractentity_UNDERLAY, scale),
    1,0,0, 41 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_abstractentity_UNDERLAY, angle),
    0,0,0, 50 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_abstractentity_UNDERLAY, flag),
    0,0,0, 280 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_abstractentity_UNDERLAY, contrast),
    0,0,0, 281 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_abstractentity_UNDERLAY, fade),
    0,0,0, 282 },
  { "num_clip_verts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_abstractentity_UNDERLAY, num_clip_verts),
    0,0,0, 0 },
  { "clip_verts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_abstractentity_UNDERLAY, clip_verts),
    1,1,0, 11 },
  { "num_clip_inverts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_abstractentity_UNDERLAY, num_clip_inverts),
    0,0,0, 170 },
  { "clip_inverts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_abstractentity_UNDERLAY, clip_inverts),
    1,1,0, 12 },
  { "definition_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_abstractentity_UNDERLAY, definition_id),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ALIGNED: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ALIGNED_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, block),
    1,0,0, 0 },
  { "xline1_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, xline1_pt),
    1,0,0, 13 },
  { "xline2_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, xline2_pt),
    1,0,0, 14 },
  { "oblique_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ALIGNED, oblique_angle),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ANG2LN: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ANG2LN_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, block),
    1,0,0, 0 },
  { "xline1start_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, xline1start_pt),
    1,0,0, 13 },
  { "xline1end_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, xline1end_pt),
    1,0,0, 14 },
  { "xline2start_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, xline2start_pt),
    1,0,0, 15 },
  { "xline2end_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG2LN, xline2end_pt),
    1,0,0, 16 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ANG3PT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ANG3PT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, block),
    1,0,0, 0 },
  { "xline1_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, xline1_pt),
    1,0,0, 13 },
  { "xline2_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, xline2_pt),
    1,0,0, 14 },
  { "center_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ANG3PT, center_pt),
    1,0,0, 15 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_DIAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_DIAMETER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, block),
    1,0,0, 0 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, first_arc_pt),
    1,0,0, 15 },
  { "leader_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_DIAMETER, leader_len),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_LINEAR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_LINEAR_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_LINEAR, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_LINEAR, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_DIMENSION_LINEAR, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_LINEAR, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_LINEAR, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_LINEAR, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_LINEAR, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_LINEAR, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_LINEAR, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_LINEAR, block),
    1,0,0, 0 },
  { "xline1_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, xline1_pt),
    1,0,0, 13 },
  { "xline2_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, xline2_pt),
    1,0,0, 14 },
  { "oblique_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, oblique_angle),
    0,0,0, 52 },
  { "dim_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_LINEAR, dim_rotation),
    0,0,0, 50 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_ORDINATE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_ORDINATE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, block),
    1,0,0, 0 },
  { "feature_location_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, feature_location_pt),
    1,0,0, 13 },
  { "leader_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, leader_endpt),
    1,0,0, 14 },
  { "flag2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_ORDINATE, flag2),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_DIMENSION_RADIUS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_RADIUS_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_DIMENSION_RADIUS, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_RADIUS, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_DIMENSION_RADIUS, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_DIMENSION_RADIUS, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_RADIUS, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_DIMENSION_RADIUS, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_RADIUS, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_DIMENSION_RADIUS, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_RADIUS, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_DIMENSION_RADIUS, block),
    1,0,0, 0 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, first_arc_pt),
    1,0,0, 15 },
  { "leader_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_DIMENSION_RADIUS, leader_len),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ELLIPSE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ELLIPSE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ELLIPSE, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ELLIPSE, center),
    1,0,0, 10 },
  { "sm_axis",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_ELLIPSE, sm_axis),
    1,0,0, 11 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_ELLIPSE, extrusion),
    0,0,0, 210 },
  { "axis_ratio",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ELLIPSE, axis_ratio),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ELLIPSE, start_angle),
    0,0,0, 41 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_ELLIPSE, end_angle),
    0,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ENDBLK: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ENDBLK_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ENDBLK, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_EXTRUDEDSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EXTRUDEDSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, modeler_format_version),
    0,0,0, 0 },
  { "bindata_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, bindata_size),
    0,0,0, 0 },
  { "bindata",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, bindata),
    1,1,0, 0 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, class_version),
    0,0,0, 0 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, draft_angle),
    0,0,0, 42 },
  { "draft_start_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, draft_start_distance),
    0,0,0, 43 },
  { "draft_end_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, draft_end_distance),
    0,0,0, 44 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, twist_angle),
    0,0,0, 45 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, scale_factor),
    0,0,0, 48 },
  { "align_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, align_angle),
    0,0,0, 49 },
  { "sweep_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_entity_transmatrix),
    1,1,0, 46 },
  { "path_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, path_entity_transmatrix),
    1,1,0, 47 },
  { "is_solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, is_solid),
    0,0,0, 290 },
  { "sweep_alignment_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_alignment_flags),
    0,0,0, 70 },
  { "path_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, path_flags),
    0,0,0, 71 },
  { "align_start",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, align_start),
    0,0,0, 292 },
  { "bank",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, bank),
    0,0,0, 293 },
  { "base_point_set",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, base_point_set),
    0,0,0, 294 },
  { "sweep_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_entity_transform_computed),
    0,0,0, 295 },
  { "path_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, path_entity_transform_computed),
    0,0,0, 296 },
  { "reference_vector_for_controlling_twist",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, reference_vector_for_controlling_twist),
    1,0,0, 11 },
  { "sweep_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_entity),
    1,0,0, 0 },
  { "path_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, path_entity),
    1,0,0, 0 },
  { "sweep_vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_vector),
    1,0,0, 10 },
  { "sweep_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_EXTRUDEDSURFACE, sweep_transmatrix),
    1,1,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_FLIPPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FLIPPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_FLIPPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_GEOPOSITIONMARKER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEOPOSITIONMARKER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, class_version),
    0,0,0, 90 },
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, position),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, radius),
    0,0,0, 40 },
  { "landing_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, landing_gap),
    0,0,0, 40 },
  { "notes",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, notes),
    1,1,1, 1 },
  { "text_alignment",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, text_alignment),
    0,0,0, 280 },
  { "mtext_visible",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, mtext_visible),
    0,0,0, 290 },
  { "enable_frame_text",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, enable_frame_text),
    0,0,0, 290 },
  { "mtext",	"struct _dwg_object*", sizeof (void *),  OFF (struct _dwg_entity_GEOPOSITIONMARKER, mtext),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_HATCH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_HATCH, parent),
    1,1,0, 0 },
  { "is_gradient_fill",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, is_gradient_fill),
    0,0,0, 450 },
  { "reserved",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, reserved),
    0,0,0, 451 },
  { "gradient_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, gradient_angle),
    0,0,0, 460 },
  { "gradient_shift",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, gradient_shift),
    0,0,0, 461 },
  { "single_color_gradient",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, single_color_gradient),
    0,0,0, 452 },
  { "gradient_tint",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, gradient_tint),
    0,0,0, 462 },
  { "num_colors",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, num_colors),
    0,0,0, 453 },
  { "colors",	"Dwg_HATCH_Color*", sizeof (Dwg_HATCH_Color*),  OFF (struct _dwg_entity_HATCH, colors),
    1,1,0, 0 },
  { "gradient_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_HATCH, gradient_name),
    1,1,1, 470 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, elevation),
    0,0,0, 30 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_HATCH, extrusion),
    0,0,0, 210 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_HATCH, name),
    1,1,1, 2 },
  { "is_solid_fill",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, is_solid_fill),
    0,0,0, 70 },
  { "is_associative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, is_associative),
    0,0,0, 71 },
  { "num_paths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, num_paths),
    0,0,0, 91 },
  { "paths",	"Dwg_HATCH_Path*", sizeof (Dwg_HATCH_Path*),  OFF (struct _dwg_entity_HATCH, paths),
    1,1,0, 0 },
  { "style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HATCH, style),
    0,0,0, 75 },
  { "pattern_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HATCH, pattern_type),
    0,0,0, 76 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, angle),
    0,0,0, 52 },
  { "scale_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, scale_spacing),
    0,0,0, 41 },
  { "double_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, double_flag),
    0,0,0, 77 },
  { "num_deflines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HATCH, num_deflines),
    0,0,0, 78 },
  { "deflines",	"Dwg_HATCH_DefLine*", sizeof (Dwg_HATCH_DefLine*),  OFF (struct _dwg_entity_HATCH, deflines),
    1,1,0, 0 },
  { "has_derived",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HATCH, has_derived),
    0,0,0, 0 },
  { "pixel_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HATCH, pixel_size),
    0,0,0, 47 },
  { "num_seeds",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HATCH, num_seeds),
    0,0,0, 98 },
  { "seeds",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_HATCH, seeds),
    1,1,0, 10 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_HELIX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HELIX_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_HELIX, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, flag),
    0,0,0, 70 },
  { "scenario",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, scenario),
    0,0,0, 0 },
  { "degree",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, degree),
    0,0,0, 71 },
  { "splineflags1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, splineflags1),
    0,0,0, 0 },
  { "knotparam",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, knotparam),
    0,0,0, 0 },
  { "fit_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, fit_tol),
    0,0,0, 44 },
  { "beg_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, beg_tan_vec),
    1,0,0, 12 },
  { "end_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, end_tan_vec),
    1,0,0, 13 },
  { "rational",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, rational),
    0,0,0, 0 },
  { "closed_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, closed_b),
    0,0,0, 0 },
  { "periodic",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, periodic),
    0,0,0, 0 },
  { "weighted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, weighted),
    0,0,0, 0 },
  { "knot_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, knot_tol),
    0,0,0, 42 },
  { "ctrl_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, ctrl_tol),
    0,0,0, 43 },
  { "num_fit_pts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_HELIX, num_fit_pts),
    0,0,0, 74 },
  { "fit_pts",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_entity_HELIX, fit_pts),
    1,1,0, 11 },
  { "num_knots",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, num_knots),
    0,0,0, 72 },
  { "knots",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_HELIX, knots),
    1,1,0, 40 },
  { "num_ctrl_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, num_ctrl_pts),
    0,0,0, 73 },
  { "ctrl_pts",	"Dwg_SPLINE_control_point*", sizeof (Dwg_SPLINE_control_point*),  OFF (struct _dwg_entity_HELIX, ctrl_pts),
    1,1,0, 0 },
  { "major_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, major_version),
    0,0,0, 90 },
  { "maint_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_HELIX, maint_version),
    0,0,0, 91 },
  { "axis_base_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, axis_base_pt),
    1,0,0, 10 },
  { "start_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, start_pt),
    1,0,0, 11 },
  { "axis_vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_HELIX, axis_vector),
    1,0,0, 12 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, radius),
    0,0,0, 40 },
  { "turns",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, turns),
    0,0,0, 41 },
  { "turn_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_HELIX, turn_height),
    0,0,0, 42 },
  { "handedness",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_HELIX, handedness),
    0,0,0, 290 },
  { "constraint_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_HELIX, constraint_type),
    0,0,0, 280 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_IMAGE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IMAGE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_IMAGE, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_IMAGE, class_version),
    0,0,0, 90 },
  { "pt0",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_IMAGE, pt0),
    1,0,0, 10 },
  { "uvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_IMAGE, uvec),
    1,0,0, 11 },
  { "vvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_IMAGE, vvec),
    1,0,0, 12 },
  { "size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_IMAGE, size),
    1,0,0, 13 },
  { "display_props",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_IMAGE, display_props),
    0,0,0, 70 },
  { "clipping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_IMAGE, clipping),
    0,0,0, 280 },
  { "brightness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_IMAGE, brightness),
    0,0,0, 281 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_IMAGE, contrast),
    0,0,0, 282 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_IMAGE, fade),
    0,0,0, 283 },
  { "clip_mode",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_IMAGE, clip_mode),
    0,0,0, 290 },
  { "clip_boundary_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_IMAGE, clip_boundary_type),
    0,0,0, 71 },
  { "num_clip_verts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_IMAGE, num_clip_verts),
    0,0,0, 91 },
  { "clip_verts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_IMAGE, clip_verts),
    1,1,0, 14 },
  { "imagedef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_IMAGE, imagedef),
    1,0,0, 340 },
  { "imagedefreactor",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_IMAGE, imagedefreactor),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_INSERT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_INSERT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_INSERT, parent),
    1,1,0, 0 },
  { "ins_pt",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_INSERT, ins_pt),
    1,0,0, 10 },
  { "scale_flag",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_entity_INSERT, scale_flag),
    0,0,0, 0 },
  { "scale",	"3BD_1", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_INSERT, scale),
    1,0,0, 41 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_INSERT, rotation),
    0,0,0, 50 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_INSERT, extrusion),
    0,0,0, 210 },
  { "has_attribs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_INSERT, has_attribs),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_INSERT, num_owned),
    0,0,0, 0 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, block_header),
    1,0,0, 2 },
  { "first_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, first_attrib),
    1,0,0, 0 },
  { "last_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, last_attrib),
    1,0,0, 0 },
  { "attribs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_INSERT, attribs),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_INSERT, seqend),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LARGE_RADIAL_DIMENSION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LARGE_RADIAL_DIMENSION_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, flag1),
    0,0,0, 0 },
  { "user_text",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, block),
    1,0,0, 0 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, first_arc_pt),
    1,0,0, 15 },
  { "leader_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, leader_len),
    0,0,0, 40 },
  { "ovr_center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, ovr_center),
    1,0,0, 12 },
  { "jog_point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LARGE_RADIAL_DIMENSION, jog_point),
    1,0,0, 13 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LEADER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LEADER, parent),
    1,1,0, 0 },
  { "unknown_bit_1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_1),
    0,0,0, 0 },
  { "path_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, path_type),
    0,0,0, 72 },
  { "annot_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, annot_type),
    0,0,0, 73 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LEADER, num_points),
    0,0,0, 76 },
  { "points",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_entity_LEADER, points),
    1,1,0, 10 },
  { "origin",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, origin),
    1,0,0, 0 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_LEADER, extrusion),
    0,0,0, 210 },
  { "x_direction",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, x_direction),
    1,0,0, 211 },
  { "inspt_offset",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, inspt_offset),
    1,0,0, 212 },
  { "endptproj",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_LEADER, endptproj),
    1,0,0, 0 },
  { "dimgap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, dimgap),
    0,0,0, 0 },
  { "box_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, box_height),
    0,0,0, 40 },
  { "box_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, box_width),
    0,0,0, 0 },
  { "hookline_dir",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, hookline_dir),
    0,0,0, 74 },
  { "arrowhead_on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, arrowhead_on),
    0,0,0, 71 },
  { "arrowhead_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, arrowhead_type),
    0,0,0, 0 },
  { "dimasz",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LEADER, dimasz),
    0,0,0, 0 },
  { "unknown_bit_2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_2),
    0,0,0, 0 },
  { "unknown_bit_3",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_3),
    0,0,0, 0 },
  { "unknown_short_1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, unknown_short_1),
    0,0,0, 0 },
  { "byblock_color",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LEADER, byblock_color),
    0,0,0, 77 },
  { "hookline_on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, hookline_on),
    0,0,0, 75 },
  { "unknown_bit_5",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LEADER, unknown_bit_5),
    0,0,0, 0 },
  { "associated_annotation",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LEADER, associated_annotation),
    1,0,0, 340 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LEADER, dimstyle),
    1,0,0, 3 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LIGHT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LIGHT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LIGHT, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LIGHT, class_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_LIGHT, name),
    1,1,1, 1 },
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LIGHT, type),
    0,0,0, 70 },
  { "status",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, status),
    0,0,0, 290 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_LIGHT, color),
    0,0,0, 63 },
  { "plot_glyph",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, plot_glyph),
    0,0,0, 291 },
  { "intensity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, intensity),
    0,0,0, 40 },
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LIGHT, position),
    1,0,0, 10 },
  { "target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LIGHT, target),
    1,0,0, 11 },
  { "attenuation_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LIGHT, attenuation_type),
    0,0,0, 72 },
  { "use_attenuation_limits",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, use_attenuation_limits),
    0,0,0, 292 },
  { "attenuation_start_limit",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, attenuation_start_limit),
    0,0,0, 41 },
  { "attenuation_end_limit",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, attenuation_end_limit),
    0,0,0, 42 },
  { "hotspot_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, hotspot_angle),
    0,0,0, 50 },
  { "falloff_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, falloff_angle),
    0,0,0, 51 },
  { "cast_shadows",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, cast_shadows),
    0,0,0, 293 },
  { "shadow_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LIGHT, shadow_type),
    0,0,0, 73 },
  { "shadow_map_size",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, shadow_map_size),
    0,0,0, 91 },
  { "shadow_map_softness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LIGHT, shadow_map_softness),
    0,0,0, 280 },
  { "is_photometric",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, is_photometric),
    0,0,0, 0 },
  { "has_photometric_data",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, has_photometric_data),
    0,0,0, 1 },
  { "has_webfile",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LIGHT, has_webfile),
    0,0,0, 290 },
  { "webfile",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_LIGHT, webfile),
    1,1,1, 300 },
  { "physical_intensity_method",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, physical_intensity_method),
    0,0,0, 70 },
  { "physical_intensity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, physical_intensity),
    0,0,0, 40 },
  { "illuminance_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, illuminance_dist),
    0,0,0, 41 },
  { "lamp_color_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, lamp_color_type),
    0,0,0, 71 },
  { "lamp_color_temp",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, lamp_color_temp),
    0,0,0, 42 },
  { "lamp_color_preset",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, lamp_color_preset),
    0,0,0, 72 },
  { "lamp_color_rgb",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LIGHT, lamp_color_rgb),
    0,0,0, 0 },
  { "web_rotation",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LIGHT, web_rotation),
    1,0,0, 43 },
  { "extlight_shape",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, extlight_shape),
    0,0,0, 73 },
  { "extlight_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, extlight_length),
    0,0,0, 46 },
  { "extlight_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, extlight_width),
    0,0,0, 47 },
  { "extlight_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, extlight_radius),
    0,0,0, 48 },
  { "webfile_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, webfile_type),
    0,0,0, 74 },
  { "web_symetry",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, web_symetry),
    0,0,0, 75 },
  { "has_target_grip",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, has_target_grip),
    0,0,0, 76 },
  { "web_flux",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, web_flux),
    0,0,0, 49 },
  { "web_angle1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, web_angle1),
    0,0,0, 50 },
  { "web_angle2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, web_angle2),
    0,0,0, 51 },
  { "web_angle3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, web_angle3),
    0,0,0, 52 },
  { "web_angle4",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, web_angle4),
    0,0,0, 53 },
  { "web_angle5",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LIGHT, web_angle5),
    0,0,0, 54 },
  { "glyph_display_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LIGHT, glyph_display_type),
    0,0,0, 77 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LINE, parent),
    1,1,0, 0 },
  { "z_is_zero",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LINE, z_is_zero),
    0,0,0, 0 },
  { "start",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LINE, start),
    1,0,0, 10 },
  { "end",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LINE, end),
    1,0,0, 11 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_LINE, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_LINE, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LINEARPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LINEARPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LINEARPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LOFTEDSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LOFTEDSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LOFTEDSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_LOFTEDSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_LOFTEDSURFACE, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_LOFTEDSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_LOFTEDSURFACE, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_LOFTEDSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_entity_LOFTEDSURFACE, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LOFTEDSURFACE, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_LOFTEDSURFACE, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LOFTEDSURFACE, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, v_isolines),
    0,0,0, 72 },
  { "loft_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_LOFTEDSURFACE, loft_entity_transmatrix),
    1,1,0, 40 },
  { "plane_normal_lofting_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LOFTEDSURFACE, plane_normal_lofting_type),
    0,0,0, 70 },
  { "start_draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, start_draft_angle),
    0,0,0, 41 },
  { "end_draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, end_draft_angle),
    0,0,0, 42 },
  { "start_draft_magnitude",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, start_draft_magnitude),
    0,0,0, 43 },
  { "end_draft_magnitude",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LOFTEDSURFACE, end_draft_magnitude),
    0,0,0, 44 },
  { "arc_length_parameterization",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, arc_length_parameterization),
    0,0,0, 290 },
  { "no_twist",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, no_twist),
    0,0,0, 291 },
  { "align_direction",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, align_direction),
    0,0,0, 292 },
  { "simple_surfaces",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, simple_surfaces),
    0,0,0, 293 },
  { "closed_surfaces",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, closed_surfaces),
    0,0,0, 294 },
  { "solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, solid),
    0,0,0, 295 },
  { "ruled_surface",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, ruled_surface),
    0,0,0, 296 },
  { "virtual_guide",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_LOFTEDSURFACE, virtual_guide),
    0,0,0, 297 },
  { "num_cross_sections",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_cross_sections),
    0,0,0, 0 },
  { "num_guide_curves",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LOFTEDSURFACE, num_guide_curves),
    0,0,0, 0 },
  { "cross_sections",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_LOFTEDSURFACE, cross_sections),
    1,1,0, 310 },
  { "guide_curves",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_LOFTEDSURFACE, guide_curves),
    1,1,0, 310 },
  { "path_curve",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_LOFTEDSURFACE, path_curve),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_LWPOLYLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LWPOLYLINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_LWPOLYLINE, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_LWPOLYLINE, flag),
    0,0,0, 70 },
  { "const_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LWPOLYLINE, const_width),
    0,0,0, 43 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LWPOLYLINE, elevation),
    0,0,0, 38 },
  { "thickness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_LWPOLYLINE, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_LWPOLYLINE, extrusion),
    0,0,0, 210 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_points),
    0,0,0, 90 },
  { "points",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_LWPOLYLINE, points),
    1,1,0, 10 },
  { "num_bulges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_bulges),
    0,0,0, 0 },
  { "bulges",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_LWPOLYLINE, bulges),
    1,1,0, 42 },
  { "num_vertexids",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_vertexids),
    0,0,0, 0 },
  { "vertexids",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_LWPOLYLINE, vertexids),
    1,1,0, 91 },
  { "num_widths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_LWPOLYLINE, num_widths),
    0,0,0, 0 },
  { "widths",	"Dwg_LWPOLYLINE_width*", sizeof (Dwg_LWPOLYLINE_width*),  OFF (struct _dwg_entity_LWPOLYLINE, widths),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MESH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MESH_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MESH, parent),
    1,1,0, 0 },
  { "dlevel",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MESH, dlevel),
    0,0,0, 71 },
  { "is_watertight",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MESH, is_watertight),
    0,0,0, 72 },
  { "num_subdiv_vertex",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_subdiv_vertex),
    0,0,0, 91 },
  { "subdiv_vertex",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_entity_MESH, subdiv_vertex),
    1,1,0, 10 },
  { "num_vertex",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_vertex),
    0,0,0, 92 },
  { "vertex",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_entity_MESH, vertex),
    1,1,0, 10 },
  { "num_faces",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_faces),
    0,0,0, 93 },
  { "faces",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_MESH, faces),
    1,1,0, 90 },
  { "num_edges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_edges),
    0,0,0, 94 },
  { "edges",	"Dwg_MESH_edge*", sizeof (Dwg_MESH_edge*),  OFF (struct _dwg_entity_MESH, edges),
    1,1,0, 0 },
  { "num_crease",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MESH, num_crease),
    0,0,0, 95 },
  { "crease",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_MESH, crease),
    1,1,0, 140 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MINSERT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MINSERT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MINSERT, parent),
    1,1,0, 0 },
  { "ins_pt",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_MINSERT, ins_pt),
    1,0,0, 10 },
  { "scale_flag",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_entity_MINSERT, scale_flag),
    0,0,0, 0 },
  { "scale",	"3BD_1", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_entity_MINSERT, scale),
    1,0,0, 41 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MINSERT, rotation),
    0,0,0, 50 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_MINSERT, extrusion),
    0,0,0, 210 },
  { "has_attribs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MINSERT, has_attribs),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MINSERT, num_owned),
    0,0,0, 0 },
  { "num_cols",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MINSERT, num_cols),
    0,0,0, 70 },
  { "num_rows",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MINSERT, num_rows),
    0,0,0, 71 },
  { "col_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MINSERT, col_spacing),
    0,0,0, 44 },
  { "row_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MINSERT, row_spacing),
    0,0,0, 45 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, block_header),
    1,0,0, 2 },
  { "first_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, first_attrib),
    1,0,0, 0 },
  { "last_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, last_attrib),
    1,0,0, 0 },
  { "attribs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_MINSERT, attribs),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MINSERT, seqend),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MLINE, parent),
    1,1,0, 0 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MLINE, scale),
    0,0,0, 40 },
  { "justification",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_MLINE, justification),
    0,0,0, 70 },
  { "base_point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MLINE, base_point),
    1,0,0, 10 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_MLINE, extrusion),
    0,0,0, 210 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MLINE, flags),
    0,0,0, 71 },
  { "num_lines",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_MLINE, num_lines),
    0,0,0, 73 },
  { "num_verts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MLINE, num_verts),
    0,0,0, 72 },
  { "verts",	"Dwg_MLINE_vertex*", sizeof (Dwg_MLINE_vertex*),  OFF (struct _dwg_entity_MLINE, verts),
    1,1,0, 0 },
  { "mlinestyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MLINE, mlinestyle),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MPOLYGON: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MPOLYGON_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MPOLYGON, parent),
    1,1,0, 0 },
  { "is_gradient_fill",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MPOLYGON, is_gradient_fill),
    0,0,0, 0 },
  { "reserved",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MPOLYGON, reserved),
    0,0,0, 0 },
  { "gradient_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MPOLYGON, gradient_angle),
    0,0,0, 0 },
  { "gradient_shift",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MPOLYGON, gradient_shift),
    0,0,0, 0 },
  { "single_color_gradient",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MPOLYGON, single_color_gradient),
    0,0,0, 0 },
  { "gradient_tint",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MPOLYGON, gradient_tint),
    0,0,0, 0 },
  { "num_colors",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MPOLYGON, num_colors),
    0,0,0, 0 },
  { "colors",	"Dwg_HATCH_Color*", sizeof (Dwg_HATCH_Color*),  OFF (struct _dwg_entity_MPOLYGON, colors),
    1,1,0, 0 },
  { "gradient_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_MPOLYGON, gradient_name),
    1,1,1, 0 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MPOLYGON, elevation),
    0,0,0, 30 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_MPOLYGON, extrusion),
    0,0,0, 210 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_MPOLYGON, name),
    1,1,1, 2 },
  { "is_solid_fill",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MPOLYGON, is_solid_fill),
    0,0,0, 70 },
  { "is_associative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MPOLYGON, is_associative),
    0,0,0, 71 },
  { "num_paths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MPOLYGON, num_paths),
    0,0,0, 91 },
  { "paths",	"Dwg_HATCH_Path*", sizeof (Dwg_HATCH_Path*),  OFF (struct _dwg_entity_MPOLYGON, paths),
    1,1,0, 0 },
  { "style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MPOLYGON, style),
    0,0,0, 75 },
  { "pattern_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MPOLYGON, pattern_type),
    0,0,0, 76 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MPOLYGON, angle),
    0,0,0, 52 },
  { "scale_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MPOLYGON, scale_spacing),
    0,0,0, 41 },
  { "double_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MPOLYGON, double_flag),
    0,0,0, 77 },
  { "num_deflines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MPOLYGON, num_deflines),
    0,0,0, 78 },
  { "deflines",	"Dwg_HATCH_DefLine*", sizeof (Dwg_HATCH_DefLine*),  OFF (struct _dwg_entity_MPOLYGON, deflines),
    1,1,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MPOLYGON, color),
    0,0,0, 62 },
  { "x_dir",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_MPOLYGON, x_dir),
    1,0,0, 11 },
  { "num_boundary_handles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MPOLYGON, num_boundary_handles),
    0,0,0, 99 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MTEXT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MTEXT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MTEXT, parent),
    1,1,0, 0 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MTEXT, ins_pt),
    1,0,0, 10 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_MTEXT, extrusion),
    0,0,0, 210 },
  { "x_axis_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MTEXT, x_axis_dir),
    1,0,0, 11 },
  { "rect_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, rect_height),
    0,0,0, 41 },
  { "rect_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, rect_width),
    0,0,0, 40 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, text_height),
    0,0,0, 40 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, attachment),
    0,0,0, 71 },
  { "flow_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, flow_dir),
    0,0,0, 72 },
  { "extents_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, extents_width),
    0,0,0, 42 },
  { "extents_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, extents_height),
    0,0,0, 43 },
  { "text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_MTEXT, text),
    1,1,1, 1 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MTEXT, style),
    1,0,0, 7 },
  { "linespace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, linespace_style),
    0,0,0, 73 },
  { "linespace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, linespace_factor),
    0,0,0, 44 },
  { "unknown_b0",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, unknown_b0),
    0,0,0, 0 },
  { "bg_fill_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, bg_fill_flag),
    0,0,0, 90 },
  { "bg_fill_scale",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, bg_fill_scale),
    0,0,0, 45 },
  { "bg_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MTEXT, bg_fill_color),
    0,0,0, 63 },
  { "bg_fill_trans",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, bg_fill_trans),
    0,0,0, 441 },
  { "is_not_annotative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, is_not_annotative),
    0,0,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, class_version),
    0,0,0, 0 },
  { "default_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, default_flag),
    0,0,0, 70 },
  { "appid",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MTEXT, appid),
    1,0,0, 0 },
  { "ignore_attachment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, ignore_attachment),
    0,0,0, 0 },
  { "column_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MTEXT, column_type),
    0,0,0, 71 },
  { "numfragments",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, numfragments),
    0,0,0, 72 },
  { "column_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, column_width),
    0,0,0, 44 },
  { "gutter",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MTEXT, gutter),
    0,0,0, 45 },
  { "auto_height",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, auto_height),
    0,0,0, 73 },
  { "flow_reversed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MTEXT, flow_reversed),
    0,0,0, 74 },
  { "num_column_heights",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MTEXT, num_column_heights),
    0,0,0, 72 },
  { "column_heights",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_MTEXT, column_heights),
    1,1,0, 46 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_MULTILEADER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MULTILEADER_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_MULTILEADER, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, class_version),
    0,0,0, 270 },
  { "ctx",	"Dwg_MLEADER_AnnotContext", sizeof (Dwg_MLEADER_AnnotContext),  OFF (struct _dwg_entity_MULTILEADER, ctx),
    0,0,0, 0 },
  { "mleaderstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, mleaderstyle),
    1,0,0, 340 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MULTILEADER, flags),
    0,0,0, 90 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, type),
    0,0,0, 170 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MULTILEADER, color),
    0,0,0, 91 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, ltype),
    1,0,0, 341 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_entity_MULTILEADER, linewt),
    0,0,0, 171 },
  { "has_landing",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, has_landing),
    0,0,0, 290 },
  { "has_dogleg",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, has_dogleg),
    0,0,0, 291 },
  { "landing_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, landing_dist),
    0,0,0, 41 },
  { "arrow_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, arrow_handle),
    1,0,0, 342 },
  { "arrow_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, arrow_size),
    0,0,0, 42 },
  { "style_content",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, style_content),
    0,0,0, 172 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, text_style),
    1,0,0, 343 },
  { "text_left",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, text_left),
    0,0,0, 173 },
  { "text_right",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, text_right),
    0,0,0, 95 },
  { "text_angletype",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, text_angletype),
    0,0,0, 174 },
  { "text_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, text_alignment),
    0,0,0, 175 },
  { "text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MULTILEADER, text_color),
    0,0,0, 92 },
  { "has_text_frame",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, has_text_frame),
    0,0,0, 292 },
  { "block_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_MULTILEADER, block_style),
    1,0,0, 344 },
  { "block_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_MULTILEADER, block_color),
    0,0,0, 93 },
  { "block_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_MULTILEADER, block_scale),
    1,0,0, 10 },
  { "block_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, block_rotation),
    0,0,0, 43 },
  { "style_attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, style_attachment),
    0,0,0, 176 },
  { "is_annotative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, is_annotative),
    0,0,0, 293 },
  { "num_arrowheads",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MULTILEADER, num_arrowheads),
    0,0,0, 0 },
  { "arrowheads",	"Dwg_LEADER_ArrowHead*", sizeof (Dwg_LEADER_ArrowHead*),  OFF (struct _dwg_entity_MULTILEADER, arrowheads),
    1,1,0, 0 },
  { "num_blocklabels",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_MULTILEADER, num_blocklabels),
    0,0,0, 0 },
  { "blocklabels",	"Dwg_LEADER_BlockLabel*", sizeof (Dwg_LEADER_BlockLabel*),  OFF (struct _dwg_entity_MULTILEADER, blocklabels),
    1,1,0, 0 },
  { "is_neg_textdir",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, is_neg_textdir),
    0,0,0, 294 },
  { "ipe_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, ipe_alignment),
    0,0,0, 178 },
  { "justification",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, justification),
    0,0,0, 179 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_MULTILEADER, scale_factor),
    0,0,0, 45 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, attach_dir),
    0,0,0, 271 },
  { "attach_top",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, attach_top),
    0,0,0, 273 },
  { "attach_bottom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_MULTILEADER, attach_bottom),
    0,0,0, 272 },
  { "is_text_extended",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_MULTILEADER, is_text_extended),
    0,0,0, 295 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_NAVISWORKSMODEL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_NAVISWORKSMODEL_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_NAVISWORKSMODEL, parent),
    1,1,0, 0 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_NAVISWORKSMODEL, flags),
    0,0,0, 70 },
  { "definition",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_NAVISWORKSMODEL, definition),
    1,0,0, 340 },
  { "transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_NAVISWORKSMODEL, transmatrix),
    1,1,0, 40 },
  { "unitfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_NAVISWORKSMODEL, unitfactor),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_NURBSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_NURBSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_NURBSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_NURBSURFACE, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_NURBSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_NURBSURFACE, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_NURBSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_NURBSURFACE, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_NURBSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_NURBSURFACE, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_NURBSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_entity_NURBSURFACE, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_NURBSURFACE, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_NURBSURFACE, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_NURBSURFACE, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_NURBSURFACE, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_NURBSURFACE, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_NURBSURFACE, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_NURBSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_NURBSURFACE, v_isolines),
    0,0,0, 72 },
  { "short170",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_NURBSURFACE, short170),
    0,0,0, 170 },
  { "cv_hull_display",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_NURBSURFACE, cv_hull_display),
    0,0,0, 290 },
  { "uvec1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_NURBSURFACE, uvec1),
    1,0,0, 10 },
  { "vvec1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_NURBSURFACE, vvec1),
    1,0,0, 11 },
  { "uvec2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_NURBSURFACE, uvec2),
    1,0,0, 12 },
  { "vvec2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_NURBSURFACE, vvec2),
    1,0,0, 13 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_OLE2FRAME: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OLE2FRAME_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_OLE2FRAME, parent),
    1,1,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLE2FRAME, type),
    0,0,0, 71 },
  { "mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLE2FRAME, mode),
    0,0,0, 72 },
  { "lock_aspect",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_OLE2FRAME, lock_aspect),
    0,0,0, 73 },
  { "data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_OLE2FRAME, data_size),
    0,0,0, 90 },
  { "data",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_OLE2FRAME, data),
    1,1,0, 310 },
  { "oleversion",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLE2FRAME, oleversion),
    0,0,0, 70 },
  { "oleclient",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_OLE2FRAME, oleclient),
    1,1,0, 3 },
  { "pt1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_OLE2FRAME, pt1),
    1,0,0, 10 },
  { "pt2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_OLE2FRAME, pt2),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_OLEFRAME: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OLEFRAME_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_OLEFRAME, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLEFRAME, flag),
    0,0,0, 70 },
  { "mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_OLEFRAME, mode),
    0,0,0, 0 },
  { "data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_OLEFRAME, data_size),
    0,0,0, 90 },
  { "data",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_OLEFRAME, data),
    1,1,0, 310 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_PLANESURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PLANESURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_PLANESURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_PLANESURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_PLANESURFACE, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_PLANESURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_PLANESURFACE, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_PLANESURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_PLANESURFACE, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_PLANESURFACE, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_entity_PLANESURFACE, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_PLANESURFACE, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_PLANESURFACE, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_PLANESURFACE, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PLANESURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_PLANESURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PLANESURFACE, class_version),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POINT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POINT, parent),
    1,1,0, 0 },
  { "x",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, x),
    0,0,0, 10 },
  { "y",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, y),
    0,0,0, 20 },
  { "z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, z),
    0,0,0, 30 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_POINT, thickness),
    0,0,0, 39 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_POINT, extrusion),
    0,0,0, 210 },
  { "x_ang",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINT, x_ang),
    0,0,0, 50 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POINTCLOUD: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUD_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POINTCLOUD, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POINTCLOUD, class_version),
    0,0,0, 70 },
  { "origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUD, origin),
    1,0,0, 10 },
  { "saved_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_POINTCLOUD, saved_filename),
    1,1,1, 1 },
  { "num_source_files",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POINTCLOUD, num_source_files),
    0,0,0, 90 },
  { "source_files",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_entity_POINTCLOUD, source_files),
    1,1,0, 2 },
  { "extents_min",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUD, extents_min),
    1,0,0, 11 },
  { "extents_max",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUD, extents_max),
    1,0,0, 12 },
  { "numpoints",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_entity_POINTCLOUD, numpoints),
    0,0,0, 92 },
  { "ucs_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_POINTCLOUD, ucs_name),
    1,1,1, 3 },
  { "ucs_origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUD, ucs_origin),
    1,0,0, 13 },
  { "ucs_x_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUD, ucs_x_dir),
    1,0,0, 210 },
  { "ucs_y_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUD, ucs_y_dir),
    1,0,0, 211 },
  { "ucs_z_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUD, ucs_z_dir),
    1,0,0, 212 },
  { "pointclouddef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POINTCLOUD, pointclouddef),
    1,0,0, 330 },
  { "reactor",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POINTCLOUD, reactor),
    1,0,0, 360 },
  { "show_intensity",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUD, show_intensity),
    0,0,0, 0 },
  { "intensity_scheme",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POINTCLOUD, intensity_scheme),
    0,0,0, 71 },
  { "intensity_style",	"Dwg_POINTCLOUD_IntensityStyle", sizeof (Dwg_POINTCLOUD_IntensityStyle),  OFF (struct _dwg_entity_POINTCLOUD, intensity_style),
    0,0,0, 0 },
  { "show_clipping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUD, show_clipping),
    0,0,0, 0 },
  { "num_clippings",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POINTCLOUD, num_clippings),
    0,0,0, 0 },
  { "clippings",	"Dwg_POINTCLOUD_Clippings*", sizeof (Dwg_POINTCLOUD_Clippings*),  OFF (struct _dwg_entity_POINTCLOUD, clippings),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POINTCLOUDEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDEX_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POINTCLOUDEX, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POINTCLOUDEX, class_version),
    0,0,0, 70 },
  { "extents_min",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUDEX, extents_min),
    1,0,0, 10 },
  { "extents_max",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUDEX, extents_max),
    1,0,0, 11 },
  { "ucs_origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUDEX, ucs_origin),
    1,0,0, 12 },
  { "ucs_x_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUDEX, ucs_x_dir),
    1,0,0, 210 },
  { "ucs_y_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUDEX, ucs_y_dir),
    1,0,0, 211 },
  { "ucs_z_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_POINTCLOUDEX, ucs_z_dir),
    1,0,0, 212 },
  { "is_locked",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUDEX, is_locked),
    0,0,0, 290 },
  { "pointclouddefex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POINTCLOUDEX, pointclouddefex),
    1,0,0, 330 },
  { "reactor",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POINTCLOUDEX, reactor),
    1,0,0, 360 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_POINTCLOUDEX, name),
    1,1,1, 1 },
  { "show_intensity",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUDEX, show_intensity),
    0,0,0, 291 },
  { "stylization_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POINTCLOUDEX, stylization_type),
    0,0,0, 71 },
  { "intensity_colorscheme",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_POINTCLOUDEX, intensity_colorscheme),
    1,1,1, 1 },
  { "cur_colorscheme",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_POINTCLOUDEX, cur_colorscheme),
    1,1,1, 1 },
  { "classification_colorscheme",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_POINTCLOUDEX, classification_colorscheme),
    1,1,1, 1 },
  { "elevation_min",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINTCLOUDEX, elevation_min),
    0,0,0, 40 },
  { "elevation_max",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POINTCLOUDEX, elevation_max),
    0,0,0, 41 },
  { "intensity_min",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POINTCLOUDEX, intensity_min),
    0,0,0, 90 },
  { "intensity_max",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POINTCLOUDEX, intensity_max),
    0,0,0, 91 },
  { "intensity_out_of_range_behavior",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POINTCLOUDEX, intensity_out_of_range_behavior),
    0,0,0, 71 },
  { "elevation_out_of_range_behavior",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POINTCLOUDEX, elevation_out_of_range_behavior),
    0,0,0, 72 },
  { "elevation_apply_to_fixed_range",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUDEX, elevation_apply_to_fixed_range),
    0,0,0, 292 },
  { "intensity_as_gradient",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUDEX, intensity_as_gradient),
    0,0,0, 293 },
  { "elevation_as_gradient",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUDEX, elevation_as_gradient),
    0,0,0, 294 },
  { "show_cropping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POINTCLOUDEX, show_cropping),
    0,0,0, 295 },
  { "unknown_bl0",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POINTCLOUDEX, unknown_bl0),
    0,0,0, 93 },
  { "unknown_bl1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POINTCLOUDEX, unknown_bl1),
    0,0,0, 93 },
  { "num_croppings",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POINTCLOUDEX, num_croppings),
    0,0,0, 92 },
  { "croppings",	"Dwg_POINTCLOUDEX_Croppings*", sizeof (Dwg_POINTCLOUDEX_Croppings*),  OFF (struct _dwg_entity_POINTCLOUDEX, croppings),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POINTPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POINTPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLARGRIPENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLARGRIPENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLARGRIPENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_2D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_2D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_2D, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_2D, has_vertex),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_2D, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_2D, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_2D, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_2D, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_2D, seqend),
    1,0,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_2D, flag),
    0,0,0, 70 },
  { "curve_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_2D, curve_type),
    0,0,0, 75 },
  { "start_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POLYLINE_2D, start_width),
    0,0,0, 40 },
  { "end_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POLYLINE_2D, end_width),
    0,0,0, 41 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_POLYLINE_2D, thickness),
    0,0,0, 39 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_POLYLINE_2D, elevation),
    0,0,0, 0 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_POLYLINE_2D, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_3D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_3D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_3D, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_3D, has_vertex),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_3D, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_3D, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_3D, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_3D, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_3D, seqend),
    1,0,0, 0 },
  { "curve_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_POLYLINE_3D, curve_type),
    0,0,0, 75 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_POLYLINE_3D, flag),
    0,0,0, 70 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_MESH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_MESH_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_MESH, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_MESH, has_vertex),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_MESH, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_MESH, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_MESH, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_MESH, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_MESH, seqend),
    1,0,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, flag),
    0,0,0, 70 },
  { "curve_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, curve_type),
    0,0,0, 75 },
  { "num_m_verts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, num_m_verts),
    0,0,0, 71 },
  { "num_n_verts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, num_n_verts),
    0,0,0, 72 },
  { "m_density",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, m_density),
    0,0,0, 73 },
  { "n_density",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_MESH, n_density),
    0,0,0, 74 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_POLYLINE_PFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POLYLINE_PFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_POLYLINE_PFACE, parent),
    1,1,0, 0 },
  { "has_vertex",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_POLYLINE_PFACE, has_vertex),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_POLYLINE_PFACE, num_owned),
    0,0,0, 0 },
  { "first_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_PFACE, first_vertex),
    1,0,0, 0 },
  { "last_vertex",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_PFACE, last_vertex),
    1,0,0, 0 },
  { "vertex",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_POLYLINE_PFACE, vertex),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_POLYLINE_PFACE, seqend),
    1,0,0, 0 },
  { "numverts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_PFACE, numverts),
    0,0,0, 71 },
  { "numfaces",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_POLYLINE_PFACE, numfaces),
    0,0,0, 72 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_PROXY_ENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PROXY_ENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_PROXY_ENTITY, parent),
    1,1,0, 0 },
  { "class_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, class_id),
    0,0,0, 91 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, version),
    0,0,0, 95 },
  { "maint_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, maint_version),
    0,0,0, 97 },
  { "from_dxf",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_PROXY_ENTITY, from_dxf),
    0,0,0, 70 },
  { "data_numbits",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, data_numbits),
    0,0,0, 0 },
  { "data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, data_size),
    0,0,0, 93 },
  { "data",	"TF", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_PROXY_ENTITY, data),
    1,1,0, 310 },
  { "num_objids",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_PROXY_ENTITY, num_objids),
    0,0,0, 0 },
  { "objids",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_PROXY_ENTITY, objids),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_RAY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RAY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_RAY, parent),
    1,1,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_RAY, point),
    1,0,0, 10 },
  { "vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_RAY, vector),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_REVOLVEDSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_REVOLVEDSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_REVOLVEDSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_REVOLVEDSURFACE, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_REVOLVEDSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_REVOLVEDSURFACE, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_REVOLVEDSURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, class_version),
    0,0,0, 90 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_REVOLVEDSURFACE, id),
    0,0,0, 90 },
  { "axis_point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, axis_point),
    1,0,0, 10 },
  { "axis_vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, axis_vector),
    1,0,0, 11 },
  { "revolve_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revolve_angle),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, start_angle),
    0,0,0, 41 },
  { "revolved_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_REVOLVEDSURFACE, revolved_entity_transmatrix),
    1,1,0, 42 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, draft_angle),
    0,0,0, 43 },
  { "draft_start_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, draft_start_distance),
    0,0,0, 44 },
  { "draft_end_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, draft_end_distance),
    0,0,0, 45 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_REVOLVEDSURFACE, twist_angle),
    0,0,0, 46 },
  { "solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, solid),
    0,0,0, 290 },
  { "close_to_axis",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_REVOLVEDSURFACE, close_to_axis),
    0,0,0, 291 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_ROTATIONPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ROTATIONPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_ROTATIONPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_RTEXT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RTEXT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_RTEXT, parent),
    1,1,0, 0 },
  { "pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_RTEXT, pt),
    1,0,0, 10 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_RTEXT, extrusion),
    0,0,0, 210 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_RTEXT, rotation),
    0,0,0, 50 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_RTEXT, height),
    0,0,0, 50 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_RTEXT, flags),
    0,0,0, 70 },
  { "text_value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_RTEXT, text_value),
    1,1,1, 1 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_RTEXT, style),
    1,0,0, 7 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SECTIONOBJECT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SECTIONOBJECT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SECTIONOBJECT, parent),
    1,1,0, 0 },
  { "state",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SECTIONOBJECT, state),
    0,0,0, 90 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SECTIONOBJECT, flags),
    0,0,0, 91 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_SECTIONOBJECT, name),
    1,1,1, 1 },
  { "vert_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SECTIONOBJECT, vert_dir),
    1,0,0, 10 },
  { "top_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SECTIONOBJECT, top_height),
    0,0,0, 40 },
  { "bottom_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SECTIONOBJECT, bottom_height),
    0,0,0, 41 },
  { "indicator_alpha",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SECTIONOBJECT, indicator_alpha),
    0,0,0, 70 },
  { "indicator_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_SECTIONOBJECT, indicator_color),
    0,0,0, 62 },
  { "num_verts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SECTIONOBJECT, num_verts),
    0,0,0, 92 },
  { "verts",	"3BD*", sizeof (BITCODE_3BD*),  OFF (struct _dwg_entity_SECTIONOBJECT, verts),
    1,1,0, 11 },
  { "num_blverts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SECTIONOBJECT, num_blverts),
    0,0,0, 93 },
  { "blverts",	"3BD*", sizeof (BITCODE_3BD*),  OFF (struct _dwg_entity_SECTIONOBJECT, blverts),
    1,1,0, 12 },
  { "section_settings",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_SECTIONOBJECT, section_settings),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SEQEND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SEQEND_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SEQEND, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SHAPE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SHAPE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SHAPE, parent),
    1,1,0, 0 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SHAPE, ins_pt),
    1,0,0, 10 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, scale),
    0,0,0, 40 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, rotation),
    0,0,0, 50 },
  { "width_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, width_factor),
    0,0,0, 41 },
  { "oblique_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, oblique_angle),
    0,0,0, 51 },
  { "thickness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SHAPE, thickness),
    0,0,0, 39 },
  { "style_id",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SHAPE, style_id),
    0,0,0, 0 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_SHAPE, extrusion),
    0,0,0, 210 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_SHAPE, style),
    1,0,0, 7 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SOLID: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SOLID_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SOLID, parent),
    1,1,0, 0 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_SOLID, thickness),
    0,0,0, 39 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SOLID, elevation),
    0,0,0, 38 },
  { "corner1",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner1),
    1,0,0, 10 },
  { "corner2",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner2),
    1,0,0, 11 },
  { "corner3",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner3),
    1,0,0, 12 },
  { "corner4",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_SOLID, corner4),
    1,0,0, 13 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_SOLID, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SPLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPLINE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SPLINE, parent),
    1,1,0, 0 },
  { "flag",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_entity_SPLINE, flag),
    0,0,0, 0 },
  { "scenario",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SPLINE, scenario),
    0,0,0, 0 },
  { "degree",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SPLINE, degree),
    0,0,0, 71 },
  { "splineflags1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, splineflags1),
    0,0,0, 0 },
  { "knotparam",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, knotparam),
    0,0,0, 0 },
  { "fit_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SPLINE, fit_tol),
    0,0,0, 44 },
  { "beg_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SPLINE, beg_tan_vec),
    1,0,0, 12 },
  { "end_tan_vec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SPLINE, end_tan_vec),
    1,0,0, 13 },
  { "closed_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, closed_b),
    0,0,0, 0 },
  { "periodic",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, periodic),
    0,0,0, 0 },
  { "rational",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, rational),
    0,0,0, 0 },
  { "weighted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SPLINE, weighted),
    0,0,0, 0 },
  { "knot_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SPLINE, knot_tol),
    0,0,0, 42 },
  { "ctrl_tol",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SPLINE, ctrl_tol),
    0,0,0, 43 },
  { "num_fit_pts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SPLINE, num_fit_pts),
    0,0,0, 74 },
  { "fit_pts",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_entity_SPLINE, fit_pts),
    1,1,0, 11 },
  { "num_knots",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, num_knots),
    0,0,0, 72 },
  { "knots",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SPLINE, knots),
    1,1,0, 40 },
  { "num_ctrl_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SPLINE, num_ctrl_pts),
    0,0,0, 73 },
  { "ctrl_pts",	"Dwg_SPLINE_control_point*", sizeof (Dwg_SPLINE_control_point*),  OFF (struct _dwg_entity_SPLINE, ctrl_pts),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_SWEPTSURFACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SWEPTSURFACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_SWEPTSURFACE, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_entity_SWEPTSURFACE, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_entity_SWEPTSURFACE, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SWEPTSURFACE, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_entity_SWEPTSURFACE, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_entity_SWEPTSURFACE, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_entity_SWEPTSURFACE, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_entity_SWEPTSURFACE, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_SWEPTSURFACE, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_entity_SWEPTSURFACE, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_SWEPTSURFACE, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, acis_empty_bit),
    0,0,0, 0 },
  { "modeler_format_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, modeler_format_version),
    0,0,0, 70 },
  { "u_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, u_isolines),
    0,0,0, 71 },
  { "v_isolines",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, v_isolines),
    0,0,0, 72 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, class_version),
    0,0,0, 90 },
  { "sweep_entity_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity_id),
    0,0,0, 90 },
  { "sweepdata_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, sweepdata_size),
    0,0,0, 90 },
  { "sweepdata",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_SWEPTSURFACE, sweepdata),
    1,1,0, 310 },
  { "path_entity_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity_id),
    0,0,0, 90 },
  { "pathdata_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_SWEPTSURFACE, pathdata_size),
    0,0,0, 90 },
  { "pathdata",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_entity_SWEPTSURFACE, pathdata),
    1,1,0, 310 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, draft_angle),
    0,0,0, 42 },
  { "draft_start_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, draft_start_distance),
    0,0,0, 43 },
  { "draft_end_distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, draft_end_distance),
    0,0,0, 44 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, twist_angle),
    0,0,0, 45 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, scale_factor),
    0,0,0, 48 },
  { "align_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_SWEPTSURFACE, align_angle),
    0,0,0, 49 },
  { "sweep_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity_transmatrix),
    1,1,0, 46 },
  { "path_entity_transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity_transmatrix),
    1,1,0, 47 },
  { "is_solid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, is_solid),
    0,0,0, 290 },
  { "sweep_alignment_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_alignment_flags),
    0,0,0, 70 },
  { "path_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_SWEPTSURFACE, path_flags),
    0,0,0, 71 },
  { "align_start",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, align_start),
    0,0,0, 292 },
  { "bank",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, bank),
    0,0,0, 293 },
  { "base_point_set",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, base_point_set),
    0,0,0, 294 },
  { "sweep_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity_transform_computed),
    0,0,0, 295 },
  { "path_entity_transform_computed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity_transform_computed),
    0,0,0, 296 },
  { "reference_vector_for_controlling_twist",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_SWEPTSURFACE, reference_vector_for_controlling_twist),
    1,0,0, 11 },
  { "sweep_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_SWEPTSURFACE, sweep_entity),
    1,0,0, 0 },
  { "path_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_SWEPTSURFACE, path_entity),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TABLE, parent),
    1,1,0, 0 },
  { "ldata",	"Dwg_LinkedData", sizeof (Dwg_LinkedData),  OFF (struct _dwg_entity_TABLE, ldata),
    0,0,0, 0 },
  { "tdata",	"Dwg_LinkedTableData", sizeof (Dwg_LinkedTableData),  OFF (struct _dwg_entity_TABLE, tdata),
    0,0,0, 0 },
  { "fdata",	"Dwg_FormattedTableData", sizeof (Dwg_FormattedTableData),  OFF (struct _dwg_entity_TABLE, fdata),
    0,0,0, 0 },
  { "tablestyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, tablestyle),
    1,0,0, 342 },
  { "unknown_rc",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_TABLE, unknown_rc),
    0,0,0, 0 },
  { "unknown_h",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, unknown_h),
    1,0,0, 0 },
  { "unknown_bl",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, unknown_bl),
    0,0,0, 0 },
  { "unknown_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, unknown_b),
    0,0,0, 0 },
  { "unknown_bl1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, unknown_bl1),
    0,0,0, 0 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, ins_pt),
    1,0,0, 10 },
  { "scale",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, scale),
    1,0,0, 41 },
  { "scale_flag",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_entity_TABLE, scale_flag),
    0,0,0, 0 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, rotation),
    0,0,0, 50 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_TABLE, extrusion),
    0,0,0, 210 },
  { "has_attribs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_attribs),
    0,0,0, 66 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_owned),
    0,0,0, 0 },
  { "flag_for_table_value",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, flag_for_table_value),
    0,0,0, 90 },
  { "horiz_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, horiz_direction),
    1,0,0, 11 },
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_cols),
    0,0,0, 92 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_rows),
    0,0,0, 91 },
  { "num_cells",	"unsigned long", sizeof (unsigned long),  OFF (struct _dwg_entity_TABLE, num_cells),
    0,0,0, 0 },
  { "col_widths",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_TABLE, col_widths),
    1,1,0, 142 },
  { "row_heights",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_entity_TABLE, row_heights),
    1,1,0, 141 },
  { "cells",	"Dwg_TABLE_Cell*", sizeof (Dwg_TABLE_Cell*),  OFF (struct _dwg_entity_TABLE, cells),
    1,1,0, 0 },
  { "has_table_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_table_overrides),
    0,0,0, 0 },
  { "table_flag_override",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, table_flag_override),
    0,0,0, 93 },
  { "title_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, title_suppressed),
    0,0,0, 280 },
  { "header_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, header_suppressed),
    0,0,0, 281 },
  { "flow_direction",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, flow_direction),
    0,0,0, 70 },
  { "horiz_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, horiz_cell_margin),
    0,0,0, 40 },
  { "vert_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, vert_cell_margin),
    0,0,0, 41 },
  { "title_row_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_row_color),
    0,0,0, 64 },
  { "header_row_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_row_color),
    0,0,0, 64 },
  { "data_row_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_row_color),
    0,0,0, 64 },
  { "title_row_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, title_row_fill_none),
    0,0,0, 283 },
  { "header_row_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, header_row_fill_none),
    0,0,0, 283 },
  { "data_row_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, data_row_fill_none),
    0,0,0, 283 },
  { "title_row_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_row_fill_color),
    0,0,0, 63 },
  { "header_row_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_row_fill_color),
    0,0,0, 63 },
  { "data_row_fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_row_fill_color),
    0,0,0, 63 },
  { "title_row_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_row_alignment),
    0,0,0, 170 },
  { "header_row_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_row_alignment),
    0,0,0, 170 },
  { "data_row_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_row_alignment),
    0,0,0, 170 },
  { "title_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, title_text_style),
    1,0,0, 7 },
  { "header_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, header_text_style),
    1,0,0, 7 },
  { "data_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, data_text_style),
    1,0,0, 7 },
  { "title_row_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, title_row_height),
    0,0,0, 140 },
  { "header_row_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, header_row_height),
    0,0,0, 140 },
  { "data_row_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, data_row_height),
    0,0,0, 140 },
  { "has_border_color_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_border_color_overrides),
    0,0,0, 0 },
  { "border_color_overrides_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, border_color_overrides_flag),
    0,0,0, 94 },
  { "title_horiz_top_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_horiz_top_color),
    0,0,0, 64 },
  { "title_horiz_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_horiz_ins_color),
    0,0,0, 65 },
  { "title_horiz_bottom_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_horiz_bottom_color),
    0,0,0, 66 },
  { "title_vert_left_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_vert_left_color),
    0,0,0, 63 },
  { "title_vert_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_vert_ins_color),
    0,0,0, 68 },
  { "title_vert_right_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, title_vert_right_color),
    0,0,0, 69 },
  { "header_horiz_top_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_horiz_top_color),
    0,0,0, 64 },
  { "header_horiz_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_horiz_ins_color),
    0,0,0, 65 },
  { "header_horiz_bottom_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_horiz_bottom_color),
    0,0,0, 66 },
  { "header_vert_left_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_vert_left_color),
    0,0,0, 63 },
  { "header_vert_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_vert_ins_color),
    0,0,0, 68 },
  { "header_vert_right_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, header_vert_right_color),
    0,0,0, 69 },
  { "data_horiz_top_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_horiz_top_color),
    0,0,0, 64 },
  { "data_horiz_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_horiz_ins_color),
    0,0,0, 65 },
  { "data_horiz_bottom_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_horiz_bottom_color),
    0,0,0, 66 },
  { "data_vert_left_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_vert_left_color),
    0,0,0, 63 },
  { "data_vert_ins_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_vert_ins_color),
    0,0,0, 68 },
  { "data_vert_right_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_TABLE, data_vert_right_color),
    0,0,0, 69 },
  { "has_border_lineweight_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_border_lineweight_overrides),
    0,0,0, 0 },
  { "border_lineweight_overrides_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, border_lineweight_overrides_flag),
    0,0,0, 95 },
  { "title_horiz_top_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_top_linewt),
    0,0,0, 0 },
  { "title_horiz_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_ins_linewt),
    0,0,0, 0 },
  { "title_horiz_bottom_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_bottom_linewt),
    0,0,0, 0 },
  { "title_vert_left_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_left_linewt),
    0,0,0, 0 },
  { "title_vert_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_ins_linewt),
    0,0,0, 0 },
  { "title_vert_right_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_right_linewt),
    0,0,0, 0 },
  { "header_horiz_top_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_top_linewt),
    0,0,0, 0 },
  { "header_horiz_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_ins_linewt),
    0,0,0, 0 },
  { "header_horiz_bottom_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_bottom_linewt),
    0,0,0, 0 },
  { "header_vert_left_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_left_linewt),
    0,0,0, 0 },
  { "header_vert_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_ins_linewt),
    0,0,0, 0 },
  { "header_vert_right_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_right_linewt),
    0,0,0, 0 },
  { "data_horiz_top_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_top_linewt),
    0,0,0, 0 },
  { "data_horiz_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_ins_linewt),
    0,0,0, 0 },
  { "data_horiz_bottom_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_bottom_linewt),
    0,0,0, 0 },
  { "data_vert_left_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_left_linewt),
    0,0,0, 0 },
  { "data_vert_ins_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_ins_linewt),
    0,0,0, 0 },
  { "data_vert_right_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_right_linewt),
    0,0,0, 0 },
  { "has_border_visibility_overrides",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_TABLE, has_border_visibility_overrides),
    0,0,0, 0 },
  { "border_visibility_overrides_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, border_visibility_overrides_flag),
    0,0,0, 96 },
  { "title_horiz_top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_top_visibility),
    0,0,0, 0 },
  { "title_horiz_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_ins_visibility),
    0,0,0, 0 },
  { "title_horiz_bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_horiz_bottom_visibility),
    0,0,0, 0 },
  { "title_vert_left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_left_visibility),
    0,0,0, 0 },
  { "title_vert_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_ins_visibility),
    0,0,0, 0 },
  { "title_vert_right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, title_vert_right_visibility),
    0,0,0, 0 },
  { "header_horiz_top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_top_visibility),
    0,0,0, 0 },
  { "header_horiz_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_ins_visibility),
    0,0,0, 0 },
  { "header_horiz_bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_horiz_bottom_visibility),
    0,0,0, 0 },
  { "header_vert_left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_left_visibility),
    0,0,0, 0 },
  { "header_vert_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_ins_visibility),
    0,0,0, 0 },
  { "header_vert_right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, header_vert_right_visibility),
    0,0,0, 0 },
  { "data_horiz_top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_top_visibility),
    0,0,0, 0 },
  { "data_horiz_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_ins_visibility),
    0,0,0, 0 },
  { "data_horiz_bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_horiz_bottom_visibility),
    0,0,0, 0 },
  { "data_vert_left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_left_visibility),
    0,0,0, 0 },
  { "data_vert_ins_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_ins_visibility),
    0,0,0, 0 },
  { "data_vert_right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, data_vert_right_visibility),
    0,0,0, 0 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, block_header),
    1,0,0, 2 },
  { "first_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, first_attrib),
    1,0,0, 0 },
  { "last_attrib",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, last_attrib),
    1,0,0, 0 },
  { "attribs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_TABLE, attribs),
    1,1,0, 0 },
  { "seqend",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, seqend),
    1,0,0, 0 },
  { "title_row_style_override",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, title_row_style_override),
    1,0,0, 7 },
  { "header_row_style_override",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, header_row_style_override),
    1,0,0, 0 },
  { "data_row_style_override",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TABLE, data_row_style_override),
    1,0,0, 0 },
  { "unknown_bs",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TABLE, unknown_bs),
    0,0,0, 0 },
  { "hor_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TABLE, hor_dir),
    1,0,0, 11 },
  { "has_break_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, has_break_data),
    0,0,0, 0 },
  { "break_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_flag),
    0,0,0, 0 },
  { "break_flow_direction",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_flow_direction),
    0,0,0, 0 },
  { "break_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TABLE, break_spacing),
    0,0,0, 0 },
  { "break_unknown1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_unknown1),
    0,0,0, 0 },
  { "break_unknown2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, break_unknown2),
    0,0,0, 0 },
  { "num_break_heights",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_break_heights),
    0,0,0, 0 },
  { "break_heights",	"Dwg_TABLE_BreakHeight*", sizeof (Dwg_TABLE_BreakHeight*),  OFF (struct _dwg_entity_TABLE, break_heights),
    1,1,0, 0 },
  { "num_break_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_TABLE, num_break_rows),
    0,0,0, 0 },
  { "break_rows",	"Dwg_TABLE_BreakRow*", sizeof (Dwg_TABLE_BreakRow*),  OFF (struct _dwg_entity_TABLE, break_rows),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TEXT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TEXT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TEXT, parent),
    1,1,0, 0 },
  { "dataflags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_TEXT, dataflags),
    0,0,0, 0 },
  { "elevation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, elevation),
    0,0,0, 30 },
  { "ins_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_TEXT, ins_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_entity_TEXT, alignment_pt),
    1,0,0, 11 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_TEXT, extrusion),
    0,0,0, 210 },
  { "thickness",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, thickness),
    0,0,0, 39 },
  { "oblique_angle",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, oblique_angle),
    0,0,0, 51 },
  { "rotation",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, rotation),
    0,0,0, 50 },
  { "height",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, height),
    0,0,0, 40 },
  { "width_factor",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_entity_TEXT, width_factor),
    0,0,0, 41 },
  { "text_value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_TEXT, text_value),
    1,1,1, 1 },
  { "generation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TEXT, generation),
    0,0,0, 71 },
  { "horiz_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TEXT, horiz_alignment),
    0,0,0, 72 },
  { "vert_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TEXT, vert_alignment),
    0,0,0, 73 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TEXT, style),
    1,0,0, 7 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TOLERANCE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TOLERANCE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TOLERANCE, parent),
    1,1,0, 0 },
  { "unknown_short",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_TOLERANCE, unknown_short),
    0,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TOLERANCE, height),
    0,0,0, 0 },
  { "dimgap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TOLERANCE, dimgap),
    0,0,0, 0 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TOLERANCE, ins_pt),
    1,0,0, 10 },
  { "x_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_TOLERANCE, x_direction),
    1,0,0, 11 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_TOLERANCE, extrusion),
    0,0,0, 0 },
  { "text_value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_entity_TOLERANCE, text_value),
    1,1,1, 1 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_TOLERANCE, dimstyle),
    1,0,0, 3 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_TRACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TRACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_TRACE, parent),
    1,1,0, 0 },
  { "thickness",	"BT", sizeof (BITCODE_BT),  OFF (struct _dwg_entity_TRACE, thickness),
    0,0,0, 39 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_TRACE, elevation),
    0,0,0, 38 },
  { "corner1",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner1),
    1,0,0, 10 },
  { "corner2",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner2),
    1,0,0, 11 },
  { "corner3",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner3),
    1,0,0, 12 },
  { "corner4",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_TRACE, corner4),
    1,0,0, 13 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_entity_TRACE, extrusion),
    0,0,0, 210 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_UNKNOWN_ENT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNKNOWN_ENT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_UNKNOWN_ENT, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VERTEX_2D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VERTEX_2D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VERTEX_2D, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VERTEX_2D, flag),
    0,0,0, 70 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VERTEX_2D, point),
    1,0,0, 10 },
  { "start_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, start_width),
    0,0,0, 40 },
  { "end_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, end_width),
    0,0,0, 41 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_VERTEX_2D, id),
    0,0,0, 91 },
  { "bulge",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, bulge),
    0,0,0, 42 },
  { "tangent_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VERTEX_2D, tangent_dir),
    0,0,0, 50 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VERTEX_3D: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VERTEX_3D_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VERTEX_3D, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VERTEX_3D, flag),
    0,0,0, 70 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VERTEX_3D, point),
    1,0,0, 10 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VERTEX_PFACE_FACE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VERTEX_PFACE_FACE_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VERTEX_PFACE_FACE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VERTEX_PFACE_FACE, flag),
    0,0,0, 70 },
  { "vertind[4]",	"BS", 4 * sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VERTEX_PFACE_FACE, vertind),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VIEWPORT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VIEWPORT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VIEWPORT, parent),
    1,1,0, 0 },
  { "center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, center),
    1,0,0, 10 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, width),
    0,0,0, 40 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, height),
    0,0,0, 41 },
  { "on_off",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_entity_VIEWPORT, on_off),
    0,0,0, 68 },
  { "id",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_entity_VIEWPORT, id),
    0,0,0, 69 },
  { "view_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, view_target),
    1,0,0, 17 },
  { "VIEWDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, VIEWDIR),
    1,0,0, 16 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, twist_angle),
    0,0,0, 51 },
  { "VIEWSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, VIEWSIZE),
    0,0,0, 45 },
  { "lens_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, lens_length),
    0,0,0, 42 },
  { "front_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, front_clip_z),
    0,0,0, 43 },
  { "back_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, back_clip_z),
    0,0,0, 44 },
  { "SNAPANG",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, SNAPANG),
    0,0,0, 50 },
  { "VIEWCTR",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, VIEWCTR),
    1,0,0, 12 },
  { "SNAPBASE",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, SNAPBASE),
    1,0,0, 13 },
  { "SNAPUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, SNAPUNIT),
    1,0,0, 14 },
  { "GRIDUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_VIEWPORT, GRIDUNIT),
    1,0,0, 15 },
  { "circle_zoom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, circle_zoom),
    0,0,0, 72 },
  { "grid_major",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, grid_major),
    0,0,0, 61 },
  { "num_frozen_layers",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_VIEWPORT, num_frozen_layers),
    0,0,0, 0 },
  { "status_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_VIEWPORT, status_flag),
    0,0,0, 90 },
  { "style_sheet",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_entity_VIEWPORT, style_sheet),
    1,1,1, 1 },
  { "render_mode",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VIEWPORT, render_mode),
    0,0,0, 281 },
  { "ucs_at_origin",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_VIEWPORT, ucs_at_origin),
    0,0,0, 74 },
  { "UCSVP",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_VIEWPORT, UCSVP),
    0,0,0, 71 },
  { "ucsorg",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, ucsorg),
    1,0,0, 110 },
  { "ucsxdir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, ucsxdir),
    1,0,0, 111 },
  { "ucsydir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_VIEWPORT, ucsydir),
    1,0,0, 112 },
  { "ucs_elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, ucs_elevation),
    0,0,0, 146 },
  { "UCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, UCSORTHOVIEW),
    0,0,0, 79 },
  { "shadeplot_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_VIEWPORT, shadeplot_mode),
    0,0,0, 170 },
  { "use_default_lights",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_VIEWPORT, use_default_lights),
    0,0,0, 292 },
  { "default_lighting_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_VIEWPORT, default_lighting_type),
    0,0,0, 282 },
  { "brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, brightness),
    0,0,0, 141 },
  { "contrast",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_entity_VIEWPORT, contrast),
    0,0,0, 142 },
  { "ambient_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_entity_VIEWPORT, ambient_color),
    0,0,0, 63 },
  { "vport_entity_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, vport_entity_header),
    1,0,0, 0 },
  { "frozen_layers",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_entity_VIEWPORT, frozen_layers),
    1,1,0, 341 },
  { "clip_boundary",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, clip_boundary),
    1,0,0, 340 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, named_ucs),
    1,0,0, 345 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, base_ucs),
    1,0,0, 346 },
  { "background",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, background),
    1,0,0, 332 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, visualstyle),
    1,0,0, 348 },
  { "shadeplot",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, shadeplot),
    1,0,0, 333 },
  { "sun",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_VIEWPORT, sun),
    1,0,0, 361 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VISIBILITYGRIPENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VISIBILITYGRIPENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VISIBILITYGRIPENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_VISIBILITYPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VISIBILITYPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_VISIBILITYPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_WIPEOUT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_WIPEOUT_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_WIPEOUT, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_WIPEOUT, class_version),
    0,0,0, 90 },
  { "pt0",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_WIPEOUT, pt0),
    1,0,0, 10 },
  { "uvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_WIPEOUT, uvec),
    1,0,0, 11 },
  { "vvec",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_entity_WIPEOUT, vvec),
    1,0,0, 12 },
  { "size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_entity_WIPEOUT, size),
    1,0,0, 13 },
  { "display_props",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_WIPEOUT, display_props),
    0,0,0, 70 },
  { "clipping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_WIPEOUT, clipping),
    0,0,0, 280 },
  { "brightness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_WIPEOUT, brightness),
    0,0,0, 281 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_WIPEOUT, contrast),
    0,0,0, 282 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_entity_WIPEOUT, fade),
    0,0,0, 283 },
  { "clip_mode",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_entity_WIPEOUT, clip_mode),
    0,0,0, 290 },
  { "clip_boundary_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_entity_WIPEOUT, clip_boundary_type),
    0,0,0, 71 },
  { "num_clip_verts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_entity_WIPEOUT, num_clip_verts),
    0,0,0, 91 },
  { "clip_verts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_entity_WIPEOUT, clip_verts),
    1,1,0, 14 },
  { "imagedef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_WIPEOUT, imagedef),
    1,0,0, 340 },
  { "imagedefreactor",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_entity_WIPEOUT, imagedefreactor),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_entity_XYPARAMETERENTITY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_XYPARAMETERENTITY_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_entity_XYPARAMETERENTITY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_object_ACMECOMMANDHISTORY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACMECOMMANDHISTORY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACMECOMMANDHISTORY, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ACMECOMMANDHISTORY, class_version),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACMESCOPE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACMESCOPE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACMESCOPE, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ACMESCOPE, class_version),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACMESTATEMGR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACMESTATEMGR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACMESTATEMGR, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ACMESTATEMGR, class_version),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_BOOLEAN_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_BOOLEAN_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, minor),
    0,0,0, 91 },
  { "operation",	"RCd", sizeof (BITCODE_RCd),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, operation),
    0,0,0, 280 },
  { "operand1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, operand1),
    0,0,0, 92 },
  { "operand2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BOOLEAN_CLASS, operand2),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_BOX_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_BOX_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_BOX_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_BOX_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_BOX_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BOX_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BOX_CLASS, minor),
    0,0,0, 91 },
  { "length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_BOX_CLASS, length),
    0,0,0, 40 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_BOX_CLASS, width),
    0,0,0, 41 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_BOX_CLASS, height),
    0,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_BREP_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_BREP_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_BREP_CLASS, parent),
    1,1,0, 0 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, acis_empty),
    0,0,0, 290 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ACSH_BREP_CLASS, version),
    0,0,0, 70 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_ACSH_BREP_CLASS, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_object_ACSH_BREP_CLASS, encr_sat_data),
    1,1,0, 1 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_object_ACSH_BREP_CLASS, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_BREP_CLASS, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_object_ACSH_BREP_CLASS, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_object_ACSH_BREP_CLASS, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_object_ACSH_BREP_CLASS, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_object_ACSH_BREP_CLASS, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_BREP_CLASS, revision_guid),
    0,0,0, 2 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ACSH_BREP_CLASS, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ACSH_BREP_CLASS, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_BREP_CLASS, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ACSH_BREP_CLASS, history_id),
    1,0,0, 350 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_BREP_CLASS, acis_empty_bit),
    0,0,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_BREP_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_BREP_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_BREP_CLASS, minor),
    0,0,0, 91 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_CHAMFER_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_CHAMFER_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, minor),
    0,0,0, 91 },
  { "bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, bl92),
    0,0,0, 92 },
  { "base_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, base_dist),
    0,0,0, 41 },
  { "other_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, other_dist),
    0,0,0, 42 },
  { "num_edges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, num_edges),
    0,0,0, 93 },
  { "edges",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, edges),
    1,1,0, 94 },
  { "bl95",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CHAMFER_CLASS, bl95),
    0,0,0, 95 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_CONE_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_CONE_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_CONE_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_CONE_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_CONE_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CONE_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CONE_CLASS, minor),
    0,0,0, 91 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CONE_CLASS, height),
    0,0,0, 40 },
  { "major_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CONE_CLASS, major_radius),
    0,0,0, 41 },
  { "minor_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CONE_CLASS, minor_radius),
    0,0,0, 42 },
  { "x_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CONE_CLASS, x_radius),
    0,0,0, 43 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_CYLINDER_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_CYLINDER_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, minor),
    0,0,0, 91 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, height),
    0,0,0, 40 },
  { "major_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, major_radius),
    0,0,0, 41 },
  { "minor_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, minor_radius),
    0,0,0, 42 },
  { "x_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_CYLINDER_CLASS, x_radius),
    0,0,0, 43 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_EXTRUSION_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_EXTRUSION_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, minor),
    0,0,0, 91 },
  { "direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, direction),
    1,0,0, 10 },
  { "bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, bl92),
    0,0,0, 92 },
  { "shsw_text_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_text_size),
    0,0,0, 90 },
  { "shsw_text",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_text),
    1,1,0, 310 },
  { "shsw_bl93",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_bl93),
    0,0,0, 93 },
  { "shsw_text2_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_text2_size),
    0,0,0, 90 },
  { "shsw_text2",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_text2),
    1,1,0, 310 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, draft_angle),
    0,0,0, 42 },
  { "start_draft_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, start_draft_dist),
    0,0,0, 43 },
  { "end_draft_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, end_draft_dist),
    0,0,0, 44 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, scale_factor),
    0,0,0, 45 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, twist_angle),
    0,0,0, 48 },
  { "align_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, align_angle),
    0,0,0, 49 },
  { "sweepentity_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, sweepentity_transform),
    1,1,0, 46 },
  { "pathentity_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, pathentity_transform),
    1,1,0, 47 },
  { "align_option",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, align_option),
    0,0,0, 70 },
  { "miter_option",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, miter_option),
    0,0,0, 71 },
  { "has_align_start",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, has_align_start),
    0,0,0, 290 },
  { "bank",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, bank),
    0,0,0, 292 },
  { "check_intersections",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, check_intersections),
    0,0,0, 293 },
  { "shsw_b294",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_b294),
    0,0,0, 294 },
  { "shsw_b295",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_b295),
    0,0,0, 295 },
  { "shsw_b296",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, shsw_b296),
    0,0,0, 296 },
  { "pt2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_EXTRUSION_CLASS, pt2),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_FILLET_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_FILLET_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, minor),
    0,0,0, 91 },
  { "bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, bl92),
    0,0,0, 92 },
  { "num_edges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, num_edges),
    0,0,0, 93 },
  { "edges",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, edges),
    1,1,0, 94 },
  { "num_radiuses",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, num_radiuses),
    0,0,0, 95 },
  { "num_startsetbacks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, num_startsetbacks),
    0,0,0, 96 },
  { "num_endsetbacks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, num_endsetbacks),
    0,0,0, 97 },
  { "radiuses",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, radiuses),
    1,1,0, 41 },
  { "startsetbacks",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, startsetbacks),
    1,1,0, 42 },
  { "endsetbacks",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_FILLET_CLASS, endsetbacks),
    1,1,0, 43 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_HISTORY_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_HISTORY_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_HISTORY_CLASS, parent),
    1,1,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_HISTORY_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_HISTORY_CLASS, minor),
    0,0,0, 91 },
  { "owner",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ACSH_HISTORY_CLASS, owner),
    1,0,0, 360 },
  { "h_nodeid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_HISTORY_CLASS, h_nodeid),
    0,0,0, 92 },
  { "show_history",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_HISTORY_CLASS, show_history),
    0,0,0, 280 },
  { "record_history",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_HISTORY_CLASS, record_history),
    0,0,0, 281 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_LOFT_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_LOFT_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, minor),
    0,0,0, 91 },
  { "num_crosssects",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, num_crosssects),
    0,0,0, 92 },
  { "crosssects",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, crosssects),
    1,1,0, 0 },
  { "num_guides",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, num_guides),
    0,0,0, 95 },
  { "guides",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ACSH_LOFT_CLASS, guides),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_PYRAMID_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_PYRAMID_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, minor),
    0,0,0, 91 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, height),
    0,0,0, 40 },
  { "sides",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, sides),
    0,0,0, 92 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, radius),
    0,0,0, 41 },
  { "topradius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_PYRAMID_CLASS, topradius),
    0,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_REVOLVE_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_REVOLVE_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, minor),
    0,0,0, 91 },
  { "axis_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, axis_pt),
    1,0,0, 10 },
  { "direction",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, direction),
    1,0,0, 11 },
  { "revolve_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, revolve_angle),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, start_angle),
    0,0,0, 41 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, draft_angle),
    0,0,0, 43 },
  { "bd44",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, bd44),
    0,0,0, 44 },
  { "bd45",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, bd45),
    0,0,0, 45 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, twist_angle),
    0,0,0, 46 },
  { "b290",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, b290),
    0,0,0, 290 },
  { "is_close_to_axis",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, is_close_to_axis),
    0,0,0, 291 },
  { "sweep_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ACSH_REVOLVE_CLASS, sweep_entity),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_SPHERE_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_SPHERE_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_SPHERE_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_SPHERE_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_SPHERE_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SPHERE_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SPHERE_CLASS, minor),
    0,0,0, 91 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SPHERE_CLASS, radius),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_SWEEP_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_SWEEP_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, minor),
    0,0,0, 91 },
  { "direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, direction),
    1,0,0, 10 },
  { "bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, bl92),
    0,0,0, 92 },
  { "shsw_text_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_text_size),
    0,0,0, 90 },
  { "shsw_text",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_text),
    1,1,0, 310 },
  { "shsw_bl93",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_bl93),
    0,0,0, 93 },
  { "shsw_text2_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_text2_size),
    0,0,0, 90 },
  { "shsw_text2",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_text2),
    1,1,0, 310 },
  { "draft_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, draft_angle),
    0,0,0, 42 },
  { "start_draft_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, start_draft_dist),
    0,0,0, 43 },
  { "end_draft_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, end_draft_dist),
    0,0,0, 44 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, scale_factor),
    0,0,0, 45 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, twist_angle),
    0,0,0, 48 },
  { "align_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, align_angle),
    0,0,0, 49 },
  { "sweepentity_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, sweepentity_transform),
    1,1,0, 46 },
  { "pathentity_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, pathentity_transform),
    1,1,0, 47 },
  { "align_option",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, align_option),
    0,0,0, 70 },
  { "miter_option",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, miter_option),
    0,0,0, 71 },
  { "has_align_start",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, has_align_start),
    0,0,0, 290 },
  { "bank",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, bank),
    0,0,0, 292 },
  { "check_intersections",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, check_intersections),
    0,0,0, 293 },
  { "shsw_b294",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_b294),
    0,0,0, 294 },
  { "shsw_b295",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_b295),
    0,0,0, 295 },
  { "shsw_b296",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, shsw_b296),
    0,0,0, 296 },
  { "pt2",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ACSH_SWEEP_CLASS, pt2),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_TORUS_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_TORUS_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_TORUS_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_TORUS_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_TORUS_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_TORUS_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_TORUS_CLASS, minor),
    0,0,0, 91 },
  { "major_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_TORUS_CLASS, major_radius),
    0,0,0, 40 },
  { "minor_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_TORUS_CLASS, minor_radius),
    0,0,0, 41 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ACSH_WEDGE_CLASS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_WEDGE_CLASS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, evalexpr),
    0,0,0, 0 },
  { "history_node",	"Dwg_ACSH_HistoryNode", sizeof (Dwg_ACSH_HistoryNode),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, history_node),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, major),
    0,0,0, 90 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, minor),
    0,0,0, 91 },
  { "length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, length),
    0,0,0, 40 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, width),
    0,0,0, 41 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ACSH_WEDGE_CLASS, height),
    0,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ALDIMOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ALDIMOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ALDIMOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ALDIMOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ALDIMOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ALDIMOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "dimension",	"Dwg_OCD_Dimension", sizeof (Dwg_OCD_Dimension),  OFF (struct _dwg_object_ALDIMOBJECTCONTEXTDATA, dimension),
    0,0,0, 0 },
  { "dimline_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ALDIMOBJECTCONTEXTDATA, dimline_pt),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ANGDIMOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ANGDIMOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ANGDIMOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ANGDIMOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ANGDIMOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ANGDIMOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "dimension",	"Dwg_OCD_Dimension", sizeof (Dwg_OCD_Dimension),  OFF (struct _dwg_object_ANGDIMOBJECTCONTEXTDATA, dimension),
    0,0,0, 0 },
  { "arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ANGDIMOBJECTCONTEXTDATA, arc_pt),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ANNOTSCALEOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_APPID: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_APPID_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_APPID, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_APPID, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_APPID, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_APPID, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_APPID, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_APPID, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_APPID, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_APPID, xref),
    1,0,0, 0 },
  { "unknown",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_APPID, unknown),
    0,0,0, 71 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_APPID_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_APPID_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_APPID_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_APPID_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_APPID_CONTROL, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOC2DCONSTRAINTGROUP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOC2DCONSTRAINTGROUP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, class_version),
    0,0,0, 90 },
  { "geometry_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, geometry_status),
    0,0,0, 90 },
  { "owningnetwork",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, owningnetwork),
    1,0,0, 330 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, actionbody),
    1,0,0, 360 },
  { "action_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, action_index),
    0,0,0, 90 },
  { "max_assoc_dep_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, max_assoc_dep_index),
    0,0,0, 90 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, num_deps),
    0,0,0, 90 },
  { "deps",	"Dwg_ASSOCACTION_Deps*", sizeof (Dwg_ASSOCACTION_Deps*),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, deps),
    1,1,0, 0 },
  { "num_owned_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, num_owned_params),
    0,0,0, 0 },
  { "owned_params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, owned_params),
    1,1,0, 0 },
  { "num_values",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, num_values),
    0,0,0, 0 },
  { "values",	"struct _dwg_VALUEPARAM*", sizeof (void *),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, values),
    1,1,0, 0 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, version),
    0,0,0, 90 },
  { "b1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, b1),
    0,0,0, 70 },
  { "workplane[3]",	"3BD", 3 * sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, workplane),
    1,0,0, 0 },
  { "h1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, h1),
    1,0,0, 360 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, num_actions),
    0,0,0, 90 },
  { "actions",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, actions),
    1,1,0, 360 },
  { "num_nodes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, num_nodes),
    0,0,0, 90 },
  { "nodes",	"Dwg_CONSTRAINTGROUPNODE*", sizeof (Dwg_CONSTRAINTGROUPNODE*),  OFF (struct _dwg_object_ASSOC2DCONSTRAINTGROUP, nodes),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOC3POINTANGULARDIMACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, parent),
    1,1,0, 0 },
  { "aaab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, aaab_version),
    0,0,0, 90 },
  { "assoc_dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, assoc_dep),
    1,0,0, 330 },
  { "aab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, aab_version),
    0,0,0, 90 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, actionbody),
    1,0,0, 360 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, pab),
    0,0,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, class_version),
    0,0,0, 90 },
  { "r_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, r_node),
    1,0,0, 330 },
  { "d_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, d_node),
    1,0,0, 330 },
  { "assocdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY, assocdep),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCACTION, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCACTION, class_version),
    0,0,0, 90 },
  { "geometry_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, geometry_status),
    0,0,0, 90 },
  { "owningnetwork",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCACTION, owningnetwork),
    1,0,0, 330 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCACTION, actionbody),
    1,0,0, 360 },
  { "action_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, action_index),
    0,0,0, 90 },
  { "max_assoc_dep_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, max_assoc_dep_index),
    0,0,0, 90 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, num_deps),
    0,0,0, 90 },
  { "deps",	"Dwg_ASSOCACTION_Deps*", sizeof (Dwg_ASSOCACTION_Deps*),  OFF (struct _dwg_object_ASSOCACTION, deps),
    1,1,0, 0 },
  { "num_owned_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, num_owned_params),
    0,0,0, 0 },
  { "owned_params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCACTION, owned_params),
    1,1,0, 0 },
  { "num_values",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTION, num_values),
    0,0,0, 0 },
  { "values",	"struct _dwg_VALUEPARAM*", sizeof (void *),  OFF (struct _dwg_object_ASSOCACTION, values),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCACTIONPARAM, name),
    1,1,1, 1 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCALIGNEDDIMACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, parent),
    1,1,0, 0 },
  { "aaab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, aaab_version),
    0,0,0, 90 },
  { "assoc_dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, assoc_dep),
    1,0,0, 330 },
  { "aab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, aab_version),
    0,0,0, 90 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, actionbody),
    1,0,0, 360 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, pab),
    0,0,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, class_version),
    0,0,0, 90 },
  { "r_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, r_node),
    1,0,0, 330 },
  { "d_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY, d_node),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCARRAYACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCARRAYACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCARRAYACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCARRAYACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCARRAYACTIONBODY, pab),
    0,0,0, 0 },
  { "aaab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCARRAYACTIONBODY, aaab_version),
    0,0,0, 90 },
  { "paramblock",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCARRAYACTIONBODY, paramblock),
    1,1,1, 1 },
  { "transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ASSOCARRAYACTIONBODY, transmatrix),
    1,1,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCARRAYMODIFYACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, pab),
    0,0,0, 0 },
  { "aaab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, aaab_version),
    0,0,0, 90 },
  { "paramblock",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, paramblock),
    1,1,1, 1 },
  { "transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, transmatrix),
    1,1,0, 40 },
  { "status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, status),
    0,0,0, 70 },
  { "num_items",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, num_items),
    0,0,0, 90 },
  { "items",	"Dwg_ARRAYITEMLOCATOR*", sizeof (Dwg_ARRAYITEMLOCATOR*),  OFF (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY, items),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCASMBODYACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCASMBODYACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, name),
    1,1,1, 1 },
  { "asdap_class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, asdap_class_version),
    0,0,0, 90 },
  { "dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, dep),
    1,0,0, 330 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, class_version),
    0,0,0, 90 },
  { "acis_empty",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, acis_empty),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, unknown),
    0,0,0, 0 },
  { "version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, version),
    0,0,0, 0 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, num_blocks),
    0,0,0, 0 },
  { "block_size",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, block_size),
    1,1,0, 0 },
  { "encr_sat_data",	"char **", sizeof (char **),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, encr_sat_data),
    1,1,0, 0 },
  { "sab_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, sab_size),
    0,0,0, 0 },
  { "acis_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, acis_data),
    1,1,0, 0 },
  { "wireframe_data_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, wireframe_data_present),
    0,0,0, 0 },
  { "point_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, point_present),
    0,0,0, 0 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, point),
    1,0,0, 0 },
  { "isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, isolines),
    0,0,0, 0 },
  { "isoline_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, isoline_present),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, wires),
    1,1,0, 0 },
  { "num_silhouettes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, num_silhouettes),
    0,0,0, 0 },
  { "silhouettes",	"Dwg_3DSOLID_silhouette*", sizeof (Dwg_3DSOLID_silhouette*),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, silhouettes),
    1,1,0, 0 },
  { "_dxf_sab_converted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, _dxf_sab_converted),
    0,0,0, 0 },
  { "acis_empty2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, acis_empty2),
    0,0,0, 0 },
  { "extra_acis_data",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, extra_acis_data),
    1,1,0, 0 },
  { "num_materials",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, num_materials),
    0,0,0, 0 },
  { "materials",	"Dwg_3DSOLID_material*", sizeof (Dwg_3DSOLID_material*),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, materials),
    1,1,0, 0 },
  { "revision_guid[39]",	"RC", 39 * sizeof (BITCODE_RC),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, revision_guid),
    0,0,0, 0 },
  { "revision_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, revision_major),
    0,0,0, 0 },
  { "revision_minor1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, revision_minor1),
    0,0,0, 0 },
  { "revision_minor2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, revision_minor2),
    0,0,0, 0 },
  { "revision_bytes[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, revision_bytes),
    0,0,0, 0 },
  { "end_marker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, end_marker),
    0,0,0, 0 },
  { "history_id",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, history_id),
    1,0,0, 0 },
  { "has_revision_guid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, has_revision_guid),
    0,0,0, 0 },
  { "acis_empty_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCASMBODYACTIONPARAM, acis_empty_bit),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCBLENDSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  { "b1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, b1),
    0,0,0, 290 },
  { "b2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, b2),
    0,0,0, 291 },
  { "b3",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, b3),
    0,0,0, 292 },
  { "b4",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, b4),
    0,0,0, 293 },
  { "b5",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, b5),
    0,0,0, 294 },
  { "blend_options",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, blend_options),
    0,0,0, 72 },
  { "bs2",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY, bs2),
    0,0,0, 73 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCCOMPOUNDACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, name),
    1,1,1, 1 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, class_version),
    0,0,0, 90 },
  { "bs1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, bs1),
    0,0,0, 90 },
  { "num_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, num_params),
    0,0,0, 90 },
  { "params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, params),
    1,1,0, 360 },
  { "has_child_param",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, has_child_param),
    0,0,0, 0 },
  { "child_status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, child_status),
    0,0,0, 90 },
  { "child_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, child_id),
    0,0,0, 90 },
  { "child_param",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, child_param),
    1,0,0, 330 },
  { "h330_2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, h330_2),
    1,0,0, 330 },
  { "bl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, bl2),
    0,0,0, 90 },
  { "h330_3",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM, h330_3),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCDEPENDENCY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCDEPENDENCY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCDEPENDENCY, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCDEPENDENCY, class_version),
    0,0,0, 90 },
  { "status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCDEPENDENCY, status),
    0,0,0, 90 },
  { "is_read_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, is_read_dep),
    0,0,0, 290 },
  { "is_write_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, is_write_dep),
    0,0,0, 290 },
  { "is_attached_to_object",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, is_attached_to_object),
    0,0,0, 290 },
  { "is_delegating_to_owning_action",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, is_delegating_to_owning_action),
    0,0,0, 290 },
  { "order",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_ASSOCDEPENDENCY, order),
    0,0,0, 90 },
  { "dep_on",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, dep_on),
    1,0,0, 330 },
  { "has_name",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCDEPENDENCY, has_name),
    0,0,0, 290 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCDEPENDENCY, name),
    1,1,1, 1 },
  { "depbodyid",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_ASSOCDEPENDENCY, depbodyid),
    0,0,0, 90 },
  { "readdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, readdep),
    1,0,0, 330 },
  { "dep_body",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, dep_body),
    1,0,0, 360 },
  { "node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCDEPENDENCY, node),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCDIMDEPENDENCYBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCDIMDEPENDENCYBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCDIMDEPENDENCYBODY, parent),
    1,1,0, 0 },
  { "adb_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCDIMDEPENDENCYBODY, adb_version),
    0,0,0, 90 },
  { "dimbase_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCDIMDEPENDENCYBODY, dimbase_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCDIMDEPENDENCYBODY, name),
    1,1,1, 1 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCDIMDEPENDENCYBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCEDGEACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCEDGEACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, name),
    1,1,1, 1 },
  { "asdap_class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, asdap_class_version),
    0,0,0, 90 },
  { "dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, dep),
    1,0,0, 330 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, class_version),
    0,0,0, 90 },
  { "param",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, param),
    1,0,0, 330 },
  { "has_action",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, has_action),
    0,0,0, 290 },
  { "action_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, action_type),
    0,0,0, 90 },
  { "subent",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCEDGEACTIONPARAM, subent),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCEDGECHAMFERACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCEDGECHAMFERACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCEDGECHAMFERACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGECHAMFERACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCEDGECHAMFERACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCEDGECHAMFERACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGECHAMFERACTIONBODY, pbsab_status),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCEDGEFILLETACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCEDGEFILLETACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCEDGEFILLETACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGEFILLETACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCEDGEFILLETACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCEDGEFILLETACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEDGEFILLETACTIONBODY, pbsab_status),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCEXTENDSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  { "option",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY, option),
    0,0,0, 280 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCEXTRUDEDSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCFACEACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCFACEACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, name),
    1,1,1, 1 },
  { "asdap_class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, asdap_class_version),
    0,0,0, 90 },
  { "dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, dep),
    1,0,0, 330 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, class_version),
    0,0,0, 90 },
  { "index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCFACEACTIONPARAM, index),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCFILLETSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  { "status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, status),
    0,0,0, 70 },
  { "pt1",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, pt1),
    1,0,0, 10 },
  { "pt2",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY, pt2),
    1,0,0, 10 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCGEOMDEPENDENCY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCGEOMDEPENDENCY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCGEOMDEPENDENCY, parent),
    1,1,0, 0 },
  { "assocdep",	"Dwg_Object_ASSOCDEPENDENCY", sizeof (Dwg_Object_ASSOCDEPENDENCY),  OFF (struct _dwg_object_ASSOCGEOMDEPENDENCY, assocdep),
    0,0,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCGEOMDEPENDENCY, class_version),
    0,0,0, 90 },
  { "enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCGEOMDEPENDENCY, enabled),
    0,0,0, 290 },
  { "classname",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCGEOMDEPENDENCY, classname),
    1,1,1, 1 },
  { "dependent_on_compound_object",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCGEOMDEPENDENCY, dependent_on_compound_object),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCLOFTEDSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCMLEADERACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCMLEADERACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, parent),
    1,1,0, 0 },
  { "aaab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, aaab_version),
    0,0,0, 90 },
  { "assoc_dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, assoc_dep),
    1,0,0, 330 },
  { "aab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, aab_version),
    0,0,0, 90 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, actionbody),
    1,0,0, 360 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, pab),
    0,0,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, class_version),
    0,0,0, 90 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, num_actions),
    0,0,0, 90 },
  { "actions",	"Dwg_ASSOCACTIONBODY_action*", sizeof (Dwg_ASSOCACTIONBODY_action*),  OFF (struct _dwg_object_ASSOCMLEADERACTIONBODY, actions),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCNETWORK: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCNETWORK_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCNETWORK, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCNETWORK, class_version),
    0,0,0, 90 },
  { "geometry_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, geometry_status),
    0,0,0, 90 },
  { "owningnetwork",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCNETWORK, owningnetwork),
    1,0,0, 330 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCNETWORK, actionbody),
    1,0,0, 360 },
  { "action_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, action_index),
    0,0,0, 90 },
  { "max_assoc_dep_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, max_assoc_dep_index),
    0,0,0, 90 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, num_deps),
    0,0,0, 90 },
  { "deps",	"Dwg_ASSOCACTION_Deps*", sizeof (Dwg_ASSOCACTION_Deps*),  OFF (struct _dwg_object_ASSOCNETWORK, deps),
    1,1,0, 0 },
  { "num_owned_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, num_owned_params),
    0,0,0, 0 },
  { "owned_params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCNETWORK, owned_params),
    1,1,0, 0 },
  { "num_values",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, num_values),
    0,0,0, 0 },
  { "values",	"struct _dwg_VALUEPARAM*", sizeof (void *),  OFF (struct _dwg_object_ASSOCNETWORK, values),
    1,1,0, 0 },
  { "network_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCNETWORK, network_version),
    0,0,0, 90 },
  { "network_action_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, network_action_index),
    0,0,0, 90 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, num_actions),
    0,0,0, 90 },
  { "actions",	"Dwg_ASSOCACTION_Deps*", sizeof (Dwg_ASSOCACTION_Deps*),  OFF (struct _dwg_object_ASSOCNETWORK, actions),
    1,1,0, 0 },
  { "num_owned_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORK, num_owned_actions),
    0,0,0, 90 },
  { "owned_actions",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCNETWORK, owned_actions),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCNETWORKSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCOBJECTACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCOBJECTACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCOBJECTACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOBJECTACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOBJECTACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCOBJECTACTIONPARAM, name),
    1,1,1, 1 },
  { "asdap_class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOBJECTACTIONPARAM, asdap_class_version),
    0,0,0, 90 },
  { "dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCOBJECTACTIONPARAM, dep),
    1,0,0, 330 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOBJECTACTIONPARAM, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCOFFSETSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  { "b1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY, b1),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCORDINATEDIMACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCORDINATEDIMACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, parent),
    1,1,0, 0 },
  { "aaab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, aaab_version),
    0,0,0, 90 },
  { "assoc_dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, assoc_dep),
    1,0,0, 330 },
  { "aab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, aab_version),
    0,0,0, 90 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, actionbody),
    1,0,0, 360 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, pab),
    0,0,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, class_version),
    0,0,0, 90 },
  { "r_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, r_node),
    1,0,0, 330 },
  { "d_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY, d_node),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCOSNAPPOINTREFACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, name),
    1,1,1, 1 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, class_version),
    0,0,0, 90 },
  { "bs1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, bs1),
    0,0,0, 90 },
  { "num_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, num_params),
    0,0,0, 90 },
  { "params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, params),
    1,1,0, 360 },
  { "has_child_param",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, has_child_param),
    0,0,0, 0 },
  { "child_status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, child_status),
    0,0,0, 90 },
  { "child_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, child_id),
    0,0,0, 90 },
  { "child_param",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, child_param),
    1,0,0, 330 },
  { "h330_2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, h330_2),
    1,0,0, 330 },
  { "bl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, bl2),
    0,0,0, 90 },
  { "h330_3",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, h330_3),
    1,0,0, 330 },
  { "status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, status),
    0,0,0, 90 },
  { "osnap_mode",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, osnap_mode),
    0,0,0, 90 },
  { "param",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM, param),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPATCHSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCPATHACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPATHACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, name),
    1,1,1, 1 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, class_version),
    0,0,0, 90 },
  { "bs1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, bs1),
    0,0,0, 90 },
  { "num_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, num_params),
    0,0,0, 90 },
  { "params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, params),
    1,1,0, 360 },
  { "has_child_param",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, has_child_param),
    0,0,0, 0 },
  { "child_status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, child_status),
    0,0,0, 90 },
  { "child_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, child_id),
    0,0,0, 90 },
  { "child_param",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, child_param),
    1,0,0, 330 },
  { "h330_2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, h330_2),
    1,0,0, 330 },
  { "bl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, bl2),
    0,0,0, 90 },
  { "h330_3",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, h330_3),
    1,0,0, 330 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPATHACTIONPARAM, version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCPERSSUBENTMANAGER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPERSSUBENTMANAGER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, class_version),
    0,0,0, 90 },
  { "unknown_3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_3),
    0,0,0, 90 },
  { "unknown_0",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_0),
    0,0,0, 90 },
  { "unknown_2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_2),
    0,0,0, 90 },
  { "num_steps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, num_steps),
    0,0,0, 90 },
  { "num_subents",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, num_subents),
    0,0,0, 90 },
  { "steps",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, steps),
    1,1,0, 90 },
  { "subents",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, subents),
    1,1,0, 0 },
  { "unknown_bl6",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl6),
    0,0,0, 90 },
  { "unknown_bl6a",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl6a),
    0,0,0, 90 },
  { "unknown_bl7a",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl7a),
    0,0,0, 90 },
  { "unknown_bl7",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl7),
    0,0,0, 90 },
  { "unknown_bl8",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl8),
    0,0,0, 90 },
  { "unknown_bl9",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl9),
    0,0,0, 90 },
  { "unknown_bl10",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl10),
    0,0,0, 90 },
  { "unknown_bl11",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl11),
    0,0,0, 90 },
  { "unknown_bl12",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl12),
    0,0,0, 90 },
  { "unknown_bl13",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl13),
    0,0,0, 90 },
  { "unknown_bl14",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl14),
    0,0,0, 90 },
  { "unknown_bl15",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl15),
    0,0,0, 90 },
  { "unknown_bl16",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl16),
    0,0,0, 90 },
  { "unknown_bl17",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl17),
    0,0,0, 90 },
  { "unknown_bl18",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl18),
    0,0,0, 90 },
  { "unknown_bl19",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl19),
    0,0,0, 90 },
  { "unknown_bl20",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl20),
    0,0,0, 90 },
  { "unknown_bl21",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl21),
    0,0,0, 90 },
  { "unknown_bl22",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl22),
    0,0,0, 90 },
  { "unknown_bl23",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl23),
    0,0,0, 90 },
  { "unknown_bl24",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl24),
    0,0,0, 90 },
  { "unknown_bl25",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl25),
    0,0,0, 90 },
  { "unknown_bl26",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl26),
    0,0,0, 90 },
  { "unknown_bl27",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl27),
    0,0,0, 90 },
  { "unknown_bl28",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl28),
    0,0,0, 90 },
  { "unknown_bl29",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl29),
    0,0,0, 90 },
  { "unknown_bl30",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl30),
    0,0,0, 90 },
  { "unknown_bl31",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl31),
    0,0,0, 90 },
  { "unknown_bl32",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl32),
    0,0,0, 90 },
  { "unknown_bl33",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl33),
    0,0,0, 90 },
  { "unknown_bl34",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl34),
    0,0,0, 90 },
  { "unknown_bl35",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl35),
    0,0,0, 90 },
  { "unknown_bl36",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_bl36),
    0,0,0, 90 },
  { "unknown_b37",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCPERSSUBENTMANAGER, unknown_b37),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCPLANESURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPLANESURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCPOINTREFACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPOINTREFACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, name),
    1,1,1, 1 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, class_version),
    0,0,0, 90 },
  { "bs1",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, bs1),
    0,0,0, 90 },
  { "num_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, num_params),
    0,0,0, 90 },
  { "params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, params),
    1,1,0, 360 },
  { "has_child_param",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, has_child_param),
    0,0,0, 0 },
  { "child_status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, child_status),
    0,0,0, 90 },
  { "child_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, child_id),
    0,0,0, 90 },
  { "child_param",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, child_param),
    1,0,0, 330 },
  { "h330_2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, h330_2),
    1,0,0, 330 },
  { "bl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, bl2),
    0,0,0, 90 },
  { "h330_3",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCPOINTREFACTIONPARAM, h330_3),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCRESTOREENTITYSTATEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCRESTOREENTITYSTATEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCRESTOREENTITYSTATEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCRESTOREENTITYSTATEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCRESTOREENTITYSTATEACTIONBODY, class_version),
    0,0,0, 90 },
  { "entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCRESTOREENTITYSTATEACTIONBODY, entity),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCREVOLVEDSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCROTATEDDIMACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCROTATEDDIMACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, parent),
    1,1,0, 0 },
  { "aaab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, aaab_version),
    0,0,0, 90 },
  { "assoc_dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, assoc_dep),
    1,0,0, 330 },
  { "aab_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, aab_version),
    0,0,0, 90 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, actionbody),
    1,0,0, 360 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, pab),
    0,0,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, class_version),
    0,0,0, 90 },
  { "r_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, r_node),
    1,0,0, 330 },
  { "d_node",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY, d_node),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCSWEPTSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCTRIMSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "aab_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, aab_version),
    0,0,0, 90 },
  { "pab",	"Dwg_ASSOCPARAMBASEDACTIONBODY", sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, pab),
    0,0,0, 0 },
  { "sab",	"Dwg_ASSOCSURFACEACTIONBODY", sizeof (Dwg_ASSOCSURFACEACTIONBODY),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, sab),
    0,0,0, 0 },
  { "pbsab_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, pbsab_status),
    0,0,0, 90 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, class_version),
    0,0,0, 90 },
  { "b1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, b1),
    0,0,0, 290 },
  { "b2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, b2),
    0,0,0, 290 },
  { "distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY, distance),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCVALUEDEPENDENCY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCVALUEDEPENDENCY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCVALUEDEPENDENCY, parent),
    1,1,0, 0 },
  { "assocdep",	"Dwg_Object_ASSOCDEPENDENCY", sizeof (Dwg_Object_ASSOCDEPENDENCY),  OFF (struct _dwg_object_ASSOCVALUEDEPENDENCY, assocdep),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCVARIABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCVARIABLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCVARIABLE, parent),
    1,1,0, 0 },
  { "av_class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCVARIABLE, av_class_version),
    0,0,0, 90 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCVARIABLE, class_version),
    0,0,0, 90 },
  { "geometry_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVARIABLE, geometry_status),
    0,0,0, 90 },
  { "owningnetwork",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCVARIABLE, owningnetwork),
    1,0,0, 330 },
  { "actionbody",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCVARIABLE, actionbody),
    1,0,0, 360 },
  { "action_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVARIABLE, action_index),
    0,0,0, 90 },
  { "max_assoc_dep_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVARIABLE, max_assoc_dep_index),
    0,0,0, 90 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVARIABLE, num_deps),
    0,0,0, 90 },
  { "deps",	"Dwg_ASSOCACTION_Deps*", sizeof (Dwg_ASSOCACTION_Deps*),  OFF (struct _dwg_object_ASSOCVARIABLE, deps),
    1,1,0, 0 },
  { "num_owned_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVARIABLE, num_owned_params),
    0,0,0, 0 },
  { "owned_params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_ASSOCVARIABLE, owned_params),
    1,1,0, 0 },
  { "num_values",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVARIABLE, num_values),
    0,0,0, 0 },
  { "values",	"struct _dwg_VALUEPARAM*", sizeof (void *),  OFF (struct _dwg_object_ASSOCVARIABLE, values),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCVARIABLE, name),
    1,1,1, 1 },
  { "t58",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCVARIABLE, t58),
    1,1,1, 1 },
  { "evaluator",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCVARIABLE, evaluator),
    1,1,1, 1 },
  { "desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCVARIABLE, desc),
    1,1,1, 1 },
  { "value",	"Dwg_EvalVariant", sizeof (Dwg_EvalVariant),  OFF (struct _dwg_object_ASSOCVARIABLE, value),
    0,0,0, 0 },
  { "has_t78",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCVARIABLE, has_t78),
    0,0,0, 290 },
  { "t78",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_ASSOCVARIABLE, t78),
    1,1,1, 1 },
  { "b290",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ASSOCVARIABLE, b290),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ASSOCVERTEXACTIONPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCVERTEXACTIONPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, parent),
    1,1,0, 0 },
  { "is_r2013",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, is_r2013),
    0,0,0, 90 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, aap_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, name),
    1,1,1, 1 },
  { "asdap_class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, asdap_class_version),
    0,0,0, 90 },
  { "dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, dep),
    1,0,0, 330 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, class_version),
    0,0,0, 90 },
  { "pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ASSOCVERTEXACTIONPARAM, pt),
    1,0,0, 10 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLKREFOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLKREFOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLKREFOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLKREFOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLKREFOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLKREFOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLKREFOBJECTCONTEXTDATA, rotation),
    0,0,0, 50 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLKREFOBJECTCONTEXTDATA, ins_pt),
    1,0,0, 10 },
  { "scale_factor",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLKREFOBJECTCONTEXTDATA, scale_factor),
    1,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKALIGNEDCONSTRAINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, endpt),
    1,0,0, 0 },
  { "dependency",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, dependency),
    1,0,0, 330 },
  { "expr_name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, expr_name),
    1,1,1, 305 },
  { "expr_description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, expr_description),
    1,1,1, 306 },
  { "value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, value),
    0,0,0, 140 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKALIGNMENTGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKALIGNMENTGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  { "orientation",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTGRIP, orientation),
    1,0,0, 140 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKALIGNMENTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKALIGNMENTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, endpt),
    1,0,0, 0 },
  { "align_perpendicular",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKALIGNMENTPARAMETER, align_perpendicular),
    0,0,0, 280 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKANGULARCONSTRAINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, endpt),
    1,0,0, 0 },
  { "dependency",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, dependency),
    1,0,0, 330 },
  { "center_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, center_pt),
    1,0,0, 1011 },
  { "end_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, end_pt),
    1,0,0, 1012 },
  { "expr_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, expr_name),
    1,1,1, 305 },
  { "expr_description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, expr_description),
    1,1,1, 306 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, angle),
    0,0,0, 140 },
  { "orientation_on_both_grips",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, orientation_on_both_grips),
    0,0,0, 280 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKARRAYACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKARRAYACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKARRAYACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKARRAYACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKARRAYACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKARRAYACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKARRAYACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKARRAYACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKARRAYACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKARRAYACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKARRAYACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKARRAYACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKARRAYACTION, deps),
    1,1,0, 330 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 4 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_object_BLOCKARRAYACTION, conn_pts),
    0,0,0, 0 },
  { "column_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKARRAYACTION, column_offset),
    0,0,0, 140 },
  { "row_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKARRAYACTION, row_offset),
    0,0,0, 141 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKBASEPOINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKBASEPOINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, def_pt),
    1,0,0, 1010 },
  { "num_propinfos",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, num_propinfos),
    0,0,0, 93 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, prop2),
    0,0,0, 0 },
  { "pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, pt),
    1,0,0, 1011 },
  { "base_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKBASEPOINTPARAMETER, base_pt),
    1,0,0, 1012 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKDIAMETRICCONSTRAINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, endpt),
    1,0,0, 0 },
  { "dependency",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, dependency),
    1,0,0, 330 },
  { "expr_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, expr_name),
    1,1,1, 305 },
  { "expr_description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, expr_description),
    1,1,1, 306 },
  { "distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, distance),
    0,0,0, 140 },
  { "orientation_on_both_grips",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, orientation_on_both_grips),
    0,0,0, 0 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKFLIPACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKFLIPACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKFLIPACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKFLIPACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKFLIPACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKFLIPACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKFLIPACTION, deps),
    1,1,0, 330 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 4 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_object_BLOCKFLIPACTION, conn_pts),
    0,0,0, 0 },
  { "action_offset_x",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKFLIPACTION, action_offset_x),
    0,0,0, 0 },
  { "action_offset_y",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKFLIPACTION, action_offset_y),
    0,0,0, 0 },
  { "angle_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKFLIPACTION, angle_offset),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKFLIPGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKFLIPGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKFLIPGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKFLIPGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKFLIPGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKFLIPGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKFLIPGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  { "combined_state",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPGRIP, combined_state),
    0,0,0, 93 },
  { "orientation",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPGRIP, orientation),
    1,0,0, 140 },
  { "upd_state",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKFLIPGRIP, upd_state),
    0,0,0, 0 },
  { "state",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKFLIPGRIP, state),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKFLIPPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKFLIPPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, endpt),
    1,0,0, 0 },
  { "flip_label",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, flip_label),
    1,1,1, 305 },
  { "flip_label_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, flip_label_desc),
    1,1,1, 306 },
  { "base_state_label",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, base_state_label),
    1,1,1, 307 },
  { "flipped_state_label",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, flipped_state_label),
    1,1,1, 308 },
  { "def_label_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, def_label_pt),
    1,0,0, 1012 },
  { "bl96",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, bl96),
    0,0,0, 96 },
  { "tooltip",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKFLIPPARAMETER, tooltip),
    1,1,1, 309 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKGRIPLOCATIONCOMPONENT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKGRIPLOCATIONCOMPONENT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKGRIPLOCATIONCOMPONENT, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKGRIPLOCATIONCOMPONENT, evalexpr),
    0,0,0, 0 },
  { "grip_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKGRIPLOCATIONCOMPONENT, grip_type),
    0,0,0, 91 },
  { "grip_expr",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKGRIPLOCATIONCOMPONENT, grip_expr),
    1,1,1, 300 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKHORIZONTALCONSTRAINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, endpt),
    1,0,0, 0 },
  { "dependency",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, dependency),
    1,0,0, 330 },
  { "expr_name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, expr_name),
    1,1,1, 305 },
  { "expr_description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, expr_description),
    1,1,1, 306 },
  { "value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, value),
    0,0,0, 140 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKLINEARCONSTRAINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, endpt),
    1,0,0, 0 },
  { "dependency",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, dependency),
    1,0,0, 330 },
  { "expr_name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, expr_name),
    1,1,1, 305 },
  { "expr_description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, expr_description),
    1,1,1, 306 },
  { "value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, value),
    0,0,0, 140 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKLINEARGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKLINEARGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKLINEARGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKLINEARGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLINEARGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLINEARGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKLINEARGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  { "orientation",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARGRIP, orientation),
    1,0,0, 140 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKLINEARPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKLINEARPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, endpt),
    1,0,0, 0 },
  { "distance_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, distance_name),
    1,1,1, 305 },
  { "distance_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, distance_desc),
    1,1,1, 306 },
  { "distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, distance),
    0,0,0, 140 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKLINEARPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKLOOKUPACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKLOOKUPACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, deps),
    1,1,0, 330 },
  { "numelems",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, numelems),
    0,0,0, 0 },
  { "numrows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, numrows),
    0,0,0, 92 },
  { "numcols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, numcols),
    0,0,0, 93 },
  { "lut",	"Dwg_BLOCKLOOKUPACTION_lut*", sizeof (Dwg_BLOCKLOOKUPACTION_lut*),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, lut),
    1,1,0, 0 },
  { "exprs",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, exprs),
    1,1,0, 302 },
  { "b280",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLOOKUPACTION, b280),
    0,0,0, 280 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKLOOKUPGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKLOOKUPGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKLOOKUPGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKLOOKUPPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKLOOKUPPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, def_pt),
    1,0,0, 1010 },
  { "num_propinfos",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, num_propinfos),
    0,0,0, 93 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, prop2),
    0,0,0, 0 },
  { "lookup_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, lookup_name),
    1,1,1, 303 },
  { "lookup_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, lookup_desc),
    1,1,1, 304 },
  { "index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, index),
    0,0,0, 94 },
  { "unknown_t",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKLOOKUPPARAMETER, unknown_t),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKMOVEACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKMOVEACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKMOVEACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKMOVEACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKMOVEACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKMOVEACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKMOVEACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKMOVEACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKMOVEACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKMOVEACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKMOVEACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKMOVEACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKMOVEACTION, deps),
    1,1,0, 330 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 2 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_object_BLOCKMOVEACTION, conn_pts),
    0,0,0, 0 },
  { "action_offset_x",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKMOVEACTION, action_offset_x),
    0,0,0, 140 },
  { "action_offset_y",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKMOVEACTION, action_offset_y),
    0,0,0, 141 },
  { "angle_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKMOVEACTION, angle_offset),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKPARAMDEPENDENCYBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPARAMDEPENDENCYBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKPARAMDEPENDENCYBODY, parent),
    1,1,0, 0 },
  { "adb_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKPARAMDEPENDENCYBODY, adb_version),
    0,0,0, 90 },
  { "dimbase_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKPARAMDEPENDENCYBODY, dimbase_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKPARAMDEPENDENCYBODY, name),
    1,1,1, 1 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKPARAMDEPENDENCYBODY, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKPOINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPOINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, def_pt),
    1,0,0, 1010 },
  { "num_propinfos",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, num_propinfos),
    0,0,0, 93 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, prop2),
    0,0,0, 0 },
  { "position_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, position_name),
    1,1,1, 303 },
  { "position_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, position_desc),
    1,1,1, 304 },
  { "def_label_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOINTPARAMETER, def_label_pt),
    1,0,0, 1011 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKPOLARGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPOLARGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKPOLARGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKPOLARGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKPOLARGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKPOLARGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKPOLARGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKPOLARPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPOLARPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, endpt),
    1,0,0, 0 },
  { "angle_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, angle_name),
    1,1,1, 305 },
  { "angle_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, angle_desc),
    1,1,1, 306 },
  { "distance_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, distance_name),
    1,1,1, 305 },
  { "distance_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, distance_desc),
    1,1,1, 306 },
  { "offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, offset),
    0,0,0, 140 },
  { "angle_value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, angle_value_set),
    0,0,0, 0 },
  { "distance_value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKPOLARPARAMETER, distance_value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKPOLARSTRETCHACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPOLARSTRETCHACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, deps),
    1,1,0, 330 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 6 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, conn_pts),
    0,0,0, 0 },
  { "num_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, num_pts),
    0,0,0, 72 },
  { "pts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, pts),
    1,1,0, 10 },
  { "num_hdls",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, num_hdls),
    0,0,0, 73 },
  { "hdls",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, hdls),
    1,1,0, 331 },
  { "shorts",	"BS*", sizeof (BITCODE_BS*),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, shorts),
    1,1,0, 74 },
  { "num_codes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, num_codes),
    0,0,0, 75 },
  { "codes",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKPOLARSTRETCHACTION, codes),
    1,1,0, 76 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKPROPERTIESTABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPROPERTIESTABLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLE, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKPROPERTIESTABLEGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPROPERTIESTABLEGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKRADIALCONSTRAINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, endpt),
    1,0,0, 0 },
  { "dependency",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, dependency),
    1,0,0, 330 },
  { "expr_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, expr_name),
    1,1,1, 305 },
  { "expr_description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, expr_description),
    1,1,1, 306 },
  { "distance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, distance),
    0,0,0, 140 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKREPRESENTATION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKREPRESENTATION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKREPRESENTATION, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKREPRESENTATION, flag),
    0,0,0, 70 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKREPRESENTATION, block),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKROTATEACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKROTATEACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKROTATEACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKROTATEACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKROTATEACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATEACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATEACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATEACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATEACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATEACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKROTATEACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATEACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKROTATEACTION, deps),
    1,1,0, 330 },
  { "offset",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATEACTION, offset),
    1,0,0, 1011 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 3 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_object_BLOCKROTATEACTION, conn_pts),
    0,0,0, 0 },
  { "dependent",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKROTATEACTION, dependent),
    0,0,0, 280 },
  { "base_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATEACTION, base_pt),
    1,0,0, 1012 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKROTATIONGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKROTATIONGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKROTATIONGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKROTATIONPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKROTATIONPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, endpt),
    1,0,0, 0 },
  { "def_base_angle_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, def_base_angle_pt),
    1,0,0, 1011 },
  { "angle_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, angle_name),
    1,1,1, 305 },
  { "angle_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, angle_desc),
    1,1,1, 306 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, angle),
    0,0,0, 140 },
  { "angle_value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKROTATIONPARAMETER, angle_value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKSCALEACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKSCALEACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKSCALEACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKSCALEACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKSCALEACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSCALEACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSCALEACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSCALEACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKSCALEACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSCALEACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKSCALEACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSCALEACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKSCALEACTION, deps),
    1,1,0, 330 },
  { "offset",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKSCALEACTION, offset),
    1,0,0, 1011 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 5 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_object_BLOCKSCALEACTION, conn_pts),
    0,0,0, 0 },
  { "dependent",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKSCALEACTION, dependent),
    0,0,0, 280 },
  { "base_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKSCALEACTION, base_pt),
    1,0,0, 1012 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKSTRETCHACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKSTRETCHACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, eed1071),
    0,0,0, 1071 },
  { "display_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, display_location),
    1,0,0, 1010 },
  { "num_actions",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, num_actions),
    0,0,0, 70 },
  { "actions",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, actions),
    1,1,0, 91 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, num_deps),
    0,0,0, 71 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, deps),
    1,1,0, 330 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 2 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, conn_pts),
    0,0,0, 0 },
  { "num_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, num_pts),
    0,0,0, 72 },
  { "pts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, pts),
    1,1,0, 1011 },
  { "num_hdls",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, num_hdls),
    0,0,0, 73 },
  { "hdls",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, hdls),
    1,1,0, 331 },
  { "shorts",	"BS*", sizeof (BITCODE_BS*),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, shorts),
    1,1,0, 74 },
  { "num_codes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, num_codes),
    0,0,0, 75 },
  { "codes",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, codes),
    1,1,0, 76 },
  { "action_offset_x",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, action_offset_x),
    0,0,0, 140 },
  { "action_offset_y",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, action_offset_y),
    0,0,0, 141 },
  { "angle_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKSTRETCHACTION, angle_offset),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKUSERPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKUSERPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, def_pt),
    1,0,0, 1010 },
  { "num_propinfos",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, num_propinfos),
    0,0,0, 93 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, prop2),
    0,0,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, flag),
    0,0,0, 90 },
  { "assocvariable",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, assocvariable),
    1,0,0, 330 },
  { "expr",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, expr),
    1,1,1, 301 },
  { "value",	"Dwg_EvalVariant", sizeof (Dwg_EvalVariant),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, value),
    0,0,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKUSERPARAMETER, type),
    0,0,0, 170 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKVERTICALCONSTRAINTPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, endpt),
    1,0,0, 0 },
  { "dependency",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, dependency),
    1,0,0, 330 },
  { "expr_name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, expr_name),
    1,1,1, 305 },
  { "expr_description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, expr_description),
    1,1,1, 306 },
  { "value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, value),
    0,0,0, 140 },
  { "value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER, value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKVISIBILITYGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKVISIBILITYGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKVISIBILITYGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKVISIBILITYPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKVISIBILITYPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, def_pt),
    1,0,0, 1010 },
  { "num_propinfos",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, num_propinfos),
    0,0,0, 93 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, prop2),
    0,0,0, 0 },
  { "is_initialized",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, is_initialized),
    0,0,0, 281 },
  { "unknown_bool",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, unknown_bool),
    0,0,0, 91 },
  { "blockvisi_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, blockvisi_name),
    1,1,1, 301 },
  { "blockvisi_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, blockvisi_desc),
    1,1,1, 302 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, num_blocks),
    0,0,0, 93 },
  { "blocks",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, blocks),
    1,1,0, 331 },
  { "num_states",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, num_states),
    0,0,0, 92 },
  { "states",	"Dwg_BLOCKVISIBILITYPARAMETER_state*", sizeof (Dwg_BLOCKVISIBILITYPARAMETER_state*),  OFF (struct _dwg_object_BLOCKVISIBILITYPARAMETER, states),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKXYGRIP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKXYGRIP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKXYGRIP, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKXYGRIP, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKXYGRIP, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYGRIP, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYGRIP, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYGRIP, eed1071),
    0,0,0, 1071 },
  { "bg_bl91",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYGRIP, bg_bl91),
    0,0,0, 91 },
  { "bg_bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYGRIP, bg_bl92),
    0,0,0, 92 },
  { "bg_location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKXYGRIP, bg_location),
    1,0,0, 1010 },
  { "bg_insert_cycling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKXYGRIP, bg_insert_cycling),
    0,0,0, 280 },
  { "bg_insert_cycling_weight",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_BLOCKXYGRIP, bg_insert_cycling_weight),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCKXYPARAMETER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKXYPARAMETER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCKXYPARAMETER, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_BLOCKXYPARAMETER, evalexpr),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCKXYPARAMETER, name),
    1,1,1, 300 },
  { "be_major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYPARAMETER, be_major),
    0,0,0, 98 },
  { "be_minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYPARAMETER, be_minor),
    0,0,0, 99 },
  { "eed1071",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCKXYPARAMETER, eed1071),
    0,0,0, 1071 },
  { "show_properties",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKXYPARAMETER, show_properties),
    0,0,0, 280 },
  { "chain_actions",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCKXYPARAMETER, chain_actions),
    0,0,0, 281 },
  { "def_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, def_basept),
    1,0,0, 1010 },
  { "def_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, def_endpt),
    1,0,0, 1011 },
  { "prop1",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKXYPARAMETER, prop1),
    0,0,0, 0 },
  { "prop2",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKXYPARAMETER, prop2),
    0,0,0, 0 },
  { "prop3",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKXYPARAMETER, prop3),
    0,0,0, 0 },
  { "prop4",	"Dwg_BLOCKPARAMETER_PropInfo", sizeof (Dwg_BLOCKPARAMETER_PropInfo),  OFF (struct _dwg_object_BLOCKXYPARAMETER, prop4),
    0,0,0, 0 },
  { "prop_states",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_BLOCKXYPARAMETER, prop_states),
    1,1,0, 91 },
  { "parameter_base_location",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCKXYPARAMETER, parameter_base_location),
    0,0,0, 177 },
  { "upd_basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, upd_basept),
    1,0,0, 0 },
  { "basept",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, basept),
    1,0,0, 0 },
  { "upd_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, upd_endpt),
    1,0,0, 0 },
  { "endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, endpt),
    1,0,0, 0 },
  { "x_label",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKXYPARAMETER, x_label),
    1,1,1, 305 },
  { "x_label_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKXYPARAMETER, x_label_desc),
    1,1,1, 306 },
  { "y_label",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKXYPARAMETER, y_label),
    1,1,1, 307 },
  { "y_label_desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_BLOCKXYPARAMETER, y_label_desc),
    1,1,1, 308 },
  { "x_value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, x_value),
    0,0,0, 142 },
  { "y_value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_BLOCKXYPARAMETER, y_value),
    0,0,0, 141 },
  { "x_value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKXYPARAMETER, x_value_set),
    0,0,0, 0 },
  { "y_value_set",	"Dwg_BLOCKPARAMVALUESET", sizeof (Dwg_BLOCKPARAMVALUESET),  OFF (struct _dwg_object_BLOCKXYPARAMETER, y_value_set),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCK_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCK_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCK_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCK_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCK_CONTROL, entries),
    1,1,0, 0 },
  { "model_space",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_CONTROL, model_space),
    1,0,0, 0 },
  { "paper_space",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_CONTROL, paper_space),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_BLOCK_HEADER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCK_HEADER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_BLOCK_HEADER, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_BLOCK_HEADER, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCK_HEADER, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_BLOCK_HEADER, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCK_HEADER, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, xref),
    1,0,0, 0 },
  { "__iterator",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCK_HEADER, __iterator),
    0,0,0, 0 },
  { "flag2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_BLOCK_HEADER, flag2),
    0,0,0, 0 },
  { "flag3",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_BLOCK_HEADER, flag3),
    0,0,0, 0 },
  { "anonymous",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, anonymous),
    0,0,0, 0 },
  { "hasattrs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, hasattrs),
    0,0,0, 0 },
  { "blkisxref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, blkisxref),
    0,0,0, 0 },
  { "xrefoverlaid",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, xrefoverlaid),
    0,0,0, 0 },
  { "loaded_bit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, loaded_bit),
    0,0,0, 0 },
  { "num_owned",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCK_HEADER, num_owned),
    0,0,0, 0 },
  { "base_pt",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_BLOCK_HEADER, base_pt),
    1,0,0, 10 },
  { "xref_pname",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCK_HEADER, xref_pname),
    1,1,1, 1 },
  { "num_inserts",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_object_BLOCK_HEADER, num_inserts),
    0,0,0, 0 },
  { "description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_BLOCK_HEADER, description),
    1,1,1, 4 },
  { "preview_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_BLOCK_HEADER, preview_size),
    0,0,0, 0 },
  { "preview",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_BLOCK_HEADER, preview),
    1,1,0, 310 },
  { "insert_units",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_BLOCK_HEADER, insert_units),
    0,0,0, 70 },
  { "explodable",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_BLOCK_HEADER, explodable),
    0,0,0, 280 },
  { "block_scaling",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_BLOCK_HEADER, block_scaling),
    0,0,0, 281 },
  { "block_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, block_entity),
    1,0,0, 0 },
  { "first_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, first_entity),
    1,0,0, 0 },
  { "last_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, last_entity),
    1,0,0, 0 },
  { "entities",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCK_HEADER, entities),
    1,1,0, 0 },
  { "endblk_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, endblk_entity),
    1,0,0, 0 },
  { "inserts",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_BLOCK_HEADER, inserts),
    1,1,0, 331 },
  { "layout",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_BLOCK_HEADER, layout),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_CELLSTYLEMAP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CELLSTYLEMAP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_CELLSTYLEMAP, parent),
    1,1,0, 0 },
  { "num_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_CELLSTYLEMAP, num_cells),
    0,0,0, 90 },
  { "cells",	"Dwg_TABLESTYLE_CellStyle*", sizeof (Dwg_TABLESTYLE_CellStyle*),  OFF (struct _dwg_object_CELLSTYLEMAP, cells),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_CONTEXTDATAMANAGER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CONTEXTDATAMANAGER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_CONTEXTDATAMANAGER, parent),
    1,1,0, 0 },
  { "objectcontext",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_CONTEXTDATAMANAGER, objectcontext),
    1,0,0, 0 },
  { "num_submgrs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_CONTEXTDATAMANAGER, num_submgrs),
    0,0,0, 0 },
  { "submgrs",	"Dwg_CONTEXTDATA_submgr*", sizeof (Dwg_CONTEXTDATA_submgr*),  OFF (struct _dwg_object_CONTEXTDATAMANAGER, submgrs),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_CSACDOCUMENTOPTIONS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CSACDOCUMENTOPTIONS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_CSACDOCUMENTOPTIONS, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_CSACDOCUMENTOPTIONS, class_version),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_CURVEPATH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CURVEPATH_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_CURVEPATH, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_CURVEPATH, class_version),
    0,0,0, 90 },
  { "entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_CURVEPATH, entity),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DATALINK: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DATALINK_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DATALINK, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, class_version),
    0,0,0, 0 },
  { "data_adapter",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DATALINK, data_adapter),
    1,1,1, 1 },
  { "description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DATALINK, description),
    1,1,1, 300 },
  { "tooltip",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DATALINK, tooltip),
    1,1,1, 301 },
  { "connection_string",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DATALINK, connection_string),
    1,1,1, 302 },
  { "option",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DATALINK, option),
    0,0,0, 90 },
  { "update_option",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DATALINK, update_option),
    0,0,0, 91 },
  { "bl92",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DATALINK, bl92),
    0,0,0, 92 },
  { "year",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, year),
    0,0,0, 170 },
  { "month",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, month),
    0,0,0, 171 },
  { "day",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, day),
    0,0,0, 172 },
  { "hour",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, hour),
    0,0,0, 173 },
  { "minute",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, minute),
    0,0,0, 174 },
  { "seconds",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, seconds),
    0,0,0, 175 },
  { "msec",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, msec),
    0,0,0, 176 },
  { "path_option",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATALINK, path_option),
    0,0,0, 177 },
  { "bl93",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DATALINK, bl93),
    0,0,0, 93 },
  { "update_status",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DATALINK, update_status),
    1,1,1, 304 },
  { "num_customdata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DATALINK, num_customdata),
    0,0,0, 94 },
  { "customdata",	"Dwg_DATALINK_customdata*", sizeof (Dwg_DATALINK_customdata*),  OFF (struct _dwg_object_DATALINK, customdata),
    1,1,0, 0 },
  { "hardowner",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DATALINK, hardowner),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DATATABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DATATABLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DATATABLE, parent),
    1,1,0, 0 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DATATABLE, flags),
    0,0,0, 70 },
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DATATABLE, num_cols),
    0,0,0, 90 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DATATABLE, num_rows),
    0,0,0, 91 },
  { "table_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DATATABLE, table_name),
    1,1,1, 1 },
  { "cols",	"Dwg_DATATABLE_column*", sizeof (Dwg_DATATABLE_column*),  OFF (struct _dwg_object_DATATABLE, cols),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DBCOLOR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DBCOLOR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DBCOLOR, parent),
    1,1,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DBCOLOR, color),
    0,0,0, 62 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DETAILVIEWSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DETAILVIEWSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DETAILVIEWSTYLE, parent),
    1,1,0, 0 },
  { "mdoc_class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DETAILVIEWSTYLE, mdoc_class_version),
    0,0,0, 70 },
  { "desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DETAILVIEWSTYLE, desc),
    1,1,1, 3 },
  { "is_modified_for_recompute",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DETAILVIEWSTYLE, is_modified_for_recompute),
    0,0,0, 290 },
  { "display_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DETAILVIEWSTYLE, display_name),
    1,1,1, 300 },
  { "viewstyle_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewstyle_flags),
    0,0,0, 90 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DETAILVIEWSTYLE, class_version),
    0,0,0, 70 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DETAILVIEWSTYLE, flags),
    0,0,0, 90 },
  { "identifier_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DETAILVIEWSTYLE, identifier_style),
    1,0,0, 340 },
  { "identifier_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, identifier_color),
    0,0,0, 62 },
  { "identifier_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DETAILVIEWSTYLE, identifier_height),
    0,0,0, 40 },
  { "identifier_exclude_characters",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DETAILVIEWSTYLE, identifier_exclude_characters),
    1,1,1, 300 },
  { "identifier_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DETAILVIEWSTYLE, identifier_offset),
    0,0,0, 40 },
  { "identifier_placement",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, identifier_placement),
    0,0,0, 280 },
  { "arrow_symbol",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DETAILVIEWSTYLE, arrow_symbol),
    1,0,0, 340 },
  { "arrow_symbol_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, arrow_symbol_color),
    0,0,0, 62 },
  { "arrow_symbol_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DETAILVIEWSTYLE, arrow_symbol_size),
    0,0,0, 40 },
  { "boundary_ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DETAILVIEWSTYLE, boundary_ltype),
    1,0,0, 340 },
  { "boundary_linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_DETAILVIEWSTYLE, boundary_linewt),
    0,0,0, 90 },
  { "boundary_line_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, boundary_line_color),
    0,0,0, 62 },
  { "viewlabel_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewlabel_text_style),
    1,0,0, 340 },
  { "viewlabel_text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewlabel_text_color),
    0,0,0, 62 },
  { "viewlabel_text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewlabel_text_height),
    0,0,0, 40 },
  { "viewlabel_attachment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewlabel_attachment),
    0,0,0, 90 },
  { "viewlabel_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewlabel_offset),
    0,0,0, 40 },
  { "viewlabel_alignment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewlabel_alignment),
    0,0,0, 90 },
  { "viewlabel_pattern",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DETAILVIEWSTYLE, viewlabel_pattern),
    1,1,1, 300 },
  { "connection_ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DETAILVIEWSTYLE, connection_ltype),
    1,0,0, 340 },
  { "connection_linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_DETAILVIEWSTYLE, connection_linewt),
    0,0,0, 90 },
  { "connection_line_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, connection_line_color),
    0,0,0, 62 },
  { "borderline_ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DETAILVIEWSTYLE, borderline_ltype),
    1,0,0, 340 },
  { "borderline_linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_DETAILVIEWSTYLE, borderline_linewt),
    0,0,0, 90 },
  { "borderline_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, borderline_color),
    0,0,0, 62 },
  { "model_edge",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DETAILVIEWSTYLE, model_edge),
    0,0,0, 280 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DICTIONARY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DICTIONARY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DICTIONARY, parent),
    1,1,0, 0 },
  { "numitems",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DICTIONARY, numitems),
    0,0,0, 0 },
  { "is_hardowner",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARY, is_hardowner),
    0,0,0, 280 },
  { "cloning",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DICTIONARY, cloning),
    0,0,0, 281 },
  { "texts",	"T*", sizeof (BITCODE_T*),  OFF (struct _dwg_object_DICTIONARY, texts),
    1,1,0, 3 },
  { "itemhandles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DICTIONARY, itemhandles),
    1,1,0, 350 },
  { "cloning_r14",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARY, cloning_r14),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DICTIONARYVAR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DICTIONARYVAR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DICTIONARYVAR, parent),
    1,1,0, 0 },
  { "schema",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARYVAR, schema),
    0,0,0, 280 },
  { "strvalue",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DICTIONARYVAR, strvalue),
    1,1,1, 1 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DICTIONARYWDFLT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DICTIONARYWDFLT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DICTIONARYWDFLT, parent),
    1,1,0, 0 },
  { "numitems",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DICTIONARYWDFLT, numitems),
    0,0,0, 0 },
  { "is_hardowner",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DICTIONARYWDFLT, is_hardowner),
    0,0,0, 280 },
  { "cloning",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DICTIONARYWDFLT, cloning),
    0,0,0, 281 },
  { "texts",	"T*", sizeof (BITCODE_T*),  OFF (struct _dwg_object_DICTIONARYWDFLT, texts),
    1,1,0, 3 },
  { "itemhandles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DICTIONARYWDFLT, itemhandles),
    1,1,0, 350 },
  { "cloning_r14",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_object_DICTIONARYWDFLT, cloning_r14),
    0,0,0, 0 },
  { "defaultid",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DICTIONARYWDFLT, defaultid),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DIMASSOC: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMASSOC_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DIMASSOC, parent),
    1,1,0, 0 },
  { "dimensionobj",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMASSOC, dimensionobj),
    1,0,0, 330 },
  { "associativity",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_DIMASSOC, associativity),
    0,0,0, 90 },
  { "trans_space_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMASSOC, trans_space_flag),
    0,0,0, 70 },
  { "rotated_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DIMASSOC, rotated_type),
    0,0,0, 71 },
  { "ref",	"Dwg_DIMASSOC_Ref*", sizeof (Dwg_DIMASSOC_Ref*),  OFF (struct _dwg_object_DIMASSOC, ref),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DIMSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DIMSTYLE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DIMSTYLE, flag),
    0,0,0, 70 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_DIMSTYLE, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, xref),
    1,0,0, 0 },
  { "DIMTOL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTOL),
    0,0,0, 71 },
  { "DIMLIM",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMLIM),
    0,0,0, 72 },
  { "DIMTIH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTIH),
    0,0,0, 73 },
  { "DIMTOH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTOH),
    0,0,0, 74 },
  { "DIMSE1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSE1),
    0,0,0, 75 },
  { "DIMSE2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSE2),
    0,0,0, 76 },
  { "DIMALT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMALT),
    0,0,0, 170 },
  { "DIMTOFL",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTOFL),
    0,0,0, 172 },
  { "DIMSAH",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSAH),
    0,0,0, 173 },
  { "DIMTIX",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTIX),
    0,0,0, 174 },
  { "DIMSOXD",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSOXD),
    0,0,0, 175 },
  { "DIMALTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTD),
    0,0,0, 171 },
  { "DIMZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMZIN),
    0,0,0, 78 },
  { "DIMSD1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSD1),
    0,0,0, 281 },
  { "DIMSD2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMSD2),
    0,0,0, 282 },
  { "DIMTOLJ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTOLJ),
    0,0,0, 283 },
  { "DIMJUST",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMJUST),
    0,0,0, 280 },
  { "DIMFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMFIT),
    0,0,0, 287 },
  { "DIMUPT",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMUPT),
    0,0,0, 288 },
  { "DIMTZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTZIN),
    0,0,0, 284 },
  { "DIMMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMMALTZ),
    0,0,0, 285 },
  { "DIMMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMMALTTZ),
    0,0,0, 286 },
  { "DIMTAD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTAD),
    0,0,0, 77 },
  { "DIMUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMUNIT),
    0,0,0, 270 },
  { "DIMAUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMAUNIT),
    0,0,0, 275 },
  { "DIMDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMDEC),
    0,0,0, 271 },
  { "DIMTDEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTDEC),
    0,0,0, 272 },
  { "DIMALTU",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTU),
    0,0,0, 273 },
  { "DIMALTTD",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTTD),
    0,0,0, 274 },
  { "DIMSCALE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMSCALE),
    0,0,0, 40 },
  { "DIMASZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMASZ),
    0,0,0, 41 },
  { "DIMEXO",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMEXO),
    0,0,0, 42 },
  { "DIMDLI",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMDLI),
    0,0,0, 43 },
  { "DIMEXE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMEXE),
    0,0,0, 44 },
  { "DIMRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMRND),
    0,0,0, 45 },
  { "DIMDLE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMDLE),
    0,0,0, 46 },
  { "DIMTP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTP),
    0,0,0, 47 },
  { "DIMTM",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTM),
    0,0,0, 48 },
  { "DIMFXL",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMFXL),
    0,0,0, 49 },
  { "DIMJOGANG",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMJOGANG),
    0,0,0, 50 },
  { "DIMTFILL",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTFILL),
    0,0,0, 69 },
  { "DIMTFILLCLR",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMTFILLCLR),
    0,0,0, 70 },
  { "DIMAZIN",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMAZIN),
    0,0,0, 79 },
  { "DIMARCSYM",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMARCSYM),
    0,0,0, 90 },
  { "DIMTXT",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTXT),
    0,0,0, 140 },
  { "DIMCEN",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMCEN),
    0,0,0, 141 },
  { "DIMTSZ",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTSZ),
    0,0,0, 142 },
  { "DIMALTF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMALTF),
    0,0,0, 143 },
  { "DIMLFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMLFAC),
    0,0,0, 144 },
  { "DIMTVP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTVP),
    0,0,0, 145 },
  { "DIMTFAC",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMTFAC),
    0,0,0, 146 },
  { "DIMGAP",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMGAP),
    0,0,0, 147 },
  { "DIMPOST",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMPOST),
    1,1,1, 3 },
  { "DIMAPOST",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMAPOST),
    1,1,1, 4 },
  { "DIMBLK_T",	"TV", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK_T),
    1,1,1, 5 },
  { "DIMBLK1_T",	"TV", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK1_T),
    1,1,1, 6 },
  { "DIMBLK2_T",	"TV", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK2_T),
    1,1,1, 7 },
  { "DIMALTRND",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMALTRND),
    0,0,0, 148 },
  { "DIMCLRD_N",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRD_N),
    0,0,0, 176 },
  { "DIMCLRE_N",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRE_N),
    0,0,0, 177 },
  { "DIMCLRT_N",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRT_N),
    0,0,0, 178 },
  { "DIMCLRD",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRD),
    0,0,0, 176 },
  { "DIMCLRE",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRE),
    0,0,0, 177 },
  { "DIMCLRT",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_DIMSTYLE, DIMCLRT),
    0,0,0, 178 },
  { "DIMADEC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMADEC),
    0,0,0, 179 },
  { "DIMFRAC",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMFRAC),
    0,0,0, 276 },
  { "DIMLUNIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMLUNIT),
    0,0,0, 277 },
  { "DIMDSEP",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMDSEP),
    0,0,0, 278 },
  { "DIMTMOVE",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMTMOVE),
    0,0,0, 279 },
  { "DIMALTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTZ),
    0,0,0, 285 },
  { "DIMALTTZ",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMALTTZ),
    0,0,0, 286 },
  { "DIMATFIT",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE, DIMATFIT),
    0,0,0, 289 },
  { "DIMFXLON",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMFXLON),
    0,0,0, 290 },
  { "DIMTXTDIRECTION",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, DIMTXTDIRECTION),
    0,0,0, 295 },
  { "DIMALTMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMALTMZF),
    0,0,0, 0 },
  { "DIMALTMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMALTMZS),
    1,1,1, 0 },
  { "DIMMZF",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_DIMSTYLE, DIMMZF),
    0,0,0, 0 },
  { "DIMMZS",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_DIMSTYLE, DIMMZS),
    1,1,1, 0 },
  { "DIMLWD",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_object_DIMSTYLE, DIMLWD),
    0,0,0, 371 },
  { "DIMLWE",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_object_DIMSTYLE, DIMLWE),
    0,0,0, 372 },
  { "flag0",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DIMSTYLE, flag0),
    0,0,0, 0 },
  { "DIMTXSTY",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMTXSTY),
    1,0,0, 340 },
  { "DIMLDRBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLDRBLK),
    1,0,0, 341 },
  { "DIMBLK",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK),
    1,0,0, 342 },
  { "DIMBLK1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK1),
    1,0,0, 343 },
  { "DIMBLK2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMBLK2),
    1,0,0, 344 },
  { "DIMLTYPE",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLTYPE),
    1,0,0, 345 },
  { "DIMLTEX1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLTEX1),
    1,0,0, 346 },
  { "DIMLTEX2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DIMSTYLE, DIMLTEX2),
    1,0,0, 347 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DIMSTYLE_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMSTYLE_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, entries),
    1,1,0, 0 },
  { "num_morehandles",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, num_morehandles),
    0,0,0, 71 },
  { "morehandles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_DIMSTYLE_CONTROL, morehandles),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DMDIMOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DMDIMOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DMDIMOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DMDIMOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_DMDIMOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DMDIMOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "dimension",	"Dwg_OCD_Dimension", sizeof (Dwg_OCD_Dimension),  OFF (struct _dwg_object_DMDIMOBJECTCONTEXTDATA, dimension),
    0,0,0, 0 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_DMDIMOBJECTCONTEXTDATA, first_arc_pt),
    1,0,0, 11 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_DMDIMOBJECTCONTEXTDATA, def_pt),
    1,0,0, 12 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DUMMY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DUMMY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DUMMY, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DYNAMICBLOCKPROXYNODE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DYNAMICBLOCKPROXYNODE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DYNAMICBLOCKPROXYNODE, parent),
    1,1,0, 0 },
  { "evalexpr",	"Dwg_EvalExpr", sizeof (Dwg_EvalExpr),  OFF (struct _dwg_object_DYNAMICBLOCKPROXYNODE, evalexpr),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DYNAMICBLOCKPURGEPREVENTER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER, flag),
    0,0,0, 70 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_EVALUATION_GRAPH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EVALUATION_GRAPH_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_EVALUATION_GRAPH, parent),
    1,1,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, major),
    0,0,0, 0 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, minor),
    0,0,0, 0 },
  { "first_nodeid",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_EVALUATION_GRAPH, first_nodeid),
    0,0,0, 96 },
  { "first_nodeid_copy",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_EVALUATION_GRAPH, first_nodeid_copy),
    0,0,0, 97 },
  { "num_nodes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, num_nodes),
    0,0,0, 0 },
  { "nodes",	"Dwg_EVAL_Node*", sizeof (Dwg_EVAL_Node*),  OFF (struct _dwg_object_EVALUATION_GRAPH, nodes),
    1,1,0, 0 },
  { "has_graph",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_EVALUATION_GRAPH, has_graph),
    0,0,0, 0 },
  { "num_edges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_EVALUATION_GRAPH, num_edges),
    0,0,0, 0 },
  { "edges",	"Dwg_EVAL_Edge*", sizeof (Dwg_EVAL_Edge*),  OFF (struct _dwg_object_EVALUATION_GRAPH, edges),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_FCFOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FCFOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_FCFOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_FCFOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_FCFOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_FCFOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_FCFOBJECTCONTEXTDATA, location),
    1,0,0, 10 },
  { "horiz_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_FCFOBJECTCONTEXTDATA, horiz_dir),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_FIELD: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FIELD_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_FIELD, parent),
    1,1,0, 0 },
  { "id",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, id),
    1,1,1, 1 },
  { "code",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, code),
    1,1,1, 2 },
  { "num_childs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, num_childs),
    0,0,0, 90 },
  { "childs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_FIELD, childs),
    1,1,0, 360 },
  { "num_objects",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, num_objects),
    0,0,0, 97 },
  { "objects",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_FIELD, objects),
    1,1,0, 331 },
  { "format",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, format),
    1,1,1, 4 },
  { "evaluation_option",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, evaluation_option),
    0,0,0, 91 },
  { "filing_option",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, filing_option),
    0,0,0, 92 },
  { "field_state",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, field_state),
    0,0,0, 94 },
  { "evaluation_status",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, evaluation_status),
    0,0,0, 95 },
  { "evaluation_error_code",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, evaluation_error_code),
    0,0,0, 96 },
  { "evaluation_error_msg",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, evaluation_error_msg),
    1,1,1, 300 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_object_FIELD, value),
    0,0,0, 0 },
  { "value_string",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_FIELD, value_string),
    1,1,1, 301 },
  { "value_string_length",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, value_string_length),
    0,0,0, 98 },
  { "num_childval",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELD, num_childval),
    0,0,0, 93 },
  { "childval",	"Dwg_FIELD_ChildValue*", sizeof (Dwg_FIELD_ChildValue*),  OFF (struct _dwg_object_FIELD, childval),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_FIELDLIST: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FIELDLIST_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_FIELDLIST, parent),
    1,1,0, 0 },
  { "num_fields",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_FIELDLIST, num_fields),
    0,0,0, 90 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_FIELDLIST, unknown),
    0,0,0, 0 },
  { "fields",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_FIELDLIST, fields),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GEODATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEODATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GEODATA, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, class_version),
    0,0,0, 90 },
  { "host_block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_GEODATA, host_block),
    1,0,0, 330 },
  { "coord_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEODATA, coord_type),
    0,0,0, 70 },
  { "design_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, design_pt),
    1,0,0, 10 },
  { "ref_pt",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, ref_pt),
    1,0,0, 11 },
  { "obs_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, obs_pt),
    1,0,0, 11 },
  { "scale_vec",	"3BD_1", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, scale_vec),
    1,0,0, 43 },
  { "unit_scale_horiz",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, unit_scale_horiz),
    0,0,0, 40 },
  { "units_value_horiz",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, units_value_horiz),
    0,0,0, 91 },
  { "unit_scale_vert",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, unit_scale_vert),
    0,0,0, 41 },
  { "units_value_vert",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, units_value_vert),
    0,0,0, 92 },
  { "up_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, up_dir),
    1,0,0, 210 },
  { "north_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, north_dir),
    1,0,0, 12 },
  { "scale_est",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, scale_est),
    0,0,0, 95 },
  { "user_scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, user_scale_factor),
    0,0,0, 141 },
  { "do_sea_level_corr",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEODATA, do_sea_level_corr),
    0,0,0, 294 },
  { "sea_level_elev",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, sea_level_elev),
    0,0,0, 142 },
  { "coord_proj_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, coord_proj_radius),
    0,0,0, 143 },
  { "coord_system_def",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, coord_system_def),
    1,1,1, 301 },
  { "geo_rss_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, geo_rss_tag),
    1,1,1, 302 },
  { "coord_system_datum",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, coord_system_datum),
    1,1,1, 303 },
  { "coord_system_wkt",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, coord_system_wkt),
    1,1,1, 304 },
  { "observation_from_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, observation_from_tag),
    1,1,1, 305 },
  { "observation_to_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, observation_to_tag),
    1,1,1, 306 },
  { "observation_coverage_tag",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEODATA, observation_coverage_tag),
    1,1,1, 307 },
  { "num_geomesh_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, num_geomesh_pts),
    0,0,0, 93 },
  { "geomesh_pts",	"Dwg_GEODATA_meshpt*", sizeof (Dwg_GEODATA_meshpt*),  OFF (struct _dwg_object_GEODATA, geomesh_pts),
    1,1,0, 0 },
  { "num_geomesh_faces",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, num_geomesh_faces),
    0,0,0, 96 },
  { "geomesh_faces",	"Dwg_GEODATA_meshface*", sizeof (Dwg_GEODATA_meshface*),  OFF (struct _dwg_object_GEODATA, geomesh_faces),
    1,1,0, 0 },
  { "has_civil_data",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEODATA, has_civil_data),
    0,0,0, 0 },
  { "obsolete_false",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEODATA, obsolete_false),
    0,0,0, 292 },
  { "ref_pt2d",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_GEODATA, ref_pt2d),
    1,0,0, 15 },
  { "zero1",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEODATA, zero1),
    1,0,0, 16 },
  { "unknown1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, unknown1),
    0,0,0, 93 },
  { "unknown2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEODATA, unknown2),
    0,0,0, 94 },
  { "unknown_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEODATA, unknown_b),
    0,0,0, 293 },
  { "north_dir_angle_deg",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, north_dir_angle_deg),
    0,0,0, 54 },
  { "north_dir_angle_rad",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEODATA, north_dir_angle_rad),
    0,0,0, 140 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GEOMAPIMAGE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEOMAPIMAGE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GEOMAPIMAGE, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GEOMAPIMAGE, class_version),
    0,0,0, 90 },
  { "pt0",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_GEOMAPIMAGE, pt0),
    1,0,0, 10 },
  { "size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_GEOMAPIMAGE, size),
    1,0,0, 13 },
  { "display_props",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, display_props),
    0,0,0, 70 },
  { "clipping",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEOMAPIMAGE, clipping),
    0,0,0, 280 },
  { "brightness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_GEOMAPIMAGE, brightness),
    0,0,0, 281 },
  { "contrast",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_GEOMAPIMAGE, contrast),
    0,0,0, 282 },
  { "fade",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_GEOMAPIMAGE, fade),
    0,0,0, 283 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, rotation),
    0,0,0, 0 },
  { "image_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_width),
    0,0,0, 0 },
  { "image_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_height),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_GEOMAPIMAGE, name),
    1,1,1, 0 },
  { "image_file",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_file),
    0,0,0, 0 },
  { "image_visibility",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, image_visibility),
    0,0,0, 0 },
  { "transparency",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, transparency),
    0,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, height),
    0,0,0, 0 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, width),
    0,0,0, 0 },
  { "show_rotation",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_GEOMAPIMAGE, show_rotation),
    0,0,0, 0 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GEOMAPIMAGE, scale_factor),
    0,0,0, 0 },
  { "geoimage_brightness",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_brightness),
    0,0,0, 0 },
  { "geoimage_contrast",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_contrast),
    0,0,0, 0 },
  { "geoimage_fade",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_fade),
    0,0,0, 0 },
  { "geoimage_position",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_position),
    0,0,0, 0 },
  { "geoimage_width",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_width),
    0,0,0, 0 },
  { "geoimage_height",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GEOMAPIMAGE, geoimage_height),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GRADIENT_BACKGROUND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GRADIENT_BACKGROUND_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, class_version),
    0,0,0, 90 },
  { "color_top",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, color_top),
    0,0,0, 90 },
  { "color_middle",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, color_middle),
    0,0,0, 91 },
  { "color_bottom",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, color_bottom),
    0,0,0, 92 },
  { "horizon",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, horizon),
    0,0,0, 140 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, height),
    0,0,0, 141 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_GRADIENT_BACKGROUND, rotation),
    0,0,0, 142 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GROUND_PLANE_BACKGROUND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GROUND_PLANE_BACKGROUND_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, class_version),
    0,0,0, 90 },
  { "color_sky_zenith",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, color_sky_zenith),
    0,0,0, 90 },
  { "color_sky_horizon",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, color_sky_horizon),
    0,0,0, 91 },
  { "color_underground_horizon",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, color_underground_horizon),
    0,0,0, 92 },
  { "color_underground_azimuth",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, color_underground_azimuth),
    0,0,0, 93 },
  { "color_near",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, color_near),
    0,0,0, 94 },
  { "color_far",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_GROUND_PLANE_BACKGROUND, color_far),
    0,0,0, 95 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_GROUP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GROUP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_GROUP, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_GROUP, name),
    1,1,1, 300 },
  { "unnamed",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GROUP, unnamed),
    0,0,0, 70 },
  { "selectable",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_GROUP, selectable),
    0,0,0, 71 },
  { "num_groups",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_GROUP, num_groups),
    0,0,0, 0 },
  { "groups",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_GROUP, groups),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IBL_BACKGROUND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IBL_BACKGROUND_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IBL_BACKGROUND, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IBL_BACKGROUND, class_version),
    0,0,0, 90 },
  { "enable",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_IBL_BACKGROUND, enable),
    0,0,0, 290 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_IBL_BACKGROUND, name),
    1,1,1, 1 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_IBL_BACKGROUND, rotation),
    0,0,0, 40 },
  { "display_image",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_IBL_BACKGROUND, display_image),
    0,0,0, 290 },
  { "secondary_background",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_IBL_BACKGROUND, secondary_background),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IDBUFFER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IDBUFFER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IDBUFFER, parent),
    1,1,0, 0 },
  { "unknown",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_IDBUFFER, unknown),
    0,0,0, 0 },
  { "num_obj_ids",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IDBUFFER, num_obj_ids),
    0,0,0, 0 },
  { "obj_ids",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_IDBUFFER, obj_ids),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IMAGEDEF: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IMAGEDEF_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IMAGEDEF, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IMAGEDEF, class_version),
    0,0,0, 90 },
  { "image_size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_IMAGEDEF, image_size),
    1,0,0, 10 },
  { "file_path",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_IMAGEDEF, file_path),
    1,1,1, 1 },
  { "is_loaded",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_IMAGEDEF, is_loaded),
    0,0,0, 280 },
  { "resunits",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_IMAGEDEF, resunits),
    0,0,0, 281 },
  { "pixel_size",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_IMAGEDEF, pixel_size),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IMAGEDEF_REACTOR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IMAGEDEF_REACTOR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IMAGEDEF_REACTOR, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IMAGEDEF_REACTOR, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_IMAGE_BACKGROUND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_IMAGE_BACKGROUND_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_IMAGE_BACKGROUND, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_IMAGE_BACKGROUND, class_version),
    0,0,0, 90 },
  { "filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_IMAGE_BACKGROUND, filename),
    1,1,1, 300 },
  { "fit_to_screen",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_IMAGE_BACKGROUND, fit_to_screen),
    0,0,0, 290 },
  { "maintain_aspect_ratio",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_IMAGE_BACKGROUND, maintain_aspect_ratio),
    0,0,0, 291 },
  { "use_tiling",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_IMAGE_BACKGROUND, use_tiling),
    0,0,0, 292 },
  { "offset",	"2BD_1", sizeof (BITCODE_2BD),  OFF (struct _dwg_object_IMAGE_BACKGROUND, offset),
    1,0,0, 140 },
  { "scale",	"2BD_1", sizeof (BITCODE_2BD),  OFF (struct _dwg_object_IMAGE_BACKGROUND, scale),
    1,0,0, 142 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_INDEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_INDEX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_INDEX, parent),
    1,1,0, 0 },
  { "last_updated",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_object_INDEX, last_updated),
    1,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYER, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYER, flag),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LAYER, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_LAYER, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYER, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, xref),
    1,0,0, 0 },
  { "frozen",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, frozen),
    0,0,0, 0 },
  { "on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, on),
    0,0,0, 0 },
  { "frozen_in_new",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, frozen_in_new),
    0,0,0, 0 },
  { "locked",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, locked),
    0,0,0, 0 },
  { "plotflag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LAYER, plotflag),
    0,0,0, 290 },
  { "linewt",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LAYER, linewt),
    0,0,0, 370 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_LAYER, color),
    0,0,0, 62 },
  { "color_rs",	"short", sizeof (short),  OFF (struct _dwg_object_LAYER, color_rs),
    0,0,0, 62 },
  { "ltype_rs",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_LAYER, ltype_rs),
    0,0,0, 7 },
  { "plotstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, plotstyle),
    1,0,0, 390 },
  { "material",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, material),
    1,0,0, 347 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, ltype),
    1,0,0, 6 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYER, visualstyle),
    1,0,0, 348 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYERFILTER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYERFILTER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYERFILTER, parent),
    1,1,0, 0 },
  { "num_names",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYERFILTER, num_names),
    0,0,0, 0 },
  { "names",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_object_LAYERFILTER, names),
    1,1,0, 8 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYER_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYER_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYER_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LAYER_CONTROL, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYER_INDEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_INDEX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYER_INDEX, parent),
    1,1,0, 0 },
  { "last_updated",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_object_LAYER_INDEX, last_updated),
    1,0,0, 40 },
  { "num_entries",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYER_INDEX, num_entries),
    0,0,0, 0 },
  { "entries",	"Dwg_LAYER_entry*", sizeof (Dwg_LAYER_entry*),  OFF (struct _dwg_object_LAYER_INDEX, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYOUT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYOUT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYOUT, parent),
    1,1,0, 0 },
  { "plotsettings",	"Dwg_Object_PLOTSETTINGS", sizeof (Dwg_Object_PLOTSETTINGS),  OFF (struct _dwg_object_LAYOUT, plotsettings),
    0,0,0, 0 },
  { "layout_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_LAYOUT, layout_name),
    1,1,1, 1 },
  { "tab_order",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, tab_order),
    0,0,0, 71 },
  { "layout_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, layout_flags),
    0,0,0, 70 },
  { "INSBASE",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, INSBASE),
    1,0,0, 12 },
  { "LIMMIN",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_object_LAYOUT, LIMMIN),
    1,0,0, 10 },
  { "LIMMAX",	"2DPOINT", sizeof (BITCODE_2DPOINT),  OFF (struct _dwg_object_LAYOUT, LIMMAX),
    1,0,0, 11 },
  { "UCSORG",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, UCSORG),
    1,0,0, 13 },
  { "UCSXDIR",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, UCSXDIR),
    1,0,0, 16 },
  { "UCSYDIR",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, UCSYDIR),
    1,0,0, 17 },
  { "ucs_elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LAYOUT, ucs_elevation),
    0,0,0, 146 },
  { "UCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUT, UCSORTHOVIEW),
    0,0,0, 76 },
  { "EXTMIN",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, EXTMIN),
    1,0,0, 14 },
  { "EXTMAX",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LAYOUT, EXTMAX),
    1,0,0, 15 },
  { "block_header",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, block_header),
    1,0,0, 330 },
  { "active_viewport",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, active_viewport),
    1,0,0, 331 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, base_ucs),
    1,0,0, 346 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LAYOUT, named_ucs),
    1,0,0, 345 },
  { "num_viewports",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LAYOUT, num_viewports),
    0,0,0, 0 },
  { "viewports",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LAYOUT, viewports),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LAYOUTPRINTCONFIG: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYOUTPRINTCONFIG_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LAYOUTPRINTCONFIG, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUTPRINTCONFIG, class_version),
    0,0,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LAYOUTPRINTCONFIG, flag),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LEADEROBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADEROBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, num_points),
    0,0,0, 70 },
  { "points",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, points),
    1,1,0, 10 },
  { "b290",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, b290),
    0,0,0, 290 },
  { "x_direction",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, x_direction),
    1,0,0, 11 },
  { "inspt_offset",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, inspt_offset),
    1,0,0, 12 },
  { "endptproj",	"3DPOINT", sizeof (BITCODE_3DPOINT),  OFF (struct _dwg_object_LEADEROBJECTCONTEXTDATA, endptproj),
    1,0,0, 13 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LIGHTLIST: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LIGHTLIST_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LIGHTLIST, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LIGHTLIST, class_version),
    0,0,0, 90 },
  { "num_lights",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_LIGHTLIST, num_lights),
    0,0,0, 90 },
  { "lights",	"Dwg_LIGHTLIST_light*", sizeof (Dwg_LIGHTLIST_light*),  OFF (struct _dwg_object_LIGHTLIST, lights),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LONG_TRANSACTION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LONG_TRANSACTION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LONG_TRANSACTION, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LTYPE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LTYPE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LTYPE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LTYPE, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LTYPE, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_LTYPE, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LTYPE, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LTYPE, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LTYPE, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LTYPE, xref),
    1,0,0, 0 },
  { "description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_LTYPE, description),
    1,1,1, 3 },
  { "pattern_len",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_LTYPE, pattern_len),
    0,0,0, 40 },
  { "alignment",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LTYPE, alignment),
    0,0,0, 72 },
  { "num_dashes",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_LTYPE, num_dashes),
    0,0,0, 73 },
  { "dashes",	"Dwg_LTYPE_dash*", sizeof (Dwg_LTYPE_dash*),  OFF (struct _dwg_object_LTYPE, dashes),
    1,1,0, 0 },
  { "dashes_r11",	"RD*", sizeof (BITCODE_RD*),  OFF (struct _dwg_object_LTYPE, dashes_r11),
    1,1,0, 0 },
  { "has_strings_area",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_LTYPE, has_strings_area),
    0,0,0, 0 },
  { "strings_area",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_LTYPE, strings_area),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_LTYPE_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LTYPE_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_LTYPE_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_LTYPE_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_LTYPE_CONTROL, entries),
    1,1,0, 0 },
  { "bylayer",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LTYPE_CONTROL, bylayer),
    1,0,0, 0 },
  { "byblock",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_LTYPE_CONTROL, byblock),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MATERIAL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MATERIAL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MATERIAL, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, name),
    1,1,1, 1 },
  { "description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, description),
    1,1,1, 2 },
  { "ambient_color",	"Dwg_MATERIAL_color", sizeof (Dwg_MATERIAL_color),  OFF (struct _dwg_object_MATERIAL, ambient_color),
    0,0,0, 0 },
  { "diffuse_color",	"Dwg_MATERIAL_color", sizeof (Dwg_MATERIAL_color),  OFF (struct _dwg_object_MATERIAL, diffuse_color),
    0,0,0, 0 },
  { "diffusemap",	"Dwg_MATERIAL_mapper", sizeof (Dwg_MATERIAL_mapper),  OFF (struct _dwg_object_MATERIAL, diffusemap),
    0,0,0, 0 },
  { "specular_gloss_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, specular_gloss_factor),
    0,0,0, 44 },
  { "specular_color",	"Dwg_MATERIAL_color", sizeof (Dwg_MATERIAL_color),  OFF (struct _dwg_object_MATERIAL, specular_color),
    0,0,0, 0 },
  { "specularmap",	"Dwg_MATERIAL_mapper", sizeof (Dwg_MATERIAL_mapper),  OFF (struct _dwg_object_MATERIAL, specularmap),
    0,0,0, 0 },
  { "reflectionmap",	"Dwg_MATERIAL_mapper", sizeof (Dwg_MATERIAL_mapper),  OFF (struct _dwg_object_MATERIAL, reflectionmap),
    0,0,0, 0 },
  { "opacity_percent",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, opacity_percent),
    0,0,0, 140 },
  { "opacitymap",	"Dwg_MATERIAL_mapper", sizeof (Dwg_MATERIAL_mapper),  OFF (struct _dwg_object_MATERIAL, opacitymap),
    0,0,0, 0 },
  { "bumpmap",	"Dwg_MATERIAL_mapper", sizeof (Dwg_MATERIAL_mapper),  OFF (struct _dwg_object_MATERIAL, bumpmap),
    0,0,0, 0 },
  { "refraction_index",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, refraction_index),
    0,0,0, 145 },
  { "refractionmap",	"Dwg_MATERIAL_mapper", sizeof (Dwg_MATERIAL_mapper),  OFF (struct _dwg_object_MATERIAL, refractionmap),
    0,0,0, 0 },
  { "color_bleed_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, color_bleed_scale),
    0,0,0, 460 },
  { "indirect_bump_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, indirect_bump_scale),
    0,0,0, 461 },
  { "reflectance_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, reflectance_scale),
    0,0,0, 462 },
  { "transmittance_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, transmittance_scale),
    0,0,0, 463 },
  { "two_sided_material",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MATERIAL, two_sided_material),
    0,0,0, 290 },
  { "luminance",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, luminance),
    0,0,0, 464 },
  { "luminance_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, luminance_mode),
    0,0,0, 270 },
  { "translucence",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, translucence),
    0,0,0, 148 },
  { "self_illumination",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, self_illumination),
    0,0,0, 149 },
  { "reflectivity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, reflectivity),
    0,0,0, 468 },
  { "illumination_model",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MATERIAL, illumination_model),
    0,0,0, 93 },
  { "channel_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MATERIAL, channel_flags),
    0,0,0, 94 },
  { "mode",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MATERIAL, mode),
    0,0,0, 282 },
  { "genprocname",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, genprocname),
    1,1,1, 0 },
  { "genproctype",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, genproctype),
    0,0,0, 0 },
  { "genprocvalbool",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MATERIAL, genprocvalbool),
    0,0,0, 0 },
  { "genprocvalint",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, genprocvalint),
    0,0,0, 0 },
  { "genprocvalreal",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MATERIAL, genprocvalreal),
    0,0,0, 0 },
  { "genprocvaltext",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MATERIAL, genprocvaltext),
    1,1,1, 0 },
  { "genprocvalcolor",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MATERIAL, genprocvalcolor),
    0,0,0, 0 },
  { "genproctableend",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MATERIAL, genproctableend),
    0,0,0, 0 },
  { "num_gentextures",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MATERIAL, num_gentextures),
    0,0,0, 0 },
  { "gentextures",	"Dwg_MATERIAL_gentexture*", sizeof (Dwg_MATERIAL_gentexture*),  OFF (struct _dwg_object_MATERIAL, gentextures),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MENTALRAYRENDERSETTINGS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MENTALRAYRENDERSETTINGS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, class_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, name),
    1,1,1, 1 },
  { "fog_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fog_enabled),
    0,0,0, 290 },
  { "fog_background_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fog_background_enabled),
    0,0,0, 290 },
  { "backfaces_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, backfaces_enabled),
    0,0,0, 290 },
  { "environ_image_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, environ_image_enabled),
    0,0,0, 290 },
  { "environ_image_filename",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, environ_image_filename),
    1,1,1, 1 },
  { "description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, description),
    1,1,1, 1 },
  { "display_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, display_index),
    0,0,0, 90 },
  { "has_predefined",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, has_predefined),
    0,0,0, 290 },
  { "mr_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, mr_version),
    0,0,0, 90 },
  { "sampling1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling1),
    0,0,0, 90 },
  { "sampling2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling2),
    0,0,0, 90 },
  { "sampling_mr_filter",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling_mr_filter),
    0,0,0, 70 },
  { "sampling_filter1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling_filter1),
    0,0,0, 40 },
  { "sampling_filter2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling_filter2),
    0,0,0, 40 },
  { "sampling_contrast_color1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling_contrast_color1),
    0,0,0, 40 },
  { "sampling_contrast_color2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling_contrast_color2),
    0,0,0, 40 },
  { "sampling_contrast_color3",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling_contrast_color3),
    0,0,0, 40 },
  { "sampling_contrast_color4",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, sampling_contrast_color4),
    0,0,0, 40 },
  { "shadow_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, shadow_mode),
    0,0,0, 70 },
  { "shadow_maps_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, shadow_maps_enabled),
    0,0,0, 290 },
  { "ray_tracing_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, ray_tracing_enabled),
    0,0,0, 290 },
  { "ray_trace_depth1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, ray_trace_depth1),
    0,0,0, 90 },
  { "ray_trace_depth2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, ray_trace_depth2),
    0,0,0, 90 },
  { "ray_trace_depth3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, ray_trace_depth3),
    0,0,0, 90 },
  { "global_illumination_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, global_illumination_enabled),
    0,0,0, 290 },
  { "gi_sample_count",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, gi_sample_count),
    0,0,0, 90 },
  { "gi_sample_radius_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, gi_sample_radius_enabled),
    0,0,0, 290 },
  { "gi_sample_radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, gi_sample_radius),
    0,0,0, 40 },
  { "gi_photons_per_light",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, gi_photons_per_light),
    0,0,0, 90 },
  { "photon_trace_depth1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, photon_trace_depth1),
    0,0,0, 90 },
  { "photon_trace_depth2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, photon_trace_depth2),
    0,0,0, 90 },
  { "photon_trace_depth3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, photon_trace_depth3),
    0,0,0, 90 },
  { "final_gathering_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, final_gathering_enabled),
    0,0,0, 290 },
  { "fg_ray_count",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fg_ray_count),
    0,0,0, 90 },
  { "fg_sample_radius_state1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fg_sample_radius_state1),
    0,0,0, 290 },
  { "fg_sample_radius_state2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fg_sample_radius_state2),
    0,0,0, 290 },
  { "fg_sample_radius_state3",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fg_sample_radius_state3),
    0,0,0, 290 },
  { "fg_sample_radius1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fg_sample_radius1),
    0,0,0, 40 },
  { "fg_sample_radius2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, fg_sample_radius2),
    0,0,0, 40 },
  { "light_luminance_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, light_luminance_scale),
    0,0,0, 40 },
  { "diagnostics_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, diagnostics_mode),
    0,0,0, 70 },
  { "diagnostics_grid_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, diagnostics_grid_mode),
    0,0,0, 70 },
  { "diagnostics_grid_float",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, diagnostics_grid_float),
    0,0,0, 40 },
  { "diagnostics_photon_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, diagnostics_photon_mode),
    0,0,0, 70 },
  { "diagnostics_bsp_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, diagnostics_bsp_mode),
    0,0,0, 70 },
  { "export_mi_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, export_mi_enabled),
    0,0,0, 290 },
  { "mr_description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, mr_description),
    1,1,1, 1 },
  { "tile_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, tile_size),
    0,0,0, 90 },
  { "tile_order",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, tile_order),
    0,0,0, 70 },
  { "memory_limit",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, memory_limit),
    0,0,0, 90 },
  { "diagnostics_samples_mode",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, diagnostics_samples_mode),
    0,0,0, 290 },
  { "energy_multiplier",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MENTALRAYRENDERSETTINGS, energy_multiplier),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MLEADEROBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADEROBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MLEADEROBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADEROBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADEROBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADEROBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MLEADERSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADERSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MLEADERSTYLE, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, class_version),
    0,0,0, 179 },
  { "content_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, content_type),
    0,0,0, 170 },
  { "mleader_order",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, mleader_order),
    0,0,0, 171 },
  { "leader_order",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, leader_order),
    0,0,0, 172 },
  { "max_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MLEADERSTYLE, max_points),
    0,0,0, 90 },
  { "first_seg_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, first_seg_angle),
    0,0,0, 40 },
  { "second_seg_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, second_seg_angle),
    0,0,0, 41 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, type),
    0,0,0, 173 },
  { "line_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLEADERSTYLE, line_color),
    0,0,0, 91 },
  { "line_type",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, line_type),
    1,0,0, 340 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_MLEADERSTYLE, linewt),
    0,0,0, 92 },
  { "has_landing",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, has_landing),
    0,0,0, 290 },
  { "has_dogleg",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, has_dogleg),
    0,0,0, 291 },
  { "landing_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, landing_gap),
    0,0,0, 42 },
  { "landing_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, landing_dist),
    0,0,0, 43 },
  { "description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLEADERSTYLE, description),
    1,1,1, 3 },
  { "arrow_head",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, arrow_head),
    1,0,0, 341 },
  { "arrow_head_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, arrow_head_size),
    0,0,0, 44 },
  { "text_default",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLEADERSTYLE, text_default),
    1,1,1, 300 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, text_style),
    1,0,0, 342 },
  { "attach_left",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_left),
    0,0,0, 174 },
  { "attach_right",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_right),
    0,0,0, 178 },
  { "text_angle_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, text_angle_type),
    0,0,0, 175 },
  { "text_align_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, text_align_type),
    0,0,0, 176 },
  { "text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLEADERSTYLE, text_color),
    0,0,0, 93 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, text_height),
    0,0,0, 45 },
  { "has_text_frame",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, has_text_frame),
    0,0,0, 292 },
  { "text_always_left",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, text_always_left),
    0,0,0, 297 },
  { "align_space",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, align_space),
    0,0,0, 46 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MLEADERSTYLE, block),
    1,0,0, 343 },
  { "block_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLEADERSTYLE, block_color),
    0,0,0, 94 },
  { "block_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_MLEADERSTYLE, block_scale),
    1,0,0, 0 },
  { "use_block_scale",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, use_block_scale),
    0,0,0, 293 },
  { "block_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, block_rotation),
    0,0,0, 141 },
  { "use_block_rotation",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, use_block_rotation),
    0,0,0, 294 },
  { "block_connection",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, block_connection),
    0,0,0, 177 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, scale),
    0,0,0, 142 },
  { "is_changed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, is_changed),
    0,0,0, 295 },
  { "is_annotative",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, is_annotative),
    0,0,0, 296 },
  { "break_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLEADERSTYLE, break_size),
    0,0,0, 143 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_dir),
    0,0,0, 271 },
  { "attach_top",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_top),
    0,0,0, 273 },
  { "attach_bottom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLEADERSTYLE, attach_bottom),
    0,0,0, 272 },
  { "text_extended",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MLEADERSTYLE, text_extended),
    0,0,0, 298 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MLINESTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINESTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MLINESTYLE, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLINESTYLE, name),
    1,1,1, 2 },
  { "description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_MLINESTYLE, description),
    1,1,1, 3 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MLINESTYLE, flag),
    0,0,0, 70 },
  { "fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_MLINESTYLE, fill_color),
    0,0,0, 62 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLINESTYLE, start_angle),
    0,0,0, 51 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MLINESTYLE, end_angle),
    0,0,0, 52 },
  { "num_lines",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_MLINESTYLE, num_lines),
    0,0,0, 71 },
  { "lines",	"Dwg_MLINESTYLE_line*", sizeof (Dwg_MLINESTYLE_line*),  OFF (struct _dwg_object_MLINESTYLE, lines),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MOTIONPATH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MOTIONPATH_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MOTIONPATH, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MOTIONPATH, class_version),
    0,0,0, 90 },
  { "camera_path",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MOTIONPATH, camera_path),
    1,0,0, 340 },
  { "target_path",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MOTIONPATH, target_path),
    1,0,0, 340 },
  { "viewtable",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MOTIONPATH, viewtable),
    1,0,0, 340 },
  { "frames",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MOTIONPATH, frames),
    0,0,0, 90 },
  { "frame_rate",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MOTIONPATH, frame_rate),
    0,0,0, 90 },
  { "corner_decel",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MOTIONPATH, corner_decel),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MTEXTATTRIBUTEOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "horizontal_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, horizontal_mode),
    0,0,0, 70 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, rotation),
    0,0,0, 50 },
  { "ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, ins_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, alignment_pt),
    1,0,0, 11 },
  { "enable_context",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, enable_context),
    0,0,0, 290 },
  { "context",	"struct _dwg_object*", sizeof (void *),  OFF (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA, context),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_MTEXTOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MTEXTOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "attachment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, attachment),
    0,0,0, 70 },
  { "ins_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, ins_pt),
    1,0,0, 10 },
  { "x_axis_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, x_axis_dir),
    1,0,0, 11 },
  { "rect_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, rect_height),
    0,0,0, 41 },
  { "rect_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, rect_width),
    0,0,0, 40 },
  { "extents_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, extents_width),
    0,0,0, 42 },
  { "extents_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, extents_height),
    0,0,0, 43 },
  { "column_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, column_type),
    0,0,0, 71 },
  { "column_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, column_width),
    0,0,0, 44 },
  { "gutter",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, gutter),
    0,0,0, 45 },
  { "auto_height",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, auto_height),
    0,0,0, 73 },
  { "flow_reversed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, flow_reversed),
    0,0,0, 74 },
  { "num_column_heights",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, num_column_heights),
    0,0,0, 72 },
  { "column_heights",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_MTEXTOBJECTCONTEXTDATA, column_heights),
    1,1,0, 46 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_NAVISWORKSMODELDEF: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_NAVISWORKSMODELDEF_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, parent),
    1,1,0, 0 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, flags),
    0,0,0, 70 },
  { "path",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, path),
    1,1,1, 1 },
  { "status",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, status),
    0,0,0, 290 },
  { "min_extent",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, min_extent),
    1,0,0, 10 },
  { "max_extent",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, max_extent),
    1,0,0, 11 },
  { "host_drawing_visibility",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_NAVISWORKSMODELDEF, host_drawing_visibility),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_OBJECT_PTR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OBJECT_PTR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_OBJECT_PTR, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_ORDDIMOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ORDDIMOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "dimension",	"Dwg_OCD_Dimension", sizeof (Dwg_OCD_Dimension),  OFF (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA, dimension),
    0,0,0, 0 },
  { "feature_location_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA, feature_location_pt),
    1,0,0, 11 },
  { "leader_endpt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA, leader_endpt),
    1,0,0, 12 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PARTIAL_VIEWING_INDEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PARTIAL_VIEWING_INDEX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PARTIAL_VIEWING_INDEX, parent),
    1,1,0, 0 },
  { "num_entries",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PARTIAL_VIEWING_INDEX, num_entries),
    0,0,0, 0 },
  { "has_entries",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_PARTIAL_VIEWING_INDEX, has_entries),
    0,0,0, 0 },
  { "entries",	"Dwg_PARTIAL_VIEWING_INDEX_Entry*", sizeof (Dwg_PARTIAL_VIEWING_INDEX_Entry*),  OFF (struct _dwg_object_PARTIAL_VIEWING_INDEX, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PERSUBENTMGR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PERSUBENTMGR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PERSUBENTMGR, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSUBENTMGR, class_version),
    0,0,0, 90 },
  { "unknown_0",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSUBENTMGR, unknown_0),
    0,0,0, 90 },
  { "unknown_2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSUBENTMGR, unknown_2),
    0,0,0, 90 },
  { "numassocsteps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSUBENTMGR, numassocsteps),
    0,0,0, 90 },
  { "numassocsubents",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSUBENTMGR, numassocsubents),
    0,0,0, 90 },
  { "num_steps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSUBENTMGR, num_steps),
    0,0,0, 90 },
  { "steps",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_PERSUBENTMGR, steps),
    1,1,0, 90 },
  { "num_subents",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PERSUBENTMGR, num_subents),
    0,0,0, 90 },
  { "subents",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_object_PERSUBENTMGR, subents),
    1,1,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PLACEHOLDER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PLACEHOLDER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PLACEHOLDER, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PLOTSETTINGS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PLOTSETTINGS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PLOTSETTINGS, parent),
    1,1,0, 0 },
  { "printer_cfg_file",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, printer_cfg_file),
    1,1,1, 1 },
  { "paper_size",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, paper_size),
    1,1,1, 2 },
  { "canonical_media_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, canonical_media_name),
    1,1,1, 4 },
  { "plot_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_flags),
    0,0,0, 70 },
  { "plotview",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_PLOTSETTINGS, plotview),
    1,0,0, 6 },
  { "plotview_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, plotview_name),
    1,1,1, 6 },
  { "left_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, left_margin),
    0,0,0, 40 },
  { "bottom_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, bottom_margin),
    0,0,0, 41 },
  { "right_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, right_margin),
    0,0,0, 42 },
  { "top_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, top_margin),
    0,0,0, 43 },
  { "paper_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, paper_width),
    0,0,0, 44 },
  { "paper_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, paper_height),
    0,0,0, 45 },
  { "plot_origin",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, plot_origin),
    1,0,0, 46 },
  { "plot_window_ll",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, plot_window_ll),
    1,0,0, 48 },
  { "plot_window_ur",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, plot_window_ur),
    1,0,0, 140 },
  { "plot_paper_unit",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_paper_unit),
    0,0,0, 72 },
  { "plot_rotation_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_rotation_mode),
    0,0,0, 73 },
  { "plot_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, plot_type),
    0,0,0, 74 },
  { "paper_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, paper_units),
    0,0,0, 142 },
  { "drawing_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, drawing_units),
    0,0,0, 143 },
  { "stylesheet",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_PLOTSETTINGS, stylesheet),
    1,1,1, 7 },
  { "std_scale_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, std_scale_type),
    0,0,0, 75 },
  { "std_scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_PLOTSETTINGS, std_scale_factor),
    0,0,0, 147 },
  { "paper_image_origin",	"2BD_1", sizeof (BITCODE_2BD_1),  OFF (struct _dwg_object_PLOTSETTINGS, paper_image_origin),
    1,0,0, 148 },
  { "shadeplot_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, shadeplot_type),
    0,0,0, 76 },
  { "shadeplot_reslevel",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, shadeplot_reslevel),
    0,0,0, 77 },
  { "shadeplot_customdpi",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_PLOTSETTINGS, shadeplot_customdpi),
    0,0,0, 78 },
  { "shadeplot",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_PLOTSETTINGS, shadeplot),
    1,0,0, 333 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_POINTCLOUDCOLORMAP: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDCOLORMAP_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, class_version),
    0,0,0, 70 },
  { "def_intensity_colorscheme",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, def_intensity_colorscheme),
    1,1,1, 1 },
  { "def_elevation_colorscheme",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, def_elevation_colorscheme),
    1,1,1, 1 },
  { "def_classification_colorscheme",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, def_classification_colorscheme),
    1,1,1, 1 },
  { "num_colorramps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, num_colorramps),
    0,0,0, 90 },
  { "colorramps",	"Dwg_POINTCLOUDCOLORMAP_Ramp*", sizeof (Dwg_POINTCLOUDCOLORMAP_Ramp*),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, colorramps),
    1,1,0, 0 },
  { "num_classification_colorramps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, num_classification_colorramps),
    0,0,0, 90 },
  { "classification_colorramps",	"Dwg_POINTCLOUDCOLORMAP_Ramp*", sizeof (Dwg_POINTCLOUDCOLORMAP_Ramp*),  OFF (struct _dwg_object_POINTCLOUDCOLORMAP, classification_colorramps),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_POINTCLOUDDEF: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDDEF_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_POINTCLOUDDEF, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_POINTCLOUDDEF, class_version),
    0,0,0, 90 },
  { "source_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_POINTCLOUDDEF, source_filename),
    1,1,1, 1 },
  { "is_loaded",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_POINTCLOUDDEF, is_loaded),
    0,0,0, 280 },
  { "numpoints",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_object_POINTCLOUDDEF, numpoints),
    0,0,0, 160 },
  { "extents_min",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_POINTCLOUDDEF, extents_min),
    1,0,0, 10 },
  { "extents_max",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_POINTCLOUDDEF, extents_max),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_POINTCLOUDDEFEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDDEFEX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_POINTCLOUDDEFEX, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_POINTCLOUDDEFEX, class_version),
    0,0,0, 90 },
  { "source_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_POINTCLOUDDEFEX, source_filename),
    1,1,1, 1 },
  { "is_loaded",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_POINTCLOUDDEFEX, is_loaded),
    0,0,0, 280 },
  { "numpoints",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_object_POINTCLOUDDEFEX, numpoints),
    0,0,0, 160 },
  { "extents_min",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_POINTCLOUDDEFEX, extents_min),
    1,0,0, 10 },
  { "extents_max",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_POINTCLOUDDEFEX, extents_max),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_POINTCLOUDDEF_REACTOR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDDEF_REACTOR_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_POINTCLOUDDEF_REACTOR, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_POINTCLOUDDEF_REACTOR, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_POINTCLOUDDEF_REACTOR_EX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDDEF_REACTOR_EX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_POINTCLOUDDEF_REACTOR_EX, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_POINTCLOUDDEF_REACTOR_EX, class_version),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_POINTPATH: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTPATH_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_POINTPATH, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_POINTPATH, class_version),
    0,0,0, 90 },
  { "point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_POINTPATH, point),
    1,0,0, 10 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_PROXY_OBJECT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PROXY_OBJECT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_PROXY_OBJECT, parent),
    1,1,0, 0 },
  { "class_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, class_id),
    0,0,0, 91 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, version),
    0,0,0, 71 },
  { "maint_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, maint_version),
    0,0,0, 97 },
  { "from_dxf",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_PROXY_OBJECT, from_dxf),
    0,0,0, 70 },
  { "data_numbits",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, data_numbits),
    0,0,0, 0 },
  { "data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, data_size),
    0,0,0, 93 },
  { "data",	"TF", sizeof (BITCODE_RC*),  OFF (struct _dwg_object_PROXY_OBJECT, data),
    1,1,0, 310 },
  { "num_objids",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_PROXY_OBJECT, num_objids),
    0,0,0, 0 },
  { "objids",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_PROXY_OBJECT, objids),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RADIMLGOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RADIMLGOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "dimension",	"Dwg_OCD_Dimension", sizeof (Dwg_OCD_Dimension),  OFF (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA, dimension),
    0,0,0, 0 },
  { "ovr_center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA, ovr_center),
    1,0,0, 12 },
  { "jog_point",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA, jog_point),
    1,0,0, 13 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RADIMOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RADIMOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RADIMOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RADIMOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RADIMOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_RADIMOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "dimension",	"Dwg_OCD_Dimension", sizeof (Dwg_OCD_Dimension),  OFF (struct _dwg_object_RADIMOBJECTCONTEXTDATA, dimension),
    0,0,0, 0 },
  { "first_arc_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_RADIMOBJECTCONTEXTDATA, first_arc_pt),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RAPIDRTRENDERSETTINGS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RAPIDRTRENDERSETTINGS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, class_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, name),
    1,1,1, 1 },
  { "fog_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, fog_enabled),
    0,0,0, 290 },
  { "fog_background_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, fog_background_enabled),
    0,0,0, 290 },
  { "backfaces_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, backfaces_enabled),
    0,0,0, 290 },
  { "environ_image_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, environ_image_enabled),
    0,0,0, 290 },
  { "environ_image_filename",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, environ_image_filename),
    1,1,1, 1 },
  { "description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, description),
    1,1,1, 1 },
  { "display_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, display_index),
    0,0,0, 90 },
  { "has_predefined",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, has_predefined),
    0,0,0, 290 },
  { "rapidrt_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, rapidrt_version),
    0,0,0, 90 },
  { "render_target",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, render_target),
    0,0,0, 70 },
  { "render_level",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, render_level),
    0,0,0, 90 },
  { "render_time",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, render_time),
    0,0,0, 90 },
  { "lighting_model",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, lighting_model),
    0,0,0, 70 },
  { "filter_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, filter_type),
    0,0,0, 70 },
  { "filter_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, filter_width),
    0,0,0, 40 },
  { "filter_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RAPIDRTRENDERSETTINGS, filter_height),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RASTERVARIABLES: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RASTERVARIABLES_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RASTERVARIABLES, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RASTERVARIABLES, class_version),
    0,0,0, 90 },
  { "image_frame",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RASTERVARIABLES, image_frame),
    0,0,0, 70 },
  { "image_quality",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RASTERVARIABLES, image_quality),
    0,0,0, 71 },
  { "units",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RASTERVARIABLES, units),
    0,0,0, 72 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RENDERENTRY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RENDERENTRY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RENDERENTRY, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, class_version),
    0,0,0, 90 },
  { "image_file_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_RENDERENTRY, image_file_name),
    1,1,1, 1 },
  { "preset_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_RENDERENTRY, preset_name),
    1,1,1, 1 },
  { "view_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_RENDERENTRY, view_name),
    1,1,1, 1 },
  { "dimension_x",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, dimension_x),
    0,0,0, 90 },
  { "dimension_y",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, dimension_y),
    0,0,0, 90 },
  { "start_year",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RENDERENTRY, start_year),
    0,0,0, 70 },
  { "start_month",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RENDERENTRY, start_month),
    0,0,0, 70 },
  { "start_day",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RENDERENTRY, start_day),
    0,0,0, 70 },
  { "start_minute",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RENDERENTRY, start_minute),
    0,0,0, 70 },
  { "start_second",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RENDERENTRY, start_second),
    0,0,0, 70 },
  { "start_msec",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_RENDERENTRY, start_msec),
    0,0,0, 70 },
  { "render_time",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENTRY, render_time),
    0,0,0, 40 },
  { "memory_amount",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, memory_amount),
    0,0,0, 90 },
  { "material_count",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, material_count),
    0,0,0, 90 },
  { "light_count",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, light_count),
    0,0,0, 90 },
  { "triangle_count",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, triangle_count),
    0,0,0, 90 },
  { "display_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENTRY, display_index),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RENDERENVIRONMENT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RENDERENVIRONMENT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RENDERENVIRONMENT, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERENVIRONMENT, class_version),
    0,0,0, 90 },
  { "fog_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_enabled),
    0,0,0, 290 },
  { "fog_background_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_background_enabled),
    0,0,0, 290 },
  { "fog_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_color),
    0,0,0, 280 },
  { "fog_density_near",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_density_near),
    0,0,0, 40 },
  { "fog_density_far",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_density_far),
    0,0,0, 40 },
  { "fog_distance_near",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_distance_near),
    0,0,0, 40 },
  { "fog_distance_far",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_RENDERENVIRONMENT, fog_distance_far),
    0,0,0, 40 },
  { "environ_image_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERENVIRONMENT, environ_image_enabled),
    0,0,0, 290 },
  { "environ_image_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_RENDERENVIRONMENT, environ_image_filename),
    1,1,1, 1 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RENDERGLOBAL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RENDERGLOBAL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RENDERGLOBAL, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, class_version),
    0,0,0, 90 },
  { "procedure",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, procedure),
    0,0,0, 90 },
  { "destination",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, destination),
    0,0,0, 90 },
  { "save_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERGLOBAL, save_enabled),
    0,0,0, 290 },
  { "save_filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_RENDERGLOBAL, save_filename),
    1,1,1, 1 },
  { "image_width",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, image_width),
    0,0,0, 90 },
  { "image_height",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERGLOBAL, image_height),
    0,0,0, 90 },
  { "predef_presets_first",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERGLOBAL, predef_presets_first),
    0,0,0, 290 },
  { "highlevel_info",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERGLOBAL, highlevel_info),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_RENDERSETTINGS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_RENDERSETTINGS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_RENDERSETTINGS, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERSETTINGS, class_version),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_RENDERSETTINGS, name),
    1,1,1, 1 },
  { "fog_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERSETTINGS, fog_enabled),
    0,0,0, 290 },
  { "fog_background_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERSETTINGS, fog_background_enabled),
    0,0,0, 290 },
  { "backfaces_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERSETTINGS, backfaces_enabled),
    0,0,0, 290 },
  { "environ_image_enabled",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERSETTINGS, environ_image_enabled),
    0,0,0, 290 },
  { "environ_image_filename",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_RENDERSETTINGS, environ_image_filename),
    1,1,1, 1 },
  { "description",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_RENDERSETTINGS, description),
    1,1,1, 1 },
  { "display_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_RENDERSETTINGS, display_index),
    0,0,0, 90 },
  { "has_predefined",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_RENDERSETTINGS, has_predefined),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SCALE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SCALE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SCALE, parent),
    1,1,0, 0 },
  { "flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SCALE, flag),
    0,0,0, 70 },
  { "name",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_SCALE, name),
    1,1,1, 300 },
  { "paper_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SCALE, paper_units),
    0,0,0, 140 },
  { "drawing_units",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SCALE, drawing_units),
    0,0,0, 141 },
  { "is_unit_scale",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SCALE, is_unit_scale),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SECTIONVIEWSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SECTIONVIEWSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, parent),
    1,1,0, 0 },
  { "mdoc_class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, mdoc_class_version),
    0,0,0, 70 },
  { "desc",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, desc),
    1,1,1, 3 },
  { "is_modified_for_recompute",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, is_modified_for_recompute),
    0,0,0, 290 },
  { "display_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, display_name),
    1,1,1, 300 },
  { "viewstyle_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewstyle_flags),
    0,0,0, 90 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, class_version),
    0,0,0, 70 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, flags),
    0,0,0, 90 },
  { "identifier_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, identifier_style),
    1,0,0, 340 },
  { "identifier_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, identifier_color),
    0,0,0, 62 },
  { "identifier_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, identifier_height),
    0,0,0, 40 },
  { "arrow_start_symbol",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, arrow_start_symbol),
    1,0,0, 340 },
  { "arrow_end_symbol",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, arrow_end_symbol),
    1,0,0, 340 },
  { "arrow_symbol_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, arrow_symbol_color),
    0,0,0, 62 },
  { "arrow_symbol_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, arrow_symbol_size),
    0,0,0, 40 },
  { "identifier_exclude_characters",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, identifier_exclude_characters),
    1,1,1, 300 },
  { "identifier_position",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, identifier_position),
    0,0,0, 90 },
  { "identifier_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, identifier_offset),
    0,0,0, 40 },
  { "arrow_position",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, arrow_position),
    0,0,0, 90 },
  { "arrow_symbol_extension_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, arrow_symbol_extension_length),
    0,0,0, 40 },
  { "plane_ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, plane_ltype),
    1,0,0, 340 },
  { "plane_linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, plane_linewt),
    0,0,0, 90 },
  { "plane_line_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, plane_line_color),
    0,0,0, 62 },
  { "bend_ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, bend_ltype),
    1,0,0, 340 },
  { "bend_linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, bend_linewt),
    0,0,0, 90 },
  { "bend_line_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, bend_line_color),
    0,0,0, 62 },
  { "bend_line_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, bend_line_length),
    0,0,0, 40 },
  { "end_line_overshoot",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, end_line_overshoot),
    0,0,0, 40 },
  { "end_line_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, end_line_length),
    0,0,0, 40 },
  { "viewlabel_text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewlabel_text_style),
    1,0,0, 340 },
  { "viewlabel_text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewlabel_text_color),
    0,0,0, 62 },
  { "viewlabel_text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewlabel_text_height),
    0,0,0, 40 },
  { "viewlabel_attachment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewlabel_attachment),
    0,0,0, 90 },
  { "viewlabel_offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewlabel_offset),
    0,0,0, 40 },
  { "viewlabel_alignment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewlabel_alignment),
    0,0,0, 90 },
  { "viewlabel_pattern",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, viewlabel_pattern),
    1,1,1, 300 },
  { "hatch_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, hatch_color),
    0,0,0, 62 },
  { "hatch_bg_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, hatch_bg_color),
    0,0,0, 62 },
  { "hatch_pattern",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, hatch_pattern),
    1,1,1, 300 },
  { "hatch_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, hatch_scale),
    0,0,0, 40 },
  { "hatch_transparency",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, hatch_transparency),
    0,0,0, 90 },
  { "unknown_b1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, unknown_b1),
    0,0,0, 290 },
  { "unknown_b2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, unknown_b2),
    0,0,0, 290 },
  { "num_hatch_angles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, num_hatch_angles),
    0,0,0, 90 },
  { "hatch_angles",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_SECTIONVIEWSTYLE, hatch_angles),
    1,1,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SECTION_MANAGER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SECTION_MANAGER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SECTION_MANAGER, parent),
    1,1,0, 0 },
  { "is_live",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SECTION_MANAGER, is_live),
    0,0,0, 70 },
  { "num_sections",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SECTION_MANAGER, num_sections),
    0,0,0, 90 },
  { "sections",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_SECTION_MANAGER, sections),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SECTION_SETTINGS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SECTION_SETTINGS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SECTION_SETTINGS, parent),
    1,1,0, 0 },
  { "curr_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SECTION_SETTINGS, curr_type),
    0,0,0, 90 },
  { "num_types",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SECTION_SETTINGS, num_types),
    0,0,0, 91 },
  { "types",	"Dwg_SECTION_typesettings*", sizeof (Dwg_SECTION_typesettings*),  OFF (struct _dwg_object_SECTION_SETTINGS, types),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SKYLIGHT_BACKGROUND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SKYLIGHT_BACKGROUND_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SKYLIGHT_BACKGROUND, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SKYLIGHT_BACKGROUND, class_version),
    0,0,0, 90 },
  { "sunid",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SKYLIGHT_BACKGROUND, sunid),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SOLID_BACKGROUND: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SOLID_BACKGROUND_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SOLID_BACKGROUND, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SOLID_BACKGROUND, class_version),
    0,0,0, 90 },
  { "color",	"BLx", sizeof (BITCODE_BLx),  OFF (struct _dwg_object_SOLID_BACKGROUND, color),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SORTENTSTABLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SORTENTSTABLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SORTENTSTABLE, parent),
    1,1,0, 0 },
  { "num_ents",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SORTENTSTABLE, num_ents),
    0,0,0, 0 },
  { "sort_ents",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_SORTENTSTABLE, sort_ents),
    1,1,0, 5 },
  { "block_owner",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SORTENTSTABLE, block_owner),
    1,0,0, 0 },
  { "ents",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_SORTENTSTABLE, ents),
    1,1,0, 331 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SPATIAL_FILTER: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPATIAL_FILTER_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SPATIAL_FILTER, parent),
    1,1,0, 0 },
  { "num_clip_verts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, num_clip_verts),
    0,0,0, 70 },
  { "clip_verts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_object_SPATIAL_FILTER, clip_verts),
    1,1,0, 10 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_object_SPATIAL_FILTER, extrusion),
    0,0,0, 210 },
  { "origin",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_SPATIAL_FILTER, origin),
    1,0,0, 11 },
  { "display_boundary_on",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, display_boundary_on),
    0,0,0, 71 },
  { "front_clip_on",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, front_clip_on),
    0,0,0, 72 },
  { "front_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SPATIAL_FILTER, front_clip_z),
    0,0,0, 40 },
  { "back_clip_on",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SPATIAL_FILTER, back_clip_on),
    0,0,0, 73 },
  { "back_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SPATIAL_FILTER, back_clip_z),
    0,0,0, 41 },
  { "inverse_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_SPATIAL_FILTER, inverse_transform),
    1,1,0, 40 },
  { "transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_object_SPATIAL_FILTER, transform),
    1,1,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SPATIAL_INDEX: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPATIAL_INDEX_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SPATIAL_INDEX, parent),
    1,1,0, 0 },
  { "last_updated",	"TIMEBLL", sizeof (BITCODE_TIMEBLL),  OFF (struct _dwg_object_SPATIAL_INDEX, last_updated),
    1,0,0, 40 },
  { "num1",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SPATIAL_INDEX, num1),
    0,0,0, 40 },
  { "num_hdls",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SPATIAL_INDEX, num_hdls),
    0,0,0, 90 },
  { "hdls",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_SPATIAL_INDEX, hdls),
    1,1,0, 330 },
  { "bindata_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SPATIAL_INDEX, bindata_size),
    0,0,0, 90 },
  { "bindata",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_SPATIAL_INDEX, bindata),
    1,1,0, 310 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_STYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_STYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_STYLE, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_STYLE, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_STYLE, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_STYLE, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_STYLE, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_STYLE, xref),
    1,0,0, 0 },
  { "is_shape",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, is_shape),
    0,0,0, 0 },
  { "is_vertical",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_STYLE, is_vertical),
    0,0,0, 0 },
  { "text_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, text_size),
    0,0,0, 40 },
  { "width_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, width_factor),
    0,0,0, 41 },
  { "oblique_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, oblique_angle),
    0,0,0, 50 },
  { "generation",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_STYLE, generation),
    0,0,0, 71 },
  { "last_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_STYLE, last_height),
    0,0,0, 42 },
  { "font_file",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_STYLE, font_file),
    1,1,1, 3 },
  { "bigfont_file",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_STYLE, bigfont_file),
    1,1,1, 4 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_STYLE_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_STYLE_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_STYLE_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_STYLE_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_STYLE_CONTROL, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SUN: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SUN_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SUN, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUN, class_version),
    0,0,0, 90 },
  { "is_on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUN, is_on),
    0,0,0, 290 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_SUN, color),
    0,0,0, 63 },
  { "intensity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SUN, intensity),
    0,0,0, 40 },
  { "has_shadow",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUN, has_shadow),
    0,0,0, 291 },
  { "julian_day",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUN, julian_day),
    0,0,0, 91 },
  { "msecs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUN, msecs),
    0,0,0, 92 },
  { "is_dst",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUN, is_dst),
    0,0,0, 292 },
  { "shadow_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUN, shadow_type),
    0,0,0, 70 },
  { "shadow_mapsize",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_SUN, shadow_mapsize),
    0,0,0, 71 },
  { "shadow_softness",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_SUN, shadow_softness),
    0,0,0, 280 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_SUNSTUDY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SUNSTUDY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_SUNSTUDY, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, class_version),
    0,0,0, 90 },
  { "setup_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, setup_name),
    1,1,1, 1 },
  { "description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, description),
    1,1,1, 2 },
  { "output_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, output_type),
    0,0,0, 70 },
  { "sheet_set_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, sheet_set_name),
    1,1,1, 3 },
  { "use_subset",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, use_subset),
    0,0,0, 290 },
  { "sheet_subset_name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_SUNSTUDY, sheet_subset_name),
    1,1,1, 4 },
  { "select_dates_from_calendar",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, select_dates_from_calendar),
    0,0,0, 291 },
  { "num_dates",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, num_dates),
    0,0,0, 91 },
  { "dates",	"Dwg_SUNSTUDY_Dates*", sizeof (Dwg_SUNSTUDY_Dates*),  OFF (struct _dwg_object_SUNSTUDY, dates),
    1,1,0, 0 },
  { "select_range_of_dates",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, select_range_of_dates),
    0,0,0, 292 },
  { "start_time",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, start_time),
    0,0,0, 93 },
  { "end_time",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, end_time),
    0,0,0, 94 },
  { "interval",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, interval),
    0,0,0, 95 },
  { "num_hours",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, num_hours),
    0,0,0, 91 },
  { "hours",	"B*", sizeof (BITCODE_B*),  OFF (struct _dwg_object_SUNSTUDY, hours),
    1,1,0, 290 },
  { "shade_plot_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, shade_plot_type),
    0,0,0, 74 },
  { "numvports",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, numvports),
    0,0,0, 75 },
  { "numrows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, numrows),
    0,0,0, 76 },
  { "numcols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_SUNSTUDY, numcols),
    0,0,0, 77 },
  { "spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_SUNSTUDY, spacing),
    0,0,0, 40 },
  { "lock_viewports",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, lock_viewports),
    0,0,0, 293 },
  { "label_viewports",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_SUNSTUDY, label_viewports),
    0,0,0, 294 },
  { "page_setup_wizard",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, page_setup_wizard),
    1,0,0, 340 },
  { "view",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, view),
    1,0,0, 341 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, visualstyle),
    1,0,0, 342 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_SUNSTUDY, text_style),
    1,0,0, 343 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TABLECONTENT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLECONTENT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TABLECONTENT, parent),
    1,1,0, 0 },
  { "ldata",	"Dwg_LinkedData", sizeof (Dwg_LinkedData),  OFF (struct _dwg_object_TABLECONTENT, ldata),
    0,0,0, 0 },
  { "tdata",	"Dwg_LinkedTableData", sizeof (Dwg_LinkedTableData),  OFF (struct _dwg_object_TABLECONTENT, tdata),
    0,0,0, 0 },
  { "fdata",	"Dwg_FormattedTableData", sizeof (Dwg_FormattedTableData),  OFF (struct _dwg_object_TABLECONTENT, fdata),
    0,0,0, 0 },
  { "tablestyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_TABLECONTENT, tablestyle),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TABLEGEOMETRY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLEGEOMETRY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TABLEGEOMETRY, parent),
    1,1,0, 0 },
  { "numrows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLEGEOMETRY, numrows),
    0,0,0, 90 },
  { "numcols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLEGEOMETRY, numcols),
    0,0,0, 91 },
  { "num_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLEGEOMETRY, num_cells),
    0,0,0, 92 },
  { "cells",	"Dwg_TABLEGEOMETRY_Cell*", sizeof (Dwg_TABLEGEOMETRY_Cell*),  OFF (struct _dwg_object_TABLEGEOMETRY, cells),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TABLESTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TABLESTYLE, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TABLESTYLE, class_version),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_TABLESTYLE, name),
    1,1,1, 3 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TABLESTYLE, flags),
    0,0,0, 71 },
  { "flow_direction",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TABLESTYLE, flow_direction),
    0,0,0, 70 },
  { "horiz_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_TABLESTYLE, horiz_cell_margin),
    0,0,0, 40 },
  { "vert_cell_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_TABLESTYLE, vert_cell_margin),
    0,0,0, 41 },
  { "is_title_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_TABLESTYLE, is_title_suppressed),
    0,0,0, 280 },
  { "is_header_suppressed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_TABLESTYLE, is_header_suppressed),
    0,0,0, 281 },
  { "unknown_rc",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_TABLESTYLE, unknown_rc),
    0,0,0, 70 },
  { "unknown_bl1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLESTYLE, unknown_bl1),
    0,0,0, 0 },
  { "unknown_bl2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLESTYLE, unknown_bl2),
    0,0,0, 0 },
  { "cellstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_TABLESTYLE, cellstyle),
    1,0,0, 0 },
  { "sty",	"Dwg_TABLESTYLE_CellStyle", sizeof (Dwg_TABLESTYLE_CellStyle),  OFF (struct _dwg_object_TABLESTYLE, sty),
    0,0,0, 0 },
  { "numoverrides",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLESTYLE, numoverrides),
    0,0,0, 0 },
  { "unknown_bl3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLESTYLE, unknown_bl3),
    0,0,0, 0 },
  { "ovr",	"Dwg_TABLESTYLE_CellStyle", sizeof (Dwg_TABLESTYLE_CellStyle),  OFF (struct _dwg_object_TABLESTYLE, ovr),
    0,0,0, 0 },
  { "num_rowstyles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TABLESTYLE, num_rowstyles),
    0,0,0, 0 },
  { "rowstyles",	"Dwg_TABLESTYLE_rowstyles*", sizeof (Dwg_TABLESTYLE_rowstyles*),  OFF (struct _dwg_object_TABLESTYLE, rowstyles),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TEXTOBJECTCONTEXTDATA: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TEXTOBJECTCONTEXTDATA_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, class_version),
    0,0,0, 70 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, is_default),
    0,0,0, 290 },
  { "scale",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, scale),
    1,0,0, 340 },
  { "horizontal_mode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, horizontal_mode),
    0,0,0, 70 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, rotation),
    0,0,0, 50 },
  { "ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, ins_pt),
    1,0,0, 10 },
  { "alignment_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_TEXTOBJECTCONTEXTDATA, alignment_pt),
    1,0,0, 11 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_TVDEVICEPROPERTIES: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TVDEVICEPROPERTIES_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, parent),
    1,1,0, 0 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, flags),
    0,0,0, 0 },
  { "max_regen_threads",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, max_regen_threads),
    0,0,0, 0 },
  { "use_lut_palette",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, use_lut_palette),
    0,0,0, 0 },
  { "alt_hlt",	"BLL", sizeof (BITCODE_BLL),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, alt_hlt),
    0,0,0, 0 },
  { "alt_hltcolor",	"BLL", sizeof (BITCODE_BLL),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, alt_hltcolor),
    0,0,0, 0 },
  { "geom_shader_usage",	"BLL", sizeof (BITCODE_BLL),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, geom_shader_usage),
    0,0,0, 0 },
  { "blending_mode",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, blending_mode),
    0,0,0, 0 },
  { "antialiasing_level",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, antialiasing_level),
    0,0,0, 0 },
  { "bd2",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_TVDEVICEPROPERTIES, bd2),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_UCS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UCS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_UCS, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_UCS, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_UCS, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_UCS, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_UCS, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_UCS, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_UCS, xref),
    1,0,0, 0 },
  { "ucsorg",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_UCS, ucsorg),
    1,0,0, 10 },
  { "ucsxdir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_UCS, ucsxdir),
    1,0,0, 11 },
  { "ucsydir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_UCS, ucsydir),
    1,0,0, 12 },
  { "ucs_elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_UCS, ucs_elevation),
    0,0,0, 146 },
  { "UCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS, UCSORTHOVIEW),
    0,0,0, 79 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_UCS, base_ucs),
    1,0,0, 346 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_UCS, named_ucs),
    1,0,0, 0 },
  { "num_orthopts",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS, num_orthopts),
    0,0,0, 0 },
  { "orthopts",	"Dwg_UCS_orthopts*", sizeof (Dwg_UCS_orthopts*),  OFF (struct _dwg_object_UCS, orthopts),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_UCS_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UCS_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_UCS_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_UCS_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_UCS_CONTROL, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_UNKNOWN_OBJ: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNKNOWN_OBJ_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_UNKNOWN_OBJ, parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VBA_PROJECT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VBA_PROJECT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VBA_PROJECT, parent),
    1,1,0, 0 },
  { "data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VBA_PROJECT, data_size),
    0,0,0, 90 },
  { "data",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_VBA_PROJECT, data),
    1,1,0, 310 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VIEW: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VIEW_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VIEW, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VIEW, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_VIEW, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_VIEW, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VIEW, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, xref),
    1,0,0, 0 },
  { "VIEWSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, VIEWSIZE),
    0,0,0, 40 },
  { "view_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, view_width),
    0,0,0, 41 },
  { "aspect_ratio",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, aspect_ratio),
    0,0,0, 0 },
  { "VIEWCTR",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VIEW, VIEWCTR),
    1,0,0, 10 },
  { "view_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, view_target),
    1,0,0, 12 },
  { "VIEWDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, VIEWDIR),
    1,0,0, 11 },
  { "twist_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, twist_angle),
    0,0,0, 50 },
  { "lens_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, lens_length),
    0,0,0, 42 },
  { "front_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, front_clip_z),
    0,0,0, 43 },
  { "back_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, back_clip_z),
    0,0,0, 44 },
  { "VIEWMODE",	"4BITS", sizeof (BITCODE_4BITS),  OFF (struct _dwg_object_VIEW, VIEWMODE),
    0,0,0, 71 },
  { "render_mode",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VIEW, render_mode),
    0,0,0, 281 },
  { "use_default_lights",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, use_default_lights),
    0,0,0, 292 },
  { "default_lightning_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VIEW, default_lightning_type),
    0,0,0, 282 },
  { "brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, brightness),
    0,0,0, 141 },
  { "contrast",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, contrast),
    0,0,0, 142 },
  { "ambient_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VIEW, ambient_color),
    0,0,0, 63 },
  { "is_pspace",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, is_pspace),
    0,0,0, 0 },
  { "associated_ucs",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, associated_ucs),
    0,0,0, 72 },
  { "ucsorg",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, ucsorg),
    1,0,0, 110 },
  { "ucsxdir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, ucsxdir),
    1,0,0, 111 },
  { "ucsydir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VIEW, ucsydir),
    1,0,0, 112 },
  { "ucs_elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VIEW, ucs_elevation),
    0,0,0, 146 },
  { "UCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VIEW, UCSORTHOVIEW),
    0,0,0, 79 },
  { "is_camera_plottable",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VIEW, is_camera_plottable),
    0,0,0, 73 },
  { "background",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, background),
    1,0,0, 332 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, visualstyle),
    1,0,0, 348 },
  { "sun",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, sun),
    1,0,0, 361 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, base_ucs),
    1,0,0, 346 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, named_ucs),
    1,0,0, 345 },
  { "livesection",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VIEW, livesection),
    1,0,0, 334 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VIEW_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VIEW_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VIEW_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VIEW_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_VIEW_CONTROL, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VISUALSTYLE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VISUALSTYLE_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VISUALSTYLE, parent),
    1,1,0, 0 },
  { "description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_object_VISUALSTYLE, description),
    1,1,1, 2 },
  { "style_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, style_type),
    0,0,0, 70 },
  { "ext_lighting_model",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, ext_lighting_model),
    0,0,0, 177 },
  { "internal_only",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, internal_only),
    0,0,0, 291 },
  { "face_lighting_model",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, face_lighting_model),
    0,0,0, 71 },
  { "face_lighting_model_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_lighting_model_int),
    0,0,0, 176 },
  { "face_lighting_quality",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, face_lighting_quality),
    0,0,0, 72 },
  { "face_lighting_quality_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_lighting_quality_int),
    0,0,0, 176 },
  { "face_color_mode",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, face_color_mode),
    0,0,0, 73 },
  { "face_color_mode_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_color_mode_int),
    0,0,0, 176 },
  { "face_opacity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, face_opacity),
    0,0,0, 40 },
  { "face_opacity_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_opacity_int),
    0,0,0, 176 },
  { "face_specular",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, face_specular),
    0,0,0, 41 },
  { "face_specular_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_specular_int),
    0,0,0, 176 },
  { "face_modifier",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, face_modifier),
    0,0,0, 90 },
  { "face_modifier_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_modifier_int),
    0,0,0, 176 },
  { "face_mono_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, face_mono_color),
    0,0,0, 63 },
  { "face_mono_color_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, face_mono_color_int),
    0,0,0, 176 },
  { "edge_model",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_model),
    0,0,0, 74 },
  { "edge_model_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_model_int),
    0,0,0, 176 },
  { "edge_style",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_style),
    0,0,0, 91 },
  { "edge_style_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_style_int),
    0,0,0, 176 },
  { "edge_intersection_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_intersection_color),
    0,0,0, 64 },
  { "edge_intersection_color_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_intersection_color_int),
    0,0,0, 176 },
  { "edge_obscured_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_obscured_color),
    0,0,0, 65 },
  { "edge_obscured_color_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_obscured_color_int),
    0,0,0, 176 },
  { "edge_obscured_ltype",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_obscured_ltype),
    0,0,0, 75 },
  { "edge_obscured_ltype_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_obscured_ltype_int),
    0,0,0, 176 },
  { "edge_intersection_ltype",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_intersection_ltype),
    0,0,0, 175 },
  { "edge_intersection_ltype_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_intersection_ltype_int),
    0,0,0, 176 },
  { "edge_crease_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, edge_crease_angle),
    0,0,0, 42 },
  { "edge_crease_angle_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_crease_angle_int),
    0,0,0, 176 },
  { "edge_modifier",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_modifier),
    0,0,0, 92 },
  { "edge_modifier_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_modifier_int),
    0,0,0, 176 },
  { "edge_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_color),
    0,0,0, 66 },
  { "edge_color_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_color_int),
    0,0,0, 176 },
  { "edge_opacity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, edge_opacity),
    0,0,0, 43 },
  { "edge_opacity_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_opacity_int),
    0,0,0, 176 },
  { "edge_width",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_width),
    0,0,0, 76 },
  { "edge_width_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_width_int),
    0,0,0, 176 },
  { "edge_overhang",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_overhang),
    0,0,0, 77 },
  { "edge_overhang_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_overhang_int),
    0,0,0, 176 },
  { "edge_jitter",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_jitter),
    0,0,0, 78 },
  { "edge_jitter_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_jitter_int),
    0,0,0, 176 },
  { "edge_silhouette_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, edge_silhouette_color),
    0,0,0, 67 },
  { "edge_silhouette_color_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_silhouette_color_int),
    0,0,0, 176 },
  { "edge_silhouette_width",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_silhouette_width),
    0,0,0, 79 },
  { "edge_silhouette_width_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_silhouette_width_int),
    0,0,0, 176 },
  { "edge_halo_gap",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_halo_gap),
    0,0,0, 170 },
  { "edge_halo_gap_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_halo_gap_int),
    0,0,0, 176 },
  { "edge_isolines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_isolines),
    0,0,0, 171 },
  { "edge_isolines_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_isolines_int),
    0,0,0, 176 },
  { "edge_do_hide_precision",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, edge_do_hide_precision),
    0,0,0, 290 },
  { "edge_do_hide_precision_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_do_hide_precision_int),
    0,0,0, 176 },
  { "edge_style_apply",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_style_apply),
    0,0,0, 174 },
  { "edge_style_apply_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_style_apply_int),
    0,0,0, 0 },
  { "display_settings",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, display_settings),
    0,0,0, 93 },
  { "display_settings_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, display_settings_int),
    0,0,0, 176 },
  { "display_brightness_bl",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_object_VISUALSTYLE, display_brightness_bl),
    0,0,0, 44 },
  { "display_brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, display_brightness),
    0,0,0, 44 },
  { "display_brightness_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, display_brightness_int),
    0,0,0, 176 },
  { "display_shadow_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, display_shadow_type),
    0,0,0, 173 },
  { "display_shadow_type_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, display_shadow_type_int),
    0,0,0, 176 },
  { "bd2007_45",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, bd2007_45),
    0,0,0, 45 },
  { "num_props",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, num_props),
    0,0,0, 70 },
  { "b_prop1c",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1c),
    0,0,0, 290 },
  { "b_prop1c_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1c_int),
    0,0,0, 176 },
  { "b_prop1d",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1d),
    0,0,0, 290 },
  { "b_prop1d_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1d_int),
    0,0,0, 176 },
  { "b_prop1e",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1e),
    0,0,0, 290 },
  { "b_prop1e_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1e_int),
    0,0,0, 176 },
  { "b_prop1f",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1f),
    0,0,0, 290 },
  { "b_prop1f_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop1f_int),
    0,0,0, 176 },
  { "b_prop20",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop20),
    0,0,0, 290 },
  { "b_prop20_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop20_int),
    0,0,0, 176 },
  { "b_prop21",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop21),
    0,0,0, 290 },
  { "b_prop21_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop21_int),
    0,0,0, 176 },
  { "b_prop22",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop22),
    0,0,0, 290 },
  { "b_prop22_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop22_int),
    0,0,0, 176 },
  { "b_prop23",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop23),
    0,0,0, 290 },
  { "b_prop23_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop23_int),
    0,0,0, 176 },
  { "b_prop24",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop24),
    0,0,0, 290 },
  { "b_prop24_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop24_int),
    0,0,0, 176 },
  { "bl_prop25",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop25),
    0,0,0, 90 },
  { "bl_prop25_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop25_int),
    0,0,0, 176 },
  { "bd_prop26",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop26),
    0,0,0, 40 },
  { "bd_prop26_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop26_int),
    0,0,0, 176 },
  { "bd_prop27",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop27),
    0,0,0, 40 },
  { "bd_prop27_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop27_int),
    0,0,0, 176 },
  { "bl_prop28",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop28),
    0,0,0, 90 },
  { "bl_prop28_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop28_int),
    0,0,0, 176 },
  { "c_prop29",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, c_prop29),
    0,0,0, 62 },
  { "c_prop29_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, c_prop29_int),
    0,0,0, 176 },
  { "bl_prop2a",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2a),
    0,0,0, 90 },
  { "bl_prop2a_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2a_int),
    0,0,0, 176 },
  { "bl_prop2b",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2b),
    0,0,0, 90 },
  { "bl_prop2b_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2b_int),
    0,0,0, 176 },
  { "c_prop2c",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, c_prop2c),
    0,0,0, 62 },
  { "c_prop2c_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, c_prop2c_int),
    0,0,0, 176 },
  { "b_prop2d",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop2d),
    0,0,0, 290 },
  { "b_prop2d_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop2d_int),
    0,0,0, 176 },
  { "bl_prop2e",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2e),
    0,0,0, 90 },
  { "bl_prop2e_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2e_int),
    0,0,0, 176 },
  { "bl_prop2f",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2f),
    0,0,0, 90 },
  { "bl_prop2f_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop2f_int),
    0,0,0, 176 },
  { "bl_prop30",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop30),
    0,0,0, 90 },
  { "bl_prop30_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop30_int),
    0,0,0, 176 },
  { "b_prop31",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop31),
    0,0,0, 290 },
  { "b_prop31_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop31_int),
    0,0,0, 176 },
  { "bl_prop32",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop32),
    0,0,0, 90 },
  { "bl_prop32_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bl_prop32_int),
    0,0,0, 176 },
  { "c_prop33",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VISUALSTYLE, c_prop33),
    0,0,0, 62 },
  { "c_prop33_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, c_prop33_int),
    0,0,0, 176 },
  { "bd_prop34",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop34),
    0,0,0, 40 },
  { "bd_prop34_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop34_int),
    0,0,0, 176 },
  { "edge_wiggle",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_VISUALSTYLE, edge_wiggle),
    0,0,0, 90 },
  { "edge_wiggle_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, edge_wiggle_int),
    0,0,0, 176 },
  { "strokes",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_object_VISUALSTYLE, strokes),
    1,1,1, 1 },
  { "strokes_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, strokes_int),
    0,0,0, 176 },
  { "b_prop37",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VISUALSTYLE, b_prop37),
    0,0,0, 290 },
  { "b_prop37_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, b_prop37_int),
    0,0,0, 176 },
  { "bd_prop38",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop38),
    0,0,0, 40 },
  { "bd_prop38_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop38_int),
    0,0,0, 176 },
  { "bd_prop39",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop39),
    0,0,0, 40 },
  { "bd_prop39_int",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VISUALSTYLE, bd_prop39_int),
    0,0,0, 176 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VPORT: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VPORT_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VPORT, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_VPORT, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_VPORT, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, xref),
    1,0,0, 0 },
  { "VIEWSIZE",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, VIEWSIZE),
    0,0,0, 40 },
  { "view_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, view_width),
    0,0,0, 0 },
  { "aspect_ratio",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, aspect_ratio),
    0,0,0, 41 },
  { "VIEWCTR",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, VIEWCTR),
    1,0,0, 12 },
  { "view_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, view_target),
    1,0,0, 17 },
  { "VIEWDIR",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, VIEWDIR),
    1,0,0, 16 },
  { "view_twist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, view_twist),
    0,0,0, 51 },
  { "lens_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, lens_length),
    0,0,0, 42 },
  { "front_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, front_clip_z),
    0,0,0, 43 },
  { "back_clip_z",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, back_clip_z),
    0,0,0, 44 },
  { "VIEWMODE",	"4BITS", sizeof (BITCODE_4BITS),  OFF (struct _dwg_object_VPORT, VIEWMODE),
    0,0,0, 71 },
  { "render_mode",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, render_mode),
    0,0,0, 281 },
  { "use_default_lights",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, use_default_lights),
    0,0,0, 292 },
  { "default_lightning_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, default_lightning_type),
    0,0,0, 282 },
  { "brightness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, brightness),
    0,0,0, 141 },
  { "contrast",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, contrast),
    0,0,0, 142 },
  { "ambient_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_VPORT, ambient_color),
    0,0,0, 63 },
  { "lower_left",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, lower_left),
    1,0,0, 10 },
  { "upper_right",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, upper_right),
    1,0,0, 11 },
  { "UCSFOLLOW",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, UCSFOLLOW),
    0,0,0, 71 },
  { "circle_zoom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, circle_zoom),
    0,0,0, 72 },
  { "FASTZOOM",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, FASTZOOM),
    0,0,0, 73 },
  { "UCSICON",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VPORT, UCSICON),
    0,0,0, 74 },
  { "GRIDMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, GRIDMODE),
    0,0,0, 76 },
  { "GRIDUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, GRIDUNIT),
    1,0,0, 15 },
  { "SNAPMODE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, SNAPMODE),
    0,0,0, 75 },
  { "SNAPSTYLE",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, SNAPSTYLE),
    0,0,0, 77 },
  { "SNAPISOPAIR",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, SNAPISOPAIR),
    0,0,0, 78 },
  { "SNAPANG",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, SNAPANG),
    0,0,0, 50 },
  { "SNAPBASE",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, SNAPBASE),
    1,0,0, 13 },
  { "SNAPUNIT",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_object_VPORT, SNAPUNIT),
    1,0,0, 14 },
  { "ucs_at_origin",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, ucs_at_origin),
    0,0,0, 0 },
  { "UCSVP",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VPORT, UCSVP),
    0,0,0, 71 },
  { "ucsorg",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, ucsorg),
    1,0,0, 110 },
  { "ucsxdir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, ucsxdir),
    1,0,0, 111 },
  { "ucsydir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_object_VPORT, ucsydir),
    1,0,0, 112 },
  { "ucs_elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_VPORT, ucs_elevation),
    0,0,0, 146 },
  { "UCSORTHOVIEW",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, UCSORTHOVIEW),
    0,0,0, 79 },
  { "grid_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, grid_flags),
    0,0,0, 60 },
  { "grid_major",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT, grid_major),
    0,0,0, 61 },
  { "background",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, background),
    1,0,0, 332 },
  { "visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, visualstyle),
    1,0,0, 348 },
  { "sun",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, sun),
    1,0,0, 361 },
  { "named_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, named_ucs),
    1,0,0, 345 },
  { "base_ucs",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VPORT, base_ucs),
    1,0,0, 346 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VPORT_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VPORT_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VPORT_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VPORT_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_VPORT_CONTROL, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VX_CONTROL: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VX_CONTROL_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VX_CONTROL, parent),
    1,1,0, 0 },
  { "num_entries",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VX_CONTROL, num_entries),
    0,0,0, 70 },
  { "entries",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_VX_CONTROL, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_VX_TABLE_RECORD: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VX_TABLE_RECORD_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_VX_TABLE_RECORD, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_VX_TABLE_RECORD, flag),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_object_VX_TABLE_RECORD, name),
    1,1,1, 0 },
  { "used",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_VX_TABLE_RECORD, used),
    0,0,0, 0 },
  { "is_xref_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VX_TABLE_RECORD, is_xref_ref),
    0,0,0, 0 },
  { "is_xref_resolved",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_VX_TABLE_RECORD, is_xref_resolved),
    0,0,0, 0 },
  { "is_xref_dep",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VX_TABLE_RECORD, is_xref_dep),
    0,0,0, 0 },
  { "xref",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VX_TABLE_RECORD, xref),
    1,0,0, 0 },
  { "is_on",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_VX_TABLE_RECORD, is_on),
    0,0,0, 290 },
  { "viewport",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VX_TABLE_RECORD, viewport),
    1,0,0, 338 },
  { "prev_entry",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_VX_TABLE_RECORD, prev_entry),
    1,0,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_WIPEOUTVARIABLES: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_WIPEOUTVARIABLES_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_WIPEOUTVARIABLES, parent),
    1,1,0, 0 },
  { "display_frame",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_WIPEOUTVARIABLES, display_frame),
    0,0,0, 70 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_object_XRECORD: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_XRECORD_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_object_XRECORD, parent),
    1,1,0, 0 },
  { "cloning",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_XRECORD, cloning),
    0,0,0, 280 },
  { "xdata_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_XRECORD, xdata_size),
    0,0,0, 0 },
  { "num_xdata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_XRECORD, num_xdata),
    0,0,0, 0 },
  { "xdata",	"Dwg_Resbuf*", sizeof (Dwg_Resbuf*),  OFF (struct _dwg_object_XRECORD, xdata),
    1,1,0, 0 },
  { "num_objid_handles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_XRECORD, num_objid_handles),
    0,0,0, 0 },
  { "objid_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_XRECORD, objid_handles),
    1,1,0, 340 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_abstractobject_UNDERLAYDEFINITION: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UNDERLAYDEFINITION_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_abstractobject_UNDERLAYDEFINITION, parent),
    1,1,0, 0 },
  { "filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_abstractobject_UNDERLAYDEFINITION, filename),
    1,1,1, 1 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_abstractobject_UNDERLAYDEFINITION, name),
    1,1,1, 2 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_abstractobject_ASSOCARRAYPARAMETERS: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCARRAYPARAMETERS_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, parent),
    1,1,0, 0 },
  { "aap_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, aap_version),
    0,0,0, 0 },
  { "num_items",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, num_items),
    0,0,0, 0 },
  { "classname",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, classname),
    1,1,1, 0 },
  { "items",	"Dwg_ASSOCARRAYITEM*", sizeof (Dwg_ASSOCARRAYITEM*),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, items),
    1,1,0, 0 },
  { "numitems",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, numitems),
    0,0,0, 0 },
  { "numrows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, numrows),
    0,0,0, 0 },
  { "numlevels",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_abstractobject_ASSOCARRAYPARAMETERS, numlevels),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_3DSOLID_material: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DSOLID_material_fields[] = {
  { "parent",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_3DSOLID_material, parent),
    1,1,0, 0 },
  { "array_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_material, array_index),
    0,0,0, 0 },
  { "mat_absref",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_material, mat_absref),
    0,0,0, 0 },
  { "material_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_3DSOLID_material, material_handle),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_3DSOLID_silhouette: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DSOLID_silhouette_fields[] = {
  { "parent",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_3DSOLID_silhouette, parent),
    1,1,0, 0 },
  { "vp_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_silhouette, vp_id),
    0,0,0, 0 },
  { "vp_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_silhouette, vp_target),
    1,0,0, 0 },
  { "vp_dir_from_target",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_silhouette, vp_dir_from_target),
    1,0,0, 0 },
  { "vp_up_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_silhouette, vp_up_dir),
    1,0,0, 0 },
  { "vp_perspective",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_silhouette, vp_perspective),
    0,0,0, 0 },
  { "has_wires",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_silhouette, has_wires),
    0,0,0, 0 },
  { "num_wires",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_silhouette, num_wires),
    0,0,0, 0 },
  { "wires",	"Dwg_3DSOLID_wire*", sizeof (Dwg_3DSOLID_wire*),  OFF (struct _dwg_3DSOLID_silhouette, wires),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_3DSOLID_wire: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_3DSOLID_wire_fields[] = {
  { "parent",	"struct _dwg_entity_3DSOLID*", sizeof (void *),  OFF (struct _dwg_3DSOLID_wire, parent),
    1,1,0, 0 },
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_3DSOLID_wire, type),
    0,0,0, 0 },
  { "selection_marker",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_3DSOLID_wire, selection_marker),
    0,0,0, 0 },
  { "color",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_wire, color),
    0,0,0, 0 },
  { "acis_index",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_3DSOLID_wire, acis_index),
    0,0,0, 0 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_3DSOLID_wire, num_points),
    0,0,0, 0 },
  { "points",	"3BD*", sizeof (BITCODE_3BD*),  OFF (struct _dwg_3DSOLID_wire, points),
    1,1,0, 0 },
  { "transform_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, transform_present),
    0,0,0, 0 },
  { "axis_x",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, axis_x),
    1,0,0, 0 },
  { "axis_y",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, axis_y),
    1,0,0, 0 },
  { "axis_z",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, axis_z),
    1,0,0, 0 },
  { "translation",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, translation),
    1,0,0, 0 },
  { "scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_3DSOLID_wire, scale),
    1,0,0, 0 },
  { "has_rotation",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, has_rotation),
    0,0,0, 0 },
  { "has_reflection",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, has_reflection),
    0,0,0, 0 },
  { "has_shear",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_3DSOLID_wire, has_shear),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ACSH_HistoryNode: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_HistoryNode_fields[] = {
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_HistoryNode, major),
    0,0,0, 0 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_HistoryNode, minor),
    0,0,0, 0 },
  { "trans",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_ACSH_HistoryNode, trans),
    1,1,0, 40 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_ACSH_HistoryNode, color),
    0,0,0, 0 },
  { "step_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_HistoryNode, step_id),
    0,0,0, 0 },
  { "material",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ACSH_HistoryNode, material),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ACSH_SubentColor: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_SubentColor_fields[] = {
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentColor, major),
    0,0,0, 0 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentColor, minor),
    0,0,0, 0 },
  { "transparency",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentColor, transparency),
    0,0,0, 0 },
  { "bl93",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentColor, bl93),
    0,0,0, 0 },
  { "is_face_variable",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_ACSH_SubentColor, is_face_variable),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ACSH_SubentMaterial: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACSH_SubentMaterial_fields[] = {
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentMaterial, major),
    0,0,0, 0 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentMaterial, minor),
    0,0,0, 0 },
  { "reflectance",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentMaterial, reflectance),
    0,0,0, 0 },
  { "displacement",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACSH_SubentMaterial, displacement),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_ASSOCNETWORK*", sizeof (void *),  OFF (struct _dwg_ACTIONBODY, parent),
    1,1,0, 0 },
  { "evaluatorid",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_ACTIONBODY, evaluatorid),
    1,1,1, 0 },
  { "expression",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_ACTIONBODY, expression),
    1,1,1, 0 },
  { "value",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ACTIONBODY, value),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ARRAYITEMLOCATOR: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ARRAYITEMLOCATOR_fields[] = {
  { "parent",	"struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY*", sizeof (void *),  OFF (struct _dwg_ARRAYITEMLOCATOR, parent),
    1,1,0, 0 },
  { "itemloc1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ARRAYITEMLOCATOR, itemloc1),
    0,0,0, 90 },
  { "itemloc2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ARRAYITEMLOCATOR, itemloc2),
    0,0,0, 90 },
  { "itemloc3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ARRAYITEMLOCATOR, itemloc3),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ASSOCACTIONBODY_action: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCACTIONBODY_action_fields[] = {
  { "parent",	"struct _dwg_object_ASSOCMLEADERACTIONBODY*", sizeof (void *),  OFF (struct _dwg_ASSOCACTIONBODY_action, parent),
    1,1,0, 0 },
  { "depid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCACTIONBODY_action, depid),
    0,0,0, 0 },
  { "dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ASSOCACTIONBODY_action, dep),
    1,0,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ASSOCACTION_Deps: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCACTION_Deps_fields[] = {
  { "parent",	"struct _dwg_object_ASSOCACTION*", sizeof (void *),  OFF (struct _dwg_ASSOCACTION_Deps, parent),
    1,1,0, 0 },
  { "is_owned",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_ASSOCACTION_Deps, is_owned),
    0,0,0, 0 },
  { "dep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ASSOCACTION_Deps, dep),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ASSOCARRAYITEM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCARRAYITEM_fields[] = {
  { "parent",	"struct _dwg_abstractobject_ASSOCARRAYPARAMETERS*", sizeof (void *),  OFF (struct _dwg_ASSOCARRAYITEM, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCARRAYITEM, class_version),
    0,0,0, 90 },
  { "itemloc[3]",	"BL", 3 * sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCARRAYITEM, itemloc),
    0,0,0, 0 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCARRAYITEM, flags),
    0,0,0, 0 },
  { "is_default_transmatrix",	"int", sizeof (int),  OFF (struct _dwg_ASSOCARRAYITEM, is_default_transmatrix),
    0,0,0, 0 },
  { "x_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_ASSOCARRAYITEM, x_dir),
    1,0,0, 0 },
  { "transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_ASSOCARRAYITEM, transmatrix),
    1,1,0, 0 },
  { "rel_transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_ASSOCARRAYITEM, rel_transform),
    1,1,0, 0 },
  { "has_h1",	"int", sizeof (int),  OFF (struct _dwg_ASSOCARRAYITEM, has_h1),
    0,0,0, 0 },
  { "h1",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ASSOCARRAYITEM, h1),
    1,0,0, 0 },
  { "h2",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ASSOCARRAYITEM, h2),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ASSOCPARAMBASEDACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCPARAMBASEDACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, parent),
    1,1,0, 0 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, version),
    0,0,0, 0 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, minor),
    0,0,0, 0 },
  { "num_deps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, num_deps),
    0,0,0, 90 },
  { "deps",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, deps),
    1,1,0, 0 },
  { "l4",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, l4),
    0,0,0, 0 },
  { "l5",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, l5),
    0,0,0, 0 },
  { "assocdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, assocdep),
    1,0,0, 0 },
  { "num_values",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, num_values),
    0,0,0, 0 },
  { "values",	"struct _dwg_VALUEPARAM*", sizeof (void *),  OFF (struct _dwg_ASSOCPARAMBASEDACTIONBODY, values),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ASSOCSURFACEACTIONBODY: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ASSOCSURFACEACTIONBODY_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_ASSOCSURFACEACTIONBODY, parent),
    1,1,0, 0 },
  { "version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCSURFACEACTIONBODY, version),
    0,0,0, 0 },
  { "is_semi_assoc",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_ASSOCSURFACEACTIONBODY, is_semi_assoc),
    0,0,0, 0 },
  { "l2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ASSOCSURFACEACTIONBODY, l2),
    0,0,0, 0 },
  { "is_semi_ovr",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_ASSOCSURFACEACTIONBODY, is_semi_ovr),
    0,0,0, 0 },
  { "grip_status",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_ASSOCSURFACEACTIONBODY, grip_status),
    0,0,0, 0 },
  { "assocdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ASSOCSURFACEACTIONBODY, assocdep),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_fields[] = {
  { "file_signature",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, file_signature),
    0,0,0, 0 },
  { "file_header_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, file_header_size),
    0,0,0, 0 },
  { "unknown_1",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, unknown_1),
    0,0,0, 0 },
  { "version",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, version),
    0,0,0, 0 },
  { "unknown_2",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, unknown_2),
    0,0,0, 0 },
  { "ds_version",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, ds_version),
    0,0,0, 0 },
  { "segidx_offset",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, segidx_offset),
    0,0,0, 0 },
  { "segidx_unknown",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, segidx_unknown),
    0,0,0, 0 },
  { "num_segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, num_segidx),
    0,0,0, 0 },
  { "schidx_segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, schidx_segidx),
    0,0,0, 0 },
  { "datidx_segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, datidx_segidx),
    0,0,0, 0 },
  { "search_segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, search_segidx),
    0,0,0, 0 },
  { "prvsav_segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, prvsav_segidx),
    0,0,0, 0 },
  { "file_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs, file_size),
    0,0,0, 0 },
  { "total_segments",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_AcDs, total_segments),
    0,0,0, 0 },
  { "segidx",	"Dwg_AcDs_SegmentIndex*", sizeof (Dwg_AcDs_SegmentIndex*),  OFF (struct _dwg_AcDs, segidx),
    1,1,0, 0 },
  { "datidx",	"Dwg_AcDs_DataIndex", sizeof (Dwg_AcDs_DataIndex),  OFF (struct _dwg_AcDs, datidx),
    0,0,0, 0 },
  { "data",	"Dwg_AcDs_Data*", sizeof (Dwg_AcDs_Data*),  OFF (struct _dwg_AcDs, data),
    1,1,0, 0 },
  { "blob01",	"Dwg_AcDs_DataBlob", sizeof (Dwg_AcDs_DataBlob),  OFF (struct _dwg_AcDs, blob01),
    0,0,0, 0 },
  { "schidx",	"Dwg_AcDs_SchemaIndex", sizeof (Dwg_AcDs_SchemaIndex),  OFF (struct _dwg_AcDs, schidx),
    0,0,0, 0 },
  { "schdat",	"Dwg_AcDs_SchemaData", sizeof (Dwg_AcDs_SchemaData),  OFF (struct _dwg_AcDs, schdat),
    0,0,0, 0 },
  { "search",	"Dwg_AcDs_Search", sizeof (Dwg_AcDs_Search),  OFF (struct _dwg_AcDs, search),
    0,0,0, 0 },
  { "segments",	"Dwg_AcDs_Segment*", sizeof (Dwg_AcDs_Segment*),  OFF (struct _dwg_AcDs, segments),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Data: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Data_fields[] = {
  { "record_hdrs",	"Dwg_AcDs_Data_RecordHdr*", sizeof (Dwg_AcDs_Data_RecordHdr*),  OFF (struct _dwg_AcDs_Data, record_hdrs),
    1,1,0, 0 },
  { "records",	"Dwg_AcDs_Data_Record*", sizeof (Dwg_AcDs_Data_Record*),  OFF (struct _dwg_AcDs_Data, records),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_DataBlob: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_DataBlob_fields[] = {
  { "data_size",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_DataBlob, data_size),
    0,0,0, 0 },
  { "page_count",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlob, page_count),
    0,0,0, 0 },
  { "record_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlob, record_size),
    0,0,0, 0 },
  { "page_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlob, page_size),
    0,0,0, 0 },
  { "unknown_1",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlob, unknown_1),
    0,0,0, 0 },
  { "unknown_2",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlob, unknown_2),
    0,0,0, 0 },
  { "ref",	"Dwg_AcDs_DataBlobRef*", sizeof (Dwg_AcDs_DataBlobRef*),  OFF (struct _dwg_AcDs_DataBlob, ref),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_DataBlob01: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_DataBlob01_fields[] = {
  { "total_data_size",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_DataBlob01, total_data_size),
    0,0,0, 0 },
  { "page_start_offset",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_DataBlob01, page_start_offset),
    0,0,0, 0 },
  { "page_index",	"int32_t", sizeof (int32_t),  OFF (struct _dwg_AcDs_DataBlob01, page_index),
    0,0,0, 0 },
  { "page_count",	"int32_t", sizeof (int32_t),  OFF (struct _dwg_AcDs_DataBlob01, page_count),
    0,0,0, 0 },
  { "page_data_size",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_DataBlob01, page_data_size),
    0,0,0, 0 },
  { "page_data",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_AcDs_DataBlob01, page_data),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_DataBlobRef: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_DataBlobRef_fields[] = {
  { "total_data_size",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_DataBlobRef, total_data_size),
    0,0,0, 0 },
  { "num_pages",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlobRef, num_pages),
    0,0,0, 0 },
  { "record_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlobRef, record_size),
    0,0,0, 0 },
  { "page_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlobRef, page_size),
    0,0,0, 0 },
  { "unknown_1",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlobRef, unknown_1),
    0,0,0, 0 },
  { "unknown_2",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlobRef, unknown_2),
    0,0,0, 0 },
  { "pages",	"Dwg_AcDs_DataBlobRef_Page*", sizeof (Dwg_AcDs_DataBlobRef_Page*),  OFF (struct _dwg_AcDs_DataBlobRef, pages),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_DataBlobRef_Page: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_DataBlobRef_Page_fields[] = {
  { "segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlobRef_Page, segidx),
    0,0,0, 0 },
  { "size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataBlobRef_Page, size),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_DataIndex: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_DataIndex_fields[] = {
  { "num_entries",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataIndex, num_entries),
    0,0,0, 0 },
  { "di_unknown",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataIndex, di_unknown),
    0,0,0, 0 },
  { "entries",	"Dwg_AcDs_DataIndex_Entry*", sizeof (Dwg_AcDs_DataIndex_Entry*),  OFF (struct _dwg_AcDs_DataIndex, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_DataIndex_Entry: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_DataIndex_Entry_fields[] = {
  { "segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataIndex_Entry, segidx),
    0,0,0, 0 },
  { "offset",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataIndex_Entry, offset),
    0,0,0, 0 },
  { "schidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_DataIndex_Entry, schidx),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Data_Record: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Data_Record_fields[] = {
  { "data_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Data_Record, data_size),
    0,0,0, 0 },
  { "blob",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_AcDs_Data_Record, blob),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Data_RecordHdr: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Data_RecordHdr_fields[] = {
  { "entry_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Data_RecordHdr, entry_size),
    0,0,0, 0 },
  { "unknown",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Data_RecordHdr, unknown),
    0,0,0, 0 },
  { "handle",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_Data_RecordHdr, handle),
    0,0,0, 0 },
  { "offset",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Data_RecordHdr, offset),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Schema: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Schema_fields[] = {
  { "num_index",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_AcDs_Schema, num_index),
    0,0,0, 0 },
  { "index",	"RLL*", sizeof (BITCODE_RLL*),  OFF (struct _dwg_AcDs_Schema, index),
    1,1,0, 0 },
  { "num_props",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_AcDs_Schema, num_props),
    0,0,0, 0 },
  { "props",	"Dwg_AcDs_Schema_Prop*", sizeof (Dwg_AcDs_Schema_Prop*),  OFF (struct _dwg_AcDs_Schema, props),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_SchemaData: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_SchemaData_fields[] = {
  { "num_uprops",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaData, num_uprops),
    0,0,0, 0 },
  { "uprops",	"Dwg_AcDs_SchemaData_UProp*", sizeof (Dwg_AcDs_SchemaData_UProp*),  OFF (struct _dwg_AcDs_SchemaData, uprops),
    1,1,0, 0 },
  { "num_schemas",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaData, num_schemas),
    0,0,0, 0 },
  { "schemas",	"Dwg_AcDs_Schema*", sizeof (Dwg_AcDs_Schema*),  OFF (struct _dwg_AcDs_SchemaData, schemas),
    1,1,0, 0 },
  { "num_propnames",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaData, num_propnames),
    0,0,0, 0 },
  { "propnames",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_AcDs_SchemaData, propnames),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_SchemaData_UProp: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_SchemaData_UProp_fields[] = {
  { "size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaData_UProp, size),
    0,0,0, 0 },
  { "flags",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaData_UProp, flags),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_SchemaIndex: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_SchemaIndex_fields[] = {
  { "num_props",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaIndex, num_props),
    0,0,0, 0 },
  { "si_unknown_1",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaIndex, si_unknown_1),
    0,0,0, 0 },
  { "props",	"Dwg_AcDs_SchemaIndex_Prop*", sizeof (Dwg_AcDs_SchemaIndex_Prop*),  OFF (struct _dwg_AcDs_SchemaIndex, props),
    1,1,0, 0 },
  { "si_tag",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_SchemaIndex, si_tag),
    0,0,0, 0 },
  { "num_prop_entries",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaIndex, num_prop_entries),
    0,0,0, 0 },
  { "si_unknown_2",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaIndex, si_unknown_2),
    0,0,0, 0 },
  { "prop_entries",	"Dwg_AcDs_SchemaIndex_Prop*", sizeof (Dwg_AcDs_SchemaIndex_Prop*),  OFF (struct _dwg_AcDs_SchemaIndex, prop_entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_SchemaIndex_Prop: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_SchemaIndex_Prop_fields[] = {
  { "index",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaIndex_Prop, index),
    0,0,0, 0 },
  { "segidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaIndex_Prop, segidx),
    0,0,0, 0 },
  { "offset",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SchemaIndex_Prop, offset),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Schema_Prop: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Schema_Prop_fields[] = {
  { "flags",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Schema_Prop, flags),
    0,0,0, 0 },
  { "namidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Schema_Prop, namidx),
    0,0,0, 0 },
  { "type",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Schema_Prop, type),
    0,0,0, 0 },
  { "type_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Schema_Prop, type_size),
    0,0,0, 0 },
  { "unknown_1",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Schema_Prop, unknown_1),
    0,0,0, 0 },
  { "unknown_2",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Schema_Prop, unknown_2),
    0,0,0, 0 },
  { "num_values",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_AcDs_Schema_Prop, num_values),
    0,0,0, 0 },
  { "values",	"RC*", sizeof (BITCODE_RC*),  OFF (struct _dwg_AcDs_Schema_Prop, values),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Search: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Search_fields[] = {
  { "num_search",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Search, num_search),
    0,0,0, 0 },
  { "search",	"Dwg_AcDs_Search_Data*", sizeof (Dwg_AcDs_Search_Data*),  OFF (struct _dwg_AcDs_Search, search),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Search_Data: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Search_Data_fields[] = {
  { "schema_namidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Search_Data, schema_namidx),
    0,0,0, 0 },
  { "num_sortedidx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Search_Data, num_sortedidx),
    0,0,0, 0 },
  { "sortedidx",	"RLL*", sizeof (BITCODE_RLL*),  OFF (struct _dwg_AcDs_Search_Data, sortedidx),
    1,1,0, 0 },
  { "num_ididxs",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Search_Data, num_ididxs),
    0,0,0, 0 },
  { "unknown",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Search_Data, unknown),
    0,0,0, 0 },
  { "ididxs",	"Dwg_AcDs_Search_IdIdxs*", sizeof (Dwg_AcDs_Search_IdIdxs*),  OFF (struct _dwg_AcDs_Search_Data, ididxs),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Search_IdIdx: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Search_IdIdx_fields[] = {
  { "handle",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_Search_IdIdx, handle),
    0,0,0, 0 },
  { "num_ididx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Search_IdIdx, num_ididx),
    0,0,0, 0 },
  { "ididx",	"RLL*", sizeof (BITCODE_RLL*),  OFF (struct _dwg_AcDs_Search_IdIdx, ididx),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Search_IdIdxs: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Search_IdIdxs_fields[] = {
  { "num_ididx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Search_IdIdxs, num_ididx),
    0,0,0, 0 },
  { "ididx",	"Dwg_AcDs_Search_IdIdx*", sizeof (Dwg_AcDs_Search_IdIdx*),  OFF (struct _dwg_AcDs_Search_IdIdxs, ididx),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_Segment: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_Segment_fields[] = {
  { "signature",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, signature),
    0,0,0, 0 },
  { "name[7]",	"RC", 7 * sizeof (BITCODE_RC),  OFF (struct _dwg_AcDs_Segment, name),
    0,0,0, 0 },
  { "type",	"RCd", sizeof (BITCODE_RCd),  OFF (struct _dwg_AcDs_Segment, type),
    0,0,0, 0 },
  { "segment_idx",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, segment_idx),
    0,0,0, 0 },
  { "is_blob01",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, is_blob01),
    0,0,0, 0 },
  { "segsize",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, segsize),
    0,0,0, 0 },
  { "unknown_2",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, unknown_2),
    0,0,0, 0 },
  { "ds_version",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, ds_version),
    0,0,0, 0 },
  { "unknown_3",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, unknown_3),
    0,0,0, 0 },
  { "data_algn_offset",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, data_algn_offset),
    0,0,0, 0 },
  { "objdata_algn_offset",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_Segment, objdata_algn_offset),
    0,0,0, 0 },
  { "padding[9]",	"RC", 9 * sizeof (BITCODE_RC),  OFF (struct _dwg_AcDs_Segment, padding),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_AcDs_SegmentIndex: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_AcDs_SegmentIndex_fields[] = {
  { "offset",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_AcDs_SegmentIndex, offset),
    0,0,0, 0 },
  { "size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_AcDs_SegmentIndex, size),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_BLOCKACTION_connectionpts: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKACTION_connectionpts_fields[] = {
  { "code",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BLOCKACTION_connectionpts, code),
    0,0,0, 0 },
  { "name",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_BLOCKACTION_connectionpts, name),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_BLOCKLOOKUPACTION_lut: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKLOOKUPACTION_lut_fields[] = {
  { "parent",	"struct _dwg_object_BLOCKLOOKUPACTION*", sizeof (void *),  OFF (struct _dwg_BLOCKLOOKUPACTION_lut, parent),
    1,1,0, 0 },
  { "conn_pts",	"Dwg_BLOCKACTION_connectionpts", 3 * sizeof (Dwg_BLOCKACTION_connectionpts),  OFF (struct _dwg_BLOCKLOOKUPACTION_lut, conn_pts),
    0,0,0, 0 },
  { "b282",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_BLOCKLOOKUPACTION_lut, b282),
    0,0,0, 282 },
  { "b281",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_BLOCKLOOKUPACTION_lut, b281),
    0,0,0, 281 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_BLOCKPARAMETER_PropInfo: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPARAMETER_PropInfo_fields[] = {
  { "num_connections",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BLOCKPARAMETER_PropInfo, num_connections),
    0,0,0, 0 },
  { "connections",	"Dwg_BLOCKPARAMETER_connection*", sizeof (Dwg_BLOCKPARAMETER_connection*),  OFF (struct _dwg_BLOCKPARAMETER_PropInfo, connections),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_BLOCKPARAMETER_connection: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPARAMETER_connection_fields[] = {
  { "code",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BLOCKPARAMETER_connection, code),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_BLOCKPARAMETER_connection, name),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_BLOCKPARAMVALUESET: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKPARAMVALUESET_fields[] = {
  { "desc",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_BLOCKPARAMVALUESET, desc),
    1,1,1, 0 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BLOCKPARAMVALUESET, flags),
    0,0,0, 0 },
  { "minimum",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_BLOCKPARAMVALUESET, minimum),
    0,0,0, 0 },
  { "maximum",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_BLOCKPARAMVALUESET, maximum),
    0,0,0, 0 },
  { "increment",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_BLOCKPARAMVALUESET, increment),
    0,0,0, 0 },
  { "num_valuelist",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_BLOCKPARAMVALUESET, num_valuelist),
    0,0,0, 0 },
  { "valuelist",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_BLOCKPARAMVALUESET, valuelist),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_BLOCKVISIBILITYPARAMETER_state: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_BLOCKVISIBILITYPARAMETER_state_fields[] = {
  { "parent",	"struct _dwg_object_BLOCKVISIBILITYPARAMETER*", sizeof (void *),  OFF (struct _dwg_BLOCKVISIBILITYPARAMETER_state, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_BLOCKVISIBILITYPARAMETER_state, name),
    1,1,1, 303 },
  { "num_blocks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BLOCKVISIBILITYPARAMETER_state, num_blocks),
    0,0,0, 94 },
  { "blocks",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_BLOCKVISIBILITYPARAMETER_state, blocks),
    1,1,0, 332 },
  { "num_params",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_BLOCKVISIBILITYPARAMETER_state, num_params),
    0,0,0, 95 },
  { "params",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_BLOCKVISIBILITYPARAMETER_state, params),
    1,1,0, 333 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_COMPOUNDOBJECTID: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_COMPOUNDOBJECTID_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_COMPOUNDOBJECTID, parent),
    1,1,0, 0 },
  { "has_object",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_COMPOUNDOBJECTID, has_object),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_COMPOUNDOBJECTID, name),
    1,1,1, 0 },
  { "object",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_COMPOUNDOBJECTID, object),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CONSTRAINTGROUPNODE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CONSTRAINTGROUPNODE_fields[] = {
  { "parent",	"struct _dwg_object_ASSOC2DCONSTRAINTGROUP*", sizeof (void *),  OFF (struct _dwg_CONSTRAINTGROUPNODE, parent),
    1,1,0, 0 },
  { "nodeid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CONSTRAINTGROUPNODE, nodeid),
    0,0,0, 0 },
  { "status",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_CONSTRAINTGROUPNODE, status),
    0,0,0, 0 },
  { "num_connections",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CONSTRAINTGROUPNODE, num_connections),
    0,0,0, 0 },
  { "connections",	"BL*", sizeof (BITCODE_BL*),  OFF (struct _dwg_CONSTRAINTGROUPNODE, connections),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CONTEXTDATA_dict: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CONTEXTDATA_dict_fields[] = {
  { "parent",	"struct _dwg_CONTEXTDATA_submgr*", sizeof (void *),  OFF (struct _dwg_CONTEXTDATA_dict, parent),
    1,1,0, 0 },
  { "text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_CONTEXTDATA_dict, text),
    1,1,1, 3 },
  { "itemhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_CONTEXTDATA_dict, itemhandle),
    1,0,0, 350 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CONTEXTDATA_submgr: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CONTEXTDATA_submgr_fields[] = {
  { "parent",	"struct _dwg_object_CONTEXTDATAMANAGER*", sizeof (void *),  OFF (struct _dwg_CONTEXTDATA_submgr, parent),
    1,1,0, 0 },
  { "handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_CONTEXTDATA_submgr, handle),
    1,0,0, 0 },
  { "num_entries",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CONTEXTDATA_submgr, num_entries),
    0,0,0, 90 },
  { "entries",	"Dwg_CONTEXTDATA_dict*", sizeof (Dwg_CONTEXTDATA_dict*),  OFF (struct _dwg_CONTEXTDATA_submgr, entries),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CellContentGeometry: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CellContentGeometry_fields[] = {
  { "dist_top_left",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_CellContentGeometry, dist_top_left),
    1,0,0, 10 },
  { "dist_center",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_CellContentGeometry, dist_center),
    1,0,0, 11 },
  { "content_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, content_width),
    0,0,0, 43 },
  { "content_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, content_height),
    0,0,0, 44 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, width),
    0,0,0, 45 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellContentGeometry, height),
    0,0,0, 46 },
  { "unknown",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellContentGeometry, unknown),
    0,0,0, 95 },
  { "cell_parent",	"struct _dwg_TableCell*", sizeof (void *),  OFF (struct _dwg_CellContentGeometry, cell_parent),
    1,1,0, 0 },
  { "geom_parent",	"struct _dwg_TABLEGEOMETRY_Cell*", sizeof (void *),  OFF (struct _dwg_CellContentGeometry, geom_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_CellStyle: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_CellStyle_fields[] = {
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, type),
    0,0,0, 90 },
  { "data_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_CellStyle, data_flags),
    0,0,0, 170 },
  { "property_override_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, property_override_flags),
    0,0,0, 91 },
  { "merge_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, merge_flags),
    0,0,0, 92 },
  { "bg_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_CellStyle, bg_color),
    0,0,0, 62 },
  { "content_layout",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, content_layout),
    0,0,0, 93 },
  { "content_format",	"Dwg_ContentFormat", sizeof (Dwg_ContentFormat),  OFF (struct _dwg_CellStyle, content_format),
    0,0,0, 0 },
  { "margin_override_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_CellStyle, margin_override_flags),
    0,0,0, 171 },
  { "vert_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, vert_margin),
    0,0,0, 40 },
  { "horiz_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, horiz_margin),
    0,0,0, 40 },
  { "bottom_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, bottom_margin),
    0,0,0, 40 },
  { "right_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, right_margin),
    0,0,0, 40 },
  { "margin_horiz_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, margin_horiz_spacing),
    0,0,0, 40 },
  { "margin_vert_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_CellStyle, margin_vert_spacing),
    0,0,0, 40 },
  { "num_borders",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_CellStyle, num_borders),
    0,0,0, 94 },
  { "borders",	"Dwg_GridFormat*", sizeof (Dwg_GridFormat*),  OFF (struct _dwg_CellStyle, borders),
    1,1,0, 0 },
  { "tablerow_parent",	"struct _dwg_TableRow*", sizeof (void *),  OFF (struct _dwg_CellStyle, tablerow_parent),
    1,1,0, 0 },
  { "tabledatacolumn_parent",	"struct _dwg_TableDataColumn*", sizeof (void *),  OFF (struct _dwg_CellStyle, tabledatacolumn_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ColorRamp: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ColorRamp_fields[] = {
  { "parent",	"struct _dwg_POINTCLOUDCOLORMAP_Ramp*", sizeof (void *),  OFF (struct _dwg_ColorRamp, parent),
    1,1,0, 0 },
  { "colorscheme",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_ColorRamp, colorscheme),
    1,1,1, 1 },
  { "unknown_bl",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ColorRamp, unknown_bl),
    0,0,0, 91 },
  { "unknown_b",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_ColorRamp, unknown_b),
    0,0,0, 290 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_ContentFormat: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_ContentFormat_fields[] = {
  { "property_override_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, property_override_flags),
    0,0,0, 90 },
  { "property_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, property_flags),
    0,0,0, 91 },
  { "value_data_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, value_data_type),
    0,0,0, 92 },
  { "value_unit_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, value_unit_type),
    0,0,0, 93 },
  { "value_format_string",	"T", sizeof (BITCODE_TV),  OFF (struct _dwg_ContentFormat, value_format_string),
    1,1,1, 300 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_ContentFormat, rotation),
    0,0,0, 40 },
  { "block_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_ContentFormat, block_scale),
    0,0,0, 140 },
  { "cell_alignment",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_ContentFormat, cell_alignment),
    0,0,0, 94 },
  { "content_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_ContentFormat, content_color),
    0,0,0, 62 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_ContentFormat, text_style),
    1,0,0, 0 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_ContentFormat, text_height),
    0,0,0, 144 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_DATALINK_customdata: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DATALINK_customdata_fields[] = {
  { "parent",	"struct _dwg_object_DATALINK*", sizeof (void *),  OFF (struct _dwg_DATALINK_customdata, parent),
    1,1,0, 0 },
  { "target",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_DATALINK_customdata, target),
    1,0,0, 0 },
  { "text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_DATALINK_customdata, text),
    1,1,1, 304 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_DATATABLE_column: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DATATABLE_column_fields[] = {
  { "parent",	"struct _dwg_object_DATATABLE*", sizeof (void *),  OFF (struct _dwg_DATATABLE_column, parent),
    1,1,0, 0 },
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_DATATABLE_column, type),
    0,0,0, 92 },
  { "text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_DATATABLE_column, text),
    1,1,1, 2 },
  { "rows",	"Dwg_DATATABLE_row*", sizeof (Dwg_DATATABLE_row*),  OFF (struct _dwg_DATATABLE_column, rows),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_DATATABLE_row: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DATATABLE_row_fields[] = {
  { "parent",	"struct _dwg_DATATABLE_column*", sizeof (void *),  OFF (struct _dwg_DATATABLE_row, parent),
    1,1,0, 0 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_DATATABLE_row, value),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_DIMASSOC_Ref: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMASSOC_Ref_fields[] = {
  { "parent",	"struct _dwg_object_DIMASSOC*", sizeof (void *),  OFF (struct _dwg_DIMASSOC_Ref, parent),
    1,1,0, 0 },
  { "classname",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_DIMASSOC_Ref, classname),
    1,1,1, 1 },
  { "osnap_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMASSOC_Ref, osnap_type),
    0,0,0, 72 },
  { "osnap_dist",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMASSOC_Ref, osnap_dist),
    0,0,0, 40 },
  { "osnap_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMASSOC_Ref, osnap_pt),
    1,0,0, 10 },
  { "num_xrefs",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMASSOC_Ref, num_xrefs),
    0,0,0, 0 },
  { "xrefs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_DIMASSOC_Ref, xrefs),
    1,1,0, 331 },
  { "main_subent_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMASSOC_Ref, main_subent_type),
    0,0,0, 73 },
  { "main_gsmarker",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_DIMASSOC_Ref, main_gsmarker),
    0,0,0, 91 },
  { "num_xrefpaths",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMASSOC_Ref, num_xrefpaths),
    0,0,0, 0 },
  { "xrefpaths",	"TV*", sizeof (BITCODE_TV*),  OFF (struct _dwg_DIMASSOC_Ref, xrefpaths),
    1,1,0, 301 },
  { "has_lastpt_ref",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMASSOC_Ref, has_lastpt_ref),
    0,0,0, 75 },
  { "lastpt_ref",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMASSOC_Ref, lastpt_ref),
    1,0,0, 0 },
  { "num_intsectobj",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_DIMASSOC_Ref, num_intsectobj),
    0,0,0, 74 },
  { "intsectobj",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_DIMASSOC_Ref, intsectobj),
    1,1,0, 332 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_DIMENSION_common: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_DIMENSION_common_fields[] = {
  { "parent",	"struct _dwg_object_entity*", sizeof (void *),  OFF (struct _dwg_DIMENSION_common, parent),
    1,1,0, 0 },
  { "class_version",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMENSION_common, class_version),
    0,0,0, 280 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_DIMENSION_common, extrusion),
    0,0,0, 210 },
  { "def_pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMENSION_common, def_pt),
    1,0,0, 10 },
  { "text_midpt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_DIMENSION_common, text_midpt),
    1,0,0, 11 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, elevation),
    0,0,0, 31 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMENSION_common, flag),
    0,0,0, 70 },
  { "flag1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_DIMENSION_common, flag1),
    0,0,0, 0 },
  { "user_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_DIMENSION_common, user_text),
    1,1,1, 1 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, text_rotation),
    0,0,0, 53 },
  { "horiz_dir",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, horiz_dir),
    0,0,0, 51 },
  { "ins_scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_DIMENSION_common, ins_scale),
    1,0,0, 0 },
  { "ins_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, ins_rotation),
    0,0,0, 54 },
  { "attachment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMENSION_common, attachment),
    0,0,0, 71 },
  { "lspace_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_DIMENSION_common, lspace_style),
    0,0,0, 72 },
  { "lspace_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, lspace_factor),
    0,0,0, 41 },
  { "act_measurement",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_DIMENSION_common, act_measurement),
    0,0,0, 42 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMENSION_common, unknown),
    0,0,0, 73 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMENSION_common, flip_arrow1),
    0,0,0, 74 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_DIMENSION_common, flip_arrow2),
    0,0,0, 75 },
  { "clone_ins_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_DIMENSION_common, clone_ins_pt),
    1,0,0, 12 },
  { "dimstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_DIMENSION_common, dimstyle),
    1,0,0, 3 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_DIMENSION_common, block),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_EVAL_Edge: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EVAL_Edge_fields[] = {
  { "parent",	"struct _dwg_object_EVALUATION_GRAPH*", sizeof (void *),  OFF (struct _dwg_EVAL_Edge, parent),
    1,1,0, 0 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EVAL_Edge, id),
    0,0,0, 92 },
  { "nextid",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_EVAL_Edge, nextid),
    0,0,0, 93 },
  { "e1",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_EVAL_Edge, e1),
    0,0,0, 94 },
  { "e2",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_EVAL_Edge, e2),
    0,0,0, 91 },
  { "e3",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_EVAL_Edge, e3),
    0,0,0, 91 },
  { "out_edge[5]",	"BLd", 5 * sizeof (BITCODE_BLd),  OFF (struct _dwg_EVAL_Edge, out_edge),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_EVAL_Node: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EVAL_Node_fields[] = {
  { "parent",	"struct _dwg_object_EVALUATION_GRAPH*", sizeof (void *),  OFF (struct _dwg_EVAL_Node, parent),
    1,1,0, 0 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EVAL_Node, id),
    0,0,0, 91 },
  { "edge_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EVAL_Node, edge_flags),
    0,0,0, 93 },
  { "nextid",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_EVAL_Node, nextid),
    0,0,0, 95 },
  { "evalexpr",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_EVAL_Node, evalexpr),
    1,0,0, 360 },
  { "node[4]",	"BLd", 4 * sizeof (BITCODE_BLd),  OFF (struct _dwg_EVAL_Node, node),
    0,0,0, 0 },
  { "active_cycles",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_EVAL_Node, active_cycles),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_EvalExpr: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EvalExpr_fields[] = {
  { "parentid",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_EvalExpr, parentid),
    0,0,0, 0 },
  { "major",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EvalExpr, major),
    0,0,0, 0 },
  { "minor",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EvalExpr, minor),
    0,0,0, 0 },
  { "value_code",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_EvalExpr, value_code),
    0,0,0, 0 },
  { "value.num40",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_EvalExpr, value.num40),
    0,0,0, 0 },
  { "value.pt2d",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_EvalExpr, value.pt2d),
    1,0,0, 0 },
  { "value.pt3d",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_EvalExpr, value.pt3d),
    1,0,0, 0 },
  { "value.text1",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_EvalExpr, value.text1),
    1,1,1, 0 },
  { "value.long90",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EvalExpr, value.long90),
    0,0,0, 0 },
  { "value.handle91",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_EvalExpr, value.handle91),
    1,0,0, 0 },
  { "value.short70",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_EvalExpr, value.short70),
    0,0,0, 0 },
  { "nodeid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EvalExpr, nodeid),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_EvalVariant: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_EvalVariant_fields[] = {
  { "code",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_EvalVariant, code),
    0,0,0, 0 },
  { "u.bd",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_EvalVariant, u.bd),
    0,0,0, 0 },
  { "u.bl",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_EvalVariant, u.bl),
    0,0,0, 0 },
  { "u.bs",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_EvalVariant, u.bs),
    0,0,0, 0 },
  { "u.rc",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_EvalVariant, u.rc),
    0,0,0, 0 },
  { "u.text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_EvalVariant, u.text),
    1,1,1, 0 },
  { "u.handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_EvalVariant, u.handle),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_FIELD_ChildValue: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FIELD_ChildValue_fields[] = {
  { "parent",	"struct _dwg_object_FIELD*", sizeof (void *),  OFF (struct _dwg_FIELD_ChildValue, parent),
    1,1,0, 0 },
  { "key",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_FIELD_ChildValue, key),
    1,1,1, 6 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_FIELD_ChildValue, value),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_FileDepList_Files: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FileDepList_Files_fields[] = {
  { "filename",	"T32", sizeof (BITCODE_T32),  OFF (struct _dwg_FileDepList_Files, filename),
    1,0,0, 0 },
  { "filepath",	"T32", sizeof (BITCODE_T32),  OFF (struct _dwg_FileDepList_Files, filepath),
    1,0,0, 0 },
  { "fingerprint",	"T32", sizeof (BITCODE_T32),  OFF (struct _dwg_FileDepList_Files, fingerprint),
    1,0,0, 0 },
  { "version",	"T32", sizeof (BITCODE_T32),  OFF (struct _dwg_FileDepList_Files, version),
    1,0,0, 0 },
  { "feature_index",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_FileDepList_Files, feature_index),
    0,0,0, 0 },
  { "timestamp",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_FileDepList_Files, timestamp),
    0,0,0, 0 },
  { "filesize",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_FileDepList_Files, filesize),
    0,0,0, 0 },
  { "affects_graphics",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_FileDepList_Files, affects_graphics),
    0,0,0, 0 },
  { "refcount",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_FileDepList_Files, refcount),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_FormattedTableData: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FormattedTableData_fields[] = {
  { "parent",	"struct _dwg_object_TABLECONTENT*", sizeof (void *),  OFF (struct _dwg_FormattedTableData, parent),
    1,1,0, 0 },
  { "cellstyle",	"Dwg_CellStyle", sizeof (Dwg_CellStyle),  OFF (struct _dwg_FormattedTableData, cellstyle),
    0,0,0, 0 },
  { "num_merged_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableData, num_merged_cells),
    0,0,0, 90 },
  { "merged_cells",	"Dwg_FormattedTableMerged*", sizeof (Dwg_FormattedTableMerged*),  OFF (struct _dwg_FormattedTableData, merged_cells),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_FormattedTableMerged: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_FormattedTableMerged_fields[] = {
  { "parent",	"struct _dwg_FormattedTableData*", sizeof (void *),  OFF (struct _dwg_FormattedTableMerged, parent),
    1,1,0, 0 },
  { "top_row",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, top_row),
    0,0,0, 91 },
  { "left_col",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, left_col),
    0,0,0, 92 },
  { "bottom_row",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, bottom_row),
    0,0,0, 93 },
  { "right_col",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_FormattedTableMerged, right_col),
    0,0,0, 94 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_GEODATA_meshface: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEODATA_meshface_fields[] = {
  { "face1",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GEODATA_meshface, face1),
    0,0,0, 0 },
  { "face2",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GEODATA_meshface, face2),
    0,0,0, 0 },
  { "face3",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GEODATA_meshface, face3),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_GEODATA_meshpt: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GEODATA_meshpt_fields[] = {
  { "source_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_GEODATA_meshpt, source_pt),
    1,0,0, 0 },
  { "dest_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_GEODATA_meshpt, dest_pt),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_GridFormat: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_GridFormat_fields[] = {
  { "parent",	"struct _dwg_CellStyle*", sizeof (void *),  OFF (struct _dwg_GridFormat, parent),
    1,1,0, 0 },
  { "index_mask",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GridFormat, index_mask),
    0,0,0, 95 },
  { "border_overrides",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GridFormat, border_overrides),
    0,0,0, 90 },
  { "border_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_GridFormat, border_type),
    0,0,0, 91 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_GridFormat, color),
    0,0,0, 62 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_GridFormat, linewt),
    0,0,0, 92 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_GridFormat, ltype),
    1,0,0, 340 },
  { "visible",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_GridFormat, visible),
    0,0,0, 93 },
  { "double_line_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_GridFormat, double_line_spacing),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_Color: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_Color_fields[] = {
  { "parent",	"struct _dwg_entity_HATCH*", sizeof (void *),  OFF (struct _dwg_HATCH_Color, parent),
    1,1,0, 0 },
  { "shift_value",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_Color, shift_value),
    0,0,0, 463 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_HATCH_Color, color),
    0,0,0, 63 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_ControlPoint: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_ControlPoint_fields[] = {
  { "parent",	"struct _dwg_HATCH_PathSeg*", sizeof (void *),  OFF (struct _dwg_HATCH_ControlPoint, parent),
    1,1,0, 0 },
  { "point",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_ControlPoint, point),
    1,0,0, 10 },
  { "weight",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_ControlPoint, weight),
    0,0,0, 40 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_DefLine: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_DefLine_fields[] = {
  { "parent",	"struct _dwg_entity_HATCH*", sizeof (void *),  OFF (struct _dwg_HATCH_DefLine, parent),
    1,1,0, 0 },
  { "angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_DefLine, angle),
    0,0,0, 53 },
  { "pt0",	"2BD", sizeof (BITCODE_2BD),  OFF (struct _dwg_HATCH_DefLine, pt0),
    1,0,0, 43 },
  { "offset",	"2BD", sizeof (BITCODE_2BD),  OFF (struct _dwg_HATCH_DefLine, offset),
    1,0,0, 45 },
  { "num_dashes",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_HATCH_DefLine, num_dashes),
    0,0,0, 79 },
  { "dashes",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_HATCH_DefLine, dashes),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_Path: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_Path_fields[] = {
  { "parent",	"struct _dwg_entity_HATCH*", sizeof (void *),  OFF (struct _dwg_HATCH_Path, parent),
    1,1,0, 0 },
  { "flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_Path, flag),
    0,0,0, 92 },
  { "num_segs_or_paths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_Path, num_segs_or_paths),
    0,0,0, 93 },
  { "segs",	"Dwg_HATCH_PathSeg*", sizeof (Dwg_HATCH_PathSeg*),  OFF (struct _dwg_HATCH_Path, segs),
    1,1,0, 0 },
  { "bulges_present",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_Path, bulges_present),
    0,0,0, 72 },
  { "closed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_Path, closed),
    0,0,0, 73 },
  { "polyline_paths",	"Dwg_HATCH_PolylinePath*", sizeof (Dwg_HATCH_PolylinePath*),  OFF (struct _dwg_HATCH_Path, polyline_paths),
    1,1,0, 0 },
  { "num_boundary_handles",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_Path, num_boundary_handles),
    0,0,0, 97 },
  { "boundary_handles",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_HATCH_Path, boundary_handles),
    1,1,0, 330 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_PathSeg: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_PathSeg_fields[] = {
  { "parent",	"struct _dwg_HATCH_Path*", sizeof (void *),  OFF (struct _dwg_HATCH_PathSeg, parent),
    1,1,0, 0 },
  { "curve_type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_HATCH_PathSeg, curve_type),
    0,0,0, 72 },
  { "first_endpoint",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, first_endpoint),
    1,0,0, 10 },
  { "second_endpoint",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, second_endpoint),
    1,0,0, 11 },
  { "center",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, center),
    1,0,0, 10 },
  { "radius",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, radius),
    0,0,0, 40 },
  { "start_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, start_angle),
    0,0,0, 50 },
  { "end_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, end_angle),
    0,0,0, 51 },
  { "is_ccw",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_PathSeg, is_ccw),
    0,0,0, 73 },
  { "endpoint",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, endpoint),
    1,0,0, 11 },
  { "minor_major_ratio",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PathSeg, minor_major_ratio),
    0,0,0, 40 },
  { "degree",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, degree),
    0,0,0, 94 },
  { "is_rational",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_PathSeg, is_rational),
    0,0,0, 73 },
  { "is_periodic",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_HATCH_PathSeg, is_periodic),
    0,0,0, 74 },
  { "num_knots",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, num_knots),
    0,0,0, 95 },
  { "num_control_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, num_control_points),
    0,0,0, 96 },
  { "knots",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_HATCH_PathSeg, knots),
    1,1,0, 0 },
  { "control_points",	"Dwg_HATCH_ControlPoint*", sizeof (Dwg_HATCH_ControlPoint*),  OFF (struct _dwg_HATCH_PathSeg, control_points),
    1,1,0, 0 },
  { "num_fitpts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_HATCH_PathSeg, num_fitpts),
    0,0,0, 97 },
  { "fitpts",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_HATCH_PathSeg, fitpts),
    1,1,0, 0 },
  { "start_tangent",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, start_tangent),
    1,0,0, 0 },
  { "end_tangent",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PathSeg, end_tangent),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_HATCH_PolylinePath: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_HATCH_PolylinePath_fields[] = {
  { "parent",	"struct _dwg_HATCH_Path*", sizeof (void *),  OFF (struct _dwg_HATCH_PolylinePath, parent),
    1,1,0, 0 },
  { "point",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_HATCH_PolylinePath, point),
    1,0,0, 10 },
  { "bulge",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_HATCH_PolylinePath, bulge),
    0,0,0, 42 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LAYER_entry: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LAYER_entry_fields[] = {
  { "parent",	"struct _dwg_object_LAYER_INDEX*", sizeof (void *),  OFF (struct _dwg_LAYER_entry, parent),
    1,1,0, 0 },
  { "numlayers",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LAYER_entry, numlayers),
    0,0,0, 90 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_LAYER_entry, name),
    1,1,1, 8 },
  { "handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LAYER_entry, handle),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_ArrowHead: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_ArrowHead_fields[] = {
  { "parent",	"struct _dwg_entity_MULTILEADER*", sizeof (void *),  OFF (struct _dwg_LEADER_ArrowHead, parent),
    1,1,0, 0 },
  { "is_default",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_LEADER_ArrowHead, is_default),
    0,0,0, 94 },
  { "arrowhead",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_ArrowHead, arrowhead),
    1,0,0, 345 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_BlockLabel: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_BlockLabel_fields[] = {
  { "parent",	"struct _dwg_entity_MULTILEADER*", sizeof (void *),  OFF (struct _dwg_LEADER_BlockLabel, parent),
    1,1,0, 0 },
  { "attdef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_BlockLabel, attdef),
    1,0,0, 330 },
  { "label_text",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_LEADER_BlockLabel, label_text),
    1,1,1, 302 },
  { "ui_index",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LEADER_BlockLabel, ui_index),
    0,0,0, 177 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LEADER_BlockLabel, width),
    0,0,0, 44 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_Break: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_Break_fields[] = {
  { "parent",	"struct _dwg_LEADER_Line*", sizeof (void *),  OFF (struct _dwg_LEADER_Break, parent),
    1,1,0, 0 },
  { "start",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Break, start),
    1,0,0, 11 },
  { "end",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Break, end),
    1,0,0, 12 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_Line: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_Line_fields[] = {
  { "parent",	"struct _dwg_LEADER_Node*", sizeof (void *),  OFF (struct _dwg_LEADER_Line, parent),
    1,1,0, 0 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, num_points),
    0,0,0, 0 },
  { "points",	"3DPOINT*", sizeof (BITCODE_3DPOINT*),  OFF (struct _dwg_LEADER_Line, points),
    1,1,0, 0 },
  { "num_breaks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, num_breaks),
    0,0,0, 0 },
  { "breaks",	"Dwg_LEADER_Break*", sizeof (Dwg_LEADER_Break*),  OFF (struct _dwg_LEADER_Line, breaks),
    1,1,0, 0 },
  { "line_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, line_index),
    0,0,0, 91 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LEADER_Line, type),
    0,0,0, 170 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_LEADER_Line, color),
    0,0,0, 92 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_Line, ltype),
    1,0,0, 340 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_LEADER_Line, linewt),
    0,0,0, 171 },
  { "arrow_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LEADER_Line, arrow_size),
    0,0,0, 40 },
  { "arrow_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LEADER_Line, arrow_handle),
    1,0,0, 341 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Line, flags),
    0,0,0, 93 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LEADER_Node: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LEADER_Node_fields[] = {
  { "parent",	"struct _dwg_entity_MULTILEADER*", sizeof (void *),  OFF (struct _dwg_LEADER_Node, parent),
    1,1,0, 0 },
  { "has_lastleaderlinepoint",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_LEADER_Node, has_lastleaderlinepoint),
    0,0,0, 290 },
  { "has_dogleg",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_LEADER_Node, has_dogleg),
    0,0,0, 291 },
  { "lastleaderlinepoint",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Node, lastleaderlinepoint),
    1,0,0, 10 },
  { "dogleg_vector",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_LEADER_Node, dogleg_vector),
    1,0,0, 11 },
  { "branch_index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Node, branch_index),
    0,0,0, 90 },
  { "dogleg_length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LEADER_Node, dogleg_length),
    0,0,0, 40 },
  { "num_lines",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Node, num_lines),
    0,0,0, 0 },
  { "lines",	"Dwg_LEADER_Line*", sizeof (Dwg_LEADER_Line*),  OFF (struct _dwg_LEADER_Node, lines),
    1,1,0, 0 },
  { "num_breaks",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LEADER_Node, num_breaks),
    0,0,0, 0 },
  { "breaks",	"Dwg_LEADER_Break*", sizeof (Dwg_LEADER_Break*),  OFF (struct _dwg_LEADER_Node, breaks),
    1,1,0, 0 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LEADER_Node, attach_dir),
    0,0,0, 271 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LIGHTLIST_light: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LIGHTLIST_light_fields[] = {
  { "parent",	"struct _dwg_object_LIGHTLIST*", sizeof (void *),  OFF (struct _dwg_LIGHTLIST_light, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_LIGHTLIST_light, name),
    1,1,1, 1 },
  { "handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LIGHTLIST_light, handle),
    1,0,0, 5 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LTYPE_dash: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LTYPE_dash_fields[] = {
  { "parent",	"struct _dwg_object_LTYPE*", sizeof (void *),  OFF (struct _dwg_LTYPE_dash, parent),
    1,1,0, 0 },
  { "length",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LTYPE_dash, length),
    0,0,0, 49 },
  { "complex_shapecode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LTYPE_dash, complex_shapecode),
    0,0,0, 75 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_LTYPE_dash, style),
    1,0,0, 340 },
  { "x_offset",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_LTYPE_dash, x_offset),
    0,0,0, 44 },
  { "y_offset",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_LTYPE_dash, y_offset),
    0,0,0, 45 },
  { "scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LTYPE_dash, scale),
    0,0,0, 46 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LTYPE_dash, rotation),
    0,0,0, 50 },
  { "shape_flag",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_LTYPE_dash, shape_flag),
    0,0,0, 74 },
  { "text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_LTYPE_dash, text),
    1,1,1, 9 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LWPOLYLINE_width: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LWPOLYLINE_width_fields[] = {
  { "start",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LWPOLYLINE_width, start),
    0,0,0, 40 },
  { "end",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_LWPOLYLINE_width, end),
    0,0,0, 41 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LinkedData: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LinkedData_fields[] = {
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_LinkedData, name),
    1,1,1, 1 },
  { "description",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_LinkedData, description),
    1,1,1, 300 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_LinkedTableData: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_LinkedTableData_fields[] = {
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LinkedTableData, num_cols),
    0,0,0, 90 },
  { "cols",	"Dwg_TableDataColumn*", sizeof (Dwg_TableDataColumn*),  OFF (struct _dwg_LinkedTableData, cols),
    1,1,0, 0 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LinkedTableData, num_rows),
    0,0,0, 90 },
  { "rows",	"Dwg_TableRow*", sizeof (Dwg_TableRow*),  OFF (struct _dwg_LinkedTableData, rows),
    1,1,0, 0 },
  { "num_field_refs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_LinkedTableData, num_field_refs),
    0,0,0, 0 },
  { "field_refs",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_LinkedTableData, field_refs),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MATERIAL_color: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MATERIAL_color_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_MATERIAL_color, parent),
    1,1,0, 0 },
  { "flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MATERIAL_color, flag),
    0,0,0, 0 },
  { "factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MATERIAL_color, factor),
    0,0,0, 0 },
  { "rgb",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MATERIAL_color, rgb),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MATERIAL_gentexture: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MATERIAL_gentexture_fields[] = {
  { "parent",	"struct _dwg_object_MATERIAL*", sizeof (void *),  OFF (struct _dwg_MATERIAL_gentexture, parent),
    1,1,0, 0 },
  { "genprocname",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_MATERIAL_gentexture, genprocname),
    1,1,1, 0 },
  { "material",	"struct _dwg_object_MATERIAL*", sizeof (void *),  OFF (struct _dwg_MATERIAL_gentexture, material),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MATERIAL_mapper: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MATERIAL_mapper_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_MATERIAL_mapper, parent),
    1,1,0, 0 },
  { "blendfactor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MATERIAL_mapper, blendfactor),
    0,0,0, 0 },
  { "transmatrix",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_MATERIAL_mapper, transmatrix),
    1,1,0, 0 },
  { "filename",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_MATERIAL_mapper, filename),
    1,1,1, 0 },
  { "color1",	"Dwg_MATERIAL_color", sizeof (Dwg_MATERIAL_color),  OFF (struct _dwg_MATERIAL_mapper, color1),
    0,0,0, 0 },
  { "color2",	"Dwg_MATERIAL_color", sizeof (Dwg_MATERIAL_color),  OFF (struct _dwg_MATERIAL_mapper, color2),
    0,0,0, 0 },
  { "source",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MATERIAL_mapper, source),
    0,0,0, 0 },
  { "projection",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MATERIAL_mapper, projection),
    0,0,0, 0 },
  { "tiling",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MATERIAL_mapper, tiling),
    0,0,0, 0 },
  { "autotransform",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MATERIAL_mapper, autotransform),
    0,0,0, 0 },
  { "texturemode",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MATERIAL_mapper, texturemode),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MESH_edge: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MESH_edge_fields[] = {
  { "parent",	"struct _dwg_entity_MESH*", sizeof (void *),  OFF (struct _dwg_MESH_edge, parent),
    1,1,0, 0 },
  { "idxfrom",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MESH_edge, idxfrom),
    0,0,0, 90 },
  { "idxto",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MESH_edge, idxto),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLEADER_AnnotContext: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADER_AnnotContext_fields[] = {
  { "num_leaders",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MLEADER_AnnotContext, num_leaders),
    0,0,0, 0 },
  { "leaders",	"Dwg_LEADER_Node*", sizeof (Dwg_LEADER_Node*),  OFF (struct _dwg_MLEADER_AnnotContext, leaders),
    1,1,0, 0 },
  { "attach_dir",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, attach_dir),
    0,0,0, 0 },
  { "scale_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, scale_factor),
    0,0,0, 40 },
  { "content_base",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, content_base),
    1,0,0, 10 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, text_height),
    0,0,0, 41 },
  { "arrow_size",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, arrow_size),
    0,0,0, 140 },
  { "landing_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_AnnotContext, landing_gap),
    0,0,0, 145 },
  { "text_left",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_left),
    0,0,0, 174 },
  { "text_right",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_right),
    0,0,0, 175 },
  { "text_angletype",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_angletype),
    0,0,0, 176 },
  { "text_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_alignment),
    0,0,0, 177 },
  { "has_content_txt",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, has_content_txt),
    0,0,0, 290 },
  { "has_content_blk",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, has_content_blk),
    0,0,0, 296 },
  { "content",	"Dwg_MLEADER_Content", sizeof (Dwg_MLEADER_Content),  OFF (struct _dwg_MLEADER_AnnotContext, content),
    0,0,0, 0 },
  { "base",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, base),
    1,0,0, 110 },
  { "base_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, base_dir),
    1,0,0, 111 },
  { "base_vert",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_AnnotContext, base_vert),
    1,0,0, 112 },
  { "is_normal_reversed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_AnnotContext, is_normal_reversed),
    0,0,0, 297 },
  { "text_top",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_top),
    0,0,0, 273 },
  { "text_bottom",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_AnnotContext, text_bottom),
    0,0,0, 272 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLEADER_Content_Block: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADER_Content_Block_fields[] = {
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MLEADER_Content_Block, type),
    0,0,0, 0 },
  { "normal",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_Content_Block, normal),
    1,0,0, 0 },
  { "location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_Content_Block, location),
    1,0,0, 0 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_Block, rotation),
    0,0,0, 0 },
  { "block_table",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_MLEADER_Content_Block, block_table),
    1,0,0, 0 },
  { "scale",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_Content_Block, scale),
    1,0,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_MLEADER_Content_Block, color),
    0,0,0, 0 },
  { "transform",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_MLEADER_Content_Block, transform),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLEADER_Content_MText: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADER_Content_MText_fields[] = {
  { "type",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MLEADER_Content_MText, type),
    0,0,0, 0 },
  { "normal",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_Content_MText, normal),
    1,0,0, 0 },
  { "location",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_Content_MText, location),
    1,0,0, 0 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_MText, rotation),
    0,0,0, 0 },
  { "default_text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_MLEADER_Content_MText, default_text),
    1,1,1, 0 },
  { "style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_MLEADER_Content_MText, style),
    1,0,0, 0 },
  { "direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLEADER_Content_MText, direction),
    1,0,0, 0 },
  { "width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_MText, width),
    0,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_MText, height),
    0,0,0, 0 },
  { "line_spacing_factor",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_MText, line_spacing_factor),
    0,0,0, 0 },
  { "line_spacing_style",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_Content_MText, line_spacing_style),
    0,0,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_MLEADER_Content_MText, color),
    0,0,0, 0 },
  { "alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_Content_MText, alignment),
    0,0,0, 0 },
  { "flow",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_Content_MText, flow),
    0,0,0, 0 },
  { "bg_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_MLEADER_Content_MText, bg_color),
    0,0,0, 0 },
  { "bg_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_MText, bg_scale),
    0,0,0, 0 },
  { "bg_transparency",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MLEADER_Content_MText, bg_transparency),
    0,0,0, 0 },
  { "is_bg_fill",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_Content_MText, is_bg_fill),
    0,0,0, 0 },
  { "is_bg_mask_fill",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_Content_MText, is_bg_mask_fill),
    0,0,0, 0 },
  { "col_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLEADER_Content_MText, col_type),
    0,0,0, 0 },
  { "is_height_auto",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_Content_MText, is_height_auto),
    0,0,0, 0 },
  { "col_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_MText, col_width),
    0,0,0, 0 },
  { "col_gutter",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLEADER_Content_MText, col_gutter),
    0,0,0, 0 },
  { "is_col_flow_reversed",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_Content_MText, is_col_flow_reversed),
    0,0,0, 0 },
  { "num_col_sizes",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_MLEADER_Content_MText, num_col_sizes),
    0,0,0, 0 },
  { "col_sizes",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_MLEADER_Content_MText, col_sizes),
    1,1,0, 0 },
  { "word_break",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_Content_MText, word_break),
    0,0,0, 0 },
  { "unknown",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_MLEADER_Content_MText, unknown),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLINESTYLE_line: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINESTYLE_line_fields[] = {
  { "parent",	"struct _dwg_object_MLINESTYLE*", sizeof (void *),  OFF (struct _dwg_MLINESTYLE_line, parent),
    1,1,0, 0 },
  { "offset",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_MLINESTYLE_line, offset),
    0,0,0, 49 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_MLINESTYLE_line, color),
    0,0,0, 62 },
  { "lt_index",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_MLINESTYLE_line, lt_index),
    0,0,0, 6 },
  { "lt_ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_MLINESTYLE_line, lt_ltype),
    1,0,0, 6 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLINE_line: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINE_line_fields[] = {
  { "parent",	"struct _dwg_MLINE_vertex*", sizeof (void *),  OFF (struct _dwg_MLINE_line, parent),
    1,1,0, 0 },
  { "num_segparms",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLINE_line, num_segparms),
    0,0,0, 74 },
  { "segparms",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_MLINE_line, segparms),
    1,1,0, 0 },
  { "num_areafillparms",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_MLINE_line, num_areafillparms),
    0,0,0, 75 },
  { "areafillparms",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_MLINE_line, areafillparms),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_MLINE_vertex: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLINE_vertex_fields[] = {
  { "parent",	"struct _dwg_entity_MLINE*", sizeof (void *),  OFF (struct _dwg_MLINE_vertex, parent),
    1,1,0, 0 },
  { "vertex",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLINE_vertex, vertex),
    1,0,0, 11 },
  { "vertex_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLINE_vertex, vertex_direction),
    1,0,0, 12 },
  { "miter_direction",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_MLINE_vertex, miter_direction),
    1,0,0, 13 },
  { "num_lines",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_MLINE_vertex, num_lines),
    0,0,0, 0 },
  { "lines",	"Dwg_MLINE_line*", sizeof (Dwg_MLINE_line*),  OFF (struct _dwg_MLINE_vertex, lines),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_OCD_Dimension: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_OCD_Dimension_fields[] = {
  { "b293",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, b293),
    0,0,0, 293 },
  { "def_pt",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_OCD_Dimension, def_pt),
    1,0,0, 10 },
  { "is_def_textloc",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, is_def_textloc),
    0,0,0, 294 },
  { "text_rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_OCD_Dimension, text_rotation),
    0,0,0, 140 },
  { "block",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_OCD_Dimension, block),
    1,0,0, 2 },
  { "dimtofl",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, dimtofl),
    0,0,0, 298 },
  { "dimosxd",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, dimosxd),
    0,0,0, 291 },
  { "dimatfit",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, dimatfit),
    0,0,0, 70 },
  { "dimtix",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, dimtix),
    0,0,0, 292 },
  { "dimtmove",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, dimtmove),
    0,0,0, 71 },
  { "override_code",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_OCD_Dimension, override_code),
    0,0,0, 280 },
  { "has_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, has_arrow2),
    0,0,0, 295 },
  { "flip_arrow2",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, flip_arrow2),
    0,0,0, 296 },
  { "flip_arrow1",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_OCD_Dimension, flip_arrow1),
    0,0,0, 297 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_PARTIAL_VIEWING_INDEX_Entry: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PARTIAL_VIEWING_INDEX_Entry_fields[] = {
  { "parent",	"struct _dwg_object_PARTIAL_VIEWING_INDEX*", sizeof (void *),  OFF (struct _dwg_PARTIAL_VIEWING_INDEX_Entry, parent),
    1,1,0, 0 },
  { "extents_min",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_PARTIAL_VIEWING_INDEX_Entry, extents_min),
    1,0,0, 0 },
  { "extents_max",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_PARTIAL_VIEWING_INDEX_Entry, extents_max),
    1,0,0, 0 },
  { "object",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_PARTIAL_VIEWING_INDEX_Entry, object),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_POINTCLOUDCOLORMAP_Ramp: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDCOLORMAP_Ramp_fields[] = {
  { "parent",	"struct _dwg_object_POINTCLOUDCOLORMAP*", sizeof (void *),  OFF (struct _dwg_POINTCLOUDCOLORMAP_Ramp, parent),
    1,1,0, 0 },
  { "class_version",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_POINTCLOUDCOLORMAP_Ramp, class_version),
    0,0,0, 70 },
  { "num_ramps",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_POINTCLOUDCOLORMAP_Ramp, num_ramps),
    0,0,0, 90 },
  { "ramps",	"Dwg_ColorRamp*", sizeof (Dwg_ColorRamp*),  OFF (struct _dwg_POINTCLOUDCOLORMAP_Ramp, ramps),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_POINTCLOUDEX_Croppings: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUDEX_Croppings_fields[] = {
  { "parent",	"struct _dwg_entity_POINTCLOUDEX*", sizeof (void *),  OFF (struct _dwg_POINTCLOUDEX_Croppings, parent),
    1,1,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_POINTCLOUDEX_Croppings, type),
    0,0,0, 280 },
  { "is_inside",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_POINTCLOUDEX_Croppings, is_inside),
    0,0,0, 290 },
  { "is_inverted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_POINTCLOUDEX_Croppings, is_inverted),
    0,0,0, 290 },
  { "crop_plane",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_POINTCLOUDEX_Croppings, crop_plane),
    1,0,0, 13 },
  { "crop_x_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_POINTCLOUDEX_Croppings, crop_x_dir),
    1,0,0, 213 },
  { "crop_y_dir",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_POINTCLOUDEX_Croppings, crop_y_dir),
    1,0,0, 213 },
  { "num_pts",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_POINTCLOUDEX_Croppings, num_pts),
    0,0,0, 93 },
  { "pts",	"3BD*", sizeof (BITCODE_3BD*),  OFF (struct _dwg_POINTCLOUDEX_Croppings, pts),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_POINTCLOUD_Clippings: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUD_Clippings_fields[] = {
  { "parent",	"struct _dwg_entity_POINTCLOUD*", sizeof (void *),  OFF (struct _dwg_POINTCLOUD_Clippings, parent),
    1,1,0, 0 },
  { "is_inverted",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_POINTCLOUD_Clippings, is_inverted),
    0,0,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_POINTCLOUD_Clippings, type),
    0,0,0, 0 },
  { "num_vertices",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_POINTCLOUD_Clippings, num_vertices),
    0,0,0, 0 },
  { "vertices",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_POINTCLOUD_Clippings, vertices),
    1,1,0, 0 },
  { "z_min",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_POINTCLOUD_Clippings, z_min),
    0,0,0, 0 },
  { "z_max",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_POINTCLOUD_Clippings, z_max),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_POINTCLOUD_IntensityStyle: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_POINTCLOUD_IntensityStyle_fields[] = {
  { "parent",	"struct _dwg_entity_POINTCLOUD*", sizeof (void *),  OFF (struct _dwg_POINTCLOUD_IntensityStyle, parent),
    1,1,0, 0 },
  { "min_intensity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_POINTCLOUD_IntensityStyle, min_intensity),
    0,0,0, 0 },
  { "max_intensity",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_POINTCLOUD_IntensityStyle, max_intensity),
    0,0,0, 0 },
  { "intensity_low_treshold",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_POINTCLOUD_IntensityStyle, intensity_low_treshold),
    0,0,0, 0 },
  { "intensity_high_treshold",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_POINTCLOUD_IntensityStyle, intensity_high_treshold),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_PROXY_LWPOLYLINE: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_PROXY_LWPOLYLINE_fields[] = {
  { "parent",	"struct _dwg_entity_PROXY_ENTITY*", sizeof (void *),  OFF (struct _dwg_PROXY_LWPOLYLINE, parent),
    1,1,0, 0 },
  { "size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_PROXY_LWPOLYLINE, size),
    0,0,0, 0 },
  { "flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_PROXY_LWPOLYLINE, flags),
    0,0,0, 0 },
  { "const_width",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_PROXY_LWPOLYLINE, const_width),
    0,0,0, 0 },
  { "elevation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_PROXY_LWPOLYLINE, elevation),
    0,0,0, 0 },
  { "thickness",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_PROXY_LWPOLYLINE, thickness),
    0,0,0, 0 },
  { "extrusion",	"BE", sizeof (BITCODE_BE),  OFF (struct _dwg_PROXY_LWPOLYLINE, extrusion),
    0,0,0, 0 },
  { "num_points",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_PROXY_LWPOLYLINE, num_points),
    0,0,0, 0 },
  { "points",	"2RD*", sizeof (BITCODE_2RD*),  OFF (struct _dwg_PROXY_LWPOLYLINE, points),
    1,1,0, 0 },
  { "num_bulges",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_PROXY_LWPOLYLINE, num_bulges),
    0,0,0, 0 },
  { "bulges",	"BD*", sizeof (BITCODE_BD*),  OFF (struct _dwg_PROXY_LWPOLYLINE, bulges),
    1,1,0, 0 },
  { "num_widths",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_PROXY_LWPOLYLINE, num_widths),
    0,0,0, 0 },
  { "widths",	"Dwg_LWPOLYLINE_width*", sizeof (Dwg_LWPOLYLINE_width*),  OFF (struct _dwg_PROXY_LWPOLYLINE, widths),
    1,1,0, 0 },
  { "unknown_1",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_PROXY_LWPOLYLINE, unknown_1),
    0,0,0, 0 },
  { "unknown_2",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_PROXY_LWPOLYLINE, unknown_2),
    0,0,0, 0 },
  { "unknown_3",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_PROXY_LWPOLYLINE, unknown_3),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_R2004_Header: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_R2004_Header_fields[] = {
  { "file_ID_string[12]",	"RC", 12 * sizeof (BITCODE_RC),  OFF (struct _dwg_R2004_Header, file_ID_string),
    0,0,0, 0 },
  { "header_address",	"RLx", sizeof (BITCODE_RLx),  OFF (struct _dwg_R2004_Header, header_address),
    0,0,0, 0 },
  { "header_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, header_size),
    0,0,0, 0 },
  { "x04",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, x04),
    0,0,0, 0 },
  { "root_tree_node_gap",	"RLd", sizeof (BITCODE_RLd),  OFF (struct _dwg_R2004_Header, root_tree_node_gap),
    0,0,0, 0 },
  { "lowermost_left_tree_node_gap",	"RLd", sizeof (BITCODE_RLd),  OFF (struct _dwg_R2004_Header, lowermost_left_tree_node_gap),
    0,0,0, 0 },
  { "lowermost_right_tree_node_gap",	"RLd", sizeof (BITCODE_RLd),  OFF (struct _dwg_R2004_Header, lowermost_right_tree_node_gap),
    0,0,0, 0 },
  { "unknown_long",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, unknown_long),
    0,0,0, 0 },
  { "last_section_id",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, last_section_id),
    0,0,0, 0 },
  { "last_section_address",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_R2004_Header, last_section_address),
    0,0,0, 0 },
  { "second_header_address",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_R2004_Header, second_header_address),
    0,0,0, 0 },
  { "numgaps",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, numgaps),
    0,0,0, 0 },
  { "numsections",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, numsections),
    0,0,0, 0 },
  { "x20",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, x20),
    0,0,0, 0 },
  { "x80",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, x80),
    0,0,0, 0 },
  { "x40",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, x40),
    0,0,0, 0 },
  { "section_map_id",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, section_map_id),
    0,0,0, 0 },
  { "section_map_address",	"RLL", sizeof (BITCODE_RLL),  OFF (struct _dwg_R2004_Header, section_map_address),
    0,0,0, 0 },
  { "section_info_id",	"RLd", sizeof (BITCODE_RLd),  OFF (struct _dwg_R2004_Header, section_info_id),
    0,0,0, 0 },
  { "section_array_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, section_array_size),
    0,0,0, 0 },
  { "gap_array_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, gap_array_size),
    0,0,0, 0 },
  { "crc32",	"RLx", sizeof (BITCODE_RLx),  OFF (struct _dwg_R2004_Header, crc32),
    0,0,0, 0 },
  { "padding[12]",	"RC", 12 * sizeof (BITCODE_RC),  OFF (struct _dwg_R2004_Header, padding),
    0,0,0, 0 },
  { "section_type",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, section_type),
    0,0,0, 0 },
  { "decomp_data_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, decomp_data_size),
    0,0,0, 0 },
  { "comp_data_size",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, comp_data_size),
    0,0,0, 0 },
  { "compression_type",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_R2004_Header, compression_type),
    0,0,0, 0 },
  { "checksum",	"RLx", sizeof (BITCODE_RLx),  OFF (struct _dwg_R2004_Header, checksum),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SECTION_geometrysettings: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SECTION_geometrysettings_fields[] = {
  { "parent",	"struct _dwg_SECTION_typesettings*", sizeof (void *),  OFF (struct _dwg_SECTION_geometrysettings, parent),
    1,1,0, 0 },
  { "num_geoms",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SECTION_geometrysettings, num_geoms),
    0,0,0, 90 },
  { "hexindex",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SECTION_geometrysettings, hexindex),
    0,0,0, 91 },
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SECTION_geometrysettings, flags),
    0,0,0, 92 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_SECTION_geometrysettings, color),
    0,0,0, 62 },
  { "layer",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_SECTION_geometrysettings, layer),
    1,1,1, 8 },
  { "ltype",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_SECTION_geometrysettings, ltype),
    1,1,1, 6 },
  { "ltype_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_SECTION_geometrysettings, ltype_scale),
    0,0,0, 40 },
  { "plotstyle",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_SECTION_geometrysettings, plotstyle),
    1,1,1, 1 },
  { "linewt",	"BLd", sizeof (BITCODE_BLd),  OFF (struct _dwg_SECTION_geometrysettings, linewt),
    0,0,0, 370 },
  { "face_transparency",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_SECTION_geometrysettings, face_transparency),
    0,0,0, 70 },
  { "edge_transparency",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_SECTION_geometrysettings, edge_transparency),
    0,0,0, 71 },
  { "hatch_type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_SECTION_geometrysettings, hatch_type),
    0,0,0, 72 },
  { "hatch_pattern",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_SECTION_geometrysettings, hatch_pattern),
    1,1,1, 2 },
  { "hatch_angle",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_SECTION_geometrysettings, hatch_angle),
    0,0,0, 41 },
  { "hatch_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_SECTION_geometrysettings, hatch_spacing),
    0,0,0, 42 },
  { "hatch_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_SECTION_geometrysettings, hatch_scale),
    0,0,0, 43 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SECTION_typesettings: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SECTION_typesettings_fields[] = {
  { "parent",	"struct _dwg_object_SECTION_SETTINGS*", sizeof (void *),  OFF (struct _dwg_SECTION_typesettings, parent),
    1,1,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_SECTION_typesettings, type),
    0,0,0, 90 },
  { "generation",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_SECTION_typesettings, generation),
    0,0,0, 91 },
  { "num_sources",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SECTION_typesettings, num_sources),
    0,0,0, 92 },
  { "sources",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_SECTION_typesettings, sources),
    1,1,0, 330 },
  { "destblock",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_SECTION_typesettings, destblock),
    1,0,0, 331 },
  { "destfile",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_SECTION_typesettings, destfile),
    1,1,1, 1 },
  { "num_geom",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SECTION_typesettings, num_geom),
    0,0,0, 93 },
  { "geom",	"Dwg_SECTION_geometrysettings*", sizeof (Dwg_SECTION_geometrysettings*),  OFF (struct _dwg_SECTION_typesettings, geom),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SPLINE_control_point: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SPLINE_control_point_fields[] = {
  { "parent",	"struct _dwg_entity_SPLINE*", sizeof (void *),  OFF (struct _dwg_SPLINE_control_point, parent),
    1,1,0, 0 },
  { "x",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, x),
    0,0,0, 0 },
  { "y",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, y),
    0,0,0, 0 },
  { "z",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, z),
    0,0,0, 0 },
  { "w",	"BD", sizeof (double),  OFF (struct _dwg_SPLINE_control_point, w),
    0,0,0, 41 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SUNSTUDY_Dates: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SUNSTUDY_Dates_fields[] = {
  { "julian_day",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SUNSTUDY_Dates, julian_day),
    0,0,0, 90 },
  { "msecs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_SUNSTUDY_Dates, msecs),
    0,0,0, 90 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_SummaryInfo_Property: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_SummaryInfo_Property_fields[] = {
  { "tag",	"TU", sizeof (BITCODE_TU),  OFF (struct _dwg_SummaryInfo_Property, tag),
    1,1,1, 0 },
  { "value",	"TU", sizeof (BITCODE_TU),  OFF (struct _dwg_SummaryInfo_Property, value),
    1,1,1, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLEGEOMETRY_Cell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLEGEOMETRY_Cell_fields[] = {
  { "parent",	"struct _dwg_object_TABLEGEOMETRY*", sizeof (void *),  OFF (struct _dwg_TABLEGEOMETRY_Cell, parent),
    1,1,0, 0 },
  { "geom_data_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLEGEOMETRY_Cell, geom_data_flag),
    0,0,0, 93 },
  { "width_w_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLEGEOMETRY_Cell, width_w_gap),
    0,0,0, 40 },
  { "height_w_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLEGEOMETRY_Cell, height_w_gap),
    0,0,0, 41 },
  { "tablegeometry",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLEGEOMETRY_Cell, tablegeometry),
    1,0,0, 330 },
  { "num_geometry",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLEGEOMETRY_Cell, num_geometry),
    0,0,0, 94 },
  { "geometry",	"Dwg_CellContentGeometry*", sizeof (Dwg_CellContentGeometry*),  OFF (struct _dwg_TABLEGEOMETRY_Cell, geometry),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLESTYLE_CellStyle: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_CellStyle_fields[] = {
  { "parent",	"struct _dwg_object_TABLESTYLE*", sizeof (void *),  OFF (struct _dwg_TABLESTYLE_CellStyle, parent),
    1,1,0, 0 },
  { "id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_CellStyle, id),
    0,0,0, 90 },
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_CellStyle, type),
    0,0,0, 91 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TABLESTYLE_CellStyle, name),
    1,1,1, 300 },
  { "cellstyle.type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.type),
    0,0,0, 0 },
  { "cellstyle.data_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.data_flags),
    0,0,0, 0 },
  { "cellstyle.property_override_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.property_override_flags),
    0,0,0, 0 },
  { "cellstyle.merge_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.merge_flags),
    0,0,0, 0 },
  { "cellstyle.bg_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.bg_color),
    0,0,0, 0 },
  { "cellstyle.content_layout",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.content_layout),
    0,0,0, 0 },
  { "cellstyle.content_format",	"Dwg_ContentFormat", sizeof (Dwg_ContentFormat),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.content_format),
    0,0,0, 0 },
  { "cellstyle.margin_override_flags",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.margin_override_flags),
    0,0,0, 0 },
  { "cellstyle.vert_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.vert_margin),
    0,0,0, 0 },
  { "cellstyle.horiz_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.horiz_margin),
    0,0,0, 0 },
  { "cellstyle.bottom_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.bottom_margin),
    0,0,0, 0 },
  { "cellstyle.right_margin",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.right_margin),
    0,0,0, 0 },
  { "cellstyle.margin_horiz_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.margin_horiz_spacing),
    0,0,0, 0 },
  { "cellstyle.margin_vert_spacing",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.margin_vert_spacing),
    0,0,0, 0 },
  { "cellstyle.num_borders",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.num_borders),
    0,0,0, 0 },
  { "cellstyle.borders",	"Dwg_GridFormat*", sizeof (Dwg_GridFormat*),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.borders),
    1,1,0, 0 },
  { "cellstyle.tablerow_parent",	"struct _dwg_TableRow*", sizeof (void *),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.tablerow_parent),
    1,1,0, 0 },
  { "cellstyle.tabledatacolumn_parent",	"struct _dwg_TableDataColumn*", sizeof (void *),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle.tabledatacolumn_parent),
    1,1,0, 0 },
  { "cellstyle",	"struct _dwg_CellStyle", sizeof (struct _dwg_CellStyle),  OFF (struct _dwg_TABLESTYLE_CellStyle, cellstyle),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLESTYLE_border: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_border_fields[] = {
  { "linewt",	"BSd", sizeof (BITCODE_BSd),  OFF (struct _dwg_TABLESTYLE_border, linewt),
    0,0,0, 0 },
  { "visible",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLESTYLE_border, visible),
    0,0,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLESTYLE_border, color),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLESTYLE_rowstyles: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLESTYLE_rowstyles_fields[] = {
  { "parent",	"struct _dwg_object_TABLESTYLE*", sizeof (void *),  OFF (struct _dwg_TABLESTYLE_rowstyles, parent),
    1,1,0, 0 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_style),
    1,0,0, 7 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_height),
    0,0,0, 140 },
  { "text_alignment",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_alignment),
    0,0,0, 170 },
  { "text_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLESTYLE_rowstyles, text_color),
    0,0,0, 62 },
  { "fill_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLESTYLE_rowstyles, fill_color),
    0,0,0, 63 },
  { "has_bgcolor",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLESTYLE_rowstyles, has_bgcolor),
    0,0,0, 283 },
  { "num_borders",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_rowstyles, num_borders),
    0,0,0, 0 },
  { "borders",	"Dwg_TABLESTYLE_border*", sizeof (Dwg_TABLESTYLE_border*),  OFF (struct _dwg_TABLESTYLE_rowstyles, borders),
    1,1,0, 0 },
  { "data_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_rowstyles, data_type),
    0,0,0, 90 },
  { "unit_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLESTYLE_rowstyles, unit_type),
    0,0,0, 91 },
  { "format_string",	"TU", sizeof (BITCODE_TU),  OFF (struct _dwg_TABLESTYLE_rowstyles, format_string),
    1,1,1, 1 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_AttrDef: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_AttrDef_fields[] = {
  { "parent",	"struct _dwg_TABLE_Cell*", sizeof (void *),  OFF (struct _dwg_TABLE_AttrDef, parent),
    1,1,0, 0 },
  { "attdef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLE_AttrDef, attdef),
    1,0,0, 331 },
  { "index",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_AttrDef, index),
    0,0,0, 179 },
  { "text",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TABLE_AttrDef, text),
    1,1,1, 300 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_BreakHeight: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_BreakHeight_fields[] = {
  { "parent",	"struct _dwg_entity_TABLE*", sizeof (void *),  OFF (struct _dwg_TABLE_BreakHeight, parent),
    1,1,0, 0 },
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_TABLE_BreakHeight, position),
    1,0,0, 0 },
  { "height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_BreakHeight, height),
    0,0,0, 0 },
  { "flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_BreakHeight, flag),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_BreakRow: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_BreakRow_fields[] = {
  { "parent",	"struct _dwg_entity_TABLE*", sizeof (void *),  OFF (struct _dwg_TABLE_BreakRow, parent),
    1,1,0, 0 },
  { "position",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_TABLE_BreakRow, position),
    1,0,0, 0 },
  { "start",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_BreakRow, start),
    0,0,0, 0 },
  { "end",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_BreakRow, end),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_Cell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_Cell_fields[] = {
  { "parent",	"struct _dwg_entity_TABLE*", sizeof (void *),  OFF (struct _dwg_TABLE_Cell, parent),
    1,1,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, type),
    0,0,0, 171 },
  { "flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_TABLE_Cell, flags),
    0,0,0, 172 },
  { "is_merged_value",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, is_merged_value),
    0,0,0, 173 },
  { "is_autofit_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, is_autofit_flag),
    0,0,0, 174 },
  { "merged_width_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, merged_width_flag),
    0,0,0, 175 },
  { "merged_height_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, merged_height_flag),
    0,0,0, 176 },
  { "rotation",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_Cell, rotation),
    0,0,0, 145 },
  { "text_value",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TABLE_Cell, text_value),
    1,1,1, 1 },
  { "text_style",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLE_Cell, text_style),
    1,0,0, 7 },
  { "block_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLE_Cell, block_handle),
    1,0,0, 340 },
  { "block_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_Cell, block_scale),
    0,0,0, 144 },
  { "additional_data_flag",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, additional_data_flag),
    0,0,0, 0 },
  { "cell_flag_override",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, cell_flag_override),
    0,0,0, 177 },
  { "virtual_edge_flag",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_TABLE_Cell, virtual_edge_flag),
    0,0,0, 178 },
  { "cell_alignment",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_TABLE_Cell, cell_alignment),
    0,0,0, 170 },
  { "bg_fill_none",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_TABLE_Cell, bg_fill_none),
    0,0,0, 283 },
  { "bg_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, bg_color),
    0,0,0, 63 },
  { "content_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, content_color),
    0,0,0, 64 },
  { "text_height",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_Cell, text_height),
    0,0,0, 140 },
  { "top_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, top_grid_color),
    0,0,0, 69 },
  { "top_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, top_grid_linewt),
    0,0,0, 279 },
  { "top_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, top_visibility),
    0,0,0, 289 },
  { "right_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, right_grid_color),
    0,0,0, 65 },
  { "right_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, right_grid_linewt),
    0,0,0, 275 },
  { "right_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, right_visibility),
    0,0,0, 285 },
  { "bottom_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, bottom_grid_color),
    0,0,0, 66 },
  { "bottom_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, bottom_grid_linewt),
    0,0,0, 276 },
  { "bottom_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, bottom_visibility),
    0,0,0, 286 },
  { "left_grid_color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_TABLE_Cell, left_grid_color),
    0,0,0, 68 },
  { "left_grid_linewt",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, left_grid_linewt),
    0,0,0, 278 },
  { "left_visibility",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TABLE_Cell, left_visibility),
    0,0,0, 288 },
  { "unknown",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, unknown),
    0,0,0, 0 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_TABLE_Cell, value),
    0,0,0, 0 },
  { "num_attr_defs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_Cell, num_attr_defs),
    0,0,0, 0 },
  { "attr_defs",	"Dwg_TABLE_AttrDef*", sizeof (Dwg_TABLE_AttrDef*),  OFF (struct _dwg_TABLE_Cell, attr_defs),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_CustomDataItem: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_CustomDataItem_fields[] = {
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TABLE_CustomDataItem, name),
    1,1,1, 300 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_TABLE_CustomDataItem, value),
    0,0,0, 0 },
  { "cell_parent",	"struct _dwg_TableCell*", sizeof (void *),  OFF (struct _dwg_TABLE_CustomDataItem, cell_parent),
    1,1,0, 0 },
  { "row_parent",	"struct _dwg_TableRow*", sizeof (void *),  OFF (struct _dwg_TABLE_CustomDataItem, row_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TABLE_value: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TABLE_value_fields[] = {
  { "flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, flags),
    0,0,0, 0 },
  { "format_flags",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, format_flags),
    0,0,0, 0 },
  { "data_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, data_type),
    0,0,0, 90 },
  { "data_size",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, data_size),
    0,0,0, 92 },
  { "data_long",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, data_long),
    0,0,0, 91 },
  { "data_double",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TABLE_value, data_double),
    0,0,0, 140 },
  { "data_string",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TABLE_value, data_string),
    1,1,1, 1 },
  { "data_date",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_TABLE_value, data_date),
    1,1,0, 0 },
  { "data_point",	"2RD", sizeof (BITCODE_2RD),  OFF (struct _dwg_TABLE_value, data_point),
    1,0,0, 11 },
  { "data_3dpoint",	"3RD", sizeof (BITCODE_3RD),  OFF (struct _dwg_TABLE_value, data_3dpoint),
    1,0,0, 11 },
  { "data_handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TABLE_value, data_handle),
    1,0,0, 0 },
  { "unit_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TABLE_value, unit_type),
    0,0,0, 94 },
  { "format_string",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TABLE_value, format_string),
    1,1,1, 300 },
  { "value_string",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TABLE_value, value_string),
    1,1,1, 302 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableCell: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableCell_fields[] = {
  { "flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, flag),
    0,0,0, 90 },
  { "tooltip",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TableCell, tooltip),
    1,1,1, 300 },
  { "customdata",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, customdata),
    0,0,0, 91 },
  { "num_customdata_items",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_customdata_items),
    0,0,0, 90 },
  { "customdata_items",	"Dwg_TABLE_CustomDataItem*", sizeof (Dwg_TABLE_CustomDataItem*),  OFF (struct _dwg_TableCell, customdata_items),
    1,1,0, 0 },
  { "has_linked_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, has_linked_data),
    0,0,0, 0 },
  { "data_link",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCell, data_link),
    1,0,0, 0 },
  { "num_rows",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_rows),
    0,0,0, 0 },
  { "num_cols",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_cols),
    0,0,0, 0 },
  { "unknown",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, unknown),
    0,0,0, 0 },
  { "num_cell_contents",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_cell_contents),
    0,0,0, 0 },
  { "cell_contents",	"Dwg_TableCellContent*", sizeof (Dwg_TableCellContent*),  OFF (struct _dwg_TableCell, cell_contents),
    1,1,0, 0 },
  { "style_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, style_id),
    0,0,0, 0 },
  { "has_geom_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, has_geom_data),
    0,0,0, 0 },
  { "geom_data_flag",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, geom_data_flag),
    0,0,0, 0 },
  { "width_w_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TableCell, width_w_gap),
    0,0,0, 0 },
  { "height_w_gap",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_TableCell, height_w_gap),
    0,0,0, 0 },
  { "tablegeometry",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCell, tablegeometry),
    1,0,0, 0 },
  { "num_geometry",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCell, num_geometry),
    0,0,0, 0 },
  { "geometry",	"Dwg_CellContentGeometry*", sizeof (Dwg_CellContentGeometry*),  OFF (struct _dwg_TableCell, geometry),
    1,1,0, 0 },
  { "style_parent",	"struct _dwg_CellStyle*", sizeof (void *),  OFF (struct _dwg_TableCell, style_parent),
    1,1,0, 0 },
  { "row_parent",	"struct _dwg_TableRow*", sizeof (void *),  OFF (struct _dwg_TableCell, row_parent),
    1,1,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableCellContent: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableCellContent_fields[] = {
  { "parent",	"struct _dwg_TableCell*", sizeof (void *),  OFF (struct _dwg_TableCellContent, parent),
    1,1,0, 0 },
  { "type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCellContent, type),
    0,0,0, 90 },
  { "value",	"Dwg_TABLE_value", sizeof (Dwg_TABLE_value),  OFF (struct _dwg_TableCellContent, value),
    0,0,0, 0 },
  { "handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCellContent, handle),
    1,0,0, 340 },
  { "num_attrs",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCellContent, num_attrs),
    0,0,0, 91 },
  { "attrs",	"Dwg_TableCellContent_Attr*", sizeof (Dwg_TableCellContent_Attr*),  OFF (struct _dwg_TableCellContent, attrs),
    1,1,0, 0 },
  { "has_content_format_overrides",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_TableCellContent, has_content_format_overrides),
    0,0,0, 0 },
  { "content_format",	"Dwg_ContentFormat", sizeof (Dwg_ContentFormat),  OFF (struct _dwg_TableCellContent, content_format),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableCellContent_Attr: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableCellContent_Attr_fields[] = {
  { "parent",	"struct _dwg_TableCellContent*", sizeof (void *),  OFF (struct _dwg_TableCellContent_Attr, parent),
    1,1,0, 0 },
  { "attdef",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_TableCellContent_Attr, attdef),
    1,0,0, 330 },
  { "value",	"TV", sizeof (BITCODE_TV),  OFF (struct _dwg_TableCellContent_Attr, value),
    1,1,1, 301 },
  { "index",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableCellContent_Attr, index),
    0,0,0, 92 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableDataColumn: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableDataColumn_fields[] = {
  { "parent",	"struct _dwg_LinkedTableData*", sizeof (void *),  OFF (struct _dwg_TableDataColumn, parent),
    1,1,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_TableDataColumn, name),
    1,1,1, 300 },
  { "custom_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableDataColumn, custom_data),
    0,0,0, 91 },
  { "cellstyle",	"Dwg_CellStyle", sizeof (Dwg_CellStyle),  OFF (struct _dwg_TableDataColumn, cellstyle),
    0,0,0, 0 },
  { "cellstyle_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableDataColumn, cellstyle_id),
    0,0,0, 0 },
  { "width",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableDataColumn, width),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_TableRow: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_TableRow_fields[] = {
  { "parent",	"struct _dwg_LinkedTableData*", sizeof (void *),  OFF (struct _dwg_TableRow, parent),
    1,1,0, 0 },
  { "num_cells",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, num_cells),
    0,0,0, 0 },
  { "cells",	"Dwg_TableCell*", sizeof (Dwg_TableCell*),  OFF (struct _dwg_TableRow, cells),
    1,1,0, 0 },
  { "custom_data",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, custom_data),
    0,0,0, 0 },
  { "num_customdata_items",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, num_customdata_items),
    0,0,0, 0 },
  { "customdata_items",	"Dwg_TABLE_CustomDataItem*", sizeof (Dwg_TABLE_CustomDataItem*),  OFF (struct _dwg_TableRow, customdata_items),
    1,1,0, 0 },
  { "cellstyle",	"Dwg_CellStyle", sizeof (Dwg_CellStyle),  OFF (struct _dwg_TableRow, cellstyle),
    0,0,0, 0 },
  { "style_id",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, style_id),
    0,0,0, 0 },
  { "height",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_TableRow, height),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_UCS_orthopts: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_UCS_orthopts_fields[] = {
  { "parent",	"struct _dwg_object_UCS*", sizeof (void *),  OFF (struct _dwg_UCS_orthopts, parent),
    1,1,0, 0 },
  { "type",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_UCS_orthopts, type),
    0,0,0, 71 },
  { "pt",	"3BD", sizeof (BITCODE_3BD),  OFF (struct _dwg_UCS_orthopts, pt),
    1,0,0, 13 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_VALUEPARAM: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VALUEPARAM_fields[] = {
  { "parent",	"struct _dwg_object_object*", sizeof (void *),  OFF (struct _dwg_VALUEPARAM, parent),
    1,1,0, 0 },
  { "class_version",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_VALUEPARAM, class_version),
    0,0,0, 0 },
  { "name",	"T", sizeof (BITCODE_T),  OFF (struct _dwg_VALUEPARAM, name),
    1,1,1, 0 },
  { "unit_type",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_VALUEPARAM, unit_type),
    0,0,0, 0 },
  { "num_vars",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_VALUEPARAM, num_vars),
    0,0,0, 0 },
  { "vars",	"Dwg_VALUEPARAM_vars*", sizeof (Dwg_VALUEPARAM_vars*),  OFF (struct _dwg_VALUEPARAM, vars),
    1,1,0, 0 },
  { "controlled_objdep",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_VALUEPARAM, controlled_objdep),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef struct _dwg_VALUEPARAM_vars: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_VALUEPARAM_vars_fields[] = {
  { "value",	"Dwg_EvalVariant", sizeof (Dwg_EvalVariant),  OFF (struct _dwg_VALUEPARAM_vars, value),
    0,0,0, 0 },
  { "handle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_VALUEPARAM_vars, handle),
    1,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};
/* from typedef union _dwg_MLEADER_Content: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_MLEADER_Content_fields[] = {
  { "txt",	"Dwg_MLEADER_Content_MText", sizeof (Dwg_MLEADER_Content_MText),  OFF (union _dwg_MLEADER_Content, txt),
    0,0,0, 0 },
  { "blk",	"Dwg_MLEADER_Content_Block", sizeof (Dwg_MLEADER_Content_Block),  OFF (union _dwg_MLEADER_Content, blk),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};


/* common fields: */
/* from typedef struct _dwg_object_entity: (sorted by name) */
static const Dwg_DYNAPI_field _dwg_object_entity_fields[] = {
  { "__iterator",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, __iterator),
    0,0,0, 0 },
  { "color",	"CMC", sizeof (BITCODE_CMC),  OFF (struct _dwg_object_entity, color),
    0,0,0, 62 },
  { "color_r11",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, color_r11),
    0,0,0, 62 },
  { "dwg",	"struct _dwg_struct*", sizeof (void *),  OFF (struct _dwg_object_entity, dwg),
    1,1,0, 0 },
  { "edge_visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, edge_visualstyle),
    1,0,0, 348 },
  { "eed",	"Dwg_Eed*", sizeof (Dwg_Eed*),  OFF (struct _dwg_object_entity, eed),
    1,1,0, 0 },
  { "elevation_r11",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_object_entity, elevation_r11),
    0,0,0, 0 },
  { "entmode",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, entmode),
    0,0,0, 67 },
  { "extra_r11",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, extra_r11),
    0,0,0, 0 },
  { "face_visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, face_visualstyle),
    1,0,0, 348 },
  { "flag_r11",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, flag_r11),
    0,0,0, 0 },
  { "full_visualstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, full_visualstyle),
    1,0,0, 348 },
  { "has_ds_data",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_ds_data),
    0,0,0, 0 },
  { "has_edge_visualstyle",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_edge_visualstyle),
    0,0,0, 0 },
  { "has_face_visualstyle",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_face_visualstyle),
    0,0,0, 0 },
  { "has_full_visualstyle",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, has_full_visualstyle),
    0,0,0, 0 },
  { "invisible",	"BS", sizeof (BITCODE_BS),  OFF (struct _dwg_object_entity, invisible),
    0,0,0, 60 },
  { "is_xdic_missing",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, is_xdic_missing),
    0,0,0, 0 },
  { "isbylayerlt",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, isbylayerlt),
    0,0,0, 0 },
  { "kind_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, kind_r11),
    0,0,0, 0 },
  { "layer",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, layer),
    1,0,0, 8 },
  { "layer_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, layer_r11),
    0,0,0, 0 },
  { "linewt",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, linewt),
    0,0,0, 370 },
  { "ltype",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, ltype),
    1,0,0, 6 },
  { "ltype_flags",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, ltype_flags),
    0,0,0, 0 },
  { "ltype_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, ltype_r11),
    0,0,0, 0 },
  { "ltype_scale",	"BD", sizeof (BITCODE_BD),  OFF (struct _dwg_object_entity, ltype_scale),
    0,0,0, 48 },
  { "material",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, material),
    1,0,0, 347 },
  { "material_flags",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, material_flags),
    0,0,0, 0 },
  { "next_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, next_entity),
    1,0,0, 0 },
  { "nolinks",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, nolinks),
    0,0,0, 0 },
  { "num_eed",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, num_eed),
    0,0,0, 0 },
  { "num_reactors",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, num_reactors),
    0,0,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_entity, objid),
    0,0,0, 0 },
  { "opts_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, opts_r11),
    0,0,0, 0 },
  { "ownerhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, ownerhandle),
    1,0,0, 330 },
  { "paper_r11",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_object_entity, paper_r11),
    0,0,0, 67 },
  { "plotstyle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, plotstyle),
    1,0,0, 390 },
  { "plotstyle_flags",	"BB", sizeof (BITCODE_BB),  OFF (struct _dwg_object_entity, plotstyle_flags),
    0,0,0, 0 },
  { "prev_entity",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, prev_entity),
    1,0,0, 0 },
  { "preview",	"TF", sizeof (BITCODE_TF),  OFF (struct _dwg_object_entity, preview),
    1,1,0, 310 },
  { "preview_exists",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, preview_exists),
    0,0,0, 0 },
  { "preview_is_proxy",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_entity, preview_is_proxy),
    0,0,0, 0 },
  { "preview_size",	"BLL", sizeof (BITCODE_BLL),  OFF (struct _dwg_object_entity, preview_size),
    0,0,0, 160 },
  { "reactors",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_entity, reactors),
    1,1,0, 330 },
  { "shadow",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, shadow),
    1,0,0, 0 },
  { "shadow_flags",	"RC", sizeof (BITCODE_RC),  OFF (struct _dwg_object_entity, shadow_flags),
    0,0,0, 284 },
  { "thickness_r11",	"RD", sizeof (BITCODE_RD),  OFF (struct _dwg_object_entity, thickness_r11),
    0,0,0, 0 },
  { "xdicobjhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_entity, xdicobjhandle),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};

/* from typedef struct _dwg_object_object: (sorted by name) */
static const Dwg_DYNAPI_field _dwg_object_object_fields[] = {
  { "dwg",	"struct _dwg_struct*", sizeof (void *),  OFF (struct _dwg_object_object, dwg),
    1,1,0, 0 },
  { "eed",	"Dwg_Eed*", sizeof (Dwg_Eed*),  OFF (struct _dwg_object_object, eed),
    1,1,0, 0 },
  { "handleref",	"Dwg_Handle*", sizeof (Dwg_Handle*),  OFF (struct _dwg_object_object, handleref),
    1,1,0, 0 },
  { "has_ds_data",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_object, has_ds_data),
    0,0,0, 0 },
  { "is_xdic_missing",	"B", sizeof (BITCODE_B),  OFF (struct _dwg_object_object, is_xdic_missing),
    0,0,0, 0 },
  { "num_eed",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_object, num_eed),
    0,0,0, 0 },
  { "num_reactors",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_object, num_reactors),
    0,0,0, 0 },
  { "objid",	"BL", sizeof (BITCODE_BL),  OFF (struct _dwg_object_object, objid),
    0,0,0, 0 },
  { "ownerhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_object, ownerhandle),
    1,0,0, 330 },
  { "reactors",	"H*", sizeof (BITCODE_H*),  OFF (struct _dwg_object_object, reactors),
    1,1,0, 330 },
  { "xdicobjhandle",	"H", sizeof (BITCODE_H),  OFF (struct _dwg_object_object, xdicobjhandle),
    1,0,0, 360 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};


/* from typedef struct _dwg_summaryinfo: (sorted by offset) */
static const Dwg_DYNAPI_field _dwg_summaryinfo_fields[] = {
  { "TITLE",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, TITLE),
    1,1,0, 1 },
  { "SUBJECT",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, SUBJECT),
    1,1,0, 1 },
  { "AUTHOR",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, AUTHOR),
    1,1,0, 1 },
  { "KEYWORDS",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, KEYWORDS),
    1,1,0, 1 },
  { "COMMENTS",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, COMMENTS),
    1,1,0, 1 },
  { "LASTSAVEDBY",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, LASTSAVEDBY),
    1,1,0, 1 },
  { "REVISIONNUMBER",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, REVISIONNUMBER),
    1,1,0, 1 },
  { "HYPERLINKBASE",	"TU16", sizeof (BITCODE_TU),  OFF (struct _dwg_summaryinfo, HYPERLINKBASE),
    1,1,0, 1 },
  { "TDINDWG",	"TIMERLL", sizeof (BITCODE_TIMERLL),  OFF (struct _dwg_summaryinfo, TDINDWG),
    1,0,0, 0 },
  { "TDCREATE",	"TIMERLL", sizeof (BITCODE_TIMERLL),  OFF (struct _dwg_summaryinfo, TDCREATE),
    1,0,0, 0 },
  { "TDUPDATE",	"TIMERLL", sizeof (BITCODE_TIMERLL),  OFF (struct _dwg_summaryinfo, TDUPDATE),
    1,0,0, 0 },
  { "num_props",	"RS", sizeof (BITCODE_RS),  OFF (struct _dwg_summaryinfo, num_props),
    0,0,0, 0 },
  { "props",	"Dwg_SummaryInfo_Property*", sizeof (Dwg_SummaryInfo_Property*),  OFF (struct _dwg_summaryinfo, props),
    1,1,0, 0 },
  { "unknown1",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_summaryinfo, unknown1),
    0,0,0, 0 },
  { "unknown2",	"RL", sizeof (BITCODE_RL),  OFF (struct _dwg_summaryinfo, unknown2),
    0,0,0, 0 },
  {NULL,	NULL,	0,	0,	0,0,0, 0},
};


/* FIXME: Remove name. Get type via dwg_object_name() */
struct _name_type_fields {
  const char *const name;
  const enum DWG_OBJECT_TYPE type;
  const Dwg_DYNAPI_field *const fields;
  const int size;
};

struct _name_subclass_fields {
  const char *const name;
  const int type;
  const char *const subclass;
  const Dwg_DYNAPI_field *const fields;
  const int size;
};

/* Generated fields for all the objects, sorted for bsearch. from enum DWG_OBJECT_TYPE.
   FIXME: Replace name by type. Get type via dwg_object_name().
   Make it an array of type for O(1) lookup.
 */
static const struct _name_type_fields dwg_name_types[] = {
  { "3DFACE", DWG_TYPE__3DFACE /*(28)*/, _dwg_3DFACE_fields, sizeof (struct _dwg_entity_3DFACE) },	/* 0 */
  { "3DSOLID", DWG_TYPE__3DSOLID /*(38)*/, _dwg_3DSOLID_fields, sizeof (struct _dwg_entity_3DSOLID) },	/* 1 */
  { "ACDSRECORD", DWG_TYPE_ACDSRECORD /*(500)*/, NULL, 0 },	/* 2 */
  { "ACDSSCHEMA", DWG_TYPE_ACDSSCHEMA /*(501)*/, NULL, 0 },	/* 3 */
  { "ACMECOMMANDHISTORY", DWG_TYPE_ACMECOMMANDHISTORY /*(502)*/, _dwg_ACMECOMMANDHISTORY_fields, sizeof (struct _dwg_object_ACMECOMMANDHISTORY) },	/* 4 */
  { "ACMESCOPE", DWG_TYPE_ACMESCOPE /*(503)*/, _dwg_ACMESCOPE_fields, sizeof (struct _dwg_object_ACMESCOPE) },	/* 5 */
  { "ACMESTATEMGR", DWG_TYPE_ACMESTATEMGR /*(504)*/, _dwg_ACMESTATEMGR_fields, sizeof (struct _dwg_object_ACMESTATEMGR) },	/* 6 */
  { "ACSH_BOOLEAN_CLASS", DWG_TYPE_ACSH_BOOLEAN_CLASS /*(505)*/, _dwg_ACSH_BOOLEAN_CLASS_fields, sizeof (struct _dwg_object_ACSH_BOOLEAN_CLASS) },	/* 7 */
  { "ACSH_BOX_CLASS", DWG_TYPE_ACSH_BOX_CLASS /*(506)*/, _dwg_ACSH_BOX_CLASS_fields, sizeof (struct _dwg_object_ACSH_BOX_CLASS) },	/* 8 */
  { "ACSH_BREP_CLASS", DWG_TYPE_ACSH_BREP_CLASS /*(507)*/, _dwg_ACSH_BREP_CLASS_fields, sizeof (struct _dwg_object_ACSH_BREP_CLASS) },	/* 9 */
  { "ACSH_CHAMFER_CLASS", DWG_TYPE_ACSH_CHAMFER_CLASS /*(508)*/, _dwg_ACSH_CHAMFER_CLASS_fields, sizeof (struct _dwg_object_ACSH_CHAMFER_CLASS) },	/* 10 */
  { "ACSH_CONE_CLASS", DWG_TYPE_ACSH_CONE_CLASS /*(509)*/, _dwg_ACSH_CONE_CLASS_fields, sizeof (struct _dwg_object_ACSH_CONE_CLASS) },	/* 11 */
  { "ACSH_CYLINDER_CLASS", DWG_TYPE_ACSH_CYLINDER_CLASS /*(510)*/, _dwg_ACSH_CYLINDER_CLASS_fields, sizeof (struct _dwg_object_ACSH_CYLINDER_CLASS) },	/* 12 */
  { "ACSH_EXTRUSION_CLASS", DWG_TYPE_ACSH_EXTRUSION_CLASS /*(511)*/, _dwg_ACSH_EXTRUSION_CLASS_fields, sizeof (struct _dwg_object_ACSH_EXTRUSION_CLASS) },	/* 13 */
  { "ACSH_FILLET_CLASS", DWG_TYPE_ACSH_FILLET_CLASS /*(512)*/, _dwg_ACSH_FILLET_CLASS_fields, sizeof (struct _dwg_object_ACSH_FILLET_CLASS) },	/* 14 */
  { "ACSH_HISTORY_CLASS", DWG_TYPE_ACSH_HISTORY_CLASS /*(513)*/, _dwg_ACSH_HISTORY_CLASS_fields, sizeof (struct _dwg_object_ACSH_HISTORY_CLASS) },	/* 15 */
  { "ACSH_LOFT_CLASS", DWG_TYPE_ACSH_LOFT_CLASS /*(514)*/, _dwg_ACSH_LOFT_CLASS_fields, sizeof (struct _dwg_object_ACSH_LOFT_CLASS) },	/* 16 */
  { "ACSH_PYRAMID_CLASS", DWG_TYPE_ACSH_PYRAMID_CLASS /*(515)*/, _dwg_ACSH_PYRAMID_CLASS_fields, sizeof (struct _dwg_object_ACSH_PYRAMID_CLASS) },	/* 17 */
  { "ACSH_REVOLVE_CLASS", DWG_TYPE_ACSH_REVOLVE_CLASS /*(516)*/, _dwg_ACSH_REVOLVE_CLASS_fields, sizeof (struct _dwg_object_ACSH_REVOLVE_CLASS) },	/* 18 */
  { "ACSH_SPHERE_CLASS", DWG_TYPE_ACSH_SPHERE_CLASS /*(517)*/, _dwg_ACSH_SPHERE_CLASS_fields, sizeof (struct _dwg_object_ACSH_SPHERE_CLASS) },	/* 19 */
  { "ACSH_SWEEP_CLASS", DWG_TYPE_ACSH_SWEEP_CLASS /*(518)*/, _dwg_ACSH_SWEEP_CLASS_fields, sizeof (struct _dwg_object_ACSH_SWEEP_CLASS) },	/* 20 */
  { "ACSH_TORUS_CLASS", DWG_TYPE_ACSH_TORUS_CLASS /*(519)*/, _dwg_ACSH_TORUS_CLASS_fields, sizeof (struct _dwg_object_ACSH_TORUS_CLASS) },	/* 21 */
  { "ACSH_WEDGE_CLASS", DWG_TYPE_ACSH_WEDGE_CLASS /*(520)*/, _dwg_ACSH_WEDGE_CLASS_fields, sizeof (struct _dwg_object_ACSH_WEDGE_CLASS) },	/* 22 */
  { "ALDIMOBJECTCONTEXTDATA", DWG_TYPE_ALDIMOBJECTCONTEXTDATA /*(521)*/, _dwg_ALDIMOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_ALDIMOBJECTCONTEXTDATA) },	/* 23 */
  { "ALIGNMENTPARAMETERENTITY", DWG_TYPE_ALIGNMENTPARAMETERENTITY /*(522)*/, _dwg_ALIGNMENTPARAMETERENTITY_fields, sizeof (struct _dwg_entity_ALIGNMENTPARAMETERENTITY) },	/* 24 */
  { "ANGDIMOBJECTCONTEXTDATA", DWG_TYPE_ANGDIMOBJECTCONTEXTDATA /*(523)*/, _dwg_ANGDIMOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_ANGDIMOBJECTCONTEXTDATA) },	/* 25 */
  { "ANNOTSCALEOBJECTCONTEXTDATA", DWG_TYPE_ANNOTSCALEOBJECTCONTEXTDATA /*(524)*/, _dwg_ANNOTSCALEOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_ANNOTSCALEOBJECTCONTEXTDATA) },	/* 26 */
  { "APPID", DWG_TYPE_APPID /*(67)*/, _dwg_APPID_fields, sizeof (struct _dwg_object_APPID) },	/* 27 */
  { "APPID_CONTROL", DWG_TYPE_APPID_CONTROL /*(66)*/, _dwg_APPID_CONTROL_fields, sizeof (struct _dwg_object_APPID_CONTROL) },	/* 28 */
  { "ARC", DWG_TYPE_ARC /*(17)*/, _dwg_ARC_fields, sizeof (struct _dwg_entity_ARC) },	/* 29 */
  { "ARCALIGNEDTEXT", DWG_TYPE_ARCALIGNEDTEXT /*(525)*/, _dwg_ARCALIGNEDTEXT_fields, sizeof (struct _dwg_entity_ARCALIGNEDTEXT) },	/* 30 */
  { "ARC_DIMENSION", DWG_TYPE_ARC_DIMENSION /*(526)*/, _dwg_ARC_DIMENSION_fields, sizeof (struct _dwg_entity_ARC_DIMENSION) },	/* 31 */
  { "ASSOC2DCONSTRAINTGROUP", DWG_TYPE_ASSOC2DCONSTRAINTGROUP /*(527)*/, _dwg_ASSOC2DCONSTRAINTGROUP_fields, sizeof (struct _dwg_object_ASSOC2DCONSTRAINTGROUP) },	/* 32 */
  { "ASSOC3POINTANGULARDIMACTIONBODY", DWG_TYPE_ASSOC3POINTANGULARDIMACTIONBODY /*(528)*/, _dwg_ASSOC3POINTANGULARDIMACTIONBODY_fields, sizeof (struct _dwg_object_ASSOC3POINTANGULARDIMACTIONBODY) },	/* 33 */
  { "ASSOCACTION", DWG_TYPE_ASSOCACTION /*(529)*/, _dwg_ASSOCACTION_fields, sizeof (struct _dwg_object_ASSOCACTION) },	/* 34 */
  { "ASSOCACTIONPARAM", DWG_TYPE_ASSOCACTIONPARAM /*(530)*/, _dwg_ASSOCACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCACTIONPARAM) },	/* 35 */
  { "ASSOCALIGNEDDIMACTIONBODY", DWG_TYPE_ASSOCALIGNEDDIMACTIONBODY /*(531)*/, _dwg_ASSOCALIGNEDDIMACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCALIGNEDDIMACTIONBODY) },	/* 36 */
  { "ASSOCARRAYACTIONBODY", DWG_TYPE_ASSOCARRAYACTIONBODY /*(532)*/, _dwg_ASSOCARRAYACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCARRAYACTIONBODY) },	/* 37 */
  { "ASSOCARRAYMODIFYACTIONBODY", DWG_TYPE_ASSOCARRAYMODIFYACTIONBODY /*(533)*/, _dwg_ASSOCARRAYMODIFYACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCARRAYMODIFYACTIONBODY) },	/* 38 */
  { "ASSOCARRAYMODIFYPARAMETERS", DWG_TYPE_ASSOCARRAYMODIFYPARAMETERS /*(534)*/, _dwg_ASSOCARRAYPARAMETERS_fields, sizeof (Dwg_Object_ASSOCARRAYPARAMETERS) },	/* 39 */
  { "ASSOCARRAYPATHPARAMETERS", DWG_TYPE_ASSOCARRAYPATHPARAMETERS /*(535)*/, _dwg_ASSOCARRAYPARAMETERS_fields, sizeof (Dwg_Object_ASSOCARRAYPARAMETERS) },	/* 40 */
  { "ASSOCARRAYPOLARPARAMETERS", DWG_TYPE_ASSOCARRAYPOLARPARAMETERS /*(536)*/, _dwg_ASSOCARRAYPARAMETERS_fields, sizeof (Dwg_Object_ASSOCARRAYPARAMETERS) },	/* 41 */
  { "ASSOCARRAYRECTANGULARPARAMETERS", DWG_TYPE_ASSOCARRAYRECTANGULARPARAMETERS /*(537)*/, _dwg_ASSOCARRAYPARAMETERS_fields, sizeof (Dwg_Object_ASSOCARRAYPARAMETERS) },	/* 42 */
  { "ASSOCASMBODYACTIONPARAM", DWG_TYPE_ASSOCASMBODYACTIONPARAM /*(538)*/, _dwg_ASSOCASMBODYACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCASMBODYACTIONPARAM) },	/* 43 */
  { "ASSOCBLENDSURFACEACTIONBODY", DWG_TYPE_ASSOCBLENDSURFACEACTIONBODY /*(539)*/, _dwg_ASSOCBLENDSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCBLENDSURFACEACTIONBODY) },	/* 44 */
  { "ASSOCCOMPOUNDACTIONPARAM", DWG_TYPE_ASSOCCOMPOUNDACTIONPARAM /*(540)*/, _dwg_ASSOCCOMPOUNDACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCCOMPOUNDACTIONPARAM) },	/* 45 */
  { "ASSOCDEPENDENCY", DWG_TYPE_ASSOCDEPENDENCY /*(541)*/, _dwg_ASSOCDEPENDENCY_fields, sizeof (struct _dwg_object_ASSOCDEPENDENCY) },	/* 46 */
  { "ASSOCDIMDEPENDENCYBODY", DWG_TYPE_ASSOCDIMDEPENDENCYBODY /*(542)*/, _dwg_ASSOCDIMDEPENDENCYBODY_fields, sizeof (struct _dwg_object_ASSOCDIMDEPENDENCYBODY) },	/* 47 */
  { "ASSOCEDGEACTIONPARAM", DWG_TYPE_ASSOCEDGEACTIONPARAM /*(543)*/, _dwg_ASSOCEDGEACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCEDGEACTIONPARAM) },	/* 48 */
  { "ASSOCEDGECHAMFERACTIONBODY", DWG_TYPE_ASSOCEDGECHAMFERACTIONBODY /*(544)*/, _dwg_ASSOCEDGECHAMFERACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCEDGECHAMFERACTIONBODY) },	/* 49 */
  { "ASSOCEDGEFILLETACTIONBODY", DWG_TYPE_ASSOCEDGEFILLETACTIONBODY /*(545)*/, _dwg_ASSOCEDGEFILLETACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCEDGEFILLETACTIONBODY) },	/* 50 */
  { "ASSOCEXTENDSURFACEACTIONBODY", DWG_TYPE_ASSOCEXTENDSURFACEACTIONBODY /*(546)*/, _dwg_ASSOCEXTENDSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCEXTENDSURFACEACTIONBODY) },	/* 51 */
  { "ASSOCEXTRUDEDSURFACEACTIONBODY", DWG_TYPE_ASSOCEXTRUDEDSURFACEACTIONBODY /*(547)*/, _dwg_ASSOCEXTRUDEDSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCEXTRUDEDSURFACEACTIONBODY) },	/* 52 */
  { "ASSOCFACEACTIONPARAM", DWG_TYPE_ASSOCFACEACTIONPARAM /*(548)*/, _dwg_ASSOCFACEACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCFACEACTIONPARAM) },	/* 53 */
  { "ASSOCFILLETSURFACEACTIONBODY", DWG_TYPE_ASSOCFILLETSURFACEACTIONBODY /*(549)*/, _dwg_ASSOCFILLETSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCFILLETSURFACEACTIONBODY) },	/* 54 */
  { "ASSOCGEOMDEPENDENCY", DWG_TYPE_ASSOCGEOMDEPENDENCY /*(550)*/, _dwg_ASSOCGEOMDEPENDENCY_fields, sizeof (struct _dwg_object_ASSOCGEOMDEPENDENCY) },	/* 55 */
  { "ASSOCLOFTEDSURFACEACTIONBODY", DWG_TYPE_ASSOCLOFTEDSURFACEACTIONBODY /*(551)*/, _dwg_ASSOCLOFTEDSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCLOFTEDSURFACEACTIONBODY) },	/* 56 */
  { "ASSOCMLEADERACTIONBODY", DWG_TYPE_ASSOCMLEADERACTIONBODY /*(552)*/, _dwg_ASSOCMLEADERACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCMLEADERACTIONBODY) },	/* 57 */
  { "ASSOCNETWORK", DWG_TYPE_ASSOCNETWORK /*(553)*/, _dwg_ASSOCNETWORK_fields, sizeof (struct _dwg_object_ASSOCNETWORK) },	/* 58 */
  { "ASSOCNETWORKSURFACEACTIONBODY", DWG_TYPE_ASSOCNETWORKSURFACEACTIONBODY /*(554)*/, _dwg_ASSOCNETWORKSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCNETWORKSURFACEACTIONBODY) },	/* 59 */
  { "ASSOCOBJECTACTIONPARAM", DWG_TYPE_ASSOCOBJECTACTIONPARAM /*(555)*/, _dwg_ASSOCOBJECTACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCOBJECTACTIONPARAM) },	/* 60 */
  { "ASSOCOFFSETSURFACEACTIONBODY", DWG_TYPE_ASSOCOFFSETSURFACEACTIONBODY /*(556)*/, _dwg_ASSOCOFFSETSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCOFFSETSURFACEACTIONBODY) },	/* 61 */
  { "ASSOCORDINATEDIMACTIONBODY", DWG_TYPE_ASSOCORDINATEDIMACTIONBODY /*(557)*/, _dwg_ASSOCORDINATEDIMACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCORDINATEDIMACTIONBODY) },	/* 62 */
  { "ASSOCOSNAPPOINTREFACTIONPARAM", DWG_TYPE_ASSOCOSNAPPOINTREFACTIONPARAM /*(558)*/, _dwg_ASSOCOSNAPPOINTREFACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCOSNAPPOINTREFACTIONPARAM) },	/* 63 */
  { "ASSOCPATCHSURFACEACTIONBODY", DWG_TYPE_ASSOCPATCHSURFACEACTIONBODY /*(559)*/, _dwg_ASSOCPATCHSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCPATCHSURFACEACTIONBODY) },	/* 64 */
  { "ASSOCPATHACTIONPARAM", DWG_TYPE_ASSOCPATHACTIONPARAM /*(560)*/, _dwg_ASSOCPATHACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCPATHACTIONPARAM) },	/* 65 */
  { "ASSOCPERSSUBENTMANAGER", DWG_TYPE_ASSOCPERSSUBENTMANAGER /*(561)*/, _dwg_ASSOCPERSSUBENTMANAGER_fields, sizeof (struct _dwg_object_ASSOCPERSSUBENTMANAGER) },	/* 66 */
  { "ASSOCPLANESURFACEACTIONBODY", DWG_TYPE_ASSOCPLANESURFACEACTIONBODY /*(562)*/, _dwg_ASSOCPLANESURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCPLANESURFACEACTIONBODY) },	/* 67 */
  { "ASSOCPOINTREFACTIONPARAM", DWG_TYPE_ASSOCPOINTREFACTIONPARAM /*(563)*/, _dwg_ASSOCPOINTREFACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCPOINTREFACTIONPARAM) },	/* 68 */
  { "ASSOCRESTOREENTITYSTATEACTIONBODY", DWG_TYPE_ASSOCRESTOREENTITYSTATEACTIONBODY /*(564)*/, _dwg_ASSOCRESTOREENTITYSTATEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCRESTOREENTITYSTATEACTIONBODY) },	/* 69 */
  { "ASSOCREVOLVEDSURFACEACTIONBODY", DWG_TYPE_ASSOCREVOLVEDSURFACEACTIONBODY /*(565)*/, _dwg_ASSOCREVOLVEDSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCREVOLVEDSURFACEACTIONBODY) },	/* 70 */
  { "ASSOCROTATEDDIMACTIONBODY", DWG_TYPE_ASSOCROTATEDDIMACTIONBODY /*(566)*/, _dwg_ASSOCROTATEDDIMACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCROTATEDDIMACTIONBODY) },	/* 71 */
  { "ASSOCSWEPTSURFACEACTIONBODY", DWG_TYPE_ASSOCSWEPTSURFACEACTIONBODY /*(567)*/, _dwg_ASSOCSWEPTSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCSWEPTSURFACEACTIONBODY) },	/* 72 */
  { "ASSOCTRIMSURFACEACTIONBODY", DWG_TYPE_ASSOCTRIMSURFACEACTIONBODY /*(568)*/, _dwg_ASSOCTRIMSURFACEACTIONBODY_fields, sizeof (struct _dwg_object_ASSOCTRIMSURFACEACTIONBODY) },	/* 73 */
  { "ASSOCVALUEDEPENDENCY", DWG_TYPE_ASSOCVALUEDEPENDENCY /*(569)*/, _dwg_ASSOCVALUEDEPENDENCY_fields, sizeof (struct _dwg_object_ASSOCVALUEDEPENDENCY) },	/* 74 */
  { "ASSOCVARIABLE", DWG_TYPE_ASSOCVARIABLE /*(570)*/, _dwg_ASSOCVARIABLE_fields, sizeof (struct _dwg_object_ASSOCVARIABLE) },	/* 75 */
  { "ASSOCVERTEXACTIONPARAM", DWG_TYPE_ASSOCVERTEXACTIONPARAM /*(571)*/, _dwg_ASSOCVERTEXACTIONPARAM_fields, sizeof (struct _dwg_object_ASSOCVERTEXACTIONPARAM) },	/* 76 */
  { "ATTDEF", DWG_TYPE_ATTDEF /*(3)*/, _dwg_ATTDEF_fields, sizeof (struct _dwg_entity_ATTDEF) },	/* 77 */
  { "ATTRIB", DWG_TYPE_ATTRIB /*(2)*/, _dwg_ATTRIB_fields, sizeof (struct _dwg_entity_ATTRIB) },	/* 78 */
  { "BASEPOINTPARAMETERENTITY", DWG_TYPE_BASEPOINTPARAMETERENTITY /*(572)*/, _dwg_BASEPOINTPARAMETERENTITY_fields, sizeof (struct _dwg_entity_BASEPOINTPARAMETERENTITY) },	/* 79 */
  { "BLKREFOBJECTCONTEXTDATA", DWG_TYPE_BLKREFOBJECTCONTEXTDATA /*(573)*/, _dwg_BLKREFOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_BLKREFOBJECTCONTEXTDATA) },	/* 80 */
  { "BLOCK", DWG_TYPE_BLOCK /*(4)*/, _dwg_BLOCK_fields, sizeof (struct _dwg_entity_BLOCK) },	/* 81 */
  { "BLOCKALIGNEDCONSTRAINTPARAMETER", DWG_TYPE_BLOCKALIGNEDCONSTRAINTPARAMETER /*(574)*/, _dwg_BLOCKALIGNEDCONSTRAINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKALIGNEDCONSTRAINTPARAMETER) },	/* 82 */
  { "BLOCKALIGNMENTGRIP", DWG_TYPE_BLOCKALIGNMENTGRIP /*(575)*/, _dwg_BLOCKALIGNMENTGRIP_fields, sizeof (struct _dwg_object_BLOCKALIGNMENTGRIP) },	/* 83 */
  { "BLOCKALIGNMENTPARAMETER", DWG_TYPE_BLOCKALIGNMENTPARAMETER /*(576)*/, _dwg_BLOCKALIGNMENTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKALIGNMENTPARAMETER) },	/* 84 */
  { "BLOCKANGULARCONSTRAINTPARAMETER", DWG_TYPE_BLOCKANGULARCONSTRAINTPARAMETER /*(577)*/, _dwg_BLOCKANGULARCONSTRAINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKANGULARCONSTRAINTPARAMETER) },	/* 85 */
  { "BLOCKARRAYACTION", DWG_TYPE_BLOCKARRAYACTION /*(578)*/, _dwg_BLOCKARRAYACTION_fields, sizeof (struct _dwg_object_BLOCKARRAYACTION) },	/* 86 */
  { "BLOCKBASEPOINTPARAMETER", DWG_TYPE_BLOCKBASEPOINTPARAMETER /*(579)*/, _dwg_BLOCKBASEPOINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKBASEPOINTPARAMETER) },	/* 87 */
  { "BLOCKDIAMETRICCONSTRAINTPARAMETER", DWG_TYPE_BLOCKDIAMETRICCONSTRAINTPARAMETER /*(580)*/, _dwg_BLOCKDIAMETRICCONSTRAINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKDIAMETRICCONSTRAINTPARAMETER) },	/* 88 */
  { "BLOCKFLIPACTION", DWG_TYPE_BLOCKFLIPACTION /*(581)*/, _dwg_BLOCKFLIPACTION_fields, sizeof (struct _dwg_object_BLOCKFLIPACTION) },	/* 89 */
  { "BLOCKFLIPGRIP", DWG_TYPE_BLOCKFLIPGRIP /*(582)*/, _dwg_BLOCKFLIPGRIP_fields, sizeof (struct _dwg_object_BLOCKFLIPGRIP) },	/* 90 */
  { "BLOCKFLIPPARAMETER", DWG_TYPE_BLOCKFLIPPARAMETER /*(583)*/, _dwg_BLOCKFLIPPARAMETER_fields, sizeof (struct _dwg_object_BLOCKFLIPPARAMETER) },	/* 91 */
  { "BLOCKGRIPLOCATIONCOMPONENT", DWG_TYPE_BLOCKGRIPLOCATIONCOMPONENT /*(584)*/, _dwg_BLOCKGRIPLOCATIONCOMPONENT_fields, sizeof (struct _dwg_object_BLOCKGRIPLOCATIONCOMPONENT) },	/* 92 */
  { "BLOCKHORIZONTALCONSTRAINTPARAMETER", DWG_TYPE_BLOCKHORIZONTALCONSTRAINTPARAMETER /*(585)*/, _dwg_BLOCKHORIZONTALCONSTRAINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKHORIZONTALCONSTRAINTPARAMETER) },	/* 93 */
  { "BLOCKLINEARCONSTRAINTPARAMETER", DWG_TYPE_BLOCKLINEARCONSTRAINTPARAMETER /*(586)*/, _dwg_BLOCKLINEARCONSTRAINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKLINEARCONSTRAINTPARAMETER) },	/* 94 */
  { "BLOCKLINEARGRIP", DWG_TYPE_BLOCKLINEARGRIP /*(587)*/, _dwg_BLOCKLINEARGRIP_fields, sizeof (struct _dwg_object_BLOCKLINEARGRIP) },	/* 95 */
  { "BLOCKLINEARPARAMETER", DWG_TYPE_BLOCKLINEARPARAMETER /*(588)*/, _dwg_BLOCKLINEARPARAMETER_fields, sizeof (struct _dwg_object_BLOCKLINEARPARAMETER) },	/* 96 */
  { "BLOCKLOOKUPACTION", DWG_TYPE_BLOCKLOOKUPACTION /*(589)*/, _dwg_BLOCKLOOKUPACTION_fields, sizeof (struct _dwg_object_BLOCKLOOKUPACTION) },	/* 97 */
  { "BLOCKLOOKUPGRIP", DWG_TYPE_BLOCKLOOKUPGRIP /*(590)*/, _dwg_BLOCKLOOKUPGRIP_fields, sizeof (struct _dwg_object_BLOCKLOOKUPGRIP) },	/* 98 */
  { "BLOCKLOOKUPPARAMETER", DWG_TYPE_BLOCKLOOKUPPARAMETER /*(591)*/, _dwg_BLOCKLOOKUPPARAMETER_fields, sizeof (struct _dwg_object_BLOCKLOOKUPPARAMETER) },	/* 99 */
  { "BLOCKMOVEACTION", DWG_TYPE_BLOCKMOVEACTION /*(592)*/, _dwg_BLOCKMOVEACTION_fields, sizeof (struct _dwg_object_BLOCKMOVEACTION) },	/* 100 */
  { "BLOCKPARAMDEPENDENCYBODY", DWG_TYPE_BLOCKPARAMDEPENDENCYBODY /*(593)*/, _dwg_BLOCKPARAMDEPENDENCYBODY_fields, sizeof (struct _dwg_object_BLOCKPARAMDEPENDENCYBODY) },	/* 101 */
  { "BLOCKPOINTPARAMETER", DWG_TYPE_BLOCKPOINTPARAMETER /*(594)*/, _dwg_BLOCKPOINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKPOINTPARAMETER) },	/* 102 */
  { "BLOCKPOLARGRIP", DWG_TYPE_BLOCKPOLARGRIP /*(595)*/, _dwg_BLOCKPOLARGRIP_fields, sizeof (struct _dwg_object_BLOCKPOLARGRIP) },	/* 103 */
  { "BLOCKPOLARPARAMETER", DWG_TYPE_BLOCKPOLARPARAMETER /*(596)*/, _dwg_BLOCKPOLARPARAMETER_fields, sizeof (struct _dwg_object_BLOCKPOLARPARAMETER) },	/* 104 */
  { "BLOCKPOLARSTRETCHACTION", DWG_TYPE_BLOCKPOLARSTRETCHACTION /*(597)*/, _dwg_BLOCKPOLARSTRETCHACTION_fields, sizeof (struct _dwg_object_BLOCKPOLARSTRETCHACTION) },	/* 105 */
  { "BLOCKPROPERTIESTABLE", DWG_TYPE_BLOCKPROPERTIESTABLE /*(598)*/, _dwg_BLOCKPROPERTIESTABLE_fields, sizeof (struct _dwg_object_BLOCKPROPERTIESTABLE) },	/* 106 */
  { "BLOCKPROPERTIESTABLEGRIP", DWG_TYPE_BLOCKPROPERTIESTABLEGRIP /*(599)*/, _dwg_BLOCKPROPERTIESTABLEGRIP_fields, sizeof (struct _dwg_object_BLOCKPROPERTIESTABLEGRIP) },	/* 107 */
  { "BLOCKRADIALCONSTRAINTPARAMETER", DWG_TYPE_BLOCKRADIALCONSTRAINTPARAMETER /*(600)*/, _dwg_BLOCKRADIALCONSTRAINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKRADIALCONSTRAINTPARAMETER) },	/* 108 */
  { "BLOCKREPRESENTATION", DWG_TYPE_BLOCKREPRESENTATION /*(601)*/, _dwg_BLOCKREPRESENTATION_fields, sizeof (struct _dwg_object_BLOCKREPRESENTATION) },	/* 109 */
  { "BLOCKROTATEACTION", DWG_TYPE_BLOCKROTATEACTION /*(602)*/, _dwg_BLOCKROTATEACTION_fields, sizeof (struct _dwg_object_BLOCKROTATEACTION) },	/* 110 */
  { "BLOCKROTATIONGRIP", DWG_TYPE_BLOCKROTATIONGRIP /*(603)*/, _dwg_BLOCKROTATIONGRIP_fields, sizeof (struct _dwg_object_BLOCKROTATIONGRIP) },	/* 111 */
  { "BLOCKROTATIONPARAMETER", DWG_TYPE_BLOCKROTATIONPARAMETER /*(604)*/, _dwg_BLOCKROTATIONPARAMETER_fields, sizeof (struct _dwg_object_BLOCKROTATIONPARAMETER) },	/* 112 */
  { "BLOCKSCALEACTION", DWG_TYPE_BLOCKSCALEACTION /*(605)*/, _dwg_BLOCKSCALEACTION_fields, sizeof (struct _dwg_object_BLOCKSCALEACTION) },	/* 113 */
  { "BLOCKSTRETCHACTION", DWG_TYPE_BLOCKSTRETCHACTION /*(606)*/, _dwg_BLOCKSTRETCHACTION_fields, sizeof (struct _dwg_object_BLOCKSTRETCHACTION) },	/* 114 */
  { "BLOCKUSERPARAMETER", DWG_TYPE_BLOCKUSERPARAMETER /*(607)*/, _dwg_BLOCKUSERPARAMETER_fields, sizeof (struct _dwg_object_BLOCKUSERPARAMETER) },	/* 115 */
  { "BLOCKVERTICALCONSTRAINTPARAMETER", DWG_TYPE_BLOCKVERTICALCONSTRAINTPARAMETER /*(608)*/, _dwg_BLOCKVERTICALCONSTRAINTPARAMETER_fields, sizeof (struct _dwg_object_BLOCKVERTICALCONSTRAINTPARAMETER) },	/* 116 */
  { "BLOCKVISIBILITYGRIP", DWG_TYPE_BLOCKVISIBILITYGRIP /*(609)*/, _dwg_BLOCKVISIBILITYGRIP_fields, sizeof (struct _dwg_object_BLOCKVISIBILITYGRIP) },	/* 117 */
  { "BLOCKVISIBILITYPARAMETER", DWG_TYPE_BLOCKVISIBILITYPARAMETER /*(610)*/, _dwg_BLOCKVISIBILITYPARAMETER_fields, sizeof (struct _dwg_object_BLOCKVISIBILITYPARAMETER) },	/* 118 */
  { "BLOCKXYGRIP", DWG_TYPE_BLOCKXYGRIP /*(611)*/, _dwg_BLOCKXYGRIP_fields, sizeof (struct _dwg_object_BLOCKXYGRIP) },	/* 119 */
  { "BLOCKXYPARAMETER", DWG_TYPE_BLOCKXYPARAMETER /*(612)*/, _dwg_BLOCKXYPARAMETER_fields, sizeof (struct _dwg_object_BLOCKXYPARAMETER) },	/* 120 */
  { "BLOCK_CONTROL", DWG_TYPE_BLOCK_CONTROL /*(48)*/, _dwg_BLOCK_CONTROL_fields, sizeof (struct _dwg_object_BLOCK_CONTROL) },	/* 121 */
  { "BLOCK_HEADER", DWG_TYPE_BLOCK_HEADER /*(49)*/, _dwg_BLOCK_HEADER_fields, sizeof (struct _dwg_object_BLOCK_HEADER) },	/* 122 */
  { "BODY", DWG_TYPE_BODY /*(39)*/, _dwg_3DSOLID_fields, sizeof (struct _dwg_entity_3DSOLID) },	/* 123 */
  { "CAMERA", DWG_TYPE_CAMERA /*(613)*/, _dwg_CAMERA_fields, sizeof (struct _dwg_entity_CAMERA) },	/* 124 */
  { "CELLSTYLEMAP", DWG_TYPE_CELLSTYLEMAP /*(614)*/, _dwg_CELLSTYLEMAP_fields, sizeof (struct _dwg_object_CELLSTYLEMAP) },	/* 125 */
  { "CIRCLE", DWG_TYPE_CIRCLE /*(18)*/, _dwg_CIRCLE_fields, sizeof (struct _dwg_entity_CIRCLE) },	/* 126 */
  { "CONTEXTDATAMANAGER", DWG_TYPE_CONTEXTDATAMANAGER /*(615)*/, _dwg_CONTEXTDATAMANAGER_fields, sizeof (struct _dwg_object_CONTEXTDATAMANAGER) },	/* 127 */
  { "CSACDOCUMENTOPTIONS", DWG_TYPE_CSACDOCUMENTOPTIONS /*(616)*/, _dwg_CSACDOCUMENTOPTIONS_fields, sizeof (struct _dwg_object_CSACDOCUMENTOPTIONS) },	/* 128 */
  { "CURVEPATH", DWG_TYPE_CURVEPATH /*(617)*/, _dwg_CURVEPATH_fields, sizeof (struct _dwg_object_CURVEPATH) },	/* 129 */
  { "DATALINK", DWG_TYPE_DATALINK /*(618)*/, _dwg_DATALINK_fields, sizeof (struct _dwg_object_DATALINK) },	/* 130 */
  { "DATATABLE", DWG_TYPE_DATATABLE /*(619)*/, _dwg_DATATABLE_fields, sizeof (struct _dwg_object_DATATABLE) },	/* 131 */
  { "DBCOLOR", DWG_TYPE_DBCOLOR /*(620)*/, _dwg_DBCOLOR_fields, sizeof (struct _dwg_object_DBCOLOR) },	/* 132 */
  { "DETAILVIEWSTYLE", DWG_TYPE_DETAILVIEWSTYLE /*(621)*/, _dwg_DETAILVIEWSTYLE_fields, sizeof (struct _dwg_object_DETAILVIEWSTYLE) },	/* 133 */
  { "DGNDEFINITION", DWG_TYPE_DGNDEFINITION /*(622)*/, _dwg_UNDERLAYDEFINITION_fields, sizeof (Dwg_Object_DGNDEFINITION) },	/* 134 */
  { "DGNUNDERLAY", DWG_TYPE_DGNUNDERLAY /*(623)*/, _dwg_UNDERLAY_fields, sizeof (Dwg_Entity_DGNUNDERLAY) },	/* 135 */
  { "DICTIONARY", DWG_TYPE_DICTIONARY /*(42)*/, _dwg_DICTIONARY_fields, sizeof (struct _dwg_object_DICTIONARY) },	/* 136 */
  { "DICTIONARYVAR", DWG_TYPE_DICTIONARYVAR /*(624)*/, _dwg_DICTIONARYVAR_fields, sizeof (struct _dwg_object_DICTIONARYVAR) },	/* 137 */
  { "DICTIONARYWDFLT", DWG_TYPE_DICTIONARYWDFLT /*(625)*/, _dwg_DICTIONARYWDFLT_fields, sizeof (struct _dwg_object_DICTIONARYWDFLT) },	/* 138 */
  { "DIMASSOC", DWG_TYPE_DIMASSOC /*(626)*/, _dwg_DIMASSOC_fields, sizeof (struct _dwg_object_DIMASSOC) },	/* 139 */
  { "DIMENSION_ALIGNED", DWG_TYPE_DIMENSION_ALIGNED /*(22)*/, _dwg_DIMENSION_ALIGNED_fields, sizeof (struct _dwg_entity_DIMENSION_ALIGNED) },	/* 140 */
  { "DIMENSION_ANG2LN", DWG_TYPE_DIMENSION_ANG2LN /*(24)*/, _dwg_DIMENSION_ANG2LN_fields, sizeof (struct _dwg_entity_DIMENSION_ANG2LN) },	/* 141 */
  { "DIMENSION_ANG3PT", DWG_TYPE_DIMENSION_ANG3PT /*(23)*/, _dwg_DIMENSION_ANG3PT_fields, sizeof (struct _dwg_entity_DIMENSION_ANG3PT) },	/* 142 */
  { "DIMENSION_DIAMETER", DWG_TYPE_DIMENSION_DIAMETER /*(26)*/, _dwg_DIMENSION_DIAMETER_fields, sizeof (struct _dwg_entity_DIMENSION_DIAMETER) },	/* 143 */
  { "DIMENSION_LINEAR", DWG_TYPE_DIMENSION_LINEAR /*(21)*/, _dwg_DIMENSION_LINEAR_fields, sizeof (struct _dwg_entity_DIMENSION_LINEAR) },	/* 144 */
  { "DIMENSION_ORDINATE", DWG_TYPE_DIMENSION_ORDINATE /*(20)*/, _dwg_DIMENSION_ORDINATE_fields, sizeof (struct _dwg_entity_DIMENSION_ORDINATE) },	/* 145 */
  { "DIMENSION_RADIUS", DWG_TYPE_DIMENSION_RADIUS /*(25)*/, _dwg_DIMENSION_RADIUS_fields, sizeof (struct _dwg_entity_DIMENSION_RADIUS) },	/* 146 */
  { "DIMSTYLE", DWG_TYPE_DIMSTYLE /*(69)*/, _dwg_DIMSTYLE_fields, sizeof (struct _dwg_object_DIMSTYLE) },	/* 147 */
  { "DIMSTYLE_CONTROL", DWG_TYPE_DIMSTYLE_CONTROL /*(68)*/, _dwg_DIMSTYLE_CONTROL_fields, sizeof (struct _dwg_object_DIMSTYLE_CONTROL) },	/* 148 */
  { "DMDIMOBJECTCONTEXTDATA", DWG_TYPE_DMDIMOBJECTCONTEXTDATA /*(627)*/, _dwg_DMDIMOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_DMDIMOBJECTCONTEXTDATA) },	/* 149 */
  { "DUMMY", DWG_TYPE_DUMMY /*(75)*/, _dwg_DUMMY_fields, sizeof (struct _dwg_object_DUMMY) },	/* 150 */
  { "DWFDEFINITION", DWG_TYPE_DWFDEFINITION /*(628)*/, _dwg_UNDERLAYDEFINITION_fields, sizeof (Dwg_Object_DWFDEFINITION) },	/* 151 */
  { "DWFUNDERLAY", DWG_TYPE_DWFUNDERLAY /*(629)*/, _dwg_UNDERLAY_fields, sizeof (Dwg_Entity_DWFUNDERLAY) },	/* 152 */
  { "DYNAMICBLOCKPROXYNODE", DWG_TYPE_DYNAMICBLOCKPROXYNODE /*(630)*/, _dwg_DYNAMICBLOCKPROXYNODE_fields, sizeof (struct _dwg_object_DYNAMICBLOCKPROXYNODE) },	/* 153 */
  { "DYNAMICBLOCKPURGEPREVENTER", DWG_TYPE_DYNAMICBLOCKPURGEPREVENTER /*(631)*/, _dwg_DYNAMICBLOCKPURGEPREVENTER_fields, sizeof (struct _dwg_object_DYNAMICBLOCKPURGEPREVENTER) },	/* 154 */
  { "ELLIPSE", DWG_TYPE_ELLIPSE /*(35)*/, _dwg_ELLIPSE_fields, sizeof (struct _dwg_entity_ELLIPSE) },	/* 155 */
  { "ENDBLK", DWG_TYPE_ENDBLK /*(5)*/, _dwg_ENDBLK_fields, sizeof (struct _dwg_entity_ENDBLK) },	/* 156 */
  { "EVALUATION_GRAPH", DWG_TYPE_EVALUATION_GRAPH /*(632)*/, _dwg_EVALUATION_GRAPH_fields, sizeof (struct _dwg_object_EVALUATION_GRAPH) },	/* 157 */
  { "EXTRUDEDSURFACE", DWG_TYPE_EXTRUDEDSURFACE /*(633)*/, _dwg_EXTRUDEDSURFACE_fields, sizeof (struct _dwg_entity_EXTRUDEDSURFACE) },	/* 158 */
  { "FCFOBJECTCONTEXTDATA", DWG_TYPE_FCFOBJECTCONTEXTDATA /*(634)*/, _dwg_FCFOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_FCFOBJECTCONTEXTDATA) },	/* 159 */
  { "FIELD", DWG_TYPE_FIELD /*(635)*/, _dwg_FIELD_fields, sizeof (struct _dwg_object_FIELD) },	/* 160 */
  { "FIELDLIST", DWG_TYPE_FIELDLIST /*(636)*/, _dwg_FIELDLIST_fields, sizeof (struct _dwg_object_FIELDLIST) },	/* 161 */
  { "FLIPPARAMETERENTITY", DWG_TYPE_FLIPPARAMETERENTITY /*(637)*/, _dwg_FLIPPARAMETERENTITY_fields, sizeof (struct _dwg_entity_FLIPPARAMETERENTITY) },	/* 162 */
  { "FREED", DWG_TYPE_FREED /*(65533)*/, NULL, 0 },	/* 163 */
  { "GEODATA", DWG_TYPE_GEODATA /*(638)*/, _dwg_GEODATA_fields, sizeof (struct _dwg_object_GEODATA) },	/* 164 */
  { "GEOMAPIMAGE", DWG_TYPE_GEOMAPIMAGE /*(639)*/, _dwg_GEOMAPIMAGE_fields, sizeof (struct _dwg_object_GEOMAPIMAGE) },	/* 165 */
  { "GEOPOSITIONMARKER", DWG_TYPE_GEOPOSITIONMARKER /*(640)*/, _dwg_GEOPOSITIONMARKER_fields, sizeof (struct _dwg_entity_GEOPOSITIONMARKER) },	/* 166 */
  { "GRADIENT_BACKGROUND", DWG_TYPE_GRADIENT_BACKGROUND /*(641)*/, _dwg_GRADIENT_BACKGROUND_fields, sizeof (struct _dwg_object_GRADIENT_BACKGROUND) },	/* 167 */
  { "GROUND_PLANE_BACKGROUND", DWG_TYPE_GROUND_PLANE_BACKGROUND /*(642)*/, _dwg_GROUND_PLANE_BACKGROUND_fields, sizeof (struct _dwg_object_GROUND_PLANE_BACKGROUND) },	/* 168 */
  { "GROUP", DWG_TYPE_GROUP /*(72)*/, _dwg_GROUP_fields, sizeof (struct _dwg_object_GROUP) },	/* 169 */
  { "HATCH", DWG_TYPE_HATCH /*(78)*/, _dwg_HATCH_fields, sizeof (struct _dwg_entity_HATCH) },	/* 170 */
  { "HELIX", DWG_TYPE_HELIX /*(643)*/, _dwg_HELIX_fields, sizeof (struct _dwg_entity_HELIX) },	/* 171 */
  { "IBL_BACKGROUND", DWG_TYPE_IBL_BACKGROUND /*(644)*/, _dwg_IBL_BACKGROUND_fields, sizeof (struct _dwg_object_IBL_BACKGROUND) },	/* 172 */
  { "IDBUFFER", DWG_TYPE_IDBUFFER /*(645)*/, _dwg_IDBUFFER_fields, sizeof (struct _dwg_object_IDBUFFER) },	/* 173 */
  { "IMAGE", DWG_TYPE_IMAGE /*(646)*/, _dwg_IMAGE_fields, sizeof (struct _dwg_entity_IMAGE) },	/* 174 */
  { "IMAGEDEF", DWG_TYPE_IMAGEDEF /*(647)*/, _dwg_IMAGEDEF_fields, sizeof (struct _dwg_object_IMAGEDEF) },	/* 175 */
  { "IMAGEDEF_REACTOR", DWG_TYPE_IMAGEDEF_REACTOR /*(648)*/, _dwg_IMAGEDEF_REACTOR_fields, sizeof (struct _dwg_object_IMAGEDEF_REACTOR) },	/* 176 */
  { "IMAGE_BACKGROUND", DWG_TYPE_IMAGE_BACKGROUND /*(649)*/, _dwg_IMAGE_BACKGROUND_fields, sizeof (struct _dwg_object_IMAGE_BACKGROUND) },	/* 177 */
  { "INDEX", DWG_TYPE_INDEX /*(650)*/, _dwg_INDEX_fields, sizeof (struct _dwg_object_INDEX) },	/* 178 */
  { "INSERT", DWG_TYPE_INSERT /*(7)*/, _dwg_INSERT_fields, sizeof (struct _dwg_entity_INSERT) },	/* 179 */
  { "LARGE_RADIAL_DIMENSION", DWG_TYPE_LARGE_RADIAL_DIMENSION /*(651)*/, _dwg_LARGE_RADIAL_DIMENSION_fields, sizeof (struct _dwg_entity_LARGE_RADIAL_DIMENSION) },	/* 180 */
  { "LAYER", DWG_TYPE_LAYER /*(51)*/, _dwg_LAYER_fields, sizeof (struct _dwg_object_LAYER) },	/* 181 */
  { "LAYERFILTER", DWG_TYPE_LAYERFILTER /*(652)*/, _dwg_LAYERFILTER_fields, sizeof (struct _dwg_object_LAYERFILTER) },	/* 182 */
  { "LAYER_CONTROL", DWG_TYPE_LAYER_CONTROL /*(50)*/, _dwg_LAYER_CONTROL_fields, sizeof (struct _dwg_object_LAYER_CONTROL) },	/* 183 */
  { "LAYER_INDEX", DWG_TYPE_LAYER_INDEX /*(653)*/, _dwg_LAYER_INDEX_fields, sizeof (struct _dwg_object_LAYER_INDEX) },	/* 184 */
  { "LAYOUT", DWG_TYPE_LAYOUT /*(82)*/, _dwg_LAYOUT_fields, sizeof (struct _dwg_object_LAYOUT) },	/* 185 */
  { "LAYOUTPRINTCONFIG", DWG_TYPE_LAYOUTPRINTCONFIG /*(654)*/, _dwg_LAYOUTPRINTCONFIG_fields, sizeof (struct _dwg_object_LAYOUTPRINTCONFIG) },	/* 186 */
  { "LEADER", DWG_TYPE_LEADER /*(45)*/, _dwg_LEADER_fields, sizeof (struct _dwg_entity_LEADER) },	/* 187 */
  { "LEADEROBJECTCONTEXTDATA", DWG_TYPE_LEADEROBJECTCONTEXTDATA /*(655)*/, _dwg_LEADEROBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_LEADEROBJECTCONTEXTDATA) },	/* 188 */
  { "LIGHT", DWG_TYPE_LIGHT /*(656)*/, _dwg_LIGHT_fields, sizeof (struct _dwg_entity_LIGHT) },	/* 189 */
  { "LIGHTLIST", DWG_TYPE_LIGHTLIST /*(657)*/, _dwg_LIGHTLIST_fields, sizeof (struct _dwg_object_LIGHTLIST) },	/* 190 */
  { "LINE", DWG_TYPE_LINE /*(19)*/, _dwg_LINE_fields, sizeof (struct _dwg_entity_LINE) },	/* 191 */
  { "LINEARPARAMETERENTITY", DWG_TYPE_LINEARPARAMETERENTITY /*(658)*/, _dwg_LINEARPARAMETERENTITY_fields, sizeof (struct _dwg_entity_LINEARPARAMETERENTITY) },	/* 192 */
  { "LOFTEDSURFACE", DWG_TYPE_LOFTEDSURFACE /*(659)*/, _dwg_LOFTEDSURFACE_fields, sizeof (struct _dwg_entity_LOFTEDSURFACE) },	/* 193 */
  { "LONG_TRANSACTION", DWG_TYPE_LONG_TRANSACTION /*(76)*/, _dwg_LONG_TRANSACTION_fields, sizeof (struct _dwg_object_LONG_TRANSACTION) },	/* 194 */
  { "LTYPE", DWG_TYPE_LTYPE /*(57)*/, _dwg_LTYPE_fields, sizeof (struct _dwg_object_LTYPE) },	/* 195 */
  { "LTYPE_CONTROL", DWG_TYPE_LTYPE_CONTROL /*(56)*/, _dwg_LTYPE_CONTROL_fields, sizeof (struct _dwg_object_LTYPE_CONTROL) },	/* 196 */
  { "LWPOLYLINE", DWG_TYPE_LWPOLYLINE /*(77)*/, _dwg_LWPOLYLINE_fields, sizeof (struct _dwg_entity_LWPOLYLINE) },	/* 197 */
  { "MATERIAL", DWG_TYPE_MATERIAL /*(660)*/, _dwg_MATERIAL_fields, sizeof (struct _dwg_object_MATERIAL) },	/* 198 */
  { "MENTALRAYRENDERSETTINGS", DWG_TYPE_MENTALRAYRENDERSETTINGS /*(661)*/, _dwg_MENTALRAYRENDERSETTINGS_fields, sizeof (struct _dwg_object_MENTALRAYRENDERSETTINGS) },	/* 199 */
  { "MESH", DWG_TYPE_MESH /*(662)*/, _dwg_MESH_fields, sizeof (struct _dwg_entity_MESH) },	/* 200 */
  { "MINSERT", DWG_TYPE_MINSERT /*(8)*/, _dwg_MINSERT_fields, sizeof (struct _dwg_entity_MINSERT) },	/* 201 */
  { "MLEADEROBJECTCONTEXTDATA", DWG_TYPE_MLEADEROBJECTCONTEXTDATA /*(663)*/, _dwg_MLEADEROBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_MLEADEROBJECTCONTEXTDATA) },	/* 202 */
  { "MLEADERSTYLE", DWG_TYPE_MLEADERSTYLE /*(664)*/, _dwg_MLEADERSTYLE_fields, sizeof (struct _dwg_object_MLEADERSTYLE) },	/* 203 */
  { "MLINE", DWG_TYPE_MLINE /*(47)*/, _dwg_MLINE_fields, sizeof (struct _dwg_entity_MLINE) },	/* 204 */
  { "MLINESTYLE", DWG_TYPE_MLINESTYLE /*(73)*/, _dwg_MLINESTYLE_fields, sizeof (struct _dwg_object_MLINESTYLE) },	/* 205 */
  { "MOTIONPATH", DWG_TYPE_MOTIONPATH /*(665)*/, _dwg_MOTIONPATH_fields, sizeof (struct _dwg_object_MOTIONPATH) },	/* 206 */
  { "MPOLYGON", DWG_TYPE_MPOLYGON /*(666)*/, _dwg_MPOLYGON_fields, sizeof (struct _dwg_entity_MPOLYGON) },	/* 207 */
  { "MTEXT", DWG_TYPE_MTEXT /*(44)*/, _dwg_MTEXT_fields, sizeof (struct _dwg_entity_MTEXT) },	/* 208 */
  { "MTEXTATTRIBUTEOBJECTCONTEXTDATA", DWG_TYPE_MTEXTATTRIBUTEOBJECTCONTEXTDATA /*(667)*/, _dwg_MTEXTATTRIBUTEOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_MTEXTATTRIBUTEOBJECTCONTEXTDATA) },	/* 209 */
  { "MTEXTOBJECTCONTEXTDATA", DWG_TYPE_MTEXTOBJECTCONTEXTDATA /*(668)*/, _dwg_MTEXTOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_MTEXTOBJECTCONTEXTDATA) },	/* 210 */
  { "MULTILEADER", DWG_TYPE_MULTILEADER /*(669)*/, _dwg_MULTILEADER_fields, sizeof (struct _dwg_entity_MULTILEADER) },	/* 211 */
  { "NAVISWORKSMODEL", DWG_TYPE_NAVISWORKSMODEL /*(670)*/, _dwg_NAVISWORKSMODEL_fields, sizeof (struct _dwg_entity_NAVISWORKSMODEL) },	/* 212 */
  { "NAVISWORKSMODELDEF", DWG_TYPE_NAVISWORKSMODELDEF /*(671)*/, _dwg_NAVISWORKSMODELDEF_fields, sizeof (struct _dwg_object_NAVISWORKSMODELDEF) },	/* 213 */
  { "NPOCOLLECTION", DWG_TYPE_NPOCOLLECTION /*(672)*/, NULL, 0 },	/* 214 */
  { "NURBSURFACE", DWG_TYPE_NURBSURFACE /*(673)*/, _dwg_NURBSURFACE_fields, sizeof (struct _dwg_entity_NURBSURFACE) },	/* 215 */
  { "OBJECT_PTR", DWG_TYPE_OBJECT_PTR /*(674)*/, _dwg_OBJECT_PTR_fields, sizeof (struct _dwg_object_OBJECT_PTR) },	/* 216 */
  { "OLE2FRAME", DWG_TYPE_OLE2FRAME /*(74)*/, _dwg_OLE2FRAME_fields, sizeof (struct _dwg_entity_OLE2FRAME) },	/* 217 */
  { "OLEFRAME", DWG_TYPE_OLEFRAME /*(43)*/, _dwg_OLEFRAME_fields, sizeof (struct _dwg_entity_OLEFRAME) },	/* 218 */
  { "ORDDIMOBJECTCONTEXTDATA", DWG_TYPE_ORDDIMOBJECTCONTEXTDATA /*(675)*/, _dwg_ORDDIMOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_ORDDIMOBJECTCONTEXTDATA) },	/* 219 */
  { "PARTIAL_VIEWING_INDEX", DWG_TYPE_PARTIAL_VIEWING_INDEX /*(676)*/, _dwg_PARTIAL_VIEWING_INDEX_fields, sizeof (struct _dwg_object_PARTIAL_VIEWING_INDEX) },	/* 220 */
  { "PDFDEFINITION", DWG_TYPE_PDFDEFINITION /*(677)*/, _dwg_UNDERLAYDEFINITION_fields, sizeof (Dwg_Object_PDFDEFINITION) },	/* 221 */
  { "PDFUNDERLAY", DWG_TYPE_PDFUNDERLAY /*(678)*/, _dwg_UNDERLAY_fields, sizeof (Dwg_Entity_PDFUNDERLAY) },	/* 222 */
  { "PERSUBENTMGR", DWG_TYPE_PERSUBENTMGR /*(679)*/, _dwg_PERSUBENTMGR_fields, sizeof (struct _dwg_object_PERSUBENTMGR) },	/* 223 */
  { "PLACEHOLDER", DWG_TYPE_PLACEHOLDER /*(80)*/, _dwg_PLACEHOLDER_fields, sizeof (struct _dwg_object_PLACEHOLDER) },	/* 224 */
  { "PLANESURFACE", DWG_TYPE_PLANESURFACE /*(680)*/, _dwg_PLANESURFACE_fields, sizeof (struct _dwg_entity_PLANESURFACE) },	/* 225 */
  { "PLOTSETTINGS", DWG_TYPE_PLOTSETTINGS /*(681)*/, _dwg_PLOTSETTINGS_fields, sizeof (struct _dwg_object_PLOTSETTINGS) },	/* 226 */
  { "POINT", DWG_TYPE_POINT /*(27)*/, _dwg_POINT_fields, sizeof (struct _dwg_entity_POINT) },	/* 227 */
  { "POINTCLOUD", DWG_TYPE_POINTCLOUD /*(682)*/, _dwg_POINTCLOUD_fields, sizeof (struct _dwg_entity_POINTCLOUD) },	/* 228 */
  { "POINTCLOUDCOLORMAP", DWG_TYPE_POINTCLOUDCOLORMAP /*(683)*/, _dwg_POINTCLOUDCOLORMAP_fields, sizeof (struct _dwg_object_POINTCLOUDCOLORMAP) },	/* 229 */
  { "POINTCLOUDDEF", DWG_TYPE_POINTCLOUDDEF /*(684)*/, _dwg_POINTCLOUDDEF_fields, sizeof (struct _dwg_object_POINTCLOUDDEF) },	/* 230 */
  { "POINTCLOUDDEFEX", DWG_TYPE_POINTCLOUDDEFEX /*(685)*/, _dwg_POINTCLOUDDEFEX_fields, sizeof (struct _dwg_object_POINTCLOUDDEFEX) },	/* 231 */
  { "POINTCLOUDDEF_REACTOR", DWG_TYPE_POINTCLOUDDEF_REACTOR /*(686)*/, _dwg_POINTCLOUDDEF_REACTOR_fields, sizeof (struct _dwg_object_POINTCLOUDDEF_REACTOR) },	/* 232 */
  { "POINTCLOUDDEF_REACTOR_EX", DWG_TYPE_POINTCLOUDDEF_REACTOR_EX /*(687)*/, _dwg_POINTCLOUDDEF_REACTOR_EX_fields, sizeof (struct _dwg_object_POINTCLOUDDEF_REACTOR_EX) },	/* 233 */
  { "POINTCLOUDEX", DWG_TYPE_POINTCLOUDEX /*(688)*/, _dwg_POINTCLOUDEX_fields, sizeof (struct _dwg_entity_POINTCLOUDEX) },	/* 234 */
  { "POINTPARAMETERENTITY", DWG_TYPE_POINTPARAMETERENTITY /*(689)*/, _dwg_POINTPARAMETERENTITY_fields, sizeof (struct _dwg_entity_POINTPARAMETERENTITY) },	/* 235 */
  { "POINTPATH", DWG_TYPE_POINTPATH /*(690)*/, _dwg_POINTPATH_fields, sizeof (struct _dwg_object_POINTPATH) },	/* 236 */
  { "POLARGRIPENTITY", DWG_TYPE_POLARGRIPENTITY /*(691)*/, _dwg_POLARGRIPENTITY_fields, sizeof (struct _dwg_entity_POLARGRIPENTITY) },	/* 237 */
  { "POLYLINE_2D", DWG_TYPE_POLYLINE_2D /*(15)*/, _dwg_POLYLINE_2D_fields, sizeof (struct _dwg_entity_POLYLINE_2D) },	/* 238 */
  { "POLYLINE_3D", DWG_TYPE_POLYLINE_3D /*(16)*/, _dwg_POLYLINE_3D_fields, sizeof (struct _dwg_entity_POLYLINE_3D) },	/* 239 */
  { "POLYLINE_MESH", DWG_TYPE_POLYLINE_MESH /*(30)*/, _dwg_POLYLINE_MESH_fields, sizeof (struct _dwg_entity_POLYLINE_MESH) },	/* 240 */
  { "POLYLINE_PFACE", DWG_TYPE_POLYLINE_PFACE /*(29)*/, _dwg_POLYLINE_PFACE_fields, sizeof (struct _dwg_entity_POLYLINE_PFACE) },	/* 241 */
  { "PROXY_ENTITY", DWG_TYPE_PROXY_ENTITY /*(498)*/, _dwg_PROXY_ENTITY_fields, sizeof (struct _dwg_entity_PROXY_ENTITY) },	/* 242 */
  { "PROXY_OBJECT", DWG_TYPE_PROXY_OBJECT /*(499)*/, _dwg_PROXY_OBJECT_fields, sizeof (struct _dwg_object_PROXY_OBJECT) },	/* 243 */
  { "RADIMLGOBJECTCONTEXTDATA", DWG_TYPE_RADIMLGOBJECTCONTEXTDATA /*(692)*/, _dwg_RADIMLGOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_RADIMLGOBJECTCONTEXTDATA) },	/* 244 */
  { "RADIMOBJECTCONTEXTDATA", DWG_TYPE_RADIMOBJECTCONTEXTDATA /*(693)*/, _dwg_RADIMOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_RADIMOBJECTCONTEXTDATA) },	/* 245 */
  { "RAPIDRTRENDERSETTINGS", DWG_TYPE_RAPIDRTRENDERSETTINGS /*(694)*/, _dwg_RAPIDRTRENDERSETTINGS_fields, sizeof (struct _dwg_object_RAPIDRTRENDERSETTINGS) },	/* 246 */
  { "RASTERVARIABLES", DWG_TYPE_RASTERVARIABLES /*(695)*/, _dwg_RASTERVARIABLES_fields, sizeof (struct _dwg_object_RASTERVARIABLES) },	/* 247 */
  { "RAY", DWG_TYPE_RAY /*(40)*/, _dwg_RAY_fields, sizeof (struct _dwg_entity_RAY) },	/* 248 */
  { "REGION", DWG_TYPE_REGION /*(37)*/, _dwg_3DSOLID_fields, sizeof (struct _dwg_entity_3DSOLID) },	/* 249 */
  { "RENDERENTRY", DWG_TYPE_RENDERENTRY /*(696)*/, _dwg_RENDERENTRY_fields, sizeof (struct _dwg_object_RENDERENTRY) },	/* 250 */
  { "RENDERENVIRONMENT", DWG_TYPE_RENDERENVIRONMENT /*(697)*/, _dwg_RENDERENVIRONMENT_fields, sizeof (struct _dwg_object_RENDERENVIRONMENT) },	/* 251 */
  { "RENDERGLOBAL", DWG_TYPE_RENDERGLOBAL /*(698)*/, _dwg_RENDERGLOBAL_fields, sizeof (struct _dwg_object_RENDERGLOBAL) },	/* 252 */
  { "RENDERSETTINGS", DWG_TYPE_RENDERSETTINGS /*(699)*/, _dwg_RENDERSETTINGS_fields, sizeof (struct _dwg_object_RENDERSETTINGS) },	/* 253 */
  { "REVOLVEDSURFACE", DWG_TYPE_REVOLVEDSURFACE /*(700)*/, _dwg_REVOLVEDSURFACE_fields, sizeof (struct _dwg_entity_REVOLVEDSURFACE) },	/* 254 */
  { "ROTATIONPARAMETERENTITY", DWG_TYPE_ROTATIONPARAMETERENTITY /*(701)*/, _dwg_ROTATIONPARAMETERENTITY_fields, sizeof (struct _dwg_entity_ROTATIONPARAMETERENTITY) },	/* 255 */
  { "RTEXT", DWG_TYPE_RTEXT /*(702)*/, _dwg_RTEXT_fields, sizeof (struct _dwg_entity_RTEXT) },	/* 256 */
  { "SCALE", DWG_TYPE_SCALE /*(703)*/, _dwg_SCALE_fields, sizeof (struct _dwg_object_SCALE) },	/* 257 */
  { "SECTIONOBJECT", DWG_TYPE_SECTIONOBJECT /*(704)*/, _dwg_SECTIONOBJECT_fields, sizeof (struct _dwg_entity_SECTIONOBJECT) },	/* 258 */
  { "SECTIONVIEWSTYLE", DWG_TYPE_SECTIONVIEWSTYLE /*(705)*/, _dwg_SECTIONVIEWSTYLE_fields, sizeof (struct _dwg_object_SECTIONVIEWSTYLE) },	/* 259 */
  { "SECTION_MANAGER", DWG_TYPE_SECTION_MANAGER /*(706)*/, _dwg_SECTION_MANAGER_fields, sizeof (struct _dwg_object_SECTION_MANAGER) },	/* 260 */
  { "SECTION_SETTINGS", DWG_TYPE_SECTION_SETTINGS /*(707)*/, _dwg_SECTION_SETTINGS_fields, sizeof (struct _dwg_object_SECTION_SETTINGS) },	/* 261 */
  { "SEQEND", DWG_TYPE_SEQEND /*(6)*/, _dwg_SEQEND_fields, sizeof (struct _dwg_entity_SEQEND) },	/* 262 */
  { "SHAPE", DWG_TYPE_SHAPE /*(33)*/, _dwg_SHAPE_fields, sizeof (struct _dwg_entity_SHAPE) },	/* 263 */
  { "SKYLIGHT_BACKGROUND", DWG_TYPE_SKYLIGHT_BACKGROUND /*(708)*/, _dwg_SKYLIGHT_BACKGROUND_fields, sizeof (struct _dwg_object_SKYLIGHT_BACKGROUND) },	/* 264 */
  { "SOLID", DWG_TYPE_SOLID /*(31)*/, _dwg_SOLID_fields, sizeof (struct _dwg_entity_SOLID) },	/* 265 */
  { "SOLID_BACKGROUND", DWG_TYPE_SOLID_BACKGROUND /*(709)*/, _dwg_SOLID_BACKGROUND_fields, sizeof (struct _dwg_object_SOLID_BACKGROUND) },	/* 266 */
  { "SORTENTSTABLE", DWG_TYPE_SORTENTSTABLE /*(710)*/, _dwg_SORTENTSTABLE_fields, sizeof (struct _dwg_object_SORTENTSTABLE) },	/* 267 */
  { "SPATIAL_FILTER", DWG_TYPE_SPATIAL_FILTER /*(711)*/, _dwg_SPATIAL_FILTER_fields, sizeof (struct _dwg_object_SPATIAL_FILTER) },	/* 268 */
  { "SPATIAL_INDEX", DWG_TYPE_SPATIAL_INDEX /*(712)*/, _dwg_SPATIAL_INDEX_fields, sizeof (struct _dwg_object_SPATIAL_INDEX) },	/* 269 */
  { "SPLINE", DWG_TYPE_SPLINE /*(36)*/, _dwg_SPLINE_fields, sizeof (struct _dwg_entity_SPLINE) },	/* 270 */
  { "STYLE", DWG_TYPE_STYLE /*(53)*/, _dwg_STYLE_fields, sizeof (struct _dwg_object_STYLE) },	/* 271 */
  { "STYLE_CONTROL", DWG_TYPE_STYLE_CONTROL /*(52)*/, _dwg_STYLE_CONTROL_fields, sizeof (struct _dwg_object_STYLE_CONTROL) },	/* 272 */
  { "SUN", DWG_TYPE_SUN /*(713)*/, _dwg_SUN_fields, sizeof (struct _dwg_object_SUN) },	/* 273 */
  { "SUNSTUDY", DWG_TYPE_SUNSTUDY /*(714)*/, _dwg_SUNSTUDY_fields, sizeof (struct _dwg_object_SUNSTUDY) },	/* 274 */
  { "SWEPTSURFACE", DWG_TYPE_SWEPTSURFACE /*(715)*/, _dwg_SWEPTSURFACE_fields, sizeof (struct _dwg_entity_SWEPTSURFACE) },	/* 275 */
  { "TABLE", DWG_TYPE_TABLE /*(716)*/, _dwg_TABLE_fields, sizeof (struct _dwg_entity_TABLE) },	/* 276 */
  { "TABLECONTENT", DWG_TYPE_TABLECONTENT /*(717)*/, _dwg_TABLECONTENT_fields, sizeof (struct _dwg_object_TABLECONTENT) },	/* 277 */
  { "TABLEGEOMETRY", DWG_TYPE_TABLEGEOMETRY /*(718)*/, _dwg_TABLEGEOMETRY_fields, sizeof (struct _dwg_object_TABLEGEOMETRY) },	/* 278 */
  { "TABLESTYLE", DWG_TYPE_TABLESTYLE /*(719)*/, _dwg_TABLESTYLE_fields, sizeof (struct _dwg_object_TABLESTYLE) },	/* 279 */
  { "TEXT", DWG_TYPE_TEXT /*(1)*/, _dwg_TEXT_fields, sizeof (struct _dwg_entity_TEXT) },	/* 280 */
  { "TEXTOBJECTCONTEXTDATA", DWG_TYPE_TEXTOBJECTCONTEXTDATA /*(720)*/, _dwg_TEXTOBJECTCONTEXTDATA_fields, sizeof (struct _dwg_object_TEXTOBJECTCONTEXTDATA) },	/* 281 */
  { "TOLERANCE", DWG_TYPE_TOLERANCE /*(46)*/, _dwg_TOLERANCE_fields, sizeof (struct _dwg_entity_TOLERANCE) },	/* 282 */
  { "TRACE", DWG_TYPE_TRACE /*(32)*/, _dwg_TRACE_fields, sizeof (struct _dwg_entity_TRACE) },	/* 283 */
  { "TVDEVICEPROPERTIES", DWG_TYPE_TVDEVICEPROPERTIES /*(721)*/, _dwg_TVDEVICEPROPERTIES_fields, sizeof (struct _dwg_object_TVDEVICEPROPERTIES) },	/* 284 */
  { "UCS", DWG_TYPE_UCS /*(63)*/, _dwg_UCS_fields, sizeof (struct _dwg_object_UCS) },	/* 285 */
  { "UCS_CONTROL", DWG_TYPE_UCS_CONTROL /*(62)*/, _dwg_UCS_CONTROL_fields, sizeof (struct _dwg_object_UCS_CONTROL) },	/* 286 */
  { "UNKNOWN_ENT", DWG_TYPE_UNKNOWN_ENT /*(65534)*/, _dwg_UNKNOWN_ENT_fields, sizeof (struct _dwg_entity_UNKNOWN_ENT) },	/* 287 */
  { "UNKNOWN_OBJ", DWG_TYPE_UNKNOWN_OBJ /*(65535)*/, _dwg_UNKNOWN_OBJ_fields, sizeof (struct _dwg_object_UNKNOWN_OBJ) },	/* 288 */
  { "UNUSED", DWG_TYPE_UNUSED /*(0)*/, NULL, 0 },	/* 289 */
  { "VBA_PROJECT", DWG_TYPE_VBA_PROJECT /*(81)*/, _dwg_VBA_PROJECT_fields, sizeof (struct _dwg_object_VBA_PROJECT) },	/* 290 */
  { "VERTEX_2D", DWG_TYPE_VERTEX_2D /*(10)*/, _dwg_VERTEX_2D_fields, sizeof (struct _dwg_entity_VERTEX_2D) },	/* 291 */
  { "VERTEX_3D", DWG_TYPE_VERTEX_3D /*(11)*/, _dwg_VERTEX_3D_fields, sizeof (struct _dwg_entity_VERTEX_3D) },	/* 292 */
  { "VERTEX_MESH", DWG_TYPE_VERTEX_MESH /*(12)*/, _dwg_VERTEX_3D_fields, sizeof (struct _dwg_entity_VERTEX_3D) },	/* 293 */
  { "VERTEX_PFACE", DWG_TYPE_VERTEX_PFACE /*(13)*/, _dwg_VERTEX_3D_fields, sizeof (struct _dwg_entity_VERTEX_3D) },	/* 294 */
  { "VERTEX_PFACE_FACE", DWG_TYPE_VERTEX_PFACE_FACE /*(14)*/, _dwg_VERTEX_PFACE_FACE_fields, sizeof (struct _dwg_entity_VERTEX_PFACE_FACE) },	/* 295 */
  { "VIEW", DWG_TYPE_VIEW /*(61)*/, _dwg_VIEW_fields, sizeof (struct _dwg_object_VIEW) },	/* 296 */
  { "VIEWPORT", DWG_TYPE_VIEWPORT /*(34)*/, _dwg_VIEWPORT_fields, sizeof (struct _dwg_entity_VIEWPORT) },	/* 297 */
  { "VIEW_CONTROL", DWG_TYPE_VIEW_CONTROL /*(60)*/, _dwg_VIEW_CONTROL_fields, sizeof (struct _dwg_object_VIEW_CONTROL) },	/* 298 */
  { "VISIBILITYGRIPENTITY", DWG_TYPE_VISIBILITYGRIPENTITY /*(722)*/, _dwg_VISIBILITYGRIPENTITY_fields, sizeof (struct _dwg_entity_VISIBILITYGRIPENTITY) },	/* 299 */
  { "VISIBILITYPARAMETERENTITY", DWG_TYPE_VISIBILITYPARAMETERENTITY /*(723)*/, _dwg_VISIBILITYPARAMETERENTITY_fields, sizeof (struct _dwg_entity_VISIBILITYPARAMETERENTITY) },	/* 300 */
  { "VISUALSTYLE", DWG_TYPE_VISUALSTYLE /*(724)*/, _dwg_VISUALSTYLE_fields, sizeof (struct _dwg_object_VISUALSTYLE) },	/* 301 */
  { "VPORT", DWG_TYPE_VPORT /*(65)*/, _dwg_VPORT_fields, sizeof (struct _dwg_object_VPORT) },	/* 302 */
  { "VPORT_CONTROL", DWG_TYPE_VPORT_CONTROL /*(64)*/, _dwg_VPORT_CONTROL_fields, sizeof (struct _dwg_object_VPORT_CONTROL) },	/* 303 */
  { "VX_CONTROL", DWG_TYPE_VX_CONTROL /*(70)*/, _dwg_VX_CONTROL_fields, sizeof (struct _dwg_object_VX_CONTROL) },	/* 304 */
  { "VX_TABLE_RECORD", DWG_TYPE_VX_TABLE_RECORD /*(71)*/, _dwg_VX_TABLE_RECORD_fields, sizeof (struct _dwg_object_VX_TABLE_RECORD) },	/* 305 */
  { "WIPEOUT", DWG_TYPE_WIPEOUT /*(725)*/, _dwg_WIPEOUT_fields, sizeof (struct _dwg_entity_WIPEOUT) },	/* 306 */
  { "WIPEOUTVARIABLES", DWG_TYPE_WIPEOUTVARIABLES /*(726)*/, _dwg_WIPEOUTVARIABLES_fields, sizeof (struct _dwg_object_WIPEOUTVARIABLES) },	/* 307 */
  { "XLINE", DWG_TYPE_XLINE /*(41)*/, _dwg_RAY_fields, sizeof (struct _dwg_entity_RAY) },	/* 308 */
  { "XRECORD", DWG_TYPE_XRECORD /*(79)*/, _dwg_XRECORD_fields, sizeof (struct _dwg_object_XRECORD) },	/* 309 */
  { "XREFPANELOBJECT", DWG_TYPE_XREFPANELOBJECT /*(727)*/, NULL, 0 },	/* 310 */
  { "XYPARAMETERENTITY", DWG_TYPE_XYPARAMETERENTITY /*(728)*/, _dwg_XYPARAMETERENTITY_fields, sizeof (struct _dwg_entity_XYPARAMETERENTITY) },	/* 311 */

};

/* Generated fields for all the subclasses, sorted for bsearch */
static const struct _name_subclass_fields dwg_list_subclasses[] = {
  { "3DSOLID_material", (int)DWG_TYPE__3DSOLID, NULL, _dwg_3DSOLID_material_fields, sizeof (Dwg_3DSOLID_material) },	/* 0 */
  { "3DSOLID_silhouette", (int)DWG_TYPE__3DSOLID, NULL, _dwg_3DSOLID_silhouette_fields, sizeof (Dwg_3DSOLID_silhouette) },	/* 1 */
  { "3DSOLID_wire", (int)DWG_TYPE__3DSOLID, NULL, _dwg_3DSOLID_wire_fields, sizeof (Dwg_3DSOLID_wire) },	/* 2 */
  { "ACSH_HistoryNode", 0, NULL, _dwg_ACSH_HistoryNode_fields, sizeof (Dwg_ACSH_HistoryNode) },	/* 3 */
  { "ACSH_SubentColor", 0, NULL, _dwg_ACSH_SubentColor_fields, sizeof (Dwg_ACSH_SubentColor) },	/* 4 */
  { "ACSH_SubentMaterial", 0, NULL, _dwg_ACSH_SubentMaterial_fields, sizeof (Dwg_ACSH_SubentMaterial) },	/* 5 */
  { "ACTIONBODY", 0, "AcDbAssocActionBody", _dwg_ACTIONBODY_fields, sizeof (Dwg_ACTIONBODY) },	/* 6 */
  { "ARRAYITEMLOCATOR", 0, NULL, _dwg_ARRAYITEMLOCATOR_fields, sizeof (Dwg_ARRAYITEMLOCATOR) },	/* 7 */
  { "ASSOCACTIONBODY_action", 0, NULL, _dwg_ASSOCACTIONBODY_action_fields, sizeof (Dwg_ASSOCACTIONBODY_action) },	/* 8 */
  { "ASSOCACTION_Deps", (int)DWG_TYPE_ASSOCACTION, NULL, _dwg_ASSOCACTION_Deps_fields, sizeof (Dwg_ASSOCACTION_Deps) },	/* 9 */
  { "ASSOCARRAYITEM", 0, NULL, _dwg_ASSOCARRAYITEM_fields, sizeof (Dwg_ASSOCARRAYITEM) },	/* 10 */
  { "ASSOCPARAMBASEDACTIONBODY", 0, NULL, _dwg_ASSOCPARAMBASEDACTIONBODY_fields, sizeof (Dwg_ASSOCPARAMBASEDACTIONBODY) },	/* 11 */
  { "ASSOCSURFACEACTIONBODY", 0, NULL, _dwg_ASSOCSURFACEACTIONBODY_fields, sizeof (Dwg_ASSOCSURFACEACTIONBODY) },	/* 12 */
  { "AcDs", 0, NULL, _dwg_AcDs_fields, sizeof (Dwg_AcDs) },	/* 13 */
  { "AcDs_Data", 0, NULL, _dwg_AcDs_Data_fields, sizeof (Dwg_AcDs_Data) },	/* 14 */
  { "AcDs_DataBlob", 0, NULL, _dwg_AcDs_DataBlob_fields, sizeof (Dwg_AcDs_DataBlob) },	/* 15 */
  { "AcDs_DataBlob01", 0, NULL, _dwg_AcDs_DataBlob01_fields, sizeof (Dwg_AcDs_DataBlob01) },	/* 16 */
  { "AcDs_DataBlobRef", 0, NULL, _dwg_AcDs_DataBlobRef_fields, sizeof (Dwg_AcDs_DataBlobRef) },	/* 17 */
  { "AcDs_DataBlobRef_Page", 0, NULL, _dwg_AcDs_DataBlobRef_Page_fields, sizeof (Dwg_AcDs_DataBlobRef_Page) },	/* 18 */
  { "AcDs_DataIndex", 0, NULL, _dwg_AcDs_DataIndex_fields, sizeof (Dwg_AcDs_DataIndex) },	/* 19 */
  { "AcDs_DataIndex_Entry", 0, NULL, _dwg_AcDs_DataIndex_Entry_fields, sizeof (Dwg_AcDs_DataIndex_Entry) },	/* 20 */
  { "AcDs_Data_Record", 0, NULL, _dwg_AcDs_Data_Record_fields, sizeof (Dwg_AcDs_Data_Record) },	/* 21 */
  { "AcDs_Data_RecordHdr", 0, NULL, _dwg_AcDs_Data_RecordHdr_fields, sizeof (Dwg_AcDs_Data_RecordHdr) },	/* 22 */
  { "AcDs_Schema", 0, NULL, _dwg_AcDs_Schema_fields, sizeof (Dwg_AcDs_Schema) },	/* 23 */
  { "AcDs_SchemaData", 0, NULL, _dwg_AcDs_SchemaData_fields, sizeof (Dwg_AcDs_SchemaData) },	/* 24 */
  { "AcDs_SchemaData_UProp", 0, NULL, _dwg_AcDs_SchemaData_UProp_fields, sizeof (Dwg_AcDs_SchemaData_UProp) },	/* 25 */
  { "AcDs_SchemaIndex", 0, NULL, _dwg_AcDs_SchemaIndex_fields, sizeof (Dwg_AcDs_SchemaIndex) },	/* 26 */
  { "AcDs_SchemaIndex_Prop", 0, NULL, _dwg_AcDs_SchemaIndex_Prop_fields, sizeof (Dwg_AcDs_SchemaIndex_Prop) },	/* 27 */
  { "AcDs_Schema_Prop", 0, NULL, _dwg_AcDs_Schema_Prop_fields, sizeof (Dwg_AcDs_Schema_Prop) },	/* 28 */
  { "AcDs_Search", 0, NULL, _dwg_AcDs_Search_fields, sizeof (Dwg_AcDs_Search) },	/* 29 */
  { "AcDs_Search_Data", 0, NULL, _dwg_AcDs_Search_Data_fields, sizeof (Dwg_AcDs_Search_Data) },	/* 30 */
  { "AcDs_Search_IdIdx", 0, NULL, _dwg_AcDs_Search_IdIdx_fields, sizeof (Dwg_AcDs_Search_IdIdx) },	/* 31 */
  { "AcDs_Search_IdIdxs", 0, NULL, _dwg_AcDs_Search_IdIdxs_fields, sizeof (Dwg_AcDs_Search_IdIdxs) },	/* 32 */
  { "AcDs_Segment", 0, NULL, _dwg_AcDs_Segment_fields, sizeof (Dwg_AcDs_Segment) },	/* 33 */
  { "AcDs_SegmentIndex", 0, NULL, _dwg_AcDs_SegmentIndex_fields, sizeof (Dwg_AcDs_SegmentIndex) },	/* 34 */
  { "BLOCKACTION_connectionpts", 0, NULL, _dwg_BLOCKACTION_connectionpts_fields, sizeof (Dwg_BLOCKACTION_connectionpts) },	/* 35 */
  { "BLOCKLOOKUPACTION_lut", (int)DWG_TYPE_BLOCKLOOKUPACTION, NULL, _dwg_BLOCKLOOKUPACTION_lut_fields, sizeof (Dwg_BLOCKLOOKUPACTION_lut) },	/* 36 */
  { "BLOCKPARAMETER_PropInfo", 0, NULL, _dwg_BLOCKPARAMETER_PropInfo_fields, sizeof (Dwg_BLOCKPARAMETER_PropInfo) },	/* 37 */
  { "BLOCKPARAMETER_connection", 0, NULL, _dwg_BLOCKPARAMETER_connection_fields, sizeof (Dwg_BLOCKPARAMETER_connection) },	/* 38 */
  { "BLOCKPARAMVALUESET", 0, NULL, _dwg_BLOCKPARAMVALUESET_fields, sizeof (Dwg_BLOCKPARAMVALUESET) },	/* 39 */
  { "BLOCKVISIBILITYPARAMETER_state", (int)DWG_TYPE_BLOCKVISIBILITYPARAMETER, NULL, _dwg_BLOCKVISIBILITYPARAMETER_state_fields, sizeof (Dwg_BLOCKVISIBILITYPARAMETER_state) },	/* 40 */
  { "COMPOUNDOBJECTID", 0, NULL, _dwg_COMPOUNDOBJECTID_fields, sizeof (Dwg_COMPOUNDOBJECTID) },	/* 41 */
  { "CONSTRAINTGROUPNODE", 0, NULL, _dwg_CONSTRAINTGROUPNODE_fields, sizeof (Dwg_CONSTRAINTGROUPNODE) },	/* 42 */
  { "CONTEXTDATA_dict", 0, NULL, _dwg_CONTEXTDATA_dict_fields, sizeof (Dwg_CONTEXTDATA_dict) },	/* 43 */
  { "CONTEXTDATA_submgr", 0, NULL, _dwg_CONTEXTDATA_submgr_fields, sizeof (Dwg_CONTEXTDATA_submgr) },	/* 44 */
  { "CellContentGeometry", 0, NULL, _dwg_CellContentGeometry_fields, sizeof (Dwg_CellContentGeometry) },	/* 45 */
  { "CellStyle", 0, NULL, _dwg_CellStyle_fields, sizeof (Dwg_CellStyle) },	/* 46 */
  { "ColorRamp", 0, NULL, _dwg_ColorRamp_fields, sizeof (Dwg_ColorRamp) },	/* 47 */
  { "ContentFormat", 0, NULL, _dwg_ContentFormat_fields, sizeof (Dwg_ContentFormat) },	/* 48 */
  { "DATALINK_customdata", (int)DWG_TYPE_DATALINK, NULL, _dwg_DATALINK_customdata_fields, sizeof (Dwg_DATALINK_customdata) },	/* 49 */
  { "DATATABLE_column", (int)DWG_TYPE_DATATABLE, NULL, _dwg_DATATABLE_column_fields, sizeof (Dwg_DATATABLE_column) },	/* 50 */
  { "DATATABLE_row", (int)DWG_TYPE_DATATABLE, NULL, _dwg_DATATABLE_row_fields, sizeof (Dwg_DATATABLE_row) },	/* 51 */
  { "DIMASSOC_Ref", (int)DWG_TYPE_DIMASSOC, NULL, _dwg_DIMASSOC_Ref_fields, sizeof (Dwg_DIMASSOC_Ref) },	/* 52 */
  { "DIMENSION_common", 0, "AcDbDimension", _dwg_DIMENSION_common_fields, sizeof (Dwg_DIMENSION_common) },	/* 53 */
  { "EVAL_Edge", 0, NULL, _dwg_EVAL_Edge_fields, sizeof (Dwg_EVAL_Edge) },	/* 54 */
  { "EVAL_Node", 0, NULL, _dwg_EVAL_Node_fields, sizeof (Dwg_EVAL_Node) },	/* 55 */
  { "EvalExpr", 0, NULL, _dwg_EvalExpr_fields, sizeof (Dwg_EvalExpr) },	/* 56 */
  { "EvalVariant", 0, NULL, _dwg_EvalVariant_fields, sizeof (Dwg_EvalVariant) },	/* 57 */
  { "FIELD_ChildValue", (int)DWG_TYPE_FIELD, NULL, _dwg_FIELD_ChildValue_fields, sizeof (Dwg_FIELD_ChildValue) },	/* 58 */
  { "FileDepList_Files", 0, NULL, _dwg_FileDepList_Files_fields, sizeof (Dwg_FileDepList_Files) },	/* 59 */
  { "FormattedTableData", 0, NULL, _dwg_FormattedTableData_fields, sizeof (Dwg_FormattedTableData) },	/* 60 */
  { "FormattedTableMerged", 0, NULL, _dwg_FormattedTableMerged_fields, sizeof (Dwg_FormattedTableMerged) },	/* 61 */
  { "GEODATA_meshface", (int)DWG_TYPE_GEODATA, NULL, _dwg_GEODATA_meshface_fields, sizeof (Dwg_GEODATA_meshface) },	/* 62 */
  { "GEODATA_meshpt", (int)DWG_TYPE_GEODATA, NULL, _dwg_GEODATA_meshpt_fields, sizeof (Dwg_GEODATA_meshpt) },	/* 63 */
  { "GridFormat", 0, NULL, _dwg_GridFormat_fields, sizeof (Dwg_GridFormat) },	/* 64 */
  { "HATCH_Color", (int)DWG_TYPE_HATCH, NULL, _dwg_HATCH_Color_fields, sizeof (Dwg_HATCH_Color) },	/* 65 */
  { "HATCH_ControlPoint", (int)DWG_TYPE_HATCH, NULL, _dwg_HATCH_ControlPoint_fields, sizeof (Dwg_HATCH_ControlPoint) },	/* 66 */
  { "HATCH_DefLine", (int)DWG_TYPE_HATCH, NULL, _dwg_HATCH_DefLine_fields, sizeof (Dwg_HATCH_DefLine) },	/* 67 */
  { "HATCH_Path", (int)DWG_TYPE_HATCH, NULL, _dwg_HATCH_Path_fields, sizeof (Dwg_HATCH_Path) },	/* 68 */
  { "HATCH_PathSeg", (int)DWG_TYPE_HATCH, NULL, _dwg_HATCH_PathSeg_fields, sizeof (Dwg_HATCH_PathSeg) },	/* 69 */
  { "HATCH_PolylinePath", (int)DWG_TYPE_HATCH, NULL, _dwg_HATCH_PolylinePath_fields, sizeof (Dwg_HATCH_PolylinePath) },	/* 70 */
  { "LAYER_entry", (int)DWG_TYPE_LAYER, NULL, _dwg_LAYER_entry_fields, sizeof (Dwg_LAYER_entry) },	/* 71 */
  { "LEADER_ArrowHead", (int)DWG_TYPE_LEADER, NULL, _dwg_LEADER_ArrowHead_fields, sizeof (Dwg_LEADER_ArrowHead) },	/* 72 */
  { "LEADER_BlockLabel", (int)DWG_TYPE_LEADER, NULL, _dwg_LEADER_BlockLabel_fields, sizeof (Dwg_LEADER_BlockLabel) },	/* 73 */
  { "LEADER_Break", (int)DWG_TYPE_LEADER, NULL, _dwg_LEADER_Break_fields, sizeof (Dwg_LEADER_Break) },	/* 74 */
  { "LEADER_Line", (int)DWG_TYPE_LEADER, NULL, _dwg_LEADER_Line_fields, sizeof (Dwg_LEADER_Line) },	/* 75 */
  { "LEADER_Node", (int)DWG_TYPE_LEADER, NULL, _dwg_LEADER_Node_fields, sizeof (Dwg_LEADER_Node) },	/* 76 */
  { "LIGHTLIST_light", (int)DWG_TYPE_LIGHTLIST, NULL, _dwg_LIGHTLIST_light_fields, sizeof (Dwg_LIGHTLIST_light) },	/* 77 */
  { "LTYPE_dash", (int)DWG_TYPE_LTYPE, NULL, _dwg_LTYPE_dash_fields, sizeof (Dwg_LTYPE_dash) },	/* 78 */
  { "LWPOLYLINE_width", (int)DWG_TYPE_LWPOLYLINE, NULL, _dwg_LWPOLYLINE_width_fields, sizeof (Dwg_LWPOLYLINE_width) },	/* 79 */
  { "LinkedData", 0, NULL, _dwg_LinkedData_fields, sizeof (Dwg_LinkedData) },	/* 80 */
  { "LinkedTableData", 0, NULL, _dwg_LinkedTableData_fields, sizeof (Dwg_LinkedTableData) },	/* 81 */
  { "MATERIAL_color", (int)DWG_TYPE_MATERIAL, NULL, _dwg_MATERIAL_color_fields, sizeof (Dwg_MATERIAL_color) },	/* 82 */
  { "MATERIAL_gentexture", (int)DWG_TYPE_MATERIAL, NULL, _dwg_MATERIAL_gentexture_fields, sizeof (Dwg_MATERIAL_gentexture) },	/* 83 */
  { "MATERIAL_mapper", (int)DWG_TYPE_MATERIAL, NULL, _dwg_MATERIAL_mapper_fields, sizeof (Dwg_MATERIAL_mapper) },	/* 84 */
  { "MESH_edge", (int)DWG_TYPE_MESH, NULL, _dwg_MESH_edge_fields, sizeof (Dwg_MESH_edge) },	/* 85 */
  { "MLEADER_AnnotContext", 0, "AcDbMLeaderAnnotContext", _dwg_MLEADER_AnnotContext_fields, sizeof (Dwg_MLEADER_AnnotContext) },	/* 86 */
  { "MLEADER_Content", 0, NULL, _dwg_MLEADER_Content_fields, sizeof (Dwg_MLEADER_Content) },	/* 87 */
  { "MLEADER_Content_Block", 0, NULL, _dwg_MLEADER_Content_Block_fields, sizeof (Dwg_MLEADER_Content_Block) },	/* 88 */
  { "MLEADER_Content_MText", 0, NULL, _dwg_MLEADER_Content_MText_fields, sizeof (Dwg_MLEADER_Content_MText) },	/* 89 */
  { "MLINESTYLE_line", (int)DWG_TYPE_MLINESTYLE, NULL, _dwg_MLINESTYLE_line_fields, sizeof (Dwg_MLINESTYLE_line) },	/* 90 */
  { "MLINE_line", (int)DWG_TYPE_MLINE, NULL, _dwg_MLINE_line_fields, sizeof (Dwg_MLINE_line) },	/* 91 */
  { "MLINE_vertex", (int)DWG_TYPE_MLINE, NULL, _dwg_MLINE_vertex_fields, sizeof (Dwg_MLINE_vertex) },	/* 92 */
  { "OCD_Dimension", 0, "AcDbDimensionObjectContextData", _dwg_OCD_Dimension_fields, sizeof (Dwg_OCD_Dimension) },	/* 93 */
  { "PARTIAL_VIEWING_INDEX_Entry", (int)DWG_TYPE_PARTIAL_VIEWING_INDEX, NULL, _dwg_PARTIAL_VIEWING_INDEX_Entry_fields, sizeof (Dwg_PARTIAL_VIEWING_INDEX_Entry) },	/* 94 */
  { "POINTCLOUDCOLORMAP_Ramp", (int)DWG_TYPE_POINTCLOUDCOLORMAP, NULL, _dwg_POINTCLOUDCOLORMAP_Ramp_fields, sizeof (Dwg_POINTCLOUDCOLORMAP_Ramp) },	/* 95 */
  { "POINTCLOUDEX_Croppings", (int)DWG_TYPE_POINTCLOUDEX, NULL, _dwg_POINTCLOUDEX_Croppings_fields, sizeof (Dwg_POINTCLOUDEX_Croppings) },	/* 96 */
  { "POINTCLOUD_Clippings", (int)DWG_TYPE_POINTCLOUD, NULL, _dwg_POINTCLOUD_Clippings_fields, sizeof (Dwg_POINTCLOUD_Clippings) },	/* 97 */
  { "POINTCLOUD_IntensityStyle", (int)DWG_TYPE_POINTCLOUD, NULL, _dwg_POINTCLOUD_IntensityStyle_fields, sizeof (Dwg_POINTCLOUD_IntensityStyle) },	/* 98 */
  { "PROXY_LWPOLYLINE", 0, NULL, _dwg_PROXY_LWPOLYLINE_fields, sizeof (Dwg_PROXY_LWPOLYLINE) },	/* 99 */
  { "R2004_Header", 0, NULL, _dwg_R2004_Header_fields, sizeof (Dwg_R2004_Header) },	/* 100 */
  { "SECTION_geometrysettings", 0, NULL, _dwg_SECTION_geometrysettings_fields, sizeof (Dwg_SECTION_geometrysettings) },	/* 101 */
  { "SECTION_typesettings", 0, NULL, _dwg_SECTION_typesettings_fields, sizeof (Dwg_SECTION_typesettings) },	/* 102 */
  { "SPLINE_control_point", (int)DWG_TYPE_SPLINE, NULL, _dwg_SPLINE_control_point_fields, sizeof (Dwg_SPLINE_control_point) },	/* 103 */
  { "SUNSTUDY_Dates", (int)DWG_TYPE_SUNSTUDY, NULL, _dwg_SUNSTUDY_Dates_fields, sizeof (Dwg_SUNSTUDY_Dates) },	/* 104 */
  { "SummaryInfo_Property", 0, NULL, _dwg_SummaryInfo_Property_fields, sizeof (Dwg_SummaryInfo_Property) },	/* 105 */
  { "TABLEGEOMETRY_Cell", (int)DWG_TYPE_TABLEGEOMETRY, NULL, _dwg_TABLEGEOMETRY_Cell_fields, sizeof (Dwg_TABLEGEOMETRY_Cell) },	/* 106 */
  { "TABLESTYLE_CellStyle", (int)DWG_TYPE_TABLESTYLE, NULL, _dwg_TABLESTYLE_CellStyle_fields, sizeof (Dwg_TABLESTYLE_CellStyle) },	/* 107 */
  { "TABLESTYLE_border", (int)DWG_TYPE_TABLESTYLE, NULL, _dwg_TABLESTYLE_border_fields, sizeof (Dwg_TABLESTYLE_border) },	/* 108 */
  { "TABLESTYLE_rowstyles", (int)DWG_TYPE_TABLESTYLE, NULL, _dwg_TABLESTYLE_rowstyles_fields, sizeof (Dwg_TABLESTYLE_rowstyles) },	/* 109 */
  { "TABLE_AttrDef", (int)DWG_TYPE_TABLE, NULL, _dwg_TABLE_AttrDef_fields, sizeof (Dwg_TABLE_AttrDef) },	/* 110 */
  { "TABLE_BreakHeight", (int)DWG_TYPE_TABLE, NULL, _dwg_TABLE_BreakHeight_fields, sizeof (Dwg_TABLE_BreakHeight) },	/* 111 */
  { "TABLE_BreakRow", (int)DWG_TYPE_TABLE, NULL, _dwg_TABLE_BreakRow_fields, sizeof (Dwg_TABLE_BreakRow) },	/* 112 */
  { "TABLE_Cell", (int)DWG_TYPE_TABLE, NULL, _dwg_TABLE_Cell_fields, sizeof (Dwg_TABLE_Cell) },	/* 113 */
  { "TABLE_CustomDataItem", (int)DWG_TYPE_TABLE, NULL, _dwg_TABLE_CustomDataItem_fields, sizeof (Dwg_TABLE_CustomDataItem) },	/* 114 */
  { "TABLE_value", (int)DWG_TYPE_TABLE, NULL, _dwg_TABLE_value_fields, sizeof (Dwg_TABLE_value) },	/* 115 */
  { "TableCell", 0, NULL, _dwg_TableCell_fields, sizeof (Dwg_TableCell) },	/* 116 */
  { "TableCellContent", 0, NULL, _dwg_TableCellContent_fields, sizeof (Dwg_TableCellContent) },	/* 117 */
  { "TableCellContent_Attr", 0, NULL, _dwg_TableCellContent_Attr_fields, sizeof (Dwg_TableCellContent_Attr) },	/* 118 */
  { "TableDataColumn", 0, NULL, _dwg_TableDataColumn_fields, sizeof (Dwg_TableDataColumn) },	/* 119 */
  { "TableRow", 0, NULL, _dwg_TableRow_fields, sizeof (Dwg_TableRow) },	/* 120 */
  { "UCS_orthopts", (int)DWG_TYPE_UCS, NULL, _dwg_UCS_orthopts_fields, sizeof (Dwg_UCS_orthopts) },	/* 121 */
  { "VALUEPARAM", 0, NULL, _dwg_VALUEPARAM_fields, sizeof (Dwg_VALUEPARAM) },	/* 122 */
  { "VALUEPARAM_vars", 0, NULL, _dwg_VALUEPARAM_vars_fields, sizeof (Dwg_VALUEPARAM_vars) },	/* 123 */

};

struct _name_subclasses {
  const char *const name;
  const char *const subclasses[8];
};

/* List of all allowed subclasses per class. sorted for bsearch. */
static const struct _name_subclasses dwg_name_subclasses[] = {
  { "3DFACE", {"AcDbEntity", "AcDbFace", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "3DSOLID", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", NULL, NULL, NULL, NULL, NULL} },
  { "ACMECOMMANDHISTORY", {"AcDbObject", "AcMeCommandHistory", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ACMESCOPE", {"AcDbObject", "AcMeScope", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ACMESTATEMGR", {"AcDbObject", "AcMeStateMgr", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ACSH_BOOLEAN_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShBoolean", NULL, NULL, NULL, NULL} },
  { "ACSH_BOX_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShBox", NULL, NULL, NULL} },
  { "ACSH_BREP_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShBrep", "AcDbModelerGeometry", "AcDb3dSolid", NULL} },
  { "ACSH_CHAMFER_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShChamfer", NULL, NULL, NULL, NULL} },
  { "ACSH_CONE_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShCone", NULL, NULL, NULL} },
  { "ACSH_CYLINDER_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShCylinder", NULL, NULL, NULL} },
  { "ACSH_EXTRUSION_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShSweepBase", "AcDbShExtrusion", NULL, NULL} },
  { "ACSH_FILLET_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShFillet", NULL, NULL, NULL, NULL} },
  { "ACSH_HISTORY_CLASS", {"AcDbObject", "AcDbShHistory", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ACSH_LOFT_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShLoft", NULL, NULL, NULL} },
  { "ACSH_PYRAMID_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShPyramid", NULL, NULL, NULL} },
  { "ACSH_REVOLVE_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShRevolve", NULL, NULL, NULL} },
  { "ACSH_SPHERE_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShSpere", NULL, NULL, NULL} },
  { "ACSH_SWEEP_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShSweepBase", "AcDbShSweep", NULL, NULL} },
  { "ACSH_TORUS_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShTorus", NULL, NULL, NULL} },
  { "ACSH_WEDGE_CLASS", {"AcDbObject", "AcDbEvalExpr", "AcDbShHistoryNode", "AcDbShPrimitive", "AcDbShWedge", NULL, NULL, NULL} },
  { "ALDIMOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbDimensionObjectContextData", "AcDbAlignedDimensionObjectContextData", NULL, NULL, NULL} },
  { "ALIGNMENTPARAMETERENTITY", {"AcDbEntity", "AcDbBlockAlignmentParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ANGDIMOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbDimensionObjectContextData", "AcDbAngularDimensionObjectContextData", NULL, NULL, NULL} },
  { "ANNOTSCALEOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", NULL, NULL, NULL, NULL, NULL} },
  { "APPID", {"AcDbSymbolTableRecord", "AcDbRegAppTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "APPID_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ARC", {"AcDbEntity", "AcDbCircle", "AcDbArc", NULL, NULL, NULL, NULL, NULL} },
  { "ARCALIGNEDTEXT", {"AcDbEntity", "AcDbArcAlignedText", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ARC_DIMENSION", {"AcDbEntity", "AcDbDimension", "AcDbArcDimension", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOC2DCONSTRAINTGROUP", {"AcDbObject", "AcDbAssocAction", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ASSOC3POINTANGULARDIMACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "Assoc3PointAngularDimActionBody", NULL, NULL, NULL, NULL} },
  { "ASSOCACTION", {"AcDbObject", "AcDbAssocAction", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCALIGNEDDIMACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "ACDBASSOCALIGNEDDIMACTIONBODY", NULL, NULL, NULL, NULL} },
  { "ASSOCARRAYACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocArrayActionBody", NULL, NULL, NULL, NULL} },
  { "ASSOCARRAYMODIFYACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocArrayActionBody", "AcDbAssocArrayModifyActionBody", NULL, NULL, NULL} },
  { "ASSOCARRAYMODIFYPARAMETERS", {"AcDbObject", "AcDbAssocArrayCommonParameters", "AcDbAssocArrayModifyParameters", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCARRAYPATHPARAMETERS", {"AcDbObject", "AcDbAssocArrayCommonParameters", "AcDbAssocArrayPathParameters", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCARRAYPOLARPARAMETERS", {"AcDbObject", "AcDbAssocArrayCommonParameters", "AcDbAssocArrayPolarParameters", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCARRAYRECTANGULARPARAMETERS", {"AcDbObject", "AcDbAssocArrayCommonParameters", "AcDbAssocArrayRectangularParameters", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCASMBODYACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocSingleDependencyActionParam", "AcDbAssocAsmbodyActionParam", "AcDbModelerGeometry", "AcDb3dSolid", NULL, NULL} },
  { "ASSOCBLENDSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocBlendSurfaceActionBody", NULL, NULL} },
  { "ASSOCCOMPOUNDACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocCompoundActionParam", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCDEPENDENCY", {"AcDbObject", "AcDbAssocDependency", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCDIMDEPENDENCYBODY", {"AcDbObject", "AcDbAssocDependencyBody", "AcDbImpAssocDimDependencyBodyBase", "AdDbAssocDimDependencyBody", NULL, NULL, NULL, NULL} },
  { "ASSOCEDGEACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocSingleDependencyActionParam", "AcDbAssocEdgeActionParam", NULL, NULL, NULL, NULL} },
  { "ASSOCEDGECHAMFERACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocEdgeChamferActionBody", NULL, NULL} },
  { "ASSOCEDGEFILLETACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocEdgeFilletActionBody", NULL, NULL} },
  { "ASSOCEXTENDSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocExtendSurfaceActionBody", NULL, NULL} },
  { "ASSOCEXTRUDEDSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocExtrudedSurfaceActionBody", NULL, NULL} },
  { "ASSOCFACEACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocSingleDependencyActionParam", "AcDbAssocFaceActionParam", NULL, NULL, NULL, NULL} },
  { "ASSOCFILLETSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocFilletSurfaceActionBody", NULL, NULL} },
  { "ASSOCGEOMDEPENDENCY", {"AcDbObject", "AcDbAssocDependency", "AcDbAssocGeomDependency", "AcDbAssocPersSubentId", NULL, NULL, NULL, NULL} },
  { "ASSOCLOFTEDSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocLoftedSurfaceActionBody", NULL, NULL} },
  { "ASSOCMLEADERACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocMLeaderActionBody", NULL, NULL, NULL, NULL} },
  { "ASSOCNETWORK", {"AcDbObject", "AcDbAssocAction", "AcDbAssocNetwork", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCNETWORKSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocNetworkSurfaceActionBody", NULL, NULL} },
  { "ASSOCOBJECTACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocSingleDependencyActionParam", "AcDbAssocObjectActionParam", NULL, NULL, NULL, NULL} },
  { "ASSOCOFFSETSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocOffsetSurfaceActionBody", NULL, NULL} },
  { "ASSOCORDINATEDIMACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AssocOrdinatedDimActionBody", NULL, NULL, NULL, NULL} },
  { "ASSOCOSNAPPOINTREFACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocCompoundActionParam", "AcDbAssocPathActionParam", "ACDBASSOCOSNAPPOINTREFACTIONPARAM", NULL, NULL, NULL} },
  { "ASSOCPATCHSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocPatchSurfaceActionBody", NULL, NULL} },
  { "ASSOCPATHACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocCompoundActionParam", "AcDbAssocPathActionParam", NULL, NULL, NULL, NULL} },
  { "ASSOCPERSSUBENTMANAGER", {"AcDbObject", "AcDbAssocPersSubentManager", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCPLANESURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocPlaneSurfaceActionBody", NULL, NULL} },
  { "ASSOCPOINTREFACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocCompoundActionParam", "AcDbAssocPointRefActionParam", NULL, NULL, NULL, NULL} },
  { "ASSOCRESTOREENTITYSTATEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocRestoreEntityStateActionBody", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCREVOLVEDSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocRevolvedSurfaceActionBody", NULL, NULL} },
  { "ASSOCROTATEDDIMACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AssocRotatedDimActionBody", NULL, NULL, NULL, NULL} },
  { "ASSOCSWEPTSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocSweptSurfaceActionBody", NULL, NULL} },
  { "ASSOCTRIMSURFACEACTIONBODY", {"AcDbObject", "AcDbAssocActionBody", "AcDbAssocParamBasedActionBody", "AcDbAssocSurfaceActionBody", "AcDbAssocPathBasedSurfaceActionBody", "AcDbAssocTrimSurfaceActionBody", NULL, NULL} },
  { "ASSOCVALUEDEPENDENCY", {"AcDbObject", "AcDbAssocDependency", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCVARIABLE", {"AcDbObject", "AcDbAssocAction", "AcDbAssocVariable", NULL, NULL, NULL, NULL, NULL} },
  { "ASSOCVERTEXACTIONPARAM", {"AcDbObject", "AcDbAssocActionParam", "AcDbAssocSingleDependencyActionParam", "AcDbAssocVertexActionParam", NULL, NULL, NULL, NULL} },
  { "ATTDEF", {"AcDbEntity", "AcDbText", "AcDbAttributeDefinition", "AcDbMText", NULL, NULL, NULL, NULL} },
  { "ATTRIB", {"AcDbEntity", "AcDbText", "AcDbAttribute", "AcDbMText", NULL, NULL, NULL, NULL} },
  { "BASEPOINTPARAMETERENTITY", {"AcDbEntity", "AcDbBlockBasepointParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "BLKREFOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbBlkrefObjectContextData", NULL, NULL, NULL, NULL} },
  { "BLOCK", {"AcDbEntity", "AcDbBlockBegin", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "BLOCKALIGNEDCONSTRAINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockConstraintParameter", "AcDbBlockLinearConstraintParameter", "AcDbBlockAlignedConstraintParameter"} },
  { "BLOCKALIGNMENTGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockAlignmentGrip", NULL, NULL, NULL} },
  { "BLOCKALIGNMENTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockAlignmentParameter", NULL, NULL} },
  { "BLOCKANGULARCONSTRAINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockConstraintParameter", "AcDbBlockAngularConstraintParameter", NULL} },
  { "BLOCKARRAYACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockArrayAction", NULL, NULL, NULL} },
  { "BLOCKBASEPOINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock1PtParameter", "AcDbBlockBasepointParameter", NULL, NULL} },
  { "BLOCKDIAMETRICCONSTRAINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockConstraintParameter", "AcDbBlockDiametricConstraintParameter", NULL} },
  { "BLOCKFLIPACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockFlipAction", NULL, NULL, NULL} },
  { "BLOCKFLIPGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockFlipGrip", NULL, NULL, NULL} },
  { "BLOCKFLIPPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockFlipParameter", NULL, NULL} },
  { "BLOCKGRIPLOCATIONCOMPONENT", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockGripExpr", NULL, NULL, NULL, NULL, NULL} },
  { "BLOCKHORIZONTALCONSTRAINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockConstraintParameter", "AcDbBlockLinearConstraintParameter", "AcDbBlockHorizontalConstraintParameter"} },
  { "BLOCKLINEARCONSTRAINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockConstraintParameter", "AcDbBlockLinearConstraintParameter", NULL} },
  { "BLOCKLINEARGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockLinearGrip", NULL, NULL, NULL} },
  { "BLOCKLINEARPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockLinearParameter", NULL, NULL} },
  { "BLOCKLOOKUPACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockLookupAction", NULL, NULL, NULL} },
  { "BLOCKLOOKUPGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockLookupGrip", NULL, NULL, NULL} },
  { "BLOCKLOOKUPPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock1PtParameter", "AcDbBlockLookupParameter", NULL, NULL} },
  { "BLOCKMOVEACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockMoveAction", NULL, NULL, NULL} },
  { "BLOCKPARAMDEPENDENCYBODY", {"AcDbObject", "AcDbAssocDependencyBody", "AcDbImpAssocDimDependencyBodyBase", "AcDbBlockParameterDependencyBody", NULL, NULL, NULL, NULL} },
  { "BLOCKPOINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock1PtParameter", "AcDbBlockPointParameter", NULL, NULL} },
  { "BLOCKPOLARGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockPolarGrip", NULL, NULL, NULL} },
  { "BLOCKPOLARPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockPolarParameter", NULL, NULL} },
  { "BLOCKPOLARSTRETCHACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockPolarStretchAction", NULL, NULL, NULL} },
  { "BLOCKPROPERTIESTABLE", {"AcDbObject", "AcDbBlockPropertiesTable", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "BLOCKPROPERTIESTABLEGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockPropertiesTableGrip", NULL, NULL, NULL} },
  { "BLOCKRADIALCONSTRAINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockConstraintParameter", "AcDbBlockRadialConstraintParameter", NULL} },
  { "BLOCKREPRESENTATION", {"AcDbObject", "AcDbBlockRepresentationData", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "BLOCKROTATEACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockActionWithBasePt", "AcDbBlockRotationAction", NULL, NULL} },
  { "BLOCKROTATIONGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockRotationGrip", NULL, NULL, NULL} },
  { "BLOCKROTATIONPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockRotationParameter", NULL, NULL} },
  { "BLOCKSCALEACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockActionWithBasePt", "AcDbBlockScaleAction", NULL, NULL} },
  { "BLOCKSTRETCHACTION", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockAction", "AcDbBlockStretchAction", NULL, NULL, NULL} },
  { "BLOCKUSERPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock1PtParameter", "AcDbBlockUserParameter", NULL, NULL} },
  { "BLOCKVERTICALCONSTRAINTPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockConstraintParameter", "AcDbBlockLinearConstraintParameter", "AcDbBlockVerticalConstraintParameter"} },
  { "BLOCKVISIBILITYGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockVisibilityGrip", NULL, NULL, NULL} },
  { "BLOCKVISIBILITYPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock1PtParameter", "AcDbBlockVisibilityParameter", NULL, NULL} },
  { "BLOCKXYGRIP", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockGrip", "AcDbBlockXYGrip", NULL, NULL, NULL} },
  { "BLOCKXYPARAMETER", {"AcDbObject", "AcDbEvalExpr", "AcDbBlockElement", "AcDbBlockParameter", "AcDbBlock2PtParameter", "AcDbBlockXYParameter", NULL, NULL} },
  { "BLOCK_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "BLOCK_HEADER", {"AcDbSymbolTableRecord", "AcDbBlockTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "BODY", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", NULL, NULL, NULL, NULL, NULL} },
  { "CAMERA", {"AcDbEntity", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "CELLSTYLEMAP", {"AcDbObject", "AcDbCellStyleMap", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "CIRCLE", {"AcDbEntity", "AcDbCircle", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "CONTEXTDATAMANAGER", {"AcDbObject", "AcDbContextDataManager", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "CSACDOCUMENTOPTIONS", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "CURVEPATH", {"AcDbObject", "AcDbCurvePath", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DATALINK", {"AcDbObject", "AcDbDataLink", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DATATABLE", {"AcDbObject", "ACDBDATATABLE", "AcDbDataTable", NULL, NULL, NULL, NULL, NULL} },
  { "DBCOLOR", {"AcDbObject", "AcDbColor", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DETAILVIEWSTYLE", {"AcDbObject", "AcDbModelDocViewStyle", "AcDbDetailViewStyle", NULL, NULL, NULL, NULL, NULL} },
  { "DGNDEFINITION", {"AcDbObject", "AcDbUnderlayDefinition", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DGNUNDERLAY", {"AcDbEntity", "AcDbUnderlayReference", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DICTIONARY", {"AcDbObject", "AcDbDictionary", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DICTIONARYVAR", {"AcDbObject", "DictionaryVariables", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DICTIONARYWDFLT", {"AcDbObject", "AcDbDictionary", "AcDbDictionaryWithDefault", NULL, NULL, NULL, NULL, NULL} },
  { "DIMASSOC", {"AcDbObject", "AcDbDimAssoc", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DIMENSION_ALIGNED", {"AcDbEntity", "AcDbDimension", "AcDbAlignedDimension", NULL, NULL, NULL, NULL, NULL} },
  { "DIMENSION_ANG2LN", {"AcDbEntity", "AcDbDimension", "AcDb2LineAngularDimension", NULL, NULL, NULL, NULL, NULL} },
  { "DIMENSION_ANG3PT", {"AcDbEntity", "AcDbDimension", "AcDb3PointAngularDimension", NULL, NULL, NULL, NULL, NULL} },
  { "DIMENSION_DIAMETER", {"AcDbEntity", "AcDbDimension", "AcDbDiametricDimension", NULL, NULL, NULL, NULL, NULL} },
  { "DIMENSION_LINEAR", {"AcDbEntity", "AcDbDimension", "AcDbAlignedDimension", "AcDbRotatedDimension", NULL, NULL, NULL, NULL} },
  { "DIMENSION_ORDINATE", {"AcDbEntity", "AcDbDimension", "AcDbOrdinateDimension", NULL, NULL, NULL, NULL, NULL} },
  { "DIMENSION_RADIUS", {"AcDbEntity", "AcDbDimension", "AcDbRadialDimension", NULL, NULL, NULL, NULL, NULL} },
  { "DIMSTYLE", {"AcDbSymbolTableRecord", "AcDbDimStyleTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DIMSTYLE_CONTROL", {"AcDbSymbolTable", "AcDbDimStyleTable", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DMDIMOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbDimensionObjectContextData", "AcDbDiametricDimensionObjectContextData", NULL, NULL, NULL} },
  { "DUMMY", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DWFDEFINITION", {"AcDbObject", "AcDbUnderlayDefinition", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DWFUNDERLAY", {"AcDbEntity", "AcDbUnderlayReference", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DYNAMICBLOCKPROXYNODE", {"AcDbObject", "AcDbEvalExpr", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "DYNAMICBLOCKPURGEPREVENTER", {"AcDbObject", "AcDbDynamicBlockPurgePreventer", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ELLIPSE", {"AcDbEntity", "AcDbEllipse", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ENDBLK", {"AcDbEntity", "AcDbBlockEnd", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "EVALUATION_GRAPH", {"AcDbObject", "AcDbEvalGraph", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "EXTRUDEDSURFACE", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", "AcDbSurface", "AcDbExtrudedSurface", NULL, NULL, NULL} },
  { "FCFOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbFcfObjectContextData", NULL, NULL, NULL, NULL} },
  { "FIELD", {"AcDbObject", "AcDbField", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "FIELDLIST", {"AcDbObject", "AcDbIdSet", "AcDbFieldList", NULL, NULL, NULL, NULL, NULL} },
  { "FLIPPARAMETERENTITY", {"AcDbEntity", "AcDbBlockFlipParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "GEODATA", {"AcDbObject", "AcDbGeoData", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "GEOMAPIMAGE", {"AcDbObject", "AcDbGeomapImage", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "GEOPOSITIONMARKER", {"AcDbEntity", "AcDbGeoPositionMarker", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "GRADIENT_BACKGROUND", {"AcDbObject", "AcDbGradientBackground", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "GROUND_PLANE_BACKGROUND", {"AcDbObject", "AcDbGroundPlaneBackground", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "GROUP", {"AcDbObject", "AcDbGroup", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "HATCH", {"AcDbEntity", "AcDbHatch", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "HELIX", {"AcDbEntity", "AcDbSpline", "AcDbHelix", NULL, NULL, NULL, NULL, NULL} },
  { "IBL_BACKGROUND", {"AcDbObject", "AcDbIBLBackground", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "IDBUFFER", {"AcDbObject", "AcDbIdBuffer", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "IMAGE", {"AcDbEntity", "AcDbRasterImage", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "IMAGEDEF", {"AcDbObject", "AcDbRasterImageDef", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "IMAGEDEF_REACTOR", {"AcDbObject", "AcDbRasterImageDefReactor", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "IMAGE_BACKGROUND", {"AcDbObject", "AcDbImageBackground", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "INDEX", {"AcDbObject", "AcDbIndex", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "INSERT", {"AcDbEntity", "AcDbBlockReference", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LARGE_RADIAL_DIMENSION", {"AcDbEntity", "AcDbDimension", "AcDbRadialDimensionLarge", NULL, NULL, NULL, NULL, NULL} },
  { "LAYER", {"AcDbSymbolTableRecord", "AcDbLayerTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LAYERFILTER", {"AcDbObject", "AcDbLayerFilter", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LAYER_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LAYER_INDEX", {"AcDbObject", "AcDbIndex", "AcDbLayerIndex", NULL, NULL, NULL, NULL, NULL} },
  { "LAYOUT", {"AcDbObject", "AcDbPlotSettings", "AcDbLayout", NULL, NULL, NULL, NULL, NULL} },
  { "LAYOUTPRINTCONFIG", {"AcDbObject", "CAcLayoutPrintConfig", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LEADER", {"AcDbEntity", "AcDbLeader", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LEADEROBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbLeaderObjectContextData", NULL, NULL, NULL, NULL} },
  { "LIGHT", {"AcDbEntity", "AcDbLight", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LIGHTLIST", {"AcDbObject", "AcDbLightList", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LINE", {"AcDbEntity", "AcDbLine", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LINEARPARAMETERENTITY", {"AcDbEntity", "AcDbBlockLinearParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LOFTEDSURFACE", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", "AcDbSurface", "AcDbLoftedSurface", NULL, NULL, NULL} },
  { "LONG_TRANSACTION", {"AcDbObject", "AcDbLongTransaction", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LTYPE", {"AcDbSymbolTableRecord", "AcDbLinetypeTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LTYPE_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "LWPOLYLINE", {"AcDbEntity", "AcDbPolyline", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MATERIAL", {"AcDbObject", "AcDbMaterial", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MENTALRAYRENDERSETTINGS", {"AcDbObject", "AcDbRenderSettings", "AcDbMentalRayRenderSettings", NULL, NULL, NULL, NULL, NULL} },
  { "MESH", {"AcDbEntity", "AcDbSubDMesh", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MINSERT", {"AcDbEntity", "AcDbMInsertBlock", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MLEADEROBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbMLeaderObjectContextData", NULL, NULL, NULL, NULL} },
  { "MLEADERSTYLE", {"AcDbObject", "AcDbMLeaderStyle", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MLINE", {"AcDbEntity", "AcDbMline", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MLINESTYLE", {"AcDbObject", "AcDbMlineStyle", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MOTIONPATH", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MPOLYGON", {"AcDbEntity", "AcDbMPolygon", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MTEXT", {"AcDbEntity", "AcDbMText", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "MTEXTATTRIBUTEOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbTextObjectContextData", "AcDbMTextAttributeObjectContextData", NULL, NULL, NULL} },
  { "MTEXTOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbMTextObjectContextData", NULL, NULL, NULL, NULL} },
  { "MULTILEADER", {"AcDbEntity", "AcDbMLeader", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "NAVISWORKSMODEL", {"AcDbEntity", "AcDbNavisworksModel", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "NAVISWORKSMODELDEF", {"AcDbObject", "AcDbNavisworksModelDef", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "NURBSURFACE", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", "AcDbSurface", "AcDbNurbSurface", NULL, NULL, NULL} },
  { "OBJECT_PTR", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "OLE2FRAME", {"AcDbEntity", "AcDbOle2Frame", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "OLEFRAME", {"AcDbEntity", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "ORDDIMOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbDimensionObjectContextData", "AcDbOrdinateDimensionObjectContextData", NULL, NULL, NULL} },
  { "PARTIAL_VIEWING_INDEX", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "PDFDEFINITION", {"AcDbObject", "AcDbUnderlayDefinition", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "PDFUNDERLAY", {"AcDbEntity", "AcDbUnderlayReference", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "PERSUBENTMGR", {"AcDbObject", "AcDbPersSubentManager", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "PLACEHOLDER", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "PLANESURFACE", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", "AcDbSurface", NULL, NULL, NULL, NULL} },
  { "PLOTSETTINGS", {"AcDbObject", "AcDbPlotSettings", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINT", {"AcDbEntity", "AcDbPoint", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTCLOUD", {"AcDbEntity", "AcDbPointCloud", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTCLOUDCOLORMAP", {"AcDbObject", "AcDbPointCloudColorMap", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTCLOUDDEF", {"AcDbObject", "AcDbPointCloudDef", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTCLOUDDEFEX", {"AcDbObject", "AcDbPointCloudDefEx", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTCLOUDDEF_REACTOR", {"AcDbObject", "AcDbPointCloudDefReactor", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTCLOUDDEF_REACTOR_EX", {"AcDbObject", "AcDbPointCloudDefReactorEx", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTCLOUDEX", {"AcDbEntity", "AcDbPointCloud", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTPARAMETERENTITY", {"AcDbEntity", "AcDbBlockPointParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POINTPATH", {"AcDbObject", "AcDbPointPath", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POLARGRIPENTITY", {"AcDbEntity", "AcDbBlockPolarGripEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POLYLINE_2D", {"AcDbEntity", "AcDb2dPolyline", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POLYLINE_3D", {"AcDbEntity", "AcDb3dPolyline", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POLYLINE_MESH", {"AcDbEntity", "AcDbPolygonMesh", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "POLYLINE_PFACE", {"AcDbEntity", "AcDbPolyFaceMesh", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "PROXY_ENTITY", {"AcDbEntity", "AcDbProxyEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "PROXY_OBJECT", {"AcDbObject", "AcDbProxyObject", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "RADIMLGOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbDimensionObjectContextData", "AcDbRadialDimensionLargeObjectContextData", NULL, NULL, NULL} },
  { "RADIMOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbDimensionObjectContextData", "AcDbRadialDimensionObjectContextData", NULL, NULL, NULL} },
  { "RAPIDRTRENDERSETTINGS", {"AcDbObject", "AcDbRenderSettings", "AcDbRapidRTRenderSettings", NULL, NULL, NULL, NULL, NULL} },
  { "RASTERVARIABLES", {"AcDbObject", "AcDbRasterVariables", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "RAY", {"AcDbEntity", "AcDbRay", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "REGION", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", NULL, NULL, NULL, NULL, NULL} },
  { "RENDERENTRY", {"AcDbObject", "AcDbRenderEntry", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "RENDERENVIRONMENT", {"AcDbObject", "AcDbRenderEnvironment", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "RENDERGLOBAL", {"AcDbObject", "AcDbRenderGlobal", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "RENDERSETTINGS", {"AcDbObject", "AcDbRenderSettings", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "REVOLVEDSURFACE", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", "AcDbSurface", "AcDbRevolvedSurface", NULL, NULL, NULL} },
  { "ROTATIONPARAMETERENTITY", {"AcDbEntity", "AcDbBlockRotationParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "RTEXT", {"AcDbEntity", "AcDbRText", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SCALE", {"AcDbObject", "AcDbScale", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SECTIONOBJECT", {"AcDbEntity", "AcDbSection", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SECTIONVIEWSTYLE", {"AcDbObject", "AcDbModelDocViewStyle", "AcDbSectionViewStyle", NULL, NULL, NULL, NULL, NULL} },
  { "SECTION_MANAGER", {"AcDbObject", "AcDbSectionManager", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SECTION_SETTINGS", {"AcDbObject", "AcDbSectionSettings", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SEQEND", {"AcDbEntity", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SHAPE", {"AcDbEntity", "AcDbShape", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SKYLIGHT_BACKGROUND", {"AcDbObject", "AcDbSkyBackground", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SOLID", {"AcDbEntity", "AcDbTrace", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SOLID_BACKGROUND", {"AcDbObject", "AcDbSolidBackground", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SORTENTSTABLE", {"AcDbObject", "AcDbSortentsTable", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SPATIAL_FILTER", {"AcDbObject", "AcDbFilter", "AcDbSpatialFilter", NULL, NULL, NULL, NULL, NULL} },
  { "SPATIAL_INDEX", {"AcDbObject", "AcDbIndex", "AcDbSpatialIndex", NULL, NULL, NULL, NULL, NULL} },
  { "SPLINE", {"AcDbEntity", "AcDbSpline", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "STYLE", {"AcDbSymbolTableRecord", "AcDbTextStyleTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "STYLE_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SUN", {"AcDbObject", "AcDbSun", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SUNSTUDY", {"AcDbObject", "AcDbSunStudy", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "SWEPTSURFACE", {"AcDbEntity", "AcDbModelerGeometry", "AcDb3dSolid", "AcDbSurface", "AcDbSweptSurface", NULL, NULL, NULL} },
  { "TABLE", {"AcDbEntity", "AcDbLinkedTableData", "AcDbFormattedTableData", "AcDbTableContent", "AcDbLinkedData", "AcDbBlockReference", "AcDbTable", NULL} },
  { "TABLECONTENT", {"AcDbObject", "AcDbLinkedTableData", "AcDbFormattedTableData", "AcDbTableContent", "AcDbLinkedData", NULL, NULL, NULL} },
  { "TABLEGEOMETRY", {"AcDbObject", "AcDbTableGeometry", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "TABLESTYLE", {"AcDbObject", "AcDbTableStyle", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "TEXT", {"AcDbEntity", "AcDbText", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "TEXTOBJECTCONTEXTDATA", {"AcDbObject", "AcDbObjectContextData", "AcDbAnnotScaleObjectContextData", "AcDbTextObjectContextData", NULL, NULL, NULL, NULL} },
  { "TOLERANCE", {"AcDbEntity", "AcDbFcf", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "TRACE", {"AcDbEntity", "AcDbTrace", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "TVDEVICEPROPERTIES", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "UCS", {"AcDbSymbolTableRecord", "AcDbUCSTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "UCS_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "UNKNOWN_ENT", {"AcDbEntity", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "UNKNOWN_OBJ", {"AcDbObject", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VBA_PROJECT", {"AcDbObject", "AcDbVbaProject", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VERTEX_2D", {"AcDbEntity", "AcDbVertex", "AcDb2dVertex", NULL, NULL, NULL, NULL, NULL} },
  { "VERTEX_3D", {"AcDbEntity", "AcDbVertex", "AcDb3dPolylineVertex", NULL, NULL, NULL, NULL, NULL} },
  { "VERTEX_MESH", {"AcDbEntity", "AcDbVertex", "AcDbPolyFaceMeshVertex", NULL, NULL, NULL, NULL, NULL} },
  { "VERTEX_PFACE", {"AcDbEntity", "AcDbVertex", "AcDbPolyFaceMeshVertex", NULL, NULL, NULL, NULL, NULL} },
  { "VERTEX_PFACE_FACE", {"AcDbEntity", "AcDbFaceRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VIEW", {"AcDbSymbolTableRecord", "AcDbViewTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VIEWPORT", {"AcDbEntity", "AcDbViewport", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VIEW_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VISIBILITYGRIPENTITY", {"AcDbEntity", "AcDbBlockVisibilityGripEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VISIBILITYPARAMETERENTITY", {"AcDbEntity", "AcDbBlockVisibilityParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VISUALSTYLE", {"AcDbObject", "AcDbVisualStyle", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VPORT", {"AcDbSymbolTableRecord", "AcDbViewportTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VPORT_CONTROL", {"AcDbSymbolTable", NULL, NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VX_CONTROL", {"AcDbSymbolTable", "AcDbVXTable", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "VX_TABLE_RECORD", {"AcDbSymbolTableRecord", "AcDbVXTableRecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "WIPEOUT", {"AcDbEntity", "AcDbWipeout", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "WIPEOUTVARIABLES", {"AcDbObject", "AcDbWipeoutVariables", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "XLINE", {"AcDbEntity", "AcDbXline", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "XRECORD", {"AcDbObject", "AcDbXrecord", NULL, NULL, NULL, NULL, NULL, NULL} },
  { "XYPARAMETERENTITY", {"AcDbEntity", "AcDbBlockXYParameterEntity", NULL, NULL, NULL, NULL, NULL, NULL} },

};

#line 2544 "gen-dynapi.pl"
struct _name
{
  const char *const name;
};

static int
_name_struct_cmp (const void *restrict key, const void *restrict elem)
{
  //https://en.cppreference.com/w/c/algorithm/bsearch
  const struct _name *f = (struct _name *)elem;
  return strcmp ((const char *)key, f->name); //deref
}

#define NUM_NAME_TYPES  ARRAY_SIZE(dwg_name_types)
#define NUM_SUBCLASSES  ARRAY_SIZE(dwg_list_subclasses)

static
const struct _name_type_fields*
 __nonnull ((1))
// FIXME: use type arg only
_find_entity (const char *name)
{
  const char *p = (const char *)bsearch (name, dwg_name_types, NUM_NAME_TYPES,
                           sizeof (dwg_name_types[0]),
                           _name_struct_cmp);
  if (p)
    {
      const int i = (p - (char *)dwg_name_types) / sizeof (dwg_name_types[0]);
      return &dwg_name_types[i];
    }
  else
    return NULL;
}

static
const struct _name_subclass_fields*
 __nonnull ((1))
_find_subclass (const char *name)
{
  const char *p = (const char *)bsearch (name, dwg_list_subclasses, NUM_SUBCLASSES,
                           sizeof (dwg_list_subclasses[0]),
                           _name_struct_cmp);
  if (p)
    {
      const int i = (p - (char *)dwg_list_subclasses) / sizeof (dwg_list_subclasses[0]);
      return &dwg_list_subclasses[i];
    }
  else
    return NULL;
}

EXPORT bool
is_dwg_entity (const char *name)
{
  int isent;
  return dwg_object_name (name, NULL, NULL, &isent, NULL)
         && isent;
}

EXPORT bool
is_dwg_object (const char *name)
{
  int isent;
  return dwg_object_name (name, NULL, NULL, &isent, NULL)
         && !isent;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_entity_fields (const char *name)
{
  const struct _name_type_fields *f = _find_entity (name);
  return f ? f->fields : NULL;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_subclass_fields (const char *restrict name)
{
  const struct _name_subclass_fields *f = _find_subclass (name);
  return f ? f->fields : NULL;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_entity_fields (void)
{
  return _dwg_object_entity_fields;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_object_fields (void)
{
  return _dwg_object_object_fields;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_entity_field (const char *restrict name, const char *restrict field)
{
  const Dwg_DYNAPI_field *fields = dwg_dynapi_entity_fields (name);
  if (fields)
    { /* linear search (unsorted) */
      Dwg_DYNAPI_field *f = (Dwg_DYNAPI_field *)fields;
      for (; f->name; f++)
        {
          if (strEQ (f->name, field))
            return f;
        }
    }
  return NULL;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_subclass_field (const char *restrict name, const char *restrict field)
{
  const Dwg_DYNAPI_field *fields = dwg_dynapi_subclass_fields (name);
  if (fields)
    { /* linear search (unsorted) */
      Dwg_DYNAPI_field *f = (Dwg_DYNAPI_field *)fields;
      for (; f->name; f++)
        {
          if (strEQ (f->name, field))
            return f;
        }
    }
  return NULL;
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_header_field (const char *restrict fieldname)
{
  return (Dwg_DYNAPI_field *)bsearch (
              fieldname, _dwg_header_variables_fields,
              ARRAY_SIZE (_dwg_header_variables_fields) - 1, /* NULL terminated */
              sizeof (_dwg_header_variables_fields[0]), _name_struct_cmp);
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_entity_field (const char *restrict fieldname)
{
  return (Dwg_DYNAPI_field *)bsearch (
              fieldname, _dwg_object_entity_fields,
              ARRAY_SIZE (_dwg_object_entity_fields) - 1, /* NULL terminated */
              sizeof (_dwg_object_entity_fields[0]), _name_struct_cmp);
}

EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_common_object_field (const char *restrict fieldname)
{
  return (Dwg_DYNAPI_field *)bsearch (
              fieldname, _dwg_object_object_fields,
              ARRAY_SIZE (_dwg_object_object_fields) - 1, /* NULL terminated */
              sizeof (_dwg_object_object_fields[0]), _name_struct_cmp);
}

// search field by dxf
EXPORT const Dwg_DYNAPI_field *
dwg_dynapi_field_dxf (const Dwg_DYNAPI_field *restrict fields, const int dxf, int *restrict unique)
{
  const Dwg_DYNAPI_field *retval = NULL;
  if (fields)
    { /* linear search (unsorted) */
      Dwg_DYNAPI_field *f = (Dwg_DYNAPI_field *)fields;
      *unique = 1;
      for (; f->name; f++)
        {
          if (f->dxf == dxf)
            {
              if (retval)
                unique = 0;
              else
                retval = f;
            }
        }
    }
  return retval;
}

EXPORT int
dwg_dynapi_entity_size (const char *restrict name)
{
  const struct _name_type_fields *f = _find_entity (name);
  return f ? f->size : 0;
}

EXPORT int
dwg_dynapi_subclass_size (const char *restrict name)
{
  const struct _name_subclass_fields *f = _find_subclass (name);
  return f ? f->size : 0;
}

/* generic field getters */
EXPORT bool
dwg_dynapi_entity_value (void *restrict _obj, const char *restrict name,
                         const char *restrict fieldname,
                         void *restrict out, Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!_obj || !name || !fieldname || !out)
    return false;
#endif
  {
    int error;
    const Dwg_Object* obj = dwg_obj_generic_to_object (_obj, &error);
    // Here we need to ignore errors, because we allow subentities via
    // CHK_SUBCLASS_* e.g. layout->plotsetting via PLOTSETTING
    if (obj && strNE (obj->name, name)) // objid may be 0
      {
        const int loglevel = obj->parent->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid entity type %s, wanted %s", __FUNCTION__,
                   obj->name, name);
        return false;
      }
    {
      const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (name, fieldname);
      if (!f)
        {
          int loglevel = (obj && obj->parent) ? obj->parent->opts & DWG_OPTS_LOGLEVEL
                                              : DWG_LOGLEVEL_ERROR;
          LOG_ERROR ("%s: Invalid %s field %s", __FUNCTION__, name, fieldname);
          return false;
        }
      if (fp)
        memcpy (fp, f, sizeof (Dwg_DYNAPI_field));
      memcpy (out, &((char *)_obj)[f->offset], f->is_malloc ? sizeof(char*) : f->size);
      return true;
    }
  }
}

EXPORT bool
dwg_dynapi_entity_utf8text (void *restrict _obj, const char *restrict name,
                            const char *restrict fieldname,
                            char **restrict out, int *isnew,
                            Dwg_DYNAPI_field *restrict fp)
{
  if (isnew)
    *isnew = 0;
#ifndef HAVE_NONNULL
  if (!_obj || !name || !fieldname || !out)
    return false;
#endif
  {
    int error;
    const Dwg_Object* obj = dwg_obj_generic_to_object (_obj, &error);
    // Here we need to ignore errors, because we allow subentities via
    // CHK_SUBCLASS_* e.g. layout->plotsetting via PLOTSETTING
    if (obj && strNE (obj->name, name)) // objid may be 0
      {
        const int loglevel = obj->parent->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid entity type %s, wanted %s", __FUNCTION__,
                   obj->name, name);
        return false;
      }
    {
      const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (name, fieldname);
      const Dwg_Data *dwg = obj ? obj->parent : NULL;
      const bool is_tu = dwg ? IS_FROM_TU_DWG (dwg) : false;

      if (!f || !f->is_string)
        {
          int loglevel = dwg ? dwg->opts & DWG_OPTS_LOGLEVEL : DWG_LOGLEVEL_ERROR;
          LOG_ERROR ("%s: Invalid %s text field %s", __FUNCTION__, name, fieldname);
          return false;
        }
      if (fp)
        memcpy (fp, f, sizeof (Dwg_DYNAPI_field));

      if (is_tu && strNE (f->type, "TF")) /* not TF */
        {
          BITCODE_TU wstr = *(BITCODE_TU*)((char*)_obj + f->offset);
          char *utf8 = bit_convert_TU (wstr);
          if (wstr && !utf8) // some conversion error, invalid wchar (nyi)
            return false;
          *out = utf8;
          if (isnew)
            *isnew = 1;
        }
      else
        {
          char *utf8 = *(char **)((char*)_obj + f->offset);
          *out = utf8;
        }

      return true;
    }
  }
}

EXPORT bool
dwg_dynapi_header_value (const Dwg_Data *restrict dwg,
                         const char *restrict fieldname, void *restrict out,
                         Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!dwg || !fieldname || !out)
    return false;
#endif
  {
    const Dwg_DYNAPI_field *f = dwg_dynapi_header_field (fieldname);
    if (f)
      {
        const Dwg_Header_Variables *const _obj = &dwg->header_vars;
        if (fp)
          memcpy (fp, f, sizeof (Dwg_DYNAPI_field));
        memcpy (out, &((char*)_obj)[f->offset], f->size);
        return true;
      }
    else
      {
        const int loglevel = dwg->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid header field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_header_utf8text (const Dwg_Data *restrict dwg,
                            const char *restrict fieldname,
                            char **restrict out, int *isnew,
                            Dwg_DYNAPI_field *restrict fp)
{
  if (isnew)
    *isnew = 0;
#ifndef HAVE_NONNULL
  if (!dwg || !fieldname || !out)
    return false;
#endif
  {
    const Dwg_DYNAPI_field *f = dwg_dynapi_header_field (fieldname);
    if (f && f->is_string)
      {
        const Dwg_Header_Variables *const _obj = &dwg->header_vars;
        const bool is_tu = IS_FROM_TU_DWG (dwg);

        if (fp)
          memcpy (fp, f, sizeof (Dwg_DYNAPI_field));

        if (is_tu && strNE (f->type, "TF")) /* not TF */
          {
            BITCODE_TU wstr = *(BITCODE_TU*)((char*)_obj + f->offset);
            char *utf8 = bit_convert_TU (wstr);
            if (wstr && !utf8) // some conversion error, invalid wchar (nyi)
              return false;
            *out = utf8;
            if (isnew)
              *isnew = 1;
          }
        else
          {
            char *utf8 = *(char **)((char*)_obj + f->offset);
            *out = utf8;
          }

        return true;
      }
    else
      {
        const int loglevel = dwg->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid header text field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_common_value(void *restrict _obj, const char *restrict fieldname,
                        void *restrict out, Dwg_DYNAPI_field *restrict fp)
{
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !out)
    return false;
#endif
  {
    const Dwg_DYNAPI_field *f;
    int error;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    if (!obj || error)
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: dwg_obj_generic_to_object failed", __FUNCTION__);
        return false;
      }

    if (obj->supertype == DWG_SUPERTYPE_ENTITY)
      {
        f = dwg_dynapi_common_entity_field (fieldname);
        _obj = obj->tio.entity;
      }
    else if (obj->supertype == DWG_SUPERTYPE_OBJECT)
      {
        f = dwg_dynapi_common_object_field (fieldname);
        _obj = obj->tio.object;
      }
    else
      {
        const int loglevel = obj->parent->opts & DWG_OPTS_LOGLEVEL; // DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: Unhandled %s.supertype ", __FUNCTION__, obj->name);
        return false;
      }

    if (f)
      {
        int size = f->size;
        if (fp)
          memcpy (fp, f, sizeof(Dwg_DYNAPI_field));
        if (f->dxf == 160 && strEQc (fieldname, "preview_size")
            && obj->parent->header.version < R_2010)
          size = 4;
        memcpy (out, &((char *)_obj)[f->offset], size);
        return true;
      }
    else
      {
        const int loglevel = obj->parent->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid common field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_common_utf8text(void *restrict _obj, const char *restrict fieldname,
                           char **restrict out, int *isnew, Dwg_DYNAPI_field *restrict fp)
{
  if (isnew)
    *isnew = 0;
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !out)
    return false;
#endif
  {
    Dwg_DYNAPI_field *f;
    int error;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    Dwg_Data *dwg = NULL;

    if (!obj || error)
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: dwg_obj_generic_to_object failed", __FUNCTION__);
        return false;
      }
    if (obj->supertype == DWG_SUPERTYPE_ENTITY)
      {
        dwg = obj ? obj->parent : ((Dwg_Entity_UNKNOWN_ENT *)_obj)->parent->dwg;
        _obj = obj->tio.entity;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_entity_fields,
            ARRAY_SIZE (_dwg_object_entity_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_entity_fields[0]), _name_struct_cmp);
      }
    else if (obj->supertype == DWG_SUPERTYPE_OBJECT)
      {
        dwg = obj ? obj->parent : ((Dwg_Object_UNKNOWN_OBJ *)_obj)->parent->dwg;
        _obj = obj->tio.object;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_object_fields,
            ARRAY_SIZE (_dwg_object_object_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_object_fields[0]), _name_struct_cmp);
      }
    else
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: Unhandled %s.supertype ", __FUNCTION__, obj->name);
        return false;
      }

    if (f && f->is_string)
      {
        const bool is_tu = IS_FROM_TU_DWG (dwg);

        if (fp)
          memcpy (fp, f, sizeof(Dwg_DYNAPI_field));

        if (is_tu && strNE (f->type, "TF")) /* not TF */
          {
            BITCODE_TU wstr = *(BITCODE_TU*)((char*)_obj + f->offset);
            char *utf8 = bit_convert_TU (wstr);
            if (wstr && !utf8) // some conversion error, invalid wchar (nyi)
              return false;
            *out = utf8;
            if (isnew)
              *isnew = 1;
          }
        else
          {
            char *utf8 = *(char **)((char*)_obj + f->offset);
            *out = utf8;
          }

        return true;
      }
    else
      {
        const int loglevel = dwg ? dwg->opts & DWG_OPTS_LOGLEVEL : DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: Invalid common text field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

// create a fresh string
static void
dynapi_set_helper (void *restrict old, const Dwg_DYNAPI_field *restrict f,
                   const Dwg_Version_Type dwg_version,
                   const void *restrict value, const bool is_utf8)
{
  // TODO: sanity checks. is_malloc (TF)
  // if text strcpy or wcscpy, or do utf8 conversion.
  //if ((char*)old && f->is_malloc)
  //  free (old);
  if (f->is_malloc)
    {
      // NULL ptr
      if (!*(char**)value)
        memcpy (old, value, f->size);
      // ascii
      else if (strEQc (f->type, "TF") || (f->is_string && dwg_version < R_2007))
        {
          char *str = (char *)malloc (strlen (*(char**)value)+1);
          strcpy (str, *(char**)value);
          memcpy (old, &str, sizeof (char*)); // size of ptr
        }
      // or wide
      else if (strNE (f->type, "TF") && (f->is_string && dwg_version >= R_2007))
        {
          BITCODE_TU wstr;
          if (is_utf8)
            wstr = bit_utf8_to_TU (*(char **)value, 0);
          else // source is already TU
            {
#if defined(HAVE_WCHAR_H) && defined(SIZEOF_WCHAR_T) && SIZEOF_WCHAR_T == 2
              wstr = (BITCODE_TU)malloc (2 * (wcslen (*(wchar_t **)value) + 1));
              wcscpy ((wchar_t *)wstr, *(wchar_t **)value);
#else
              int length = 0;
              for (; (*(BITCODE_TU*)value)[length]; length++)
                ;
              length++;
              wstr = (BITCODE_TU)malloc (2 * length);
              memcpy (wstr, value, length * 2);
#endif
            }
          memcpy (old, &wstr, sizeof (char*)); // size of ptr
        }
      else
        memcpy (old, value, sizeof (char*));
    }
  else
    memcpy (old, value, f->size);
}

/* generic field setters */
EXPORT bool
dwg_dynapi_entity_set_value (void *restrict _obj, const char *restrict name,
                             const char *restrict fieldname,
                             const void *restrict value, const bool is_utf8)
{
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !value) // cannot set NULL value
    return false;
#endif
  {
    int error;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    if (error)
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: dwg_obj_generic_to_object failed", __FUNCTION__);
        return false;
      }
    if (obj && strNE (obj->name, name))
      {
        const int loglevel = obj->parent->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid entity type %s, wanted %s", __FUNCTION__,
                   obj->name, name);
        return false;
      }
    {
      void *old;
      const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (name, fieldname);
      const Dwg_Data *dwg
        = obj ? obj->parent
              : ((Dwg_Object_UNKNOWN_OBJ *)_obj)->parent->dwg;
      const Dwg_Version_Type dwg_version = dwg ? dwg->header.from_version : R_INVALID;

      if (!f)
        {
          const int loglevel = dwg ? dwg->opts & DWG_OPTS_LOGLEVEL : 0;
          LOG_ERROR ("%s: Invalid %s field %s", __FUNCTION__, name, fieldname);
          return false;
        }

      old = &((char*)_obj)[f->offset];
      dynapi_set_helper (old, f, dwg_version, value, is_utf8);
      return true;
    }
  }
}

EXPORT bool
dwg_dynapi_header_set_value (Dwg_Data *restrict dwg,
                             const char *restrict fieldname,
                             const void *restrict value, const bool is_utf8)
{
#ifndef HAVE_NONNULL
  if (!dwg || !fieldname || !value) // cannot set NULL value
    return false;
#endif
  {
    Dwg_DYNAPI_field *f = (Dwg_DYNAPI_field *)bsearch (
        fieldname, _dwg_header_variables_fields,
        ARRAY_SIZE (_dwg_header_variables_fields) - 1, /* NULL terminated */
        sizeof (_dwg_header_variables_fields[0]), _name_struct_cmp);
    if (f)
      {
        void *old;
        // there are no malloc'd fields in the HEADER, so no need to free().
        const Dwg_Header_Variables *const _obj = &dwg->header_vars;

        old = &((char*)_obj)[f->offset];
        dynapi_set_helper (old, f, dwg->header.version, value, is_utf8);

        // Set also FLAGS
        if (strEQc (fieldname, "CELWEIGHT"))
          {
            dwg->header_vars.FLAGS &= ~0x1f; // delete old, and set new
            dwg->header_vars.FLAGS |= dxf_revcvt_lweight (dwg->header_vars.CELWEIGHT);
          }
#define SET_HDR_FLAGS(name, bit, inverse)          \
        else if (strEQc (fieldname, #name))        \
          {                                        \
            if (dwg->header_vars.name && !inverse) \
              dwg->header_vars.FLAGS |= bit;       \
            else                                   \
              dwg->header_vars.FLAGS &= ~bit;      \
          }
        SET_HDR_FLAGS (ENDCAPS, 0x60, 0)
        SET_HDR_FLAGS (JOINSTYLE, 0x180, 0)
        SET_HDR_FLAGS (LWDISPLAY, 0x200, 1)
        SET_HDR_FLAGS (XEDIT, 0x400, 1)
        SET_HDR_FLAGS (EXTNAMES, 0x800, 0)
        SET_HDR_FLAGS (PSTYLEMODE, 0x2000, 0)
        SET_HDR_FLAGS (OLESTARTUP, 0x4000, 0)

        return true;
      }
    else
      {
        const int loglevel = dwg->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid header field %s", __FUNCTION__, fieldname);
        return false;
      }
  }
}

EXPORT bool
dwg_dynapi_common_set_value (void *restrict _obj,
                             const char *restrict fieldname,
                             const void *restrict value, const bool is_utf8)
{
#ifndef HAVE_NONNULL
  if (!_obj || !fieldname || !value)
    return false;
#endif
  {
    Dwg_DYNAPI_field *f;
    int error;
    void *old;
    const Dwg_Object *obj = dwg_obj_generic_to_object (_obj, &error);
    Dwg_Data *dwg;
    if (!obj || error)
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: dwg_obj_generic_to_object failed", __FUNCTION__);
        return false;
      }
    dwg = obj->parent;
    if (obj->supertype == DWG_SUPERTYPE_ENTITY)
      {
        _obj = obj->tio.entity;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_entity_fields,
            ARRAY_SIZE (_dwg_object_entity_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_entity_fields[0]), _name_struct_cmp);
      }
    else if (obj->supertype == DWG_SUPERTYPE_OBJECT)
      {
        _obj = obj->tio.object;
        f = (Dwg_DYNAPI_field *)bsearch (
            fieldname, _dwg_object_object_fields,
            ARRAY_SIZE (_dwg_object_object_fields) - 1, /* NULL terminated */
            sizeof (_dwg_object_object_fields[0]), _name_struct_cmp);
      }
    else
      {
        const int loglevel = DWG_LOGLEVEL_ERROR;
        LOG_ERROR ("%s: Unhandled %s.supertype ", __FUNCTION__, obj->name);
        return false;
      }

    if (!f)
      {
        const int loglevel = obj->parent->opts & DWG_OPTS_LOGLEVEL;
        LOG_ERROR ("%s: Invalid %s common field %s", __FUNCTION__, obj->name, fieldname);
        return false;
      }

    old = &((char*)_obj)[f->offset];
    if (f->dxf == 160 && strEQc (fieldname, "preview_size"))
      {
        int size = f->size;
        if (dwg && dwg->header.version < R_2010)
          size = 4;
        memcpy (old, value, size);
      }
    else
      dynapi_set_helper (old, f, dwg ? dwg->header.version : R_INVALID, value, is_utf8);

    if (dwg && obj->supertype == DWG_SUPERTYPE_ENTITY && strEQc (fieldname, "ltype"))
      { // set also isbylayerlt and ltype_flags
        BITCODE_H ltype = *(BITCODE_H*)value;
        Dwg_Object_Entity *ent = obj->tio.entity;
        if (!dwg->header_vars.LTYPE_BYLAYER || !ent->ltype)
          ;
        else if (ent->ltype->absolute_ref == dwg->header_vars.LTYPE_BYLAYER->absolute_ref)
          {
            ent->isbylayerlt = 1; // r13-r14 only
            ent->ltype_flags = 0;
          }
        else if (dwg->header_vars.LTYPE_BYBLOCK
                 && ent->ltype->absolute_ref == dwg->header_vars.LTYPE_BYBLOCK->absolute_ref)
          {
            ent->isbylayerlt = 0;
            ent->ltype_flags = 1;
          }
        else if (dwg->header_vars.LTYPE_CONTINUOUS
                 && ent->ltype->absolute_ref == dwg->header_vars.LTYPE_CONTINUOUS->absolute_ref)
          {
            ent->isbylayerlt = 0;
            ent->ltype_flags = 2;
          }
        else
          {
            ent->isbylayerlt = 0;
            ent->ltype_flags = 3;
          }
      }
    return true;
  }
}

// arbitrary structs, no text
EXPORT bool
dwg_dynapi_subclass_value (const void *restrict ptr,
                           const char *restrict subclass,
                           const char *restrict fieldname,
                           void *restrict out, Dwg_DYNAPI_field *restrict fp)
{
  const Dwg_DYNAPI_field *f;
#ifndef HAVE_NONNULL
  if (!ptr || !subclass || !fieldname || !out)
    return false;
#endif
  f = dwg_dynapi_subclass_field (subclass, fieldname);
  if (!f) // TODO maybe search via dwg_dynapi_subclass_name ()
    return false;
  memcpy (out, &((char*)ptr)[f->offset], f->size);
  if (fp)
    memcpy (fp, f, sizeof(Dwg_DYNAPI_field));
  return true;
}

// arbitrary structs, no text
EXPORT bool
dwg_dynapi_field_get_value (const void *restrict ptr,
                            const Dwg_DYNAPI_field *restrict field,
                            void *restrict out)
{
#ifndef HAVE_NONNULL
  if (!ptr || !field || !out)
    return false;
#endif
  memcpy (out, &((char*)ptr)[field->offset], field->size);
  return true;
}

// can do arbitrary structs, like subclasses
EXPORT bool
dwg_dynapi_field_set_value (const Dwg_Data *restrict dwg, /* only needed if unicode strings */
                            void *restrict ptr,
                            const Dwg_DYNAPI_field *restrict field,
                            const void *restrict value,
                            const bool is_utf8)
{
  void *off;
#ifndef HAVE_NONNULL
  if (!ptr || !field || !value)
    return false;
#endif
  off = &((char*)ptr)[field->offset];
  dynapi_set_helper (off, field, dwg ? dwg->header.version : R_INVALID, value, is_utf8);
  return true;
}

// check if the handle points to an object with a name.
// see also dwg_obj_table_get_name, which only supports tables.
EXPORT char*
dwg_dynapi_handle_name (const Dwg_Data *restrict dwg, Dwg_Object_Ref *restrict hdl)
{
  const bool is_tu = IS_FROM_TU_DWG (dwg);
  Dwg_Object *obj;

#ifndef HAVE_NONNULL
  if (!dwg || !hdl)
    return NULL;
#endif

  obj = dwg_ref_object_silent (dwg, hdl);
  if (!obj)
    return NULL;
  {
    const Dwg_DYNAPI_field *f = dwg_dynapi_entity_field (obj->name, "name");
    // just some random type is enough.
    Dwg_Object_STYLE *_obj = obj->tio.object->tio.STYLE;

    if (!f || !f->is_string)
      return NULL;
    if (is_tu && strNE (f->type, "TF")) /* not TF */
      {
        BITCODE_TU wstr = *(BITCODE_TU *)((char *)_obj + f->offset);
        return bit_convert_TU (wstr);
      }
    else
      {
        return *(char **)((char *)_obj + f->offset);
      }
  }
}

// The sum of the size of all fields
int
_fields_size_sum (const Dwg_DYNAPI_field *restrict fields)
{
  Dwg_DYNAPI_field *f = (Dwg_DYNAPI_field *)fields;
  int sum = 0;
  if (!f)
    return 0;
  for (; f->name; f++)
    {
      sum += f->size;
    }
  return sum;
}

// The size of the entity or subclass struct, or the sum of the size of all fields.
EXPORT int
dwg_dynapi_fields_size (const char *restrict name)
{
  const struct _name_type_fields *f;
#ifndef HAVE_NONNULL
  if (!name)
    return 0;
#endif

  f = _find_entity (name);
  // TODO PROXY_LWPOLYLINE
  if (f)
    {
      if (f->size)
        return (int)f->size;
      else
        return _fields_size_sum (f->fields); // VERTEX_PFACE is not entity nor object yet
    }
  else
    {
      int size = dwg_dynapi_subclass_size (name);
      if (size)
        return size;
      else
        return _fields_size_sum (dwg_dynapi_subclass_fields (name));
    }
}

// Converts from the fields type, like "Dwg_MLINESTYLE_line*" to the
// subclass name, like "MLINESTYLE_line".
ATTRIBUTE_MALLOC char*
dwg_dynapi_subclass_name (const char *restrict type)
{
  char *name = NULL;
  int len = strlen (type);
  if (memBEGINc (type, "Dwg_Object_"))
    {
      const int off = strlen ("Dwg_Object_"); // PLOTSETTINGS
      name = strdup (&type[off]);
      if (type[len - 1] == '*')
        name[len - off - 1] = '\0';
    }
  else if (memBEGINc (type, "Dwg_Entity_"))
    {
      const int off = strlen ("Dwg_Entity_");
      name = strdup (&type[off]);
      if (type[len - 1] == '*')
        name[len - off - 1] = '\0';
    }
  else if (memBEGINc (type, "Dwg_"))
    {
      name = strdup (&type[4]);
      if (type[len - 1] == '*')
        name[len - 5] = '\0';
    }
  else if (memBEGINc (type, "struct _dwg_entity_"))
    {
      const int off = strlen ("struct _dwg_entity_"); // TABLE
      name = strdup (&type[off]);
      if (type[len - 1] == '*')
        name[len - off - 1] = '\0';
    }
  else if (memBEGINc (type, "struct _dwg_object_"))
    {
      const int off = strlen ("struct _dwg_object_"); // CELLSTYLEMAP*, EVALUATION_GRAPH, ...
      name = strdup (&type[off]);
      if (type[len - 1] == '*')
        name[len - off - 1] = '\0';
    }
  else if (memBEGINc (type, "struct _dwg_")) // CellStyle*
    {
      const int off = strlen ("struct _dwg_");
      name = strdup (&type[off]);
      if (type[len - 1] == '*')
        name[len - off - 1] = '\0';
    }
  return name;
}

EXPORT bool
dwg_has_subclass (const char *restrict classname, const char *restrict subclass)
{
  struct _name_subclasses *f;
#ifndef HAVE_NONNULL
  if (!classname || !name)
    return false;
#endif
  f = (struct _name_subclasses *)bsearch (classname, dwg_name_subclasses,
                                          ARRAY_SIZE (dwg_name_subclasses),
                                          sizeof (dwg_name_subclasses[0]),
                                          _name_struct_cmp);
  if (f) {
    for (unsigned i = 0; i < 8 /* max_subclasses */; i++) {
      if (!f->subclasses[i]) // already at NULL
        return false;
      if (strEQ (subclass, f->subclasses[i]))
        return true;
    }
  }
  return false;
}
/* Local Variables: */
/* mode: c */
/* End: */
