/*
 * TalkWrapper.java
 *
 * Created on 10. November 2005, 9:30
 */


/**
 *
 *  This class represents an entry of the data base`s table "talks"
 *  and has added functionality.
 *
 * @author  Olle Nebendahl
 */

class TalkWrapper extends TalkRecord
{   
   
    public boolean exists;
    
    static javax.swing.DefaultListModel talkList;
    //int talksFirstSlide = Constants.NO_SLIDE_ID;
        
    TalkWrapper()
    {
      exists=false;
    }
    
    TalkWrapper(int i)
    {
        load(i);
    }
    
    static int createAndFlush(String atitle, String asubject, String aSourceFileName, String anOriginalFileName, int firstSlide)
    {
        return (new TalkWrapper(atitle,asubject,aSourceFileName,anOriginalFileName,firstSlide)).getTalkId();
    }

    TalkWrapper(String atitle, String asubject, String aSourceFileName, String anOriginalFileName, int firstSlide)
    {
        setSubject(asubject);
        setTitle(atitle);
        setSourceFileName(aSourceFileName);
        setOriginalFileName(anOriginalFileName);
        setFirstSlide(firstSlide);
        flush();
    }
    
    
    public int flush()
    {
        if(exists)
        {
            SlideConnection.doTalkTitleUpdate(getTitle(),getTalkId());
            SlideConnection.doTalkSubjectUpdate(getSubject(),getTalkId());
            SlideConnection.doTalkSourceFileNameUpdate(getSourceFileName(),getTalkId());
            SlideConnection.doTalkOriginalFileNameUpdate(getOriginalFileName(),getTalkId());
            SlideConnection.doTalkFirstSlideUpdate(getFirstSlide(),getTalkId());

            TalkCache.cacheTalk(this,getTalkId());
        } else 
        {
            Logger.log("added non-existent - propably new - talk to data base");
            SlideConnection.doSqlUpdate("insert into talks values ()");
            Object[] test=(Object[])SlideConnection.getSqlQuery("select last_insert_id();").getFirst();
            setTalkId(((Long)test[0]).intValue());
            exists=true;
            flush();
        }
        if(null==talkList)return getTalkId();
        talkList.removeAllElements();
        int[] li = SlideConnection.getTalks();
        int l = li.length;
        int i = 0;
        while(i<l)
        {
            talkList.addElement(TalkCache.getTalk(li[i]));
            i++;
        }
        return getTalkId();
        
    }

    public void load(int i)
    {
        TalkRecord talk=TalkCache.getTalk(i);
        init(talk); 
        exists=true;
    }
    
    public void init(TalkRecord t)
    {
        setTalkId(t.getTalkId());
        setTitle(t.getTitle());
        setSubject(t.getSubject());
        setOriginalFileName(t.getOriginalFileName());
        setSourceFileName(t.getSourceFileName());
        setFirstSlide(t.getFirstSlide());
    }
    
    public static void main(String[] a)
    {
        TalkWrapper sw=new TalkWrapper((Integer.decode(a[0])).intValue());
        System.out.println(sw);    
    }
}
