import java.io.*; 
import java.sql.*;

/*
 * SlideRecord.java
 *
 * Created on 4. November 2005, 21:30
 */


/**
 *
 *  This class is the closest representant of an entry in the database`s
 *  table "slides".
 *
 * @author  Olle Nebendahl
 */


class SlideRecord 
{ 
    private int slideId;
    private String aAnnotation;
    private String annotation;
    private String title;
    private String subject;
    private Date duration;
    private Date dateOfCreation;
    private String dateOfModification;
    private int version;
    private int level;
    
    SlideRecord()
    {
        slideId = Constants.NO_SLIDE_ID;
        version = 0;
    }
    
    public SlideRecord clone()
    {
        return new SlideRecord(this);
    }
    
    SlideRecord(SlideRecord sr)
    {
        slideId=sr.slideId;
        aAnnotation = sr.aAnnotation;
        annotation = sr.annotation;
        title = sr.title;
        subject = sr.subject;
        duration = sr.duration;
        dateOfCreation = sr.dateOfCreation;
        dateOfModification = sr.dateOfModification;
        version = sr.version;
        level = sr.level;
    }
    
    public int getSlideId(){ return slideId;};
    public void setSlideId(int i){slideId=i;};
  
    public void setAnnotation(String s){ annotation=s; }
    public String getAnnotation() { if(null==annotation)return null; else return new String(annotation); }

    public void setAAnnotation(String s){ aAnnotation=s; }
    public String getAAnnotation() { if(null==aAnnotation)return null; else return new String(aAnnotation); }

    public void setTitle(String s){ title=s; }        
    public String getTitle() { if(null==title)return null; else return new String(title); }

    public void setSubject(String s){ subject=s; }        
    public String getSubject() { if(null==subject)return null; else return new String(subject); }

    public void setDuration(Date s){ duration=s; }        
    public Date getDuration() { if(null==duration)return null; else return new Date(duration.getTime()); }

    public void setDateOfCreation(Date s){ dateOfCreation=s; }        
    public Date getDateOfCreation() { if(null==dateOfCreation)return null; else return new Date(dateOfCreation.getTime()); }

    public void setDateOfModification(String s){ dateOfModification=s; }        
    public String getDateOfModification() { if(null==dateOfModification)return null; else return new String(dateOfModification); }

    public void setVersion(int v){ version=v; }
    public int getVersion() { return version; }

    public void setLevel(int v){ level=v; }
    public int getLevel() { return level; }
    
    
    public String toString()
    {
        //System.out.println("Hamburg");
        return getHeader(20,40);
    }
    
    public String toFullString()
    {
        String result= new String("SlideId:"+getSlideId()+"\n");
        result+="Title: "+getTitle()+"\n";
        result+="Subject: "+getSubject()+"\n";
        result+="Annotation: "+getAnnotation()+"\n";
        result+="automatic Annotation: "+getAAnnotation()+"\n";
        result+="Duration: "+getDuration()+"\n";
        result+="Date of Creation: "+getDateOfCreation()+"\n";
        result+="Date of Modification: "+getDateOfModification()+"\n";
        result+="Version: "+getVersion()+"\n";
        result+="Level: "+getLevel()+"\n";
        result+="Source:\n";
        
        return result;
    }
    
    public String getHeader()
    {
        /*
        String result=getTitle();
        if((result!=null)&&(result.length() > 40))result=result.substring(0,40);
        result+="; "+getSubject();
        if(result.length() > 80)result=result.substring(0,80);        
        else
        if(result.length()<11)return result+" SlideId:"+getSlideId()+"\n";
        return result;
        */
        return getHeader(40,80);
    }
    
    public String getHeader(int titleLength, int totalLength)
    {
        String result=getTitle();
        if((result!=null)&&(result.length() > titleLength))result=result.substring(0,titleLength);
        result+="; "+getSubject();
        if(result.length() > totalLength)result=result.substring(0,totalLength);        
        else
        if(result.length()<11)
        result+=" SlideId:"+getSlideId();//+"\n";
        if(result.length() > totalLength)result=result.substring(0,totalLength);
        //System.out.println(result);
        return result;
    }
    
//    private String source;
//    public void setSource(String s){ source=s; }
//    public String getSource() { return source; }
}
