


     PLOTMTV(L)	       UNIX System V (July 15, 1994)	    PLOTMTV(L)



     NAME
	  plotmtv - fast multi-purpose plotting	program	for X11-
	  windows


     SYNOPSIS
	  plotmtv
		  [-mult] [-Pprinter] [-printcmd print_command]	[-
		  colorps]
		  [-3d]	[-v] [-d] [-l] [-scale scale]
		  [-noframe] [-nodate] [-noxplot] [-plotall] [-print]
		  [-pbg	background_color] [-pfg	foreground_color]
		  [-geom geometry] [-rv] [-bg background_color]	[-fg
		  foreground_color]
		  [-o postscript-file]
		  data-file1 data-file2	...


     DESCRIPTION
	  plotmtv  is  a  fast	and   convenient   X11	 program   for
	  visualization	 of scientific data. The program reads in data
	  in the MTVDAT	format and plots each dataset in the data-file
	  in  turn.  Each  plot	 comes	with  a	 simple	but functional
	  Graphical User Interface (GUI), which	allows users  to  zoom
	  in  or  pan  to  areas of interest on	the plot, or to	toggle
	  between 2D and 3D plots. The plots may then be sent directly
	  to  a	 grayscale  or	color PostScript printer for hard-copy
	  output.

	  plotmtv's capabilities include 2D  line  and	scatter	 plots
	  (x-vs-y),  contour plots, 3D surface,	line and scatter plots
	  as well as vector plots.   The  program  has	been  extended
	  recently   to	  include  probability	plots,	barcharts  and
	  histograms. See the MTV Plot Data Format for details on  the
	  data-formats	used  to  specify data for the above-mentioned
	  plot-types.

	  The Graphical	User Interface for plotmtv is  quite  limited,
	  consisting  of  several  toggle buttons for setting commonly
	  used	plot  options,	and  an	 interactive  zoom   and   pan
	  capability  via  the	mouse.	The  GUI  also allows toggling
	  between 2D  and  3D  plots,  rotating	 3D  plots,  and  some
	  (limited) customization of the resultant plots.  Through the
	  GUI, one can also print the plot using the  "Print"  button,
	  or  save  the	 Postscript plot to a file using the "Print to
	  File"	button.

	  If more than one data-file or	data-set is specified, a small
	  "page"  widget  will	appear in the lower left corner	of the
	  plotmtv plot window.	The "page" widget allows one  to  page
	  between  different plots, using the same window, by clicking
	  on the Up or Down buttons.



     Page 1					    (printed 10/17/94)






     PLOTMTV(L)	       UNIX System V (July 15, 1994)	    PLOTMTV(L)



	  The X11 plot in plotmtv can  also  be	 controlled  from  the
	  keyboard,  i.e.,  by	pressing specific keys on the keyboard
	  while	the mouse is within the	X11 plot window.  Pressing  on
	  "n" (next) and "p" (previous)	pages between different	plots,
	  while	pressing the "q" key is	a  fast	 way  of  exiting  the
	  program.  For	the 3D plot, the viewing vector	can be changed
	  using	the "h", "j", "k", "l" and "o" keys on	the  keyboard;
	  the plot on the screen can be	rotated	sideways using the "h"
	  or "l" keys, rotated up or down using	the "j"	and "k"	 keys,
	  and  drawn  with the original	viewing	vector using "o".  The
	  "a", "s", "d"	and "f"	keys will produce 90o rotations.   "z"
	  will plot the	image projected	on the x-y plane (z=constant),
	  "y"  will  plot  the	image  projected  on  the  x-z	 plane
	  (y=constant),	 and  "x" will plot the	image projected	on the
	  y-z plane (x=constant).

	       Key	 Action
	       p	 page to the previous plot
	       n	 page to the next plot
	       q	 end program
	       h	 rotate	right 10o (3D plot only)
	       j	 rotate	down 10o (3D plot only)
	       k	 rotate	up 10o (3D plot	only)
	       l	 rotate	left 10o (3D plot only)
	       a	 rotate	right 90o (3D plot only)
	       s	 rotate	down 90o (3D plot only)
	       d	 rotate	up 90o (3D plot	only)
	       f	 rotate	left 90o (3D plot only)
	       o	 return	to original view (3D plot only)
	       z	 project on x-y	plane (3D plot only)
	       x	 project on y-z	plane (3D plot only)
	       y	 project on x-z	plane (3D plot only)


     DATA FORMAT
	  plotmtv uses the MTVDAT data format, which is	 too  long  to
	  describe  in	this  document.	 The  data format is described
	  fully	in The MTV Plot	Data Format document.


     OPTIONS
	  -mult
	       Brings up an X-window with multiple plots.  This	 is  a
	       useful  way  of	comparing  different plots on the same
	       page.

	  -Pprinter
	       Specifies the printer to	which to send  the  PostScript
	       plot.   The  default  uses  the	printer	 name from the
	       environment variable $PRINTER.

	       Note: plotmtv  will  send  a  PostScript	 file  to  the



     Page 2					    (printed 10/17/94)






     PLOTMTV(L)	       UNIX System V (July 15, 1994)	    PLOTMTV(L)



	       specified  printer only if the size of the file is less
	       than 1000Kbytes.	This maximum file size is due  to  the
	       limitations of the UNIX lpr(1) command.

	  -printcmd print_command
	       Specifies the print_command to be executed in sending a
	       PostScript plot to the printer. The default is the UNIX
	       "lpr -h"	command.  The print_command may	 also  be  set
	       using  the environment variable $MTV_PRINTER_CMD, i.e.,
	       'setenv MTV_PRINTER_CMD "lpr -h"'.

	  -colorps

	  -color

	  -pscolor
	       Instructs the PostScript	renderer to include colors  in
	       the  PostScript	description  of	 the plot. By default,
	       plotmtv	produces  gray-scale  PostScript  plots.   The
	       color  PostScript file produced with this option	may be
	       printed out on a	color PostScript  printer.   Be	 aware
	       however that the	same file will not print out correctly
	       on a black-and-white  PostScript	 printer.   The	 color
	       PostScript   mode  may  also  be	 set  by  setting  the
	       $MTV_PSCOLOR  environment   variable,   i.e.,   "setenv
	       MTV_PSCOLOR ON".

	  -3d  Plots in	3D instead of the default 2D.

	  -v   Makes plotmtv more talkative.

	  -d   Makes plotmtv extremely loquacious.

	  -l   Prints the PostScript plot in landscape	mode  (rotated
	       90o).

	  -noframe
	       Prints the  PostScript  plot  without  a	 bounding  box
	       frame.	The  bounding box frame	is drawn only when the
	       plot is	printed	 with  a  scale	 value	less  than  1.
	       Specifying this option turns off	the frame.

	  -nodate
	       Prints the PostScript plot without a time/date stamp.

	  -noxplot

	  -noplot
	       Stops the program from starting	up  the	 X11  graphics
	       routines.   The	normal	mode  of operation is start up
	       plotmtv from an X-terminal or  X-display	 and  interact
	       with  the  graphics using the Graphical User Interface.



     Page 3					    (printed 10/17/94)






     PLOTMTV(L)	       UNIX System V (July 15, 1994)	    PLOTMTV(L)



	       However,	the -noxplot option is also provided to	 allow
	       the  plots  to  be  directly  drawn in PostScript, thus
	       bypassing  the  X11   plotting	routines.    This   is
	       particularly  useful  for  batch-mode  operation, where
	       multiple	plots can be sent to a	printer	 without  user
	       intervention.

	  -plotall
	       Plots all the datasets found in a single	 plot.	Useful
	       for combining data from different files.

	  -print
	       Sends the PostScript plot to the	printer	automatically.
	       Usually	this is	used together with the -noxplot	option
	       to produce PostScript plots in  batch,  i.e.,  "plotmtv
	       -noxplot	-print datafile".

	  -scale scale
	       Sets a plot  scale  factor.   This  is  used  only  for
	       PostScript plotting.

	  -pfg foreground_color

	  -pbg background_color
	       Sets  the  foreground  and  background  colors  in  the
	       plotmtv X11 Plot	Window.

	  -display host:display.screen
	       Opens a window on the given host	and display

	  -geom	geometry

	  -rv

	  -fg foreground-color

	  -bg background-color

	  data-file1 data-file2...
	       Specifies the MTVDAT data-file(s).


     ENVIRONMENT VARIABLES
	  PRINTER	      printer name for hardcopy	(e.g., "hpps")
	  MTV_PRINTER_CMD     name of the UNIX	print  command	(e.g.,
	  "lpr -h")
	  MTV_PSCOLOR	      for color	PostScript (e.g., "ON")
	  MTV_WRB_COLORMAP    uses a different color map for  contours
	  (e.g., "ON")
	  MTV_USE_ISOLATIN_FONTis  used	 to  turn  off	the   ISOLATIN
	  PostScript Plot (e.g., "OFF")
	  MT_PSFONT1	      specifies	 the  size  of	the  top-label



     Page 4					    (printed 10/17/94)






     PLOTMTV(L)	       UNIX System V (July 15, 1994)	    PLOTMTV(L)



	  PostScript font (e.g.	"25")
	  MT_PSFONT2	      specifies	the  size  of  the  axis-label
	  PostScript font (e.g.	"20")
	  MT_PSFONT3	      specifies	the  size  of  the  axis-ticks
	  PostScript font (e.g.	"15")
	  MT_PSFONT4	      specifies	the  size  of  the  side-label
	  PostScript font (e.g.	"12")
	  MT_PSFONT5	      specifies	the size  of  the  annotations
	  PostScript font (e.g.	"12")
	  MT_PSFONT6	      specifies	the  size  of  the  date-stamp
	  PostScript font (e.g.	"10")
	  MT_PSFONT7	      specifies	the size of the	 contour-label
	  PostScript font (e.g.	"8")


     HISTORY
	  plotmtv is based on the DRAWPLOT, CONTOUR and	PDRAW programs
	  from	U.C.  Berkeley	(yes, I'm responsible for those	too!).
	  plotmtv essentially combines all  the	 capabilities  of  the
	  three	packages into one single package.


     BUGS/LIMITATIONS
	  The GUI is very limited.  The	 3D  viewing  stuff  is	 quite
	  limited  too;	 hidden-surface	 removal  is  implemented as a
	  simple painter's algorithm, so large 3D polygons  don't  get
	  plotted (with	hidden-surfaces) correctly.  Also there	are no
	  perspective plots yet	(and probably never will be)...

	  plotmtv  uses	 some  level  2	 PostScript  commands.	  This
	  sometimes  causes  plots  to	disappear  if plotted on older
	  PostScript-level-1 printers.	If this	happens,  try  setting
	  the  environment  variable "MTV_USE_ISOLATIN_FONT" to	False,
	  i.e. "% setenv MTV_USE_ISOLATIN_FONT False".


     AUTHOR
	  Kenny	K.H. Toh (ktoh@td2cad.intel.com)


     FILES
	  dataplot.ps	      default PostScript file


     SEE ALSO
	  The MTV Plot Data Format









     Page 5					    (printed 10/17/94)



