//$$ newmat9.cxx         Input and output

// Copyright (C) 1991: R B Davies and DSIR


#define WANT_STREAM

#include "include.hxx"

#include "newmat.hxx"
#include "newmatrc.hxx"
#include "newmatio.hxx"

//#define REPORT { static ExeCounter ExeCount(__LINE__,9); ExeCount++; }

#define REPORT {}

ostream& operator<<(ostream& s, BaseMatrix& X)
{
   GeneralMatrix* gm = X.Evaluate(); operator<<(s, *gm);
   gm->tDelete(); return s;
}


ostream& operator<<(ostream& s, const GeneralMatrix& X)
{
   int w = s.width();  int nr = X.Nrows();  long f = s.flags();
   s.setf(ios::fixed, ios::floatfield);
   MatrixRow mr((GeneralMatrix*)&X, LoadOnEntry);
   for (int i=1; i<=nr; i++)
   {
      int skip = mr.skip;  int storage = mr.storage;
      real* store = mr.store+skip;  skip *= w+1;
      while (skip--) s << " ";
      while (storage--) s << setw(w) << *store++ << " ";
      mr.Next();  s << "\n";
   }
   s << flush;  s.flags(f); return s;
}

