#include <stdio.h>
#include "oldvort.h"
#include "vort.h"

extern char	*malloc();

/*
 * a program to convert old pix images into the new format
 */
main(ac, av)
	int	ac;
	char	**av;
{
	oldimage	*in;
	image		*out;
	unsigned char	*red, *green, *blue, *alpha;
	int		i, j;

	if (ac != 3) {
		fprintf(stderr, "Usage: conv in_image out_image\n");
		exit(1);
	}

	in = oldopenimage(av[1], "r");

	out = openimage(av[2], "w");

	if (oldcolormapped(in)) {
		if (oldalphachannel(in)) {
			imagetype(out) = PIX_RGBA;
			imagedepth(out) = 32;
		} else {
			imagetype(out) = PIX_RLECMAP;
			imagedepth(out) = 8;
		}
	} else {
		if (oldalphachannel(in)) {
			imagetype(out) = PIX_RGBA;
			imagedepth(out) = 32;
		} else {
			imagetype(out) = PIX_RLE;
			imagedepth(out) = 24;
		}
	}

	imagewidth(out) = oldimagewidth(in);
	imageheight(out) = oldimageheight(in);
	imagedate(out) = oldimagedate(in);
	titlelength(out) = oldtitlelength(in);
	imagetitle(out) = oldimagetitle(in);

	cmapsize(out) = oldcmapsize(in);
	redmap(out) = oldredmap(in);
	greenmap(out) = oldgreenmap(in);
	bluemap(out) = oldbluemap(in);

	writeheader(out);

	red = (unsigned char *)malloc(imagewidth(out));
	green = (unsigned char *)malloc(imagewidth(out));
	blue = (unsigned char *)malloc(imagewidth(out));
	alpha = (unsigned char *)malloc(imagewidth(out));

	for (i = 1; i <= oldimageheight(in); i++) {

		oldimagepos(in, 0, 0);
		for (j = oldimageheight(in); j != i; j--)
			oldreadrgbline(in, red, green, blue);

		if (oldalphachannel(in)) {
			oldreadrgbaline(in, red, green, blue, alpha);
			writergbaline(out, red, green, blue, alpha);
		} else {
			if (colormapped(out)) {
				oldreadmappedline(in, red);
				writemappedline(out, red);
			} else {
				oldreadrgbline(in, red, green, blue);
				writergbline(out, red, green, blue);
			}
		}
	}


	closeimage(out);
}
