#include <math.h>
#include <stdio.h>
#include "art.h"
#include "objs.h"
#include "macro.h"
#include "gram.h"

extern hlist	*fhlist;

extern hlist	*(*intersects[])();

extern object	*objectinit(), *csginit();

extern attr	*astackp;
extern mats	*mstackp;

/*
 * compinit
 *
 *	initialise a composite object
 *
 */
object *
compinit(sym, d)
	symbol	*sym;
	details	*d;
{
	details *dl, *nxtdl, *argdt, *otherdt, *nd;
	details *ndl, *newdl, *dtail, *dhead;
	object	*o, *objlist, *head;
	surface	s;
	int	sset;

	astackp++;
	*astackp = *(astackp - 1);

	mstackp++;
	*mstackp = *(mstackp - 1);
	mident4(mstackp->vm);
	mstackp->vmused = FALSE;

	s = *astackp->s; 
					/* reverse list */
	argdt = (details *)NULL;
	for (dl = d; dl != (details *)NULL; dl = nxtdl) {
		nxtdl = dl->nxt;
		dl->nxt = argdt;
		argdt = dl;
	}

					/* copy sym list */
	otherdt = (details *)NULL;
	if (sym != (symbol *)NULL) {
		for (dl = sym->u.det; dl != (details *)NULL; dl = dl->nxt) {
			nd = (details *)smalloc(sizeof(details));
			*nd = *dl;
			nd->nxt = otherdt;
			otherdt = nd;
		}
	}

	objlist = (object *)NULL;

	if (argdt == (details *)NULL) {
		argdt = otherdt;
		otherdt = (details *)NULL;
	}

	sset = FALSE;

	for (dl = argdt; dl != (details *)NULL; dl = nxtdl) {
		switch (dl->type) {
		case COLOUR:
			s.c.r = dl->u.c.r;
			s.c.g = dl->u.c.g;
			s.c.b = dl->u.c.b;
			sset = TRUE;
			break;
		case AMBIENT:
			s.a.r = dl->u.c.r;
			s.a.g = dl->u.c.g;
			s.a.b = dl->u.c.b;
			sset = TRUE;
			break;
		case TEXTURE:
			dl->u.txt->nxt = astackp->txtlist;
			astackp->txtlist = dl->u.txt;
			break;
		case MATERIAL:
			s.ri = dl->u.mat.ri;
			s.kd = dl->u.mat.kd;
			s.ks = dl->u.mat.ks;
			s.ksexp = dl->u.mat.ksexp;
			sset = TRUE;
			break;
		case REFLECTANCE:
			s.refl = dl->u.f;
			sset = TRUE;
			break;
		case TRANSPARENCY:
			s.trans = dl->u.f;
			sset = TRUE;
			break;
		case ABSORPTION:
			s.falloff = dl->u.f;
			sset = TRUE;
			break;
		case ART_TRANSLATE:
			art_translate(dl->u.v.x, dl->u.v.y, dl->u.v.z);
			break;
		case ART_SCALE:
			art_scale(dl->u.v.x, dl->u.v.y, dl->u.v.z);
			break;
		case ART_ROTATE:
			art_rotate(dl->u.rot.ang, dl->u.rot.axis);
			break;
		case ON:
			astackp->options |= dl->u.i;
			break;
		case OFF:
			astackp->options &= ~dl->u.i;
			break;
		case OBJECT:
			if (sset) {
				astackp->s = (surface *)smalloc(sizeof(surface));
				*astackp->s = s;
				sset = FALSE;
			}

			if (sym != (symbol *)NULL) {	/* save it */
				dhead = dtail = (details *)NULL;
				for (ndl = dl->u.obj.det; ndl != (details *)NULL; ndl = ndl->nxt) {
					newdl = (details *)smalloc(sizeof(details));
					*newdl = *ndl;

					if (dtail == (details *)NULL)
						dhead = dtail = newdl;
					else {
						dtail->nxt = newdl;
						dtail = newdl;
					}

					dtail->nxt = (details *)NULL;
				}
			} else
				dhead = dl->u.obj.det;

			if ((head = objectinit(dl->u.obj.sym, dhead)) != (object *)NULL) {
				for (o = head; o->nxt != (object *)NULL; o = o->nxt)
					;
			}
			o->nxt = objlist;
			objlist = head;
			break;
		case COMP_OBJ:
			if (sset) {
				astackp->s = (surface *)smalloc(sizeof(surface));
				*astackp->s = s;
				sset = FALSE;
			}

			if (sym != (symbol *)NULL) {	/* save it */
				dhead = dtail = (details *)NULL;
				for (ndl = dl->u.obj.det; ndl != (details *)NULL; ndl = ndl->nxt) {
					newdl = (details *)smalloc(sizeof(details));
					*newdl = *ndl;

					if (dtail == (details *)NULL)
						dhead = dtail = newdl;
					else {
						dtail->nxt = newdl;
						dtail = newdl;
					}

					dtail->nxt = (details *)NULL;
				}
			} else
				dhead = dl->u.obj.det;

			if ((head = compinit((symbol *)NULL, dhead)) != (object *)NULL) {
				for (o = head; o->nxt != (object *)NULL; o = o->nxt)
					;
				o->nxt = objlist;
				objlist = head;
			}
			break;
		case CSG_OBJ:
			if (sset) {
				astackp->s = (surface *)smalloc(sizeof(surface));
				*astackp->s = s;
				sset = FALSE;
			}
			o = csginit(dl->u.obj.sym, (details *)NULL);
			o->nxt = objlist;
			objlist = o;
			break;
		default:
			warning("art: bad detail in composite ignored.\n");
		}

		nxtdl = dl->nxt;
		if (nxtdl == (details *)NULL) {
			nxtdl = otherdt;
			otherdt = (details *)NULL;
		}

		free(dl);
	}

	astackp--;
	mstackp--;

	return(objlist);
}
