/* Copyright 1988 John M. Sullivan.  See main program for details. */
#include "point.h"
#include "fortran.h"

typedef
struct	point_with_norm2
{
	struct point xyz;
	real nrm2;
}
* point_with_norm2;

#define pwn(p) ((point_with_norm2)(p))
#define nm2(p) (pwn(p)->nrm2)
#define pnt(p) (&((p)->xyz))	/* should be same as ((point)(p)) */
/* So components of point_with_norm2 are pt(p)->x,y,z and p->nrm2 */
#define dot_4(p,q) (dot_q(pnt(p),pnt(q)) + (p)->nrm2*(q)->nrm2)

typedef int clr;

/* The following structure, site, has a pointer to a
facet_edge which allows us to get at the topology.  It also
includes the coordinates of the site in actual 3-space and a color.   */

typedef
struct	site
{
	point loc;
	clr color;
	struct facet_edge *one_fe;
	bool flag;
	struct tetq_q_entry *cnst_q;
	real volume;
	/******* now kept in external array for efficiency
	point vol_grad;	/* will point to array of volume gradients **
	point area_grad;
	*******/
}
* site;

typedef
struct	corner
{
	point loc;
	site cell[4];
	struct facet_edge *one_fe;
	point deriv[4];
	int seq_num;
}
* corner;

#include "facet_edge.h"

/* looping construct to loop through all sites */
/* unlike the above, s must be a declared variable, and {}'s are needed */
#define for_sites(s) for (s=Sites; s<Sites+N_Sites; s++)
#define for_moving_sites(s) for (s=Sites; s<Sites+N_Pos_Sites; s++)
#define EXTRA_SITES 6
#define TORUS_FACTOR (3*3*3)
#define TORUS_EXTRA (6*4+6)
#define for_colors(k) for(k=1; k<=Max_color; k++)
#define MAXC (1<<16 - 1)

/* handle edges to infinity */
#define INFTY 1e5
#define infinite(v) (!v->cell[0])

/* the number we have to beat */
#define KELVIN 148

/* retrieve corner derivatives */
#define dffrntl(v,s)			\
    (v->cell[0] == s? v->deriv[0]	\
    : v->cell[1] == s? v->deriv[1]	\
    : v->cell[2] == s? v->deriv[2]	\
    : v->cell[3] == s? v->deriv[3]	\
    : Origin)
#define vol_grad(c,s) (&Gradients[c][s-Sites])
#define vgrad(t,s) vol_grad(abs((t)->color),s)
#define area_grad(s) (&Area_Grad[s-Sites])
#define wulff_grad(s) (&Wulff_Grad[s-Sites])
#define motion(s) (&Motion[s-Sites])

#define ignored(k) ((k)==0 || Flag_volume)

extern int Flg;
#define FlagT 0x01
#define FlagV 0x02
#define FlagK 0x04
#define FlagI 0x08
#define FlagR 0x10
#define FlagO 0x20
#define FlagJ 0x40
#define Flag_torus	(Flg&FlagT)
#define Flag_volume	(Flg&FlagV)
#define Flag_kelvin	(Flg&FlagK)
#define Flag_infty	(Flg&FlagI)
#define Flag_random	(Flg&FlagR)
#define Flag_omit	(Flg&FlagO)
#define Flag_jump	(Flg&FlagJ)

/* external variable declarations */
extern site Sites;
extern int N_Sites,N_Pos_Sites;
extern int N_DEdge, N_DTri, N_DTet;
extern int N_BndryTri;
extern clr Max_color;
extern point *Gradients;
extern point Motion;
extern point Area_Grad;
extern point Wulff_Grad;
extern point Wulff_Vect;
extern int Wulff_Count;
extern real *Volumes;
extern real *Desired_Changes;
extern real *Targets;
extern real Total_Area;
extern real Total_Energy;
extern real Total_Volume;
extern real Int_Dev;
extern bool Pos_Err;
extern point Torus;
extern bool Torus_Same;
extern real Omit_Level;

/* function declarations */

/* structs.c */
void init_site();
corner new_corner();
facet_edge make_wing();
corner inf_vert();
void link_edge_loops();
void link_wings();
facet_edge reverse_edge_loop();

/* printer.c */
void fprint_corner(), fprint_site(), fprint_wing(), fprint_fe(), fprint_face();
void fprint_grads(), fprint_volumes(), fprint_volume_summary();
void eprint_face();
#define print_corner(c) fprint_corner(stdout,c)
#define print_site(s) fprint_site(stdout,s)
#define print_grads(s) fprint_grads(stdout,s)
#define print_face(f) fprint_face(stdout,f)
#define print_fe(f) fprint_fe(stdout,f)
#define print_wing(f) fprint_wing(stdout,f)
#define print_volumes() fprint_volumes(stdout)
#define print_volume_summary() fprint_volume_summary(stdout)
#define print_num(s) fprint_num(stdout,s)

/* first3.c */
facet_edge first_three();

/* areas.c */
real compute_areas();

/* init.c */
int read_sites();

/* plot.c */
void init_plot();
void plot_faces();
void plot_all_edges();
/* lower level */
void dbg_plt();
void plot_edge();
void plot_face();
void plot_dual_edge();

/* tracer.c */
void no_op();
