
/*
  $Header: /usr4/Geom_utilities/Tsum/RCS/main.c,v 1.1 91/03/12 16:44:21 meuer Exp $

  Main routine for the tsum.

  Reads a bunch of numbers and adds them up.

  Mark Meuer
  #1267045

  */

#include	<strings.h>
#include	"tsum.h"

main( argc, argv )
     int	argc;
     char	**argv;
{
    char	*in_file_name, *out_file_name;
    FILE	*in_file, *out_file;
    int		chunk_size;


    fprintf(stderr, "\n%s - compute the sum of numbers\n", argv[0]);
    fprintf(stderr, "Geometry Supercomputer Project\n\n", argv[0]);
    fflush(stderr);
    /* PARSE THE COMMAND ARGUMENTS */
    parse_command_line( argc, argv, &in_file_name, &out_file_name, &chunk_size );

    /* OPEN THE FILES */
    fprintf( stderr, "Reading from %s, writing to %s.\n",
	   ( strcmp(in_file_name, "-") == 0 ) ? "standard input" : in_file_name,
	   ( strcmp(out_file_name, "-") == 0 ) ? "standard output" : out_file_name );
    if ( strcmp(in_file_name, "-") ==  0 )
    {
	in_file = stdin;
    }
    else
    {
	in_file = open_file( in_file_name, "r" );
    }
    
    if ( strcmp(out_file_name, "-") ==  0 )
    {
	out_file = stdout;
    }
    else
    {
	out_file = open_file( out_file_name, "w" );
    }

    /* PROCESS THE NUMBERS */
    process_numbers( in_file, out_file, chunk_size );
    
    /* CLOSE THE FILES */
    if ( in_file != stdin )
    {
	fclose( in_file );
    }

    if ( out_file != stdout )
    {
	fclose( out_file );
    }

    fprintf(stderr, "%s ended normally.\n", argv[0]);
    exit(0);
}
