
/*
  $Header: /usr4/Geom_utilities/Poly2xy/RCS/process_polygons.c,v 1.1 91/03/12 11:00:32 meuer Exp $


  Read in a list of polygons and feed them one-by-one into the routine that will break them
  into triangles.

  Mark Meuer
  #1267045

  */

#include	"poly2xy.h"

void
process_polygons( in_file, out_file, no_sides )
     FILE 	*in_file, *out_file;
     int	no_sides;
{
    int	success = TRUE;
    Polygon	polygon;
    int	no_polys = 0;	/* Number of polygons processed */
    int order_changed;	/* Flag to indicate that the vertex order has been changed */
    
    /* WHILE NOT AT THE END OF THE LIST, */
    while( (!feof( in_file )) && (success) )
    {
	/* READ ONE POLYGON */
	success = read_polygon(in_file, &polygon, no_sides);
	
	/* IF SUCCESSFUL, */
	if (success)
	{
	    /* PROJECT THE VERTICIES INTO THE XY PLANE */
	    project_verticies_to_xy( &polygon );

	    /* PRINT THE NEW POLYGON */
	    print_polygon(out_file, &polygon, PRINT_PLANE_COORDS );
	    
	    no_polys++;
	}
    }
    fprintf(stderr, "Processed %d polygons.\n", no_polys );
}
