
/*
  $Header: /usr4/Geom_utilities/Poly2area/RCS/poly2a_func.c,v 1.1 91/03/12 16:39:58 meuer Exp $
  
  Compute the area of a polygon

  Returns -1 if there is an error.
  
  Mark Meuer
  #1267045
  
  */
#include	"poly2area.h"


Float
poly2area(num, poly)
     int	num;
     double	*poly;
{
    static Polygon	polygon;
    int			tris_generated = 0;
    int			order_changed;
    int			i;
    Float		area = -1;
    static		old_polygon_size = 0;

    
    /* IF THERE ARE AT LEAST THREE VERTICIES IN THE POLYGON */
    if ( num >= 3 )
    {
	/* CREATE A POLYGON STRUCTURE */
	polygon.no_verticies = num;
	if ( polygon.no_verticies > old_polygon_size )
	{
	    if ( old_polygon_size > 0 )
	    {
		free( (char *) polygon.top_vertex );
	    }
	    polygon.top_vertex = (Vertex *) malloc( sizeof(Vertex) * num );
	    old_polygon_size = polygon.no_verticies;
	}
	
	if ( polygon.top_vertex )
	{
	    for( i = 0; i < num ; i++ )
	    {
		polygon.top_vertex[i].world_coords[0] = poly[(i * 3)];
		polygon.top_vertex[i].world_coords[1] = poly[(i * 3) + 1];
		polygon.top_vertex[i].world_coords[2] = poly[(i * 3) + 2];
		if ( i != 0 )
		{
		    polygon.top_vertex[i].prev_vertex = &polygon.top_vertex[i-1];
		}
		else
		{
		    polygon.top_vertex[i].prev_vertex = &polygon.top_vertex[num-1];
		}

		if ( i != num - 1 )
		{
		    polygon.top_vertex[i].next_vertex = &polygon.top_vertex[i+1];
		}
		else
		{
		    polygon.top_vertex[i].next_vertex = &polygon.top_vertex[0];
		}
	    }
	    
	    /* PROJECT THE VERTICIES INTO THE XY PLANE IN COUNTER-CLOCKWISE ORDER. */
	    project_verticies_to_xy( &polygon );

	    /* COMPUTE THE AREA */
	    area = euclidian_area( &polygon );
	}
    }
    return( area );
}
