
/*
  $Header: /usr4/Geom_utilities/Poly2area/RCS/euclid_area.c,v 1.1 91/03/06 11:59:40 meuer Exp $


  Compute the Euclidian area of a polygon

  Mark Meuer
  #1267045

  */

#include	"poly2area.h"

Float
euclidian_area( poly )
     Polygon	*poly;
{
    Float	area;
    Vertex	*vert;
    Vertex	*temp_next_vert;
    int		order_changed = FALSE;
    
    /* COMPUTE THE AREA OF THE POLYGON */
    area = 0.0;
    vert = poly->top_vertex;
    do
    {
	area += ((vert->plane_coords[0] * vert->next_vertex->plane_coords[1])
		 - (vert->plane_coords[1] * vert->next_vertex->plane_coords[0]));

	vert = vert->next_vertex;
    } while ( vert != poly->top_vertex );
    area *= 0.5;
    
    return(fabs(area));
    
}
