


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef LIGHTDEF
#define LIGHTDEF

#include "color/color.h"
#include "geometry/point.h"

typedef struct light {
    struct light *next;
    Color ambient;
    Color color;
    Point position;
    float intensity;
    int lightswitch;

    int lightno;
    int changed;
} Light;

typedef struct lights {
    Color ambient;
    int localviewer;
    float attenconst, attenmult;
    struct light *lights;

    int lightmodelno;
    int changed;
} Lights;

Light *LtCreate();
void LtDelete( Light * );
void LtCopy( Light *, Light * );
void LtDefault( Light * );
void LtProperties( Light *, float, Color *, Point * );
void LtSwitch( Light *, int onoff );
void LtLight( Light * );
void LtSave( Light *, FILE * );
Light *LtLoad( Light *, FILE *);
void LtRemove( Lights *, Light * );
void LtAppend( Lights *, Light * );

Lights *LmCreate();
void LmDelete( Lights * );
void LmDefault( Lights * );
void LmSwitch( Lights *, int onoff );
void LmLights( Lights * );
void LmModelUpdate( Lights * );
Lights *LmLoad( Lights *, char *filename );
void LmSave( Lights *, char *filename );

#endif
