/*********************************************************************

	file.mini.c
	
	file functions for Miniedit
	
*********************************************************************/
#include <MacHeaders>

#ifdef OLDFILEMINI	
#include "MacTypes.h"
#include "FileMgr.h"
#include "TextEdit.h"
#include "WindowMgr.h"
#include "StdFilePkg.h"
#endif

#include "macstuff.h"

Str255 		theFileName;
static int	theVRefNum;

extern TEHandle  TEH;
extern WindowPtr myWindow;
extern char		 dirty;

SetUpFiles()
{
	pStrCopy((char *) "\p", (char *) theFileName);
	theVRefNum = 0;
}

int DoFile( item )
int		item;

{
	int 	vRef, io;
	short refNum;
	Str255	fn;

	switch (item) {
	case fmTop: /* fmTop */
		HideWindow( myWindow );
		return(true);
		break;		
	case fmNew: 
		SetWTitle( myWindow, "\pUntitled");
		ShowWindow( myWindow );
		dirty = 0;
		break;
	case fmOpen:
		if (OldFile(fn, &vRef ))
			if (FSOpen(fn, vRef, &refNum)==noErr) {
				if (ReadFile( refNum, TEH )) {
					pStrCopy((char *) fn, (char *) theFileName);
					theVRefNum = vRef;
					SetWTitle(myWindow, theFileName);
					dirty = 0;
				}
				if (FSClose(refNum)==noErr) ;
				ShowWindow( myWindow );
			}
			else FileError( "\pError opening ", fn );
		break;
	case fmClose:
		if (dirty) {
			switch (Advise("\pDo you want to save the changes to your file?")) {
			case aaSave:
				if (theFileName[0]==0) {
					fn[0] = 0;
					if (!SaveAs(fn, vRef)) 
						CloseMyWindow();
				}
	 			else if (!SaveFile( theFileName, theVRefNum ))
	 				CloseMyWindow();
				dirty = 0;
				return(true);
	 			break;
	 		case aaCancel:
	 			return(false);
	 			break;
	 		case aaDiscard: 
	 			CloseMyWindow();
				return(true);
	 		}
	 	}
	 	return(true);
		break;
	case fmSave:
		if (theFileName[0]==0) goto saveas;
		SaveFile(theFileName, theVRefNum);
		break;
	case fmSaveAs:
saveas:
		fn[0] = 0;
		if (SaveAs(fn, vRef )) {
			pStrCopy((char *) fn, (char *) theFileName);
			theVRefNum = vRef;
			SetWTitle(myWindow, theFileName);
		}
		break;
	case fmRevert:
		HidePen();
		TESetSelect( 0, (**TEH).teLength, TEH );
		ShowPen();
		TEDelete(TEH);
		if ((theFileName[0]!=0) &&
			(FSOpen(theFileName, theVRefNum, &refNum)==noErr)) {
			dirty = !ReadFile( refNum, TEH ); 
			/* I don't check for bad read! */
			if (FSClose(refNum)==noErr) ;
		}
		ShowWindow( myWindow );
		UpdateWindow( myWindow );
		break;
	case fmPageSetUp:
		DoPageSetUp();
		break;
	case fmPrint:
		PrintText( (**TEH).hText, (long)(**TEH).teLength, (GrafPtr)myWindow,
						StringWidth("\pmmmm"), 0L);
		break;
/*	case fmQuit: 
		if (DoFile(fmClose)) ExitToShell();
*/	}
	return(false);
}

static Point SFGwhere = { 90, 82 };
static Point SFPwhere = { 106, 104 };
static SFReply reply;

SaveAs( fn, vRef )
Str255 	fn;
int		vRef;
{
	short refNum;
	
	if (NewFile(fn, vRef)) 
		if (CreateFile(fn, vRef, &refNum)) {
			WriteFile(refNum, (*(**TEH).hText), (long)(**TEH).teLength);
			FSClose( refNum );
			dirty = 0;
			return(1);
		}
		else {
			FileError("\pError creating file ", fn);
		}
	return(0);
}

SaveFile( fn, vrn )
Str255	fn;
int		vrn;
{
	short refNum;
	
	if (FSOpen( fn, vrn, &refNum )==noErr) {
		WriteFile(refNum, (*(**TEH).hText), (long)(**TEH).teLength);
		dirty = 0;
		FSClose( refNum );
		return(1);
	}
	else FileError("\pError opening file ", fn);
	return(0);
}

NewFile( fn, vRef )
Str255	fn;
int	 vRef;
{
	SFPutFile(SFPwhere, "\p", fn, 0L, &reply);
	if (reply.good) {
		pStrCopy((char *) reply.fName, (char *) fn);
		vRef = reply.vRefNum;
		return(1);
	}
	else return(0);
}

OldFile( fn, vRef )
Str255	fn;
int		*vRef;
{
	SFTypeList	myTypes;
	
	myTypes[0]='TEXT';
	SFGetFile( SFGwhere, "\p", 0L, 1, myTypes, 0L, &reply );
	if (reply.good) {
		pStrCopy((char *) reply.fName, (char *) fn );
		*vRef = reply.vRefNum;
		return(1);
	}
	else return(0);
}

CreateFile( fn, vRef, theRef )
Str255	fn;
int		vRef;
short		*theRef;
{
	int io;
	
	io=Create(fn, vRef, '????', 'TEXT');
	if ((io==noErr) || (io==dupFNErr)) io = FSOpen( fn, vRef, theRef );
	return( (io==noErr) || (io=dupFNErr) );
}

WriteFile( refNum, p, num )
int		refNum;
char	*p;
long	num;
{
	int io;			/* 	a real application would want to check 
						this return code for failures */
	
	io=FSWrite( refNum, &num, p );
}

ReadFile( refNum, textH )
int		refNum;
TEHandle textH;
{
	char	buffer[256];
	long	count;
	int		io;
	
	TESetSelect(0, (**textH).teLength, textH);
	TEDelete( textH );
	do {
		count = 256;
		io = FSRead( refNum, &count, &buffer );
		TEInsert( &buffer, count, textH );
	} while (io==noErr);
	return( io==eofErr );
}

pStrCopy( p1, p2 )
register char *p1, *p2;
/* copies a pascal string from p1 to p2 */
{
	register int len;
	
	len = *p2++ = *p1++;
	while (--len>=0) *p2++=*p1++;
}

FileError( s, f )
Str255 s, f;
{
	ParamText(s, f,"\p", "\p");
	Alert( ErrorAlert, 0L );
}

Advise( s )
Str255 s;
{
	ParamText(s,"\p","\p","\p");
	return( Alert(AdviseAlert, 0L) );
}

