/*
 * sndheader.h
 */
/*
 * Jim Zelenka, CMU/ITC
 * rewritten 9 Jun 1992 (from my original sources, adding many new constants)
 */

#include <fcntl.h>
#include <errno.h>
#ifdef _IBMR2
#ifdef BIG_ENDIAN
#undef BIG_ENDIAN
#endif
#include <sys/audio.h>
#include <sys/acpa.h>
#endif

#ifdef _IBMR2
#define AUDIO_INIT_RETURN_FLAGS	\
"\14\14LOAD_CODE\13BEST_FIT\12BASS\11TREBLE\10BAL_DELAY\7BAL_CTRL\6VOL_DELAY\5VOL_CTRL\
\4MONITOR\3OUTPUT\2INPUT\1PITCH"
#endif

#define MONO 1
#define STEREO 2

/* NeXT sound headers */
#define NEXT_SND_MAGIC ((int)0x2e736e64)
#define NEXT_SND_FORMAT_UNSPECIFIED		(0)
#define	NEXT_SND_FORMAT_ULAW_8			(1)
#define NEXT_SND_FORMAT_LINEAR_8		(2)
#define NEXT_SND_FORMAT_LINEAR_16		(3)
#define NEXT_SND_FORMAT_LINEAR_24		(4)
#define NEXT_SND_FORMAT_LINEAR_32		(5)
#define	NEXT_SND_FORMAT_FLOAT			(6)
#define	NEXT_SND_FORMAT_DOUBLE			(7)
#define NEXT_SND_FORMAT_INDIRECT		(8)
#define	NEXT_SND_FORMAT_NESTED			(9)
#define NEXT_SND_FORMAT_DSP_CORE		(10)
#define NEXT_SND_FORMAT_DSP_DATA_8		(11)
#define NEXT_SND_FORMAT_DSP_DATA_16		(12)
#define NEXT_SND_FORMAT_DSP_DATA_24		(13)
#define NEXT_SND_FORMAT_DSP_DATA_32		(14)
#define	NEXT_SND_FORMAT_DISPLAY			(16)
#define	NEXT_SND_FORMAT_MULAW_SQUELCH		(17)
#define	NEXT_SND_FORMAT_EMPHASIZED		(18)
#define	NEXT_SND_FORMAT_COMPRESSED		(19)
#define	NEXT_SND_FORMAT_COMPRESSED_EMPHASIZED	(20)
#define	NEXT_SND_FORMAT_DSP_COMMANDS		(21)
#define	NEXT_SND_FORMAT_DSP_COMMANDS_SAMPLES	(22)

/* for soundheaders (IRCAM) */
#define IRCAM_SND_MAGIC 107364L
#define SIZEOF_IRCAM_HEADER 1024
#define IRCAM_SND_CHAR   0x101
#define IRCAM_SND_ALAW   0x102
#define IRCAM_SND_ULAW   0x103
#define IRCAM_SND_SHORT  0x104
#define IRCAM_SND_LONG   0x105
#define IRCAM_SND_FLOAT  0x106
#define	IRCAM_SND_END		0
#define	IRCAM_SND_MAXAMP	1
#define	IRCAM_SND_AUDIOENCODE	2
#define	IRCAM_SND_PVDATA	3
#define	IRCAM_SND_COMMENT	4
#define	IRCAM_SND_CODMAX	4

/* (Microsoft WAV sound headers */
/* purloined from public Microsoft RIFF docs */

#define	WAVE_FORMAT_UNKNOWN		(0x0000)
#define	WAVE_FORMAT_PCM			(0x0001) 
#define	WAVE_FORMAT_ADPCM		(0x0002)
#define	WAVE_FORMAT_ALAW		(0x0006)
#define	WAVE_FORMAT_MULAW		(0x0007)
#define	WAVE_FORMAT_OKI_ADPCM		(0x0010)
#define	WAVE_FORMAT_DIGISTD		(0x0015)
#define	WAVE_FORMAT_DIGIFIX		(0x0016)
#define	IBM_FORMAT_MULAW         	(0x0101)
#define	IBM_FORMAT_ALAW			(0x0102)
#define	IBM_FORMAT_ADPCM         	(0x0103)


#ifdef _IBMR2
#define MAXACPA 16
#endif

/* header formats */
#define SND_HEAD_NONE 0
/* LISP-SRC: (setf snd-head-none 0) */
#define SND_HEAD_AIFF 1
/* LISP-SRC: (setf snd-head-AIFF 1) */
#define SND_HEAD_IRCAM 2
/* LISP-SRC: (setf snd-head-IRCAM 2) */
#define SND_HEAD_NEXT 3
/* LISP-SRC: (setf snd-head-NeXT 3) */
#define SND_HEAD_WAVE 4
/* LISP-SRC: (setf snd-head-Wave 4) */

/* bitfields for soundheaders */
#define SND_HEAD_CHANNELS (1<<0)
/* LISP-SRC: (setf snd-head-channels 1) */
#define SND_HEAD_MODE (1<<1)
/* LISP-SRC: (setf snd-head-mode 2) */
#define SND_HEAD_BPS (1<<2)
/* LISP-SRC: (setf snd-head-bits 4) */
#define SND_HEAD_SRATE (1<<3)
/* LISP-SRC: (setf snd-head-srate 8) */

/* when returned from lisp, len (samples) is converted to time (seconds) */
#define SND_HEAD_LEN (1<<4)
/* LISP-SRC: (setf snd-head-dur 16) */

/* modes */
#define MODE_ADPCM 0
/* LISP-SRC: (setf snd-head-mode-adpcm 0) */
#define MODE_PCM   1
/* LISP-SRC: (setf snd-head-mode-pcm 1) */
#define MODE_ULAW 2
/* LISP-SRC: (setf snd-head-mode-ulaw 2) */
#define MODE_ALAW  3
/* LISP-SRC: (setf snd-head-mode-alaw 3) */
#define MODE_FLOAT 4
/* LISP-SRC: (setf snd-head-mode-float 4) */
/* unsigned pcm (e.g. Microsoft 8-bit wav format): */
#define MODE_UPCM 5
/* LISP-SRC: (setf snd-head-mode-upcm 5) */
#define NUM_MODES  6

/* including audio.h sets BIG_ENDIAN to some flag.  undefine it now */
#ifdef _IBMR2
#ifdef BIG_ENDIAN
#undef BIG_ENDIAN
#endif
#endif

int open_snd_file(char *filename, long *format, long *channels, long *mode, 
		  long *bits, double *srate, long *length, long *flags);
