.TH VIEWPOINT 1 "1 June 1988"
.SH NAME
viewpoint -- digital signal analysis with 3D interactive displays
.SH SYNOPSIS
.B viewpoint
[
.B ndcy
]
.sp
.SH DESCRIPTION
.LP
.I viewpoint
is a program for digital signal analysis that runs on Sun workstations.
Displays may be manipulated interactively in three dimensions,
allowing useful "viewpoints" of an analysis to be found.
Several "standard views" are available through mouse-driven menu selections.
Graphics and text may be accumulated to build
arbitrarily complex, fully labeled images.
.I viewpoint
runs in the suntools(1) environment but does not require it.
Hardcopy may be generated via raster dump files.
.LP
By default, the
.I viewpoint
display has an aspect ratio of 1 to .75 in width and height
(this is the "correct" aspect ratio for default Sun windows).
The display is automatically adjusted to fill as much of the
available screen area as possible.
The single command line argument, if given, sets the
.I height
of the aspect ratio to a number which must be greater than 0 and
less than or equal to 1.
For example, "viewpoint 1" sets the aspect ratio to 1:1
(resulting in round displayed circles),
while "viewpoint .25" will cause the display to be
one-fourth as tall as it is wide.
.LP
Pressing the
.I left
mouse button while the cursor points to a menu item
.I selects
that item.
When a menu item refers to a parameter value (such as the sampling rate),
selecting that item will cause a value scale to appear at the top
of the display--moving the mouse left and right selects a value
in the displayed range.
Pressing the
.I middle
mouse button causes the parameter to be
.I set.
Alternatively, reselecting the currently selected parameter
causes the program to prompt for keyboard input.
The user must then type a response followed by "return"
(typing "return" alone leaves the value unchanged).
Keyboard input may consist of strings (in the case of file names),
numbers, or expressions containing:
.IP operators
(+, -, *, /, ^, %);
.IP functions
(sin, cos, atan, ln, floor, abs, sqrt, rand--all functions
take single arguments, angles are in radians, the rand function returns
a value between 0 and its argument);
.IP parentheses,
.IP postoperators
(dB, K, k, Deg, s, ms),
and
.IP "numerical operands."
.LP
In addition, the following special operands are defined:
.IP R
- the current sampling rate (in samples/sec),
.IP L
- the length (in samples) of the current input file,
.IP B
- the current begin time (in samples),
.IP I
- the current number of processing iterations,
.IP S
- the current skip size (in samples),
and
.IP W
- the current window size (in samples).
.LP
Thus, to divide the input (waveform) data into 100 processing sections
of equal length, set "iterations" to 100 and the "skip size" to "L/I".
The "window size" parameter may then be used to specify windows
that overlap or not, as desired.
.SH OPERATION
.LP
Basic operation of
.I viewpoint
is as follows.
Starting at the current begin time (B) in the current input file,
the program reads in "window size" (W) samples and executes
the currently specified signal analysis.
If the number of iterations (I) is greater than 1, the window is advanced by
"skip size" (S) samples, the analysis is repeated, and so on.
Each iteration results in a two-dimensional display that is
drawn on an x-y plane in three-dimensional display space.
Successive displays are drawn on planes located at increasing values of z,
which recede "away" from the viewer in display space
when viewed from the "front" (a so-called "left-handed" coordinate system).
.LP
After all analysis iterations are complete, the resulting display is modified
according to the current display transformation, which consists of
optionally scaling, rotating, and translating the x, y and z coordinates.
Scale factors larger and smaller than 1 stretch and shrink the display
axes, respectively.
An additional "zoom" factor scales all axes simultaneously--zoom
factors larger and smaller than 1 zoom "towards" and "away"
from the image, respectively.
Rotations are applied around the current center of the display
first to x, then to y, then to z.
Rotations are given in radians, but the "Deg" postoperator
allows these to be specified in degrees, if desired.
A positive x rotation tilts the positive z-axis towards the positive y-axis,
a positive y rotation tilts the positive x-axis towards the positive z-axis,
while a positive z rotation tilts the positive x-axis towards the positive
y-axis.
Translations occur in the viewing area which is considered to run from
-.5 to +.5 in all dimensions
(the display is "clipped" to these values in x and y).
Standard viewpoints are centered a little to the right of the origin
(that is, they undergo a small, positive x translation)
to make room for the mouse-driven menus,
which appear at the left of the viewing area.
.SH MENUS
.LP
The command menu selects among various menu options and commands.
.LP
The
.I i/o
menu allows the input filename to be set
(input files are assumed to contain streams of binary float values
representing digital signals),
the "begin time" to be set,
the number of processing "iterations" to be set,
the "skip size" between windows to be set,
and so on.
Selecting the "current" item causes the currently specified display
to be posted, while "forward" and "backward" modify the begin time
by the current skip size and repost the display.
.LP
The
.I "signal processing"
menu allows the type of signal analysis to be selected,
the "window size" to be set,
and values for "xmin" and "xmax" to be set
(these allow certain details of the display to be examined).
Current signal analysis possibilities include
finding the r.m.s. or peak amplitude within the specified window(s),
Fourier transformation (with or without a Hamming window)
resulting in displays of amplitude, power, or phase spectra,
possibly on a dB scale which may be normalized to 0\ dB,
substitution of N-pole linear prediction waveforms for the input signal,
phase vocoder amplitude or frequency displays with optional linear prediction,
filter impulse response analysis,
optional pole-plot displays,
and so on.
.LP
The
.I "standard views"
menu allows any of the available standard viewpoints to be chosen.
If the number of iterations is greater than 1,
the resulting multiple displays may be viewed
from left-to-right,
top-to-botton,
bottom-to-top,
in a perspective projection,
or superimposed (from the front).
Individual planes of the display may be selected for separate viewing.
.LP
The
.I "adjust view"
menu allows arbitrary transformations
(scaling, rotation, or translation)
of the current display in three dimensions,
arbitrary reference viewpoints to be memorized,
n-step interpolations between alternative viewpoints to be specified,
and so on.
A "move" mode allows the display to be centered at the position of the
cursor when the middle mouse button is pressed.
.LP
The
.I "references"
menu allows the current display to be saved as a numbered reference display,
reference displays to be selected for editing, deleted, or made
temporarily invisible,
arbitrary text to be added to displays,
and so on.
.LP
The
.I "refresh"
item on the command menu redraws the entire screen
(this is sometimes necessary to correct display "damage").
.LP
The
.I "rasterdump"
item creates a file called
"raster.dump" in the current directory containing the current display
(such files may be subsequently printed on a PostScript printer
with suntops(1) and lpr(1)).
.LP
Finally, the
.I "quit"
command causes
.I viewpoint
to terminate.
.LP
Some menus contain redundant items--this is intended as a convenience.
The "grid" item cycles among available grid styles.
Tick marks for grids are automatically chosen to lie along a scale of
appropriate decimal values.
The "label" item turns axis labels on and off.
The "execute" item in the signal processing menu is synonymous with the
"current" item in the i/o menu, and so on.
.LP
A "practice image" is displayed when there is no valid file name or when
.I viewpoint
detects an error condition.
This image might be used
to adjust the viewpoint before data is read in from a file,
to experiment with viewpoint adjustments,
and so on.
.SH AUTHOR
F. R. Moore
.SH BUGS
.LP
.I viewpoint
knows nothing about soundfiles, headers, multiple channels of data, etc.
.LP
The "raster.dump" file is overwritten if it previously exists.
Raster files can take a long time to print and usually look no better
than the screen image.
.LP
It is up to the user to understand the computational implications
of the specified analysis--many long, windowed FFTs with high-order
linear prediction, for example, can sometimes take significant time
to compute.
.SH "SEE ALSO"
graph(1),
lpr(1),
sunplot(1),
suntops(1),
plot(1),
psplot(1).
