/*
 * Each converter is specified by a bit
 * position in a word which is an argument
 * to dsseq().
 */
# define CONV(x)	(1 << (x))
# define DA		(0)
# define AD		(1)

/*
 * Errors.
 * Returned in ds_err.errors.
 */
# define DSARGS		01	/* missing arguments/parameters */
# define DSACC		02	/* converters in use */
# define DSMOD		04	/* buffer size wasn't modulo MINDSB */
# define DSSIZE		010	/* buffer size was too small */
# define DSDISK		020	/* disk error */
# define DSCERR		040	/* converter error */
# define DSRST		0100	/* dsreset clobbered us */

/*
 * Ioctl commands.
 */
# define DSSEQ		((('s') << 8) | 0)	/* set sequence */
# define DSRATE		((('s') << 8) | 1)	/* set rate */
# define DS20KHZ	((('s') << 8) | 2)	/* set 20kHz filter */
# define DS10KHZ	((('s') << 8) | 3)	/* set 10kHz filter */
# define DS5KHZ		((('s') << 8) | 4)	/* set 5kHz filter */
# define DSBYPAS	((('s') << 8) | 5)	/* set bypass filter */
# define DSERRS		((('s') << 8) | 6)	/* get errors */
# define DSBNO		((('s') << 8) | 7)	/* set starting disk block */
# define DSFSIZE	((('s') << 8) | 8)	/* set file size */
# define DSCOUNT	((('s') << 8) | 9)	/* set amnt. to convert */
# define DSBOFF		((('s') << 8) | 10)	/* starting buffer offset */

# define NDSB		2		/* number of buffers chaining with */
# define MINDSB		16384		/* number of bytes per CDC track */

/*
 * Conv has a bit set which
 * corresponds to a particular
 * A/D or D/A. Dir specifies
 * the direction.
 */
struct ds_seq {
	short conv;
	short dir;
	short rate;
};

/*
 * Format of returned converter
 * errors.
 */
struct ds_err {
	short dma_csr;
	short asc_csr;
	short errors;
};

/*
 * File information.
 * The member bnosiz is used for
 * lots of things; starting block number
 * of the file, size of the file, amount
 * to convert, etc.
 * On the vax this structure
 * is the wrong size; 8 bytes instead
 * of the desired 6; fs_unused isn't
 * used so this shouldn't be a problem.
 */
struct ds_fs {
	daddr_t bnosiz;
	short fs_unused;
};
