/*
 * these values are critical;
 * dsseq depends on da being 0
 * and ad being 1
 */
# define DA		(0)
# define AD		(1)

/*
 * Errors.
 * Returned in ds_err.errors.
 */
# define DSARGS		01	/* missing arguments/parameters */
# define DSACC		02	/* converters in use */
# define DSMOD		04	/* buffer size wasn't modulo MINDSB */
# define DSSIZE		010	/* buffer size was too small */
# define DSDISK		020	/* disk error */
# define DSCERR		040	/* converter error */
# define DSRST		0100	/* dsreset clobbered us */

/*
 * Ioctl commands.
 */
# define DSSEQ		((('s') << 8) | 0)	/* set sequence */
# define DSRATE		((('s') << 8) | 1)	/* set rate */
# define DS20KHZ	((('s') << 8) | 2)	/* set 20kHz filter */
# define DS10KHZ	((('s') << 8) | 3)	/* set 10kHz filter */
# define DS5KHZ		((('s') << 8) | 4)	/* set 5kHz filter */
# define DSBYPAS	((('s') << 8) | 5)	/* set bypass filter */
# define DSERRS		((('s') << 8) | 6)	/* get errors */
# define DSBNO		((('s') << 8) | 7)	/* set starting disk block */
# define DSTODO		((('s') << 8) | 8)	/* # of bytes to be done */
# define DSCOUNT	((('s') << 8) | 9)	/* set amnt. to convert */
# define DSBOFF		((('s') << 8) | 10)	/* starting buffer offset */
# define DSNODSK	((('s') << 8) | 11)	/* no disking */
# define DSLAST		((('s') << 8) | 12)	/* last seq ram */

# define NDSB		2		/* number of buffers chaining with */
# define MINDSB		16384		/* number of bytes per CDC track */

/*
 * reg specifies a sequence register (0-15).
 * conv specifies a converter.
 * dirt specifies the direction when
 * setting up the sequence ram (DSSEQ) or the
 * sampling rate (DSRATE).
 */
struct ds_seq {
	short reg;
	short conv;
	short dirt;			/* shared by DSSEQ and DSRATE */
};

/*
 * Format of returned converter
 * errors.
 */
struct ds_err {
	short dma_csr;
	short asc_csr;
	short errors;
};

/*
 * File information.
 * The member bnosiz is used for
 * lots of things; starting block number
 * of the file, size of the file, amount
 * to convert, etc.
 * On the vax this structure
 * is the wrong size; 8 bytes instead
 * of the desired 6; fs_unused isn't
 * used so this shouldn't be a problem.
 */
struct ds_fs {
	daddr_t bnosiz;
	short fs_unused;
};
