h24522
s 00022/00058/00023
d D 1.2 88/03/16 17:00:20 root 2 1
c New improved (working!) version.
e
s 00081/00000/00000
d D 1.1 88/03/16 16:47:57 root 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

D 2

E 2
#include <stdio.h>
#include <carl/carl.h>

D 2
/*
 * vax2sun - convert vax single precision floating point to sun spf
 * How it works:
 * Between a vax and a sun, there is a high-bite/low-bite swap for each short.
 * So, with a sequence of bytes from the vax, a,b,c,d... we receive b,a,d,c...
 * For each float, first we flip the bytes back to a,b,c,d.  
 * Vaxes do not use IEEE floating point, suns do.  
 * The vax uses excess 128 representation for the exponent, whereas
 * the sun seems to use excess 126, necessitating a subtract by 2.
 * So, we split each 4 bytes
 * into the components: sign bit, exponent and mantissa.  For both a vax and
 * a sun, these are fortunately the same size and position:
 * SEEEEEEEEMMMMMMMMMMMMMMMMMMMMMMM
 * then do the subtract, then recombine elements.  The value for 0.0 is
 * non-uniform and must be treated specially.  It is 0:<31,0> on a vax, and
 * 1:<31>,0:<30,0> on a sun.
E 2
I 2
extern int fgetlong();
#define getlong(fptr)fgetlong(fptr,stdin)

/* 
 * vax2sun must be compiled and executed on a Sun
 * converts vax binary float to Sun (IEEE) binary floating point format
E 2
 */

D 2

E 2
main(argc, argv)
	char **argv;
{
	register char x[4];
D 2
	unsigned long zero = 0x80000000;
	short 	otty = isatty(1), 
		bug = 0;
	unsigned long cnt = 0, skip = 0;
E 2
I 2
	register char y[4];
E 2

D 2
	if (argc > 2)
E 2
I 2
	if (isatty(1) || argc > 1)
E 2
		usage(1);
D 2
	if (argc == 2) {
		skip = atoi(argv[1]);
		bug++;
	}
E 2

D 2
	while (getfloat((float *) x) > 0) {
		unsigned long f;	/* can't be a register variable */
		register short S = (x[1] & 0x80);	/* pick off sign bit */
		register char exp = (x[1] << 1) | ((x[0] >> 7) & 1);
		register long mant = ((x[0] & 0x7F) << 16) 
			| ((x[2] & 0xFF) << 8) | (x[3] & 0xFF);
E 2
I 2
	while (getlong((long*)x) > 0) {
		y[1] = x[0];
		y[0] = x[1];
		y[3] = x[2];
		y[2] = x[3];
		if (y[0] != 0)
			y[0] -= 1;
E 2

D 2
		if (bug)
			printf("%d\t%o\t%o\t%o\n",
				cnt++, S, exp, mant);
		if (S == 0 && exp == 0 && mant == 0) {	/* vax 0.0 ? */
			if (otty || bug)
				printf("%o\n", (long) zero);
			else
				putfloat(&zero);	/* substitute sun 0.0 */
			continue;
		}
		exp -= 2;
		f = (exp << 23);
		f |= (mant & 0xFFFFFF);
		if (S == 0)
			f &= 0x7FFFFFFF;	/* turn off sign bit */
		else
			f |= 0x80000000;	/* turn on sign bit */
		if (otty || bug)
			printf("%o\n", f);
		else
			putfloat(&f);
E 2
I 2
		putfloat((float*)y);
E 2
	}
D 2
	if (!otty && !bug)
		flushfloat();
E 2
I 2
	flushfloat();
E 2
	exit(0);
}

usage(ex)
{
D 2
	fprintf(stderr, "%s",
		"usage: vax2sun < vax_floatsams > sun_floatsams\n");
E 2
I 2
	fprintf(stderr, "%s%s%s",
		"usage: sun2vax < sun_floatsams > vax_floatsams\n",
		"output must be a file or pipe\n",
		"runs only on a vax\n"
		);
E 2
	exit(ex);
}
E 1
