/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include "sfstab.h"

main(argc, argv)
	char	**argv;
{
	extern struct sfstab	*getsfstabnam();
	extern struct sfstab	*getsfstabent();
	register char		*pv;
	struct sfstab		*st;
	int			i, j;

	for (i = 1; i < argc; i++) {
		pv = argv[i];
		if (pv[0] != '-')
			break;
		for (j = 1; pv[j] != NULL; j++) {
			switch (pv[j]) {
				default:
					usage();
					break;
			}
		}
	}

	if (i == argc) {
		int	first = 1;
		while ((st = getsfstabent()) != NULL) {
			if (strcmp(st->st_mode, "xx") != 0) {
				if (first == 0)
					printf("\n");
				first = 0;
				quotsf(st);
			}
		}
	}
	else {
		for (; i < argc; i++) {
			if ((st = getsfstabnam(argv[i])) == NULL) {
				fprintf(stderr, "can't get sfstab for %s\n", argv[i]);
				continue;
			}

			quotsf(st);
			if (i < argc)
				printf("\n");
		}
	}

	exit(0);
}

quotsf(st)
	struct sfstab		*st;
{
	extern char		*index();
	register char		*cp;
	FILE			*fid;
	char			buf[BUFSIZ];
	char			dname[BUFSIZ];	/* sfsys name */
	char			fname[BUFSIZ];	/* sound file name */
	char			user[80];	/* user name */
	char			sj[40];		/* string junk */
	char			flag[40];	/* used, unused, etc. */
	int			ij;		/* int junk */
	int			sz;		/* sound file size */
	int			stat;		/* sound file status */
	int			line;		/* current line in dskcyls */
	char			*scfmt = "%s%d%d%d%d%s";

	printf("%s:\n", st->st_dir);
	fflush(stdout);

	sprintf(dname, "%s/dskcyls", st->st_dir);
	if ((fid = fopen(dname, "r")) == NULL) {
		fprintf(stderr, "fopen: ");
		perror(dname);
		return;
	}

	line = 0;
	while (fgets(buf, sizeof(buf), fid) != NULL) {
		line++;
		if (sscanf(buf, scfmt, flag, &ij, &sz, &ij, &stat, fname) != 6) {
			fprintf(stderr, "%s: line %d mangled\n", fname, line);
			continue;
		}

		if (flag[0] == 'n')
			continue;

		/* /sndc/rusty/foo */

		for (ij = 0; ij < 3; ij++) {
			if ((cp = index(fname, '/')) == NULL) {
				if (strcmp(fname, "none") != 0)
					fprintf(stderr, "%s: line %d: funny sound file name\n", fname, line);
				goto contin;
			}

			*cp = '\t';
		}

		if (sscanf(fname, "%s%s", sj, user) != 2) {
			fprintf(stderr, "%s: line %d: can't decipher sound file name\n");
			continue;
		}

		add_tot(user, sz);

		contin:;
	}

	print_tots(st->st_dir, st);
}

struct hashlist {
	struct hashlist *	hl_next;	/* next hash entry	*/
	char *			hl_sym;		/* symbolic name	*/
	int			hl_tot;		/* value to store	*/
};

# define HSIZE		512

struct hashlist *hashlist[HSIZE];

print_tots(dname, st)
	char		*dname;
	struct sfstab	*st;
{
	extern FILE			*popen();
	register struct hashlist	*hl;
	register struct hashlist	*hlnext;
	register int			i;
	FILE				*fid;

	if ((fid = popen("/usr/bin/sort +1rn", "w")) == NULL) {
		fprintf(stderr, "print_tots: can't find sort program\n");
		return;
	}

	printf("User		Cyls	Percentage\n");
	fflush(stdout);
	for (i = 0; i < HSIZE; i++) {
		for (hl = hashlist[i]; hl != NULL; hl = hlnext) {
			fprintf(fid, "%-10s\t%d\t%3d%%\n",
				hl->hl_sym,
				hl->hl_tot,
				((int) (100 * ((double) hl->hl_tot / (double) st->st_cylsize))));
			hlnext = hl->hl_next;
			free((char *) hl);
		}
		hashlist[i] = NULL;
	}

	pclose(fid);
}

add_tot(user, size)
	char	*user;
{
	extern	struct hashlist *lookup();
	extern	struct hashlist *install();
	register struct hashlist *hl;

	if ((hl = lookup(user)) == NULL) {
		if ((hl = install(user)) == NULL) {
			fprintf(stderr, "addtot: can't install %s\n", user);
			return;
		}
	}

	hl->hl_tot += size;
}

hash(sym)
	register char *sym;
{
	register int hashval;

	for (hashval = 0; *sym != NULL; hashval <<= 2, hashval += *sym++)
		continue;

	hashval += *(sym-1) << 5;
	hashval %= HSIZE;

	if (hashval < 0)
		hashval += HSIZE;

	return(hashval);
}

struct hashlist *
lookup(sym)
	char	*sym;
{
	register struct hashlist *hl;

	for (hl = hashlist[hash(sym)]; hl != NULL; hl = hl->hl_next) {
		if ((hl->hl_sym != NULL) && (strcmp(sym, hl->hl_sym) == 0))
			return(hl);
	}

	return(NULL);
}

struct hashlist *
install(sym)
	char	*sym;
{
	extern	char *calloc();
	extern	char *strsave();
	register struct hashlist *hl;
	int	hashval;

	if ((hl = (struct hashlist *) calloc(1, sizeof(struct hashlist))) == NULL) {
		fprintf(stderr, "install: can't calloc");
		return(NULL);
	}

	if ((hl->hl_sym = strsave(sym)) == NULL) {
		fprintf(stderr, "install: can't strsave");
		return(NULL);
	}

	hl->hl_tot = 0;

	hashval = hash(hl->hl_sym);
	hl->hl_next = hashlist[hashval];
	hashlist[hashval] = hl;

	return(hl);
}

char *
strsave(str)
	register char *str;
{
	extern char *malloc();
	register char *sp;

	if ((sp = malloc(strlen(str) + 1)) == NULL)
		return(NULL);

	strcpy(sp, str);

	return(sp);
}

usage() {
	fprintf(stderr, "quotsf: usage: quotsf sfsys\n");
	exit(1);
}
