/* %M%	%I%	(CARL)	%G%	%U% */

static char SID_UTIL[] = "%Z%%M% %I% (CARL) %G%";

# include <signal.h>
# include <sgtty.h>
# include <errno.h>
# include <stdio.h>
# include "catt.h"

/*
 * print a message on the user's
 * terminal
 */
/* VARARGS */
msg(fmt, args)
char *fmt;
{
	register char *cp;

	_doprnt(fmt, &args, stdout);
	for (cp = crlf; *cp != NULL; cp++)
		putc(*cp, stdout);
}

/*
 * print a message on the user's
 * terminal, no line feed
 */
/* VARARGS */
echo(fmt, args)
char *fmt;
{
	_doprnt(fmt, &args, stdout);
}

/*
 * print a diagnostic.
 * print argv0 then duplicate
 * actions of msg()
 */
diag(fmt, args)
char *fmt;
{
	register char *cp;

	for (cp = argv0; *cp != NULL; cp++)
		putc(*cp, stdout);
	putc(':', stdout);
	putc(' ', stdout);

	_doprnt(fmt, &args, stdout);

	for (cp = crlf; *cp != NULL; cp++)
		putc(*cp, stdout);
}

sigerr(sig) {
	signal(sig, sigerr);

	diag("caught signal %d", sig);
	signal(SIGIOT, SIG_DFL);
	signal(SIGILL, SIG_DFL);
	done(ERR);
}

delay(n)
long int n;
{
	while (n-- > 0);
}

char *
noaccess(buf, nam)
char *buf, *nam;
{
	extern int errno;

	switch (errno) {
		case EBUSY:
			sprintf(buf, "%s line in use", nam);
			break;
		case EACCES:
			sprintf(buf, "access denied for %s line", nam);
			break;
		case ENOENT:
			sprintf(buf, "no such %s line", nam);
			break;
		default:
			sprintf(buf, "can't access %s line", nam);
			break;
	}

	return(buf);
}

done(stat) {
	if (rdpid) {
		if (kill(rdpid, SIGKILL) == -1) {
			printf("can't kill rd proc.\n");
			stat = ERR;
		}
		else
			wait(0);
	}

	lnclose();

	msg("disconnected");

	tty(T_NORM);

	if (stat != ERR)
		exit(stat);

	abort();
}

/*
 * change parameters on
 * user's tty
 */
tty(mode) {
	struct sgttyb stbuf;
	struct tchars tchars;

	ioctl(fileno(stdin), TIOCGETP, &stbuf);
	ioctl(fileno(stdin), TIOCGETC, (struct sgttyb *) &tchars);

	lcase = stbuf.sg_flags & LCASE;
	tkill = stbuf.sg_kill;
	terase = stbuf.sg_erase;
	tintr = tchars.t_intrc;

	switch (mode) {
		case T_NORM:
			stbuf.sg_flags &= ~ RAW;
			stbuf.sg_flags |= (ECHO | CRMOD);
			break;

		case T_RAW:
			stbuf.sg_flags |= RAW;
			if (hflg)
				stbuf.sg_flags &= ~ CRMOD;
			else
				stbuf.sg_flags &= ~ (ECHO | CRMOD);
			break;

		case T_SLNT:
			stbuf.sg_flags &= ~ RAW;
			stbuf.sg_flags &= ~ (ECHO | CRMOD);
			break;

		default:
			break;
	}

	ioctl(fileno(stdin), TIOCSETP, &stbuf);
}

char *
strsav(arg)
char *arg;
{
	register char *str;

	str = alloc(strlen(arg)+1);
	strcpy(str, arg);

	return(str);
}

char *
alloc(n)
register int n;
{
	register char *cp;

	if ((cp = malloc(n)) == NULL) {
		diag("alloc error");
		done(ERR);
	}

	zero(cp, n);

	return(cp);
}

zero(cp, n)
char *cp;
{
# ifdef vax
# ifdef lint
	cp = (char *) n;
	n = (int) cp;
# endif lint
	asm("	movc5	$0,*4(ap),$0,8(ap),*4(ap)");
# else vax
	do {
		*cp++ = NULL;
	} while (--n > 0);
# endif
}
