/* rd.c	1.2	(CARL)	8/16/82	18:15:15 */

static char SID_rd[] = "@(#)rd.c 1.2 (CARL) 8/16/82";

# include <signal.h>
# include <stdio.h>
# include "catt.h"

static char rdtmpbuf[BUFSIZ];
static int whoami;
static file *dfid;
static bool slnt;
static bool emt;

/*
 * rd: read from remote: line -> 1
 * catch:
 *
 *	~>[>][:][file]
 *	stuff from file...
 *	~> (ends diversion)
 *
 */
rd() {
	extern int dodiver(); 
	register char *bp;
	register char nl;
	register char cr;
	register char tld;
	register bool cpy;
	bool newl;
	char *buf;
	char ch;

	whoami = getpid();
	signal(SIGEMT, dodiver);

	dfid = NULL;
	buf = alloc(BUFSIZ);

	newl = TRUE;
	cpy = FALSE;
	nl = '\n';
	cr = '\r';
	tld = '~';

top:	while (read(ln, &ch, CHRSIZ) == CHRSIZ) {
		ch &= 0177;
		if (ch == tld) {
			if (newl) {
				cpy = TRUE;
				bp = &buf[0];
			}
			else if ((bp == &buf[1]) && cpy)
				cpy = FALSE;
		}

		if (newl = (ch == nl)) {
			if (cpy) {
				cpy = FALSE;
				*bp = NULL;
				putc(ch, stdout);
				if (divert(&buf[1]))
					return;		/* lost carrier */
				continue;
			}
		}

		if (cpy) {
			if (ch != cr)
				*bp++ = ch;
			if (bp >= &buf[BUFSIZ])
				bp--;
		}

		if ((dfid != NULL) && (ch != cr))
			putc(ch, dfid);

		putc(ch, stdout);
	}

	if (emt) {
		emt = FALSE;
		goto top;
	}
}

divert(buf)
char *buf;
{
	char *bp;
	char chr;
	bool tilde;
	bool edvr;
	bool apnd;
	bool newl;
	auto len;
	auto nch;
	auto i;

	bp = &buf[0];
	if (*bp != '>')
		return(OK);

	bp++;
	apnd = FALSE;
	slnt = FALSE;

	for (i = 0; i < 2; i++) {
		if (*bp == '>')
			apnd = TRUE;
		else if (*bp == ':')
			slnt = TRUE;
		else
			break;
		bp++;
	}

	len = strlen(bp);
	if (bp[len-1] == '\n')
		bp[len-1] = NULL;	/* zap newline */

	if ((dfid = fopen(bp, apnd ? "a" : "w")) == NULL) {
		diag("fopen error: %s: %s", bp, sys_errlist[errno]);
		return(OK);
	}

	setbuf(dfid, (char *) NULL);

	nch = 0;
	newl = TRUE;
	tilde = FALSE;
	edvr = FALSE;

dvr:	while (read(ln, &chr, CHRSIZ) == CHRSIZ) {
		chr &= 0177;
		if (chr == '~') {
			if (newl) {
				tilde = TRUE;
				continue;
			}
		}
		if (chr == '>') {
			if (tilde) {
				edvr = TRUE;
				continue;
			}
		}
		if (newl = (chr == '\n')) {
			if (edvr) {
				fclose(dfid);
				dfid = NULL;
				putc('\n', stdout);
				return(OK);
			}
		}

		/*
		 * watch for lines that have ~>
		 * at the beginning of them but
		 * aren't end-of-diversion lines.
		 */
		if (chr != '\r') {
			if (edvr) {
				putc('~', dfid);
				putc('>', dfid);
			}
			putc(chr, dfid);
			tilde = edvr = FALSE;
		}

		if (! slnt)
			putc(chr, stdout);
		nch++;
		if (dflg && slnt)
			if ((nch % 512) == 0)
				putc('.', stdout);
	}

	if (emt) {
		emt = FALSE;
		goto dvr;
	}

	/* lost carrier */
	return(ERR);
}

dodiver() {
	register char *cp; 
	register file *fid;

	emt = TRUE;
	signal(SIGEMT, dodiver);

	sprintf(rdtmpbuf, "/tmp/%s%d", argv0, whoami);
	if ((fid = fopen(rdtmpbuf, "r")) == NULL) {
		diag("fopen error: %s: %s", rdtmpbuf, sys_errlist[errno]);
		return;
	}

	/*
	 * the order of the next two lines
	 * is important because of our re-use
	 * of rtdmpbuf.
	 */
	unlink(rdtmpbuf);
	fgets(rdtmpbuf, BUFSIZ, fid);

	fclose(fid);

	cp  = rdtmpbuf;
	if (*cp == '>')
		cp++;
	if (*cp == ':') {
		cp++;
		if (*cp == NULL) {
			slnt = !slnt;
			return;
		}
		else
			slnt = TRUE;
	}

	if (dfid != NULL) {
		fclose(dfid);
		dfid = NULL;
	}
	if (*cp == NULL) {
		slnt = FALSE;
		dfid = NULL;
		return;
	}

	if (dflg)
		diag("dodiver: name of target file: %s", cp);

	if ((dfid = fopen(cp, (rdtmpbuf[0] == '>') ? "a" : "w")) == NULL)
		diag("fopen error: %s: %s", cp, sys_errlist[errno]);

	setbuf(dfid, (char *) NULL);
}
