/* main.c	1.4	(CARL)	8/27/82	09:38:44 */

static char SID_main[] = "@(#)main.c 1.4 (CARL) 8/27/82";

# include <sysexits.h>
# include <signal.h>
# include <sgtty.h>
# include <ctype.h>
# include <stdio.h>
# include "catt.h"
# include "conn.h"

/*
 * usage:
 *	cu [ -t ] [ -lline ] [ -sspeed ] telno
 * or
 *	dir [ -t ] [ -lline ] [ -sspeed ]
 * or
 *	dsw [ -t ] [ -w ] [ -lline ] [ -sspeed ] [ -mmach ]
 *
 * escape with `~' at beginning of line.
 * ordinary diversions are ~<, ~> and ~>>.
 * silent output diversions are ~>: and ~>>:.
 * terminate output diversion with ~> alone.
 * quit is ~. and ~! gives local command or shell.
 * also ~$ for canned procedure pumping remote.
 * ~%put from [to]  and  ~%take from [to] invoke builtins
 */

/*
 * main: get connection, set speed for line.
 * spawn child to invoke rd to read from line, output to fd 1
 * main line invokes wr to read tty, write to line
 */
main(argc, argv)
char *argv[];
{
	extern char *rindex();
	int speed;
	int i;
	bool argerr;
	char *telno;
	char *name;
	char *cmsg;
	char *dev;
	char *pv;

	/* some default values */
	argerr = FALSE;
	telno = NULL;
	dev = NULL;
	if ((pv = rindex(argv[0], '/')) != NULL)
		pv++;
	else
		pv = argv[0];
	argv0 = strsav(pv);		/* we clobber argv later */
	name = strsav(pv);		/* we clobber argv later */

	setbuf(stdout, (char *) NULL);
	setbuf(stderr, (char *) NULL);

	/*
	 * I'd like to use NSIG instead
	 * of 16 but that causes problems
	 */
	for (i = 3; i < 16; i++)
# ifdef SIGSTOP
		if (i != SIGSTOP)
# endif SIGSTOP
			signal(i, sigerr);

	dflg = mflg = sflg = tflg = wflg = FALSE;

	for (i = 1; i < argc; i++) {
		pv = argv[i];
		if (*pv != '-')
			break;
		while (*++pv != NULL) {
			switch (*pv) {
				case 'd':
					dflg = TRUE;
					break;

				case 'l':
					dev = strsav(pv+1);
					goto contin;

				case 'm':
					mflg = TRUE;
					name = strsav(pv+1);
					goto contin;

				case 's':
					sflg = TRUE;
					speed = atoi(pv+1);
					goto contin;

				case 't':
					tflg = TRUE;
					break;

				case 'w':
					wflg = TRUE;
					break;

				default:
					diag("arg error: %c", *pv);
					argerr = TRUE;
			}
		}
		contin:;
	}

	if (i == (argc-1))
		telno = strsav(argv[i]);

	/*
	 * smash argv so ps won't
	 * show telno
	 */
	while (*argv != NULL) {
		pv = *argv;
		while (*pv != NULL)
			*pv++ = NULL;
		*argv++ = NULL;
	}

	if ((cmsg = conn(name, dev, speed, telno, argerr)) != NULL) {
		diag(cmsg);
		exit(EX_UNAVAILABLE);
	}

	msg("connected");
	efork();
	tty(T_RAW);
	wr();
	done(OK);
}

efork() {

	if (rdpid)
		kill(rdpid, SIGKILL);

	while ((rdpid = fork()) == -1) {
		diag("couldn't fork, retrying..");
		sleep(1);
	}

	nhup = signal(SIGINT, SIG_IGN);

	if (rdpid == 0) {
		rd();
		diag("\007lost carrier");
		exit(EX_UNAVAILABLE);
	}
}
