/* dirconn.c	1.11	(CARL)	7/15/83	10:16:44 */

static char SID_dirconn[] = "@(#)dirconn.c 1.11 (CARL) 7/15/83";

# ifdef DIR
# include <errno.h>
# include <sgtty.h>
# include <stdio.h>
# include "catt.h"
# include "conn.h"

/*
 * direct connect routine
 */

# define STBNULL	((struct sgttyb *) NULL)

/*
 * default speed for direct
 * connection
 */
# define DIRSPEED	4800

/*
 * available devices for a
 * direct connection
 */
struct conndev pdpdev[] = {
	{ "/dev/pdp0",	DIRSPEED },
	{ "/dev/pdp1",	DIRSPEED },
	{ 0,		0 }		/* last entry must be zeros */
};
struct conndev vaxdev[] = {
	{ "/dev/vax0",	DIRSPEED },
	{ "/dev/vax1",	DIRSPEED },
	{ 0,		0 }		/* last entry must be zeros */
};
struct conndev sundev[] = {
	{ "/dev/sun0",	DIRSPEED },
	{ "/dev/sun1",	DIRSPEED },
	{ 0,		0 }		/* last entry must be zeros */
};

static char dirmsgbuf[BUFSIZ];

static char dirusage[] = "usage: %s [ -t ] [ -lline ] [ -sspeed ]";

char *
dirconn(ctp, speed, argerr)
struct conntab *ctp;
bool argerr;
{
	struct sgttyb stbuf;
	struct conndev *cdp;
	int lspeed;
	int oerrno;

	/*
	 * no telephone numbers for direct connection.
	 * bomb on any argument errors too.
	 */
	if ((ctp->c_telno != NULL) || argerr) {
		sprintf(dirmsgbuf, dirusage, ctp->c_name);
		return(dirmsgbuf);
	}

	/*
	 * check each device in the device table, check and
	 * set the speed, see if the line really exists and
	 * try to open it.
	 */
	for (cdp = ctp->c_dev; cdp->d_dev != NULL; cdp++) {
		if (sflg)
			cdp->d_speed = speed;
		if (cdp->d_speed == 0)
			cdp->d_speed = DIRSPEED;
		if ((lspeed = spdchk(cdp->d_speed, sflg)) == ERR)
			return("bad speed");

		oerrno = errno;
		if (access(cdp->d_dev, 6) != 0) {
			if (errno == ENOENT)
				errno = oerrno;
			continue;
		}

		if ((ln = open(cdp->d_dev, 2)) != -1)
			break;
	}

	if (cdp->d_dev == NULL)
		return(noaccess(dirmsgbuf, ctp->c_name));

	if (ln == -1)
		return("line in use");

	/* exclusive use */
	if (ioctl(ln, TIOCEXCL, STBNULL) == -1)
		goto iocerr;
	/* hang up on last close */
	if (ioctl(ln, TIOCHPCL, STBNULL) == -1)
		goto iocerr;

	/*
	 * get user's tty params and use
	 * them to set params on the
	 * communications line
	 */
	ioctl(fileno(stdout), TIOCGETP, &stbuf);
	stbuf.sg_ispeed = lspeed;
	stbuf.sg_ospeed = lspeed;
	stbuf.sg_flags = (EVENP | ODDP | RAW | (tflg ? TANDEM : 0));
	if (lspeed > B1200)
		stbuf.sg_flags |= TANDEM;
	if (ioctl(ln, TIOCSETP, &stbuf) == -1) {
	iocerr:	lnclose();
		return("ioctl error");
	}

	return(NULL);
}
# endif DIR
