/* curc.c	1.2	(CARL)	8/16/82	18:14:58 */

static char SID_curc[] = "@(#)curc.c 1.2 (CARL) 8/16/82";

# include <pwd.h>
# include <ctype.h>
# include <stdio.h>
# include "catt.h"
# include "conn.h"

# define delim(ch)	((ch == ' ') || (ch == '\t') || (ch == ','))
# define space(ch)	((ch == ' ') || (ch == '\t'))

static char curcf[] = ".curc";

struct telno *
curc(name)
char *name;
{
	extern struct passwd *getpwuid();
	extern struct telno *expand();
	struct passwd *pw;
	char buf[BUFSIZ];
	char fnam[80];
	char *cp;
	file *fd;

	if ((pw = getpwuid(getuid())) == NULL)
		return(NULL);

	strcpy(fnam, pw->pw_dir);
	strcat(fnam, "/");
	strcat(fnam, curcf);

	if (dflg)
		diag("curc: fnam=%s", fnam);
	if ((fd = fopen(fnam, "r")) == NULL)
		return(NULL);

	while (fgets(buf, BUFSIZ, fd) != NULL) {
		buf[strlen(buf)-1] = NULL;	/* zap newline */
		if (dflg)
			diag("curc: buf=%s", buf);
		/* find end of name */
		for (cp = &buf[0]; !space(*cp); cp++) {
			if (*cp == NULL)
				return(NULL);
		}
		*cp = NULL;

		if (eql(buf, name))
			return(expand(cp+1));	/* +1 skips over the NULL */
	}

	return(NULL);
}

# define talloc(n)	(struct telno *) alloc(sizeof(struct telno)*n)

struct telno *
expand(buf)
char *buf;
{
	struct telno *tp, *ntp;
	char numbuf[65];
	char *cp;
	int i;

	tp = talloc(1);
	ntp = tp;

	for (cp = buf; space(*cp); cp++)
		continue;

	for (;;) {
		/* copy number into numbuf */
		for (i = 0; !delim(*cp) && (*cp != NULL); i++)
			numbuf[i] = *cp++;

		numbuf[i] = NULL;
		ntp->t_telno = strsav(numbuf);

		/* skip to next number */
		while (delim(*cp) && (*cp != NULL))
			cp++;

		/*
		 * if this is the last number
		 * then terminate the list and
		 * return it.
		 */
		if (*cp == NULL) {
			ntp->t_next = NULL;
			return(tp);
		}
		else {
			ntp->t_next = talloc(1);
			ntp = ntp->t_next;
		}
	}

	/* NOTREACHED */
}
