/* switch.c	1.4	(CARL)	5/10/85	22:38:48 */

# include <stdio.h>
# include "switch.h"
# include "aswdaemon.h"

/*
 * routines and data to generalize
 * switcher interface
 */

/*
 * cmd smart switcher routines
 */
extern int	ss_conn();
extern int	ss_disconn();
extern int	ss_reset();
extern int	ss_init();

struct swdev	swdev[] = {
	{ "ss", "tcp", "/dev/ct0", ss_conn, ss_disconn, ss_reset, ss_init },
	{ NULL, NULL, NULL, NULL, NULL }
};

struct swdev	*sw = &swdev[0];

setsw(type)
	char	*type;
{
	int	retval;

	retval = RET_OK;

	for (sw = &swdev[0]; sw->sw_type != NULL; sw++) {
		if (strcmp(sw->sw_type, type) == 0)
			break;
	}

	/*
	 * didn't find it;
	 * reset sw to first entry.
	 */
	if (sw->sw_type == NULL) {
		err(ERR_USER, "setswitch: invalid switch server: %s", type);
		sw = &swdev[0];

		retval = RET_ERR;
	}

	(*sw->sw_init)();

	return(retval);
}
