/* ss_conn.c	1.12	(CARL)	5/11/85	12:26:41 */

# include <sys/file.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <stdio.h>
# include "connlist.h"
# include "numlist.h"
# include "ss_defs.h"
# include "client.h"
# include "clerr.h"
# include "switch.h"
# include "aswdaemon.h"

/*
 * connect routine for
 * cmd smart switcher
 */
ss_conn(nl1, nl2)
	struct numlist *nl1;
	struct numlist *nl2;
{
	register struct numlist *tonl, *tinl;
	register struct numlist *onl, *inl;
	register struct connlist *cl;
	short num;
	int ret;
	int fd;

	/* debug(DB_DRIVER, "ss_conn:"); */

	if (nl1 == NULL) {
		err(ERR_DRIVER, "ss_conn: nl1==NULL");
		client.cl_err = ASW_ERR_PROG;
		return(RET_ERR);
	}
	if (nl2 == NULL) {
		err(ERR_DRIVER, "ss_conn: nl2==NULL");
		client.cl_err = ASW_ERR_PROG;
		return(RET_ERR);
	}

	if (nl1->nl_type == NL_INPUT) {
		inl = nl1;
		onl = nl2;
	}
	else {
		inl = nl2;
		onl = nl1;
	}

	if (onl->nl_type == inl->nl_type) {
		info(INFO_DRIVER, "ss_conn: can't connect same type");
		client.cl_err = ASW_ERR_CHAN;
		return(RET_ERR);
	}

	if ((fd = open(sw->sw_devnam, O_WRONLY, 0)) == -1) {
		err(ERR_DRIVER, "ss_conn: open(%s): %m", sw->sw_devnam);
		client.cl_err = ASW_ERR_DEVIO;
		return(RET_ERR);
	}

	ret = RET_OK;

	/*
	 * for each input channel connect an output channel
	 * to it. if there are more output channels than
	 * input channels then output channels will be mixed
	 * together.
	 */
	tinl = inl->nl_forw;
	for (tonl = onl->nl_forw; tonl != onl; tonl = tonl->nl_forw) {
		/* verify channels */
		if ((tonl->nl_num < SS_MINCHAN) || (tonl->nl_num >= SS_MAXCHAN)) {
			info(INFO_DRIVER, "ss_conn: invalid output channel (%d)", tonl->nl_num);
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}
		if ((tinl->nl_num < SS_MINCHAN) || (tinl->nl_num >= SS_MAXCHAN)) {
			info(INFO_DRIVER, "ss_conn: invalid input channel (%d)", tinl->nl_num);
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}

		/*
		 * if single_output is non-zero then always break previous
		 * connections of the output device.
		 */
		if (single_output) {
			if ((cl = isconn(tonl->nl_num, CL_OUTPUT)) != NULL) {
				num = SS_DISCONN(cl->cl_output, cl->cl_input);
				/* debug(DB_DRIVER, "ss_conn: (disconn) num = 0%o (0x%x)", num, num); */
				debug(DB_DRIVER, "ss_conn: (disconn) %d->%d", cl->cl_output, cl->cl_input);
				if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
					err(ERR_DRIVER, "ss_conn: write: %m");
					client.cl_err = ASW_ERR_DEVIO;
					continue;
				}
			}
		}

		num = SS_CONN(tonl->nl_num, tinl->nl_num);
		debug(DB_DRIVER, "ss_conn: (conn) %d->%d", tonl->nl_num, tinl->nl_num);
		if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
			err(ERR_DRIVER, "ss_conn: write: %m");
			client.cl_err = ASW_ERR_DEVIO;
			continue;
		}

		if (addconn(tonl->nl_num, tinl->nl_num) == RET_ERR)
			err(ERR_DRIVER, "ss_conn: addconn failed");

		/*
		 * if we're at the end of the list
		 * then loop back around.
		 */
		if ((tinl = tinl->nl_forw) == inl)
			tinl = inl->nl_forw;
	}

	(void) close(fd);

	return(ret);
}
