/* log.c	1.7	(CARL)	7/24/84	13:41:35 */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <syslog.h>
# include <sgtty.h>
# include <stdio.h>
# include "aswdaemon.h"

/*
 * error logging and debug logging
 * routines. all logging routines
 * call the syslog() routine which
 * sends all messages to the syslog
 * daemon.
 */

/*VARARGS*/
err(lvl, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char *fmt;
{
	if (lvl & elevel) {
		if (setup_done)
			syslog(LOG_ERR, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
		else
			conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	}
}

/*VARARGS*/
info(lvl, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char *fmt;
{
	if (lvl & ilevel) {
		if (setup_done)
			syslog(LOG_INFO, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
		else
			conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	}
}

/*VARARGS*/
debug(lvl, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char *fmt;
{
	if (lvl & dlevel) {
		if (setup_done) {
			syslog(LOG_DEBUG, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
			/*
			 * sometimes the syslog daemon
			 * gets swamped
			 */
			sleep(1);
		}
		else
			conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	}
}

/*
 * error routine for yacc produced
 * parser
 */
asw_yyerror(str)
	char *str;
{
	err(ERR_PARSE, "%s", str);
}

/*VARARGS*/
conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char	*fmt;
{
	FILE	*fd;

	if ((fd = fopen("/dev/console", "w")) == NULL)
		return;

	fprintf(fd, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);

	fclose(fd);
}
