/* clconn.c	1.4	(CARL)	7/24/84	13:01:33 */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <errno.h>
# include <ctype.h>
# include <stdio.h>
# include "client.h"
# include "aswdaemon.h"

/*
 * clconn
 *
 * clconn accepts a client connection.
 */
clconn() {
	extern int errno;
	extern char *inet_ntoa();
	register struct hostent *hp;

	client.cl_addrlen = sizeof(client.cl_addr);
	if ((client.cl_sock = accept(sock, (struct sockaddr *) &client.cl_addr, &client.cl_addrlen)) == -1) {
		if (errno != EINTR)
			err(ERR_IPC, "clconn: accept: %m");
		errno = 0;

		return(RET_ERR);
	}

	if ((client.cl_fsock = fdopen(client.cl_sock, "r")) == NULL) {
		err(ERR_IPC, "clconn: fdopen");
		return(RET_ERR);
	}

	if ((hp = gethostbyaddr((char *) &client.cl_addr.sin_addr, sizeof(client.cl_addr.sin_addr), AF_INET)) == NULL)
		debug(DB_IPC, "clconn: hostaddr=%s", inet_ntoa(client.cl_addr.sin_addr));
	else
		debug(DB_IPC, "clconn: host=%s", hp->h_name);

	debug(DB_IPC, "clconn: port=%d", ntohs(client.cl_addr.sin_port));
	debug(DB_IPC, "clconn: sock=%d", client.cl_sock);

	return(RET_OK);
}
