h35511
s 00001/00000/00118
d D 1.6 85/04/25 11:36:38 rusty 6 5
c added "dump" command
e
s 00001/00000/00117
d D 1.5 85/03/14 16:15:55 rusty 5 4
c mods for "init" command
e
s 00001/00001/00116
d D 1.4 84/07/24 13:01:45 rusty 4 3
c changed error messages to use bits in elevel instead of ranges of values
e
s 00010/00010/00107
d D 1.3 84/07/24 12:21:07 rusty 3 2
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00022/00000/00095
d D 1.2 84/04/25 15:48:30 rusty 2 1
c many fixes to essentially add a new class of symbols to the symbol
c table; the class of variables. possibly other cosmetic changes
e
s 00095/00000/00000
d D 1.1 84/04/24 15:15:54 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
%{
/* %M%	%I%	(CARL)	%G%	%U% */

# include "parse.h"
# include "symtab.h"
# include "ident.h"
# include "aswdaemon.h"

int		cfnum;
char		cfstr[BUFSIZ];
%}

%%

"#".*"\n"	{
D 3
			debug(1, "cflex: comment");
E 3
I 3
			debug(DB_LEX, "cflex: comment");
E 3
		}

[a-zA-Z_][a-zA-Z_0-9]* {
			struct hlist	*hl;

D 3
			debug(1, "cflex: ident");
E 3
I 3
			debug(DB_LEX, "cflex: ident");
E 3
			if ((hl = lookup(yytext, ST_IDENT)) == NULL) {
				sscanf(yytext, "%s", &cfstr[0]);
				return(CF_IDENT);
			}

			strcpy(cfstr, hl->hl_ident->id_name);
			return(hl->hl_ident->id_val);
		}

I 2
\"[a-zA-Z_][a-zA-Z_0-9]*\" {
			extern char *index();
			register char *cp;

D 3
			debug(1, "cflex: string");
E 3
I 3
			debug(DB_LEX, "cflex: string");
E 3
# ifdef notdef
			/*
			 * change quotes to spaces so that
			 * we can use scanf.
			 */
			while ((cp = index(yytext, '"')) != NULL)
				*cp = ' ';
			scanf(yytext, "%s", cfstr);
# endif notdef
			strcpy(cfstr, &yytext[1]);
			cfstr[strlen(cfstr)-1] = NULL;
			return(CF_STRING);
		}

E 2
[0-9][0-9]*	{
D 3
			debug(1, "cflex: number");
E 3
I 3
			debug(DB_LEX, "cflex: number");
E 3
			sscanf(yytext, "%d", &cfnum);
			return(CF_NUMBER);
		}

";"		{
D 3
			debug(1, "cflex: semi");
E 3
I 3
			debug(DB_LEX, "cflex: semi");
E 3
			return(CF_SEMI);
		}

","		{
D 3
			debug(1, "cflex: comma");
E 3
I 3
			debug(DB_LEX, "cflex: comma");
E 3
			return(CF_COMMA);
		}

"["		{
D 3
			debug(1, "cflex: lbrack");
E 3
I 3
			debug(DB_LEX, "cflex: lbrack");
E 3
			return(CF_LBRACK);
		}

"]"		{
D 3
			debug(1, "cflex: rbrack");
E 3
I 3
			debug(DB_LEX, "cflex: rbrack");
E 3
			return(CF_RBRACK);
		}

"="		{
D 3
			debug(1, "cflex: equal");
E 3
I 3
			debug(DB_LEX, "cflex: equal");
E 3
			return(CF_EQUAL);
		}

[ \t\n]*	{
D 3
			debug(1, "cflex: blank");
E 3
I 3
			debug(DB_LEX, "cflex: blank");
E 3
		}

%%

static struct ident reswords[] = {
	{ "disconnect",	CF_DISCONNECT	},
	{ "connect",	CF_CONNECT	},
	{ "channel",	CF_CHANNEL	},
	{ "output",	CF_OUTPUT	},
	{ "input",	CF_INPUT	},
	{ "reset",	CF_RESET	},
I 5
	{ "init",	CF_INIT		},
E 5
	{ "from",	CF_FROM		},
I 6
	{ "dump",	CF_DUMP		},
E 6
	{ "set",	CF_SET		},
	{ "use",	CF_USE		},
	{ "is",		CF_IS		},
	{ "to",		CF_TO		},
	{ NULL,		-1		}
};

I 2
/*
 * instrw installs the reserved words
 */
E 2
instrw() {
	register struct ident *id;

	for (id = &reswords[0]; id->id_name != NULL; id++) {
		if (install(id->id_name, ST_IDENT, (char *) id) == NULL) {
D 4
			err(1, "instrw: can't install reserved words");
E 4
I 4
			err(ERR_LEX, "instrw: can't install reserved words");
E 4
			return(RET_ERR);
		}
	}

	return(RET_OK);
}
E 1
