h57865
s 00001/00001/00091
d D 1.5 84/07/24 13:40:53 rusty 5 4
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00003/00002/00089
d D 1.4 84/07/24 13:00:41 rusty 4 3
c changed error messages to use bits in elevel instead of ranges of values
e
s 00009/00008/00082
d D 1.3 84/04/24 11:53:05 rusty 3 2
c added error message for unknown symbolic channel
e
s 00011/00010/00079
d D 1.2 84/04/02 17:52:15 rusty 2 1
c added a few comments, fixed a bug in ss_conn.c and ss_disconn.c
e
s 00089/00000/00000
d D 1.1 84/04/02 17:08:47 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <stdio.h>
I 4
# include "aswdaemon.h"
E 4
# include "client.h"
# include "clerr.h"

D 2
# define return_status

E 2
struct clerrtab clerrtab[] = {
D 3
	{ ASW_ERR_AOK,		"ok"			},
	{ ASW_ERR_CHAN,		"invalid channel"	},
	{ ASW_ERR_DEVIO,	"device or i/o error"	},
	{ ASW_ERR_PROG,		"daemon software error"	},
	{ ASW_ERR_SUBL,		"sublist error"		},
	{ ASW_ERR_SYNTAX,	"syntax error"		},
	{ ASW_ERR_NOTCONN,	"not connected"		},
	{ -1,			NULL			}
E 3
I 3
	{ ASW_ERR_AOK,		"ok"				},
	{ ASW_ERR_CHAN,		"invalid channel"		},
	{ ASW_ERR_DEVIO,	"device or i/o error"		},
	{ ASW_ERR_PROG,		"daemon software error"		},
	{ ASW_ERR_SUBL,		"sublist error"			},
	{ ASW_ERR_SYNTAX,	"syntax error"			},
	{ ASW_ERR_NOTCONN,	"not connected"			},
	{ ASW_ERR_SYMCHAN,	"unknown symbolic channel"	},
	{ -1,			NULL				}
E 3
};

/*
 * return an error message to a
 * client. if flag is non-zero then
 * include the error message indicatd
 * by errno.
 */
clerrmsg(flag) {
	extern int errno, sys_nerr;
	extern char *sys_errlist[];
	register struct clerrtab *ce;
	register char *bp;
	char buf[BUFSIZ];

	if (client.cl_fsock == NULL)
		return;

	bp = &buf[0];

I 2
	/*
	 * linear search for the error message
	 * corresponding to this client's error.
	 */
E 2
	for (ce = &clerrtab[0]; ce->ce_str != NULL; ce++) {
		if (ce->ce_err == client.cl_err) {
			sprintf(bp, "%s", ce->ce_str);
			bp += strlen(bp);
			break;
		}
	}

I 2
	/* shouldn't happen */
E 2
	if (ce->ce_str == NULL) {
		sprintf(bp, "unknown error");
		bp += strlen(bp);
	}

I 2
	/*
	 * incorporate the errno message. must check that
	 * cl_err is set; sometimes errors local to the
	 * daemon set errno (log them if so).
	 */
E 2
	if ((errno != 0) && flag) {
		if (client.cl_err != ASW_ERR_AOK) {
			sprintf(bp, ": ");
			bp += strlen(bp);

			if ((unsigned) errno > sys_nerr)
				sprintf(bp, "error %d", errno);
			else
				sprintf(bp, sys_errlist[errno]);
			bp += strlen(bp);
		}
		else {
			char	buf2[BUFSIZ];

			if ((unsigned) errno > sys_nerr)
				sprintf(buf2, "error %d", errno);
			else
				sprintf(buf2, sys_errlist[errno]);
D 4
			err(1, "clerrmsg: %s", buf2);
E 4
I 4
D 5
			info(1, "clerrmsg: %s", buf2);
E 5
I 5
			info(INFO_USER, "clerrmsg: %s", buf2);
E 5
E 4
		}
	}

D 2
# ifdef return_status
# ifdef notdef
	fseek(client.cl_fsock, (long) 0, 2);
	fprintf(client.cl_fsock, buf);
# else notdef
E 2
	/*
D 2
	 * strlen+1 so we send the trailing null
E 2
I 2
	 * strlen+1 so to send the trailing null
E 2
	 */
	if (write(client.cl_sock, buf, strlen(buf)+1) != strlen(buf)+1)
D 4
		err(1, "clerrmsg: write: %m");
E 4
I 4
		err(ERR_SYSTEM, "clerrmsg: write: %m");
E 4
D 2
# endif notdef
# endif return_status
E 2
}
E 1
