h19263
s 00002/00002/00044
d D 1.4 84/07/24 13:01:33 rusty 4 3
c changed error messages to use bits in elevel instead of ranges of values
e
s 00004/00004/00042
d D 1.3 84/07/24 12:21:01 rusty 3 2
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00002/00000/00044
d D 1.2 84/04/11 14:52:16 rusty 2 1
c clear errno on interrupted connections
e
s 00044/00000/00000
d D 1.1 84/04/11 13:19:44 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <errno.h>
# include <ctype.h>
# include <stdio.h>
# include "client.h"
# include "aswdaemon.h"

/*
 * clconn
 *
 * clconn accepts a client connection.
 */
clconn() {
	extern int errno;
	extern char *inet_ntoa();
	register struct hostent *hp;

	client.cl_addrlen = sizeof(client.cl_addr);
	if ((client.cl_sock = accept(sock, (struct sockaddr *) &client.cl_addr, &client.cl_addrlen)) == -1) {
		if (errno != EINTR)
D 4
			err(1, "clconn: accept: %m");
E 4
I 4
			err(ERR_IPC, "clconn: accept: %m");
E 4
I 2
		errno = 0;

E 2
		return(RET_ERR);
	}

	if ((client.cl_fsock = fdopen(client.cl_sock, "r")) == NULL) {
D 4
		err(1, "clconn: fdopen");
E 4
I 4
		err(ERR_IPC, "clconn: fdopen");
E 4
		return(RET_ERR);
	}

	if ((hp = gethostbyaddr((char *) &client.cl_addr.sin_addr, sizeof(client.cl_addr.sin_addr), AF_INET)) == NULL)
D 3
		debug(1, "clconn: hostaddr=%s", inet_ntoa(client.cl_addr.sin_addr));
E 3
I 3
		debug(DB_IPC, "clconn: hostaddr=%s", inet_ntoa(client.cl_addr.sin_addr));
E 3
	else
D 3
		debug(1, "clconn: host=%s", hp->h_name);
E 3
I 3
		debug(DB_IPC, "clconn: host=%s", hp->h_name);
E 3

D 3
	debug(1, "clconn: port=%d", ntohs(client.cl_addr.sin_port));
	debug(1, "clconn: sock=%d", client.cl_sock);
E 3
I 3
	debug(DB_IPC, "clconn: port=%d", ntohs(client.cl_addr.sin_port));
	debug(DB_IPC, "clconn: sock=%d", client.cl_sock);
E 3

	return(RET_OK);
}
E 1
