h59635
s 00081/00001/00066
d D 1.2 84/11/27 17:11:56 rusty 2 1
c added code for -R flag
e
s 00067/00000/00000
d D 1.1 84/04/05 12:24:45 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>

I 2
static char	buf[BUFSIZ];

E 2
main(argc, argv)
	char	**argv;
{
	extern	char *disconnasw();
	extern	char *strsave();
	extern	char *connasw();
I 2
	extern	char *sendasw();
E 2
	char	*msg;
	char	*pv;
	char	resasw;
	int	i, j;

	for (i = 1; i < argc; i++) {
		pv = argv[i];
D 2
		if (pv[0] != '-')
E 2
I 2
		if (pv[0] != '-') {
			usage();
E 2
			break;
I 2
		}
E 2
		for (j = 1; pv[j] != NULL; j++) {
			switch (pv[j]) {
I 2
				/* raw mode */
				case 'R':
					if (pv[j+1] == NULL)
						err("-R needs arg");
					else {
						if ((msg = sendasw(&pv[j+1])) != NULL)
							err(msg);
					}
					goto contin;

				/* connect */
E 2
				case 'c':
					if (pv[j+1] == NULL)
						err("-c needs arg");
					else {
						if ((msg = connasw(&pv[j+1], NULL)) != NULL)
							err(msg);
					}
					goto contin;

I 2
				/* disconnect */
E 2
				case 'd':
					if ((msg = disconnasw()) != NULL)
						err(msg);
					goto contin;

I 2
				/* reset */
E 2
				case 'r':
					resetasw();
					break;
I 2

				/* help */
				case 'h':
					help();
					break;

				/* oops */
				default:
					usage();
					break;
E 2
			}
		}
		contin:;
	}

I 2
	if (i == 1)
		usage();

E 2
	exit(0);
}

I 2
help() {
	fprintf(stderr, "asw: usage: asw [-coutput_device] [-d] [-r] [-Rstring\n");
	fprintf(stderr, "\t-c connects your input space to \"output_device\"\n");
	fprintf(stderr, "\t-d disconnects your input space to any outputs\n");
	fprintf(stderr, "\t-r disconnects all input spaces from all outputs\n");
	fprintf(stderr, "\t-R sends the string ``as is'' to the asw daemon\n");
}

usage() {
	fprintf(stderr, "asw: usage: asw [-cdacs] [-d] [-r]\n");
	exit(1);
}

E 2
err(msg)
	char *msg;
{
	fprintf(stderr, "%s\n", msg);
	exit(1);
}

char *
strsave(str)
register char *str;
{
	extern char *malloc();
	register char *chp;

	if ((chp = malloc(strlen(str)+1)) == NULL)
		return(NULL);

	strcpy(chp, str);

	return(chp);
I 2
}

char *
sendasw(msg)
	char	*msg;
{
	int	len;
	int	fd;

	fprintf(stderr, "sending \"%s\"\n", msg);

	if ((fd = openasw()) == -1)
		return("can't connect to asw daemon");

	len = strlen(msg);
	if (write(fd, msg, len) != len) {
		closeasw(fd);
		return("write to asw daemon failed");
	}
	if (write(fd, "\n", 1) != 1) {
		closeasw(fd);
		return("write (newline) to asw daemon failed");
	}

	if ((len = read(fd, buf, sizeof(buf))) > 0) {
		closeasw(fd);
		buf[len] = NULL;
		if (strcmp(buf, "ok") != 0) {
			closeasw(fd);
			return(buf);
		}
	}

	closeasw(fd);

	return(NULL);
E 2
}
E 1
