/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>
# include <carl/dx7.h>

# define UCH(ch)	((unsigned char) ch)

int bug;
char *curfile;
int voicen, channel;

main(argc, argv) 
	char **argv;
{
	extern u_char	ck_sum();
	int		ich, ch;
	u_char		uch;
	u_char		buf[BUFSIZ];
	register int	len;
	FILE 		*fid;
	int 		nfds;
	int		hit = 0;

	while ((ch = crack(argc, argv, "hvc|", 0)) != '\0') {
		switch (ch) {
			case 'c':
				channel = atol(arg_option);
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}

	if (arg_index == argc)
		usage();
	else
		for (nfds = 0; nfds < argc - arg_index && voicen < 32; nfds++) {
			curfile = argv[nfds + arg_index];
			if (fid = fopen(curfile, "r")) {
				for (len = get_dx7_voice(buf, fid); 
				    len > 0; len = get_dx7_voice(buf, fid)) {
					massage32v(buf);
					if (++voicen >= 32)
						break;
					hit++;
				} 
			} else {
				fprintf(stderr, "fopen: ");
				perror(argv[nfds + arg_index]);
				exit(1);
			}
			fclose(fid);
		}

	if (hit) {
		if (voicen < 32)
			fprintf(stderr, "mpu32v: only %d voice%c read.\n", 
				voicen,
				voicen == 1 ? ' ' : 's');
		v32out();
		exit(0);
	} else {
		fprintf(stderr, "mpu32v: no voices read.\n");
		exit(1);
	}
}

get_dx7_voice(buf, fid)
	u_char *buf;
	FILE *fid;
{
	int n, ich, i, cksum = 0;
	u_char uch;

	/* get to SX data */
	while ((ich = getc(fid)) != EOF) {
		if (ich == SX_CMD) {
			ungetc(ich, fid);
			break;
		}
	}
	if (ich == EOF)
		return(-1);
	if ((n = fread(buf, sizeof(u_char), 163, fid)) != 163) {
		fprintf(stderr, "fread: ");
		perror(curfile);
		exit(1);
	}
	if (buf[3] != 0) {
		fprintf(stderr, "%s: system exclusive code is not 1-voice bulk data format\n", curfile);
		return(-1);
	}
	for (i = 0; i < 155; i++)
		cksum += buf[6+i];
	cksum = 0x80 - (0x7f & cksum);
	buf[161] = cksum;
	return(163);
}

usage(ex)
{
fprintf(stderr,
"usage: mpusendvoice [-c] mpu_data_file ...\n\
flag:\n\
	-cN	assign first voice to channel N\n\
");
exit(ex);
}

u_char v32buf[32][128];

massage32v(buf)
	u_char *buf;
{
	u_char *v = &buf[6];
	u_char *V = v32buf[voicen];
	int i, j, p;

	for (i = j = 0; i < DX7VOXLEN; i++) {
		p = i % DX7OPLEN;
		switch (p) {
		case 12:	/* keyboard level scaling right curve 12 => 11*/
			V[j+11] |= v[i] << 2; break;
		case 13:	/* keyboard rate scaling 13 => 12 */
			V[j+12] = v[i]; break;
		case 14:	/* amplitude mod. sens. 14 => 13 */
			V[j+13] = v[i]; break;
		case 15:	/* key vel. sens. 15 => 13<<2 */
			V[j+13] |= v[i] << 2; break;
		case 16:	/* op. output level 16 => 14 */
			V[j+14] = v[i]; break;
		case 17:	/* osc. mode 17 => 15 */
			V[j+15] = v[i]; break;
		case 18:	/* osc. freq. coarse 18 => 15<<1 */
			V[j+15] |= v[i] << 1; break;
		case 19:	/* osc. freq. fine 19 => 16 */
			V[j+16] = v[i]; break;
		case 20:	/* osc detune 20 => 12<<3; */
			V[j+12] |= v[i] << 3; j += 17; break;
		default:
			V[j+p] = v[i]; break;
		}
	}
	i = 126; p = 102;
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* alg. sel. */
	V[111] = v[135];	/* feedback */
	V[111] |= v[136] << 3;	/* osc. key sync. */
	i = 137; p = 112;
	V[p++] = v[i++];	/* lfo speed */
	V[p++] = v[i++];	/* lfo delay */
	V[p++] = v[i++];	/* lfo pmd */
	V[p++] = v[i++];	/* lfo amd */
	V[116] = v[141];	/* lfo key sync */
	V[116] |= v[142] << 1;	/* lfo wave */
	V[116] |= v[143] << 4;	/* lfo pitch mod. sens. */
	V[117] = v[144];	/* transpose */
	i = 145; p = 118;
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
}

v32out()
{
	int v, p, check_sum = 0;

	putchar(0xff);		/* reset */
	putchar(0xf0);		/* system exclusive */
	putchar(0x43);		/* Yamaha id */
	putchar(channel & 0xf0);/* channel and substatus */
	putchar(0x09);		/* format */
	putchar(0x20);		/* byte count, msb */
	putchar(0x00);		/* byte count, lsb */
	for (v = 0; v < 32; v++) {
		for (p = 0; p < 128; p++) {
			int x = v32buf[v][p];
			putchar(x);
			check_sum += x;
		}
	}
	check_sum = 0x80 - (0x7f & check_sum);
	putchar(check_sum);
	putchar(0xf7);
}
