# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/dx7.h>
# include <carl/mpu.h>
# include <math.h>

int otty;

main(argc, argv)
	char ** argv;
{
	extern char	*malloc();
	extern struct 	mpu_cmd *get_mpu_cmd();
	struct mpu_cmd *mp;
	int		ch; 
	long 		offset = 0;

	otty = isatty(1);

	if ((mp = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) == NULL) {
		perror("malloc");
		exit(1);
	}

	while ((ch = crack(argc, argv, "h", 1)) != '\0') {
		if (ch == 'h')
			usage(0);
	}

	while ((mp = get_mpu_cmd(stdin, mp)) != NULL) {
		if (mp->cmd_type == CH_KEY_ON || mp->cmd_type == CH_KEY_OFF) {
			break;
		}
	}
	mp->time_tag = 0;
	do {
		put_mpu_cmd(stdout, mp);
	} while ((mp = get_mpu_cmd(stdin, mp)) != NULL);
	exit(0);
}


usage(ex)
{
fprintf(stderr, "%s",
"usage: mpuoffset < mpu_data_file > offset_mpu_data\n"
);
exit(ex);
}
