/*
 * CARL MIDI Performance Toolkit @(#)miditune.c	1.1 2/15/87
 * Xavier Chabot
 */

#include <stdio.h>
#include <math.h>
#include <string.h>


#include "xmpu.h"
#include "moxc.h"
#include "scale.h"	/* has to included after xmpu.h	*/

/* 
 * library to communicate scale tuning to MIDI
 * See also libscale.c to build and print scales.
 */

static BOOL debug = FALSE ;
  
PlaySequence(scale,pitchlist,octave,duration)
SCALE *scale ;			/* scale definition */
int pitchlist[] ;		/* list of indexes in note_list[] */
int octave ;			/* octave from which to start */
/*
 * Prints from octmin to octmax octaves of frequencies of the scale
 */
{
	register i ;
	int pitch ;
	int oct ;
	extern PlayPitch() ;

	cause(0,PlayPitch,scale,pitchlist,0,octave,duration);
	return 0 ;
}

PlayPitch(scale,pitchlist,index,octave,duration)
SCALE *scale ;			/* scale definition */
int pitchlist[] ;
int index ;			/* index in pitchliste[]/
int octave ;			/* octave from which to start */
{

	int pitch , oct , midikey ;

	if(!scale) {
		fprintf(stderr,"scale not defined\n");
		return -1 ;
	}
	if((pitch = pitchlist[index]) != -1) {
	    pitch = (pitch + scale->scale_base_note -1)%21 ;
	    oct = pitch / 21 ;
	    midikey = scale->scale_midikey[pitch] +
			12 * oct; /* C0 is 24 */
	mpu_wpib(mpu_nb_synth,0,scale->scale_pitchbend[index]);
	mpu_kon(mpu_nb_synth,0,midikey,100);
	cause(duration,mpu_koff,mpu_nb_synth,0,midikey);
	cause(duration+10,PlayPitch,scale,pitchlist,++index,octave,duration);
DB	PX(midikey);
	} 
  return 0;
}


mpu_scale_kon(mpu_nb,chan,scale,key,vel)
SCALE *scale ;
/*
 * Sends a pitch defined by the MIDI key value and tune by the scale definition
 * pointed to by SCALE \f2*scale\f1. SCALE \f2*scale\f1 must have been 
 * previously defined by one of the function in \f2libscale.c\f1 or
 * customized (use templates in \f2libscale.c\f1).
 * If \f2scale\f1 is not defined, no pitch bend is written.
 * It calls \f2mpu_kon\f1(3MPU) and \f2mpu_wpib\f1(3MPU).
 * Returns 0 if success, -1, -2 or -3 if error.
 * .SH SEE ALSO 
 * \f2mpu_kon\f1(3MPU), \f2mpu_wpib\f1(3MPU), \f2mpu_koff\f1(3MPU),
 * \f2mpu_scale_koff\f1(3MPU).
 * .SH BUGS
 * Not very efficient.
 */
{
	register int *keylist;
	register i ;
	int vkey ;
	int octave ;
 if(scale) {
	keylist = scale->scale_midikey ;/* for efficiency	*/
	if(key >= keylist[0]) {
		octave = (key - keylist[0]) /12 ;
	} else {
		octave = (key - keylist[0]) /12  -1;
	}
	vkey = key - octave * 12 ;
DB	PX(keylist[0]);
DB	PX(key);
DB	P(octave);	
DB	PX(vkey);
	for(i=20;i>=0;keylist++,i--) {
		if(vkey == *keylist) goto foundit ;
	}
	fprintf(stderr,"key Ox%x not found in scale\n",key);
foundit:
	mpu_wpib(mpu_nb,chan,scale->scale_pitchbend[i]);
 }
 mpu_kon(mpu_nb,chan,key,vel);
 return 0;
}

mpu_scale_koff(mpu_nb,chan,scale,key)
SCALE *scale ;
/*
 * Sends a key preceeded by a null pitch bend.
 * It calls \f2mpu_koff\f1(3MPU) and \f2mpu_wpib\f1(3MPU).
 * Returns 0 if success, -1 if error.
 * .SH SEE ALSO 
 * \f2mpu_kon\f1(3MPU), \f2mpu_wpib\f1(3MPU), \f2mpu_koff\f1(3MPU),
 * \f2mpu_scale_kon\f1(3MPU).
 * .SH BUGS
 * Not very efficient.
 */
{
 if(scale) {
	mpu_wpib(mpu_nb,chan,0x2000);/* null pitch bend (wpib does * 2) */
 }
	return (mpu_koff(mpu_nb,chan,key));
}
