/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/midi.h>
# include <carl/mpu.h>

/* ef 90 48 40 ;    2.395      1 kon   [ 72]=64  C5 key on */

main(argc, argv)
	char **argv;
{
	extern char *index();
	char buf[BUFSIZ];

	while (fgets(buf, BUFSIZ, stdin) != NULL) {
		register char *c = index(buf, ';');

		if (c == NULL) {
			fprintf(stderr, "mpura: format error\n");
			exit(1);
		} else {
			double time;
			int cmd[BUFSIZ], present[BUFSIZ];

			*c++ = '\0';
			parse_midi(cmd, present, buf);
			sscanf(c, "%lf", &time);
			put_cmd(cmd, present, time);
		}
	}
}	

# define FIELD_WIDTH	(3)
# define FIELDS(x)	(x * FIELD_WIDTH -1)

parse_midi(obuf, present, ibuf)
	int *obuf, *present; 
	char *ibuf;
{
	register int i, j;

	for (i = 0, j = 0; i < FIELDS(6); i += FIELD_WIDTH, j++) {
		if (ibuf[i] == '\0')
			break;
		ibuf[i+2] = '\0';
		if (ibuf[i+1] != ' ') {
			sscanf(ibuf+i, "%x", obuf+j);
			present[j] = 1;
		} else
			present[j] = 0;
	}
}

put_cmd(cmd, present, time)
	int *cmd, *present;
	double time;
{
	static long 	now;
	long		ticks, interval;
	int 		i; 

	if (cmd[1] == RT_TCIP)
		return;
	ticks = time * MPU_TPS(100., 120.);
	interval = ticks - now;
	while (interval >= 240) {
		putchar(0xf8);
		interval -= 240;
	}
	putchar(interval);

	for (i = 1; i < 4; i++) {
		if (present[i])
			putchar(cmd[i]);
	}

	now = ticks;
}
