/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <signal.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

# define MPU_TRACK(x) (1 << x)

char		mpu[] = MPU_DEV_0;
char		tty[] = "/dev/tty";
u_char		mpu_cmds[BUFSIZ];
int		ifds[20] = {
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

main(argc, argv) 
	char **argv;
{
	extern	int synth_reset();
	u_char	buf[BUFSIZ];
	char	*cmd_file = NULL;
	int	mpu_fd,
		setup_len,
		track,
		ret_wait = 0,
		n,
		ch,
		nfds = 0,
		cur_fd = 0,
		itty = isatty(0),
		s_reset = 1;


	/* always catch interrupts */
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, synth_reset);

	(void) setup_cmds(mpu_cmds, 0xff);		/* reset mpu */

	while ((ch = crack(argc, argv, "rc|mMb|B|t|hw", 1)) != '\0') {
		switch (ch) {
			case 'B':
				{
				register int tmp = sfexpr(arg_option, 1.0);
				if (tmp < 48 || tmp > 192) {
					fprintf(stderr, "illegal timebase\n");
					exit(1);
				}
				tmp = (tmp - 48) / 24;
				(void) setup_cmds(mpu_cmds, tmp + 0xc2);
				break;
				}
			case 'M':
				(void) setup_cmds(mpu_cmds, MPU_METRO_ACC);
				break;
			case 'b':
				(void) setup_cmds(mpu_cmds, MPU_METRO_MEAS);
				ch = sfexpr(arg_option, 1.0);
				(void) setup_cmds(mpu_cmds, ch);
				break;
			case 'c':
				cmd_file = arg_option;
				break;
			case 'h':
				usage(0);
			case 'm':
				(void) setup_cmds(mpu_cmds, MPU_METRO_NO_ACC);
				break;
			case 'r':
				s_reset = 0;
				break;
			case 't':
				(void) setup_cmds(mpu_cmds, MPU_TEMPO);
				ch = sfexpr(arg_option, 1.0);
				(void) setup_cmds(mpu_cmds, ch);
				break;
			case 'w':
				ret_wait = 1;
				break;
			default:
				usage(1);
		}
	}

	if (itty && argc == arg_index)
		usage(1);	/* no input files, and no stdin */
	else if (!itty) {	/* read from stdin */
		ifds[0] = 0;
		nfds = 1;
	} else {
		if (argc - arg_index >= 20) {
			fprintf(stderr, "mpuplay too many files!\n");
			usage(1);
		}
		for (nfds = 0; nfds < argc - arg_index; nfds++) {
			if ((ifds[nfds] = open(argv[nfds + arg_index], 0))
			    == -1) {
				fprintf(stderr, "mpuplay: %s ", 
					argv[nfds + arg_index]);
				perror("open");
			}
		}
	}

	/* open for reading and writing */
	if ((mpu_fd = open(mpu, 2)) == -1) {
		fprintf(stderr, "open:");
		perror(mpu);
		exit(1);
	}

	/* pre-write first midi buffer */
	/* tell the driver to expect track 0 data */
	track = 0;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1)
		exit(2);
	/* and write first data buffer */
	if ((n = read(ifds[cur_fd], buf, BUFSIZ)) > 0) {
		if (write(mpu_fd, buf, n) != n) {
			perror("write");
			exit(3);
		}
	}

	/* tell the driver to expect command data */
# ifdef CARLDRIVER
	track = MPU_TR_COM;
# else !CARLDRIVER
	track = MPU_CTR_COM;
# endif CARLDRIVER
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1)
		exit(4);
	/* user specified command file? */
	if (cmd_file != NULL) {
		FILE *cmd_fid;
		u_char str_buf[BUFSIZ], cmd;

		if ((cmd_fid = fopen(cmd_file, "r")) == NULL) {
			fprintf(stderr, "fopen:");
			perror(cmd_file);
			exit(1);
		}
		while (fscanf(cmd_fid, "%s", str_buf) == 1) {
			cmd = sfexpr(str_buf, 1.0);
			setup_len = setup_cmds(mpu_cmds, cmd);
		}
		fclose(cmd_fid);
	} else {
		/* start up mpu */
		(void) setup_cmds(mpu_cmds, 0xec);		/* active track */
		(void) setup_cmds(mpu_cmds, MPU_TRACK(0));	/* track 0 */
		(void) setup_cmds(mpu_cmds, 0xb8);		/* clear play */
		(void) setup_cmds(mpu_cmds, 0x87);		/* bender on */
		setup_len = setup_cmds(mpu_cmds, 0x0a);	/* play on */
	}

	/* wait for user to say start? */
	if (ret_wait) {
		int tty_fd;

		if ((tty_fd = open(tty, 2)) == -1) {
			fprintf(stderr, "open: ");
			perror(tty);
			exit(1);
		}
		fprintf(stderr, "Press [RETURN] to play\t");
		fflush(stderr);
		if (iwait(tty_fd, 3600L) == 0) {
			fprintf(stderr, "timeout, aborting.\n");
			exit(1);
		} else
			read(tty_fd, &ch, 1);
	}

	/* go for it! */
	if (write(mpu_fd, mpu_cmds, setup_len) != setup_len) {
		perror("write");
		exit(5);
	}

	/* shove over the rest */
	/* tell the driver to expect track 0 data */
	track = 0;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1)
		exit(6);
	while (nfds--) {
		while ((n = read(ifds[cur_fd], buf, BUFSIZ)) > 0) {
			if (write(mpu_fd, buf, n) != n) {
				perror("write");
				exit(7);
			}
		}
		cur_fd++;
	}
	if (close(mpu_fd) != 0)
		exit(8);
	if (s_reset)
		synth_reset(-1);
	exit(0);
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s",
"usage:	mpuplay [flags] mpu_data_file ...\n",
"or:	mpuplay [flags] < mpu_data_file\n",
"flags:\n",
"\t-cS\tsend configuration file S to MPU\n",
"\t-w\twait for [RETURN] to start\n",
"\t-m\tturn on MPU metronome, no accent\n",
"\t-M\tturn on MPU metronome, with accent\n",
"\t-bN\tset number of beats per measure to N\n",
"\t-BN\tset mpu internal timebase to 48, 72, 96, 120, 144, 168, 192\n",
"\t-tN\tset tempo to N beats per minute\n",
"\t-rX\tsuppress synthesizer reset at finish\n"
);
exit(ex);
}
