#include <stdio.h>
#include <midi.h>

#d transform(m) TransformMpuCmd(m,a,b,A,B)
# define NNOTES 1024

#include <sys/ioctl.h>
#include <mpuvar.h>

PutNote(midi, track, chan, pitch, velocity)
/*
** Start a note playing with the given 'pitch' and 'velocity'
** on 'track' ('0-7') on the 'midi' device.
** 'velocity=0' means "note off".
** 'midi' is the file descriptor for the MPU-401 device.
** The note is played instantaneously, and has no time tag.
** This routine uses the 'MPU_WANT_TO_SEND_DATA' feature
** of the MPU-401 to transmit MIDI data independent of
** time schedules (ie, just poke MIDI data down the pipe
** without time tags).  Similar functions could be written
** to transmit program changes, after touch, etc;
** see sec. 5.9 of the MPU-401 manual.
*/
{
	static unsigned char s[4] = {0, CH_KEY_ON, 0, 0};
	s[0] = MPU_WANT_TO_SEND_DATA + track;
	s[1] = CH_KEY_ON + chan;
	s[2] = (unsigned char) pitch;
	s[3] = (unsigned char) velocity;
	MpuSetTrack(midi,MPU_TR_COM);
	write(midi,s,4);
	MpuSetTrack(midi,track);
}

FILE *
Open(s){
	FILE *f = sopen(s,"r");
	return f? f : OpenTune(s);
}

pitch(s) char *s; { return (*s >= '0' && *s <= '9')? atoi(s) : ptoi(s); }


main(ac,av) char *av[]; 
{
	Int i=1, a=dx7_MIN, b=dx7_MAX, A=dx7_MAX, B=dx7_MIN, midi;
	FILE *Midi;
	MpuCmd *m=Alloc(MpuCmd);
	int track = 0, chan = 0, base = 1, gkeys[NNOTES], durs[NNOTES], 
		nkeys = 0, bug = 0, measn = 0, state;

	for_each_argument {
	Case 'c': chan = atoi(argument)-1;
	Case 't': track = atoi(argument)-1;
	Case 'b': bug = atoi(argument);
	Default: MidiError("%s [-{c,n,t}] [files or stdin]\n", av0);
		 exit(1);
	}

	if ((midi = open(MidiDevice, 2)) == -1)
		MidiError("%s can't open %s\n", av0, MidiDevice);
#d mp(x) MpuSet(MPU_/**/x)
	mp(RESET), mp(BENDER_ON), mp(MIDI_THRU_OFF), mp(START_RECORD);
	Midi = fdopen(midi,"r+"); setbuf(Midi,NULL);
	MpuFlush(midi);
	fprintf(stderr, "test:\n");
	fprintf(stdout, "test:\n");
	while (!iwait(0,0))
	    while(iwait(midi,0) && GetMpuCmd(Midi,m)){
		if (!IsNote(m)) {
			if (m->mpu_cmd[0] == 0xc0) {
				/* prog change */
				if (!(state++%2)) {
				    register int x = m->mpu_cmd[1];
				    durs[nkeys] = x-32 < 0 ? x : x-32;
				    pr(stderr, gkeys, durs, nkeys+1, nkeys);
				    fprintf(stderr, ", ");
				    nkeys = nkeys+1>=NNOTES ? nkeys : nkeys+1;
				} else {
				    pr(stdout, gkeys, durs, nkeys, 0);
				    fprintf(stderr, " *\n");
				    fprintf(stdout, ",\n");
				    nkeys = 0;
				}

			} 
			else if (m->mpu_cmd[0] == 0xb0 && m->mpu_cmd[1] == 0x61) {
				/* no */
				fprintf(stderr, "\\\n");
				nkeys = 0;
				state = 0;
			}
			else if (m->mpu_cmd[0] == 0xb0 && m->mpu_cmd[1] == 0x60) {
				/* yes */
				fprintf(stderr, "|%d\n", measn);
				fprintf(stdout, "|%d\n", measn);
				measn++;
				state = 0;
			}
			else if (m->mpu_cmd[0] == 0xb0 && m->mpu_cmd[1] == 0x40
			    && m->mpu_cmd[2] != 0) {
				/* sust. pedal down */
				gkeys[nkeys] = -1;
				state = 0;
			}
		} else {
			PutNote(midi, track, chan, MpuPitch(m), MpuVelocity(m));
			if (MpuVelocity(m)) {
				gkeys[nkeys] = MpuPitch(m);
			}
			state = 0;
		}
	    }
	close(midi);
	dx7_reset(-1);
	printf("\n");
	fprintf(stderr, "Kill;\n");
	fprintf(stdout, "Kill;\n");
	exit(0);
}

char *pc[12] = 
	{"c", "cs", "d", "ds", "e", "f", "fs", "g", "gs", "a", "as", "b"};

pr(stream, keys, durs, nkeys, offset)
	FILE *stream; int keys[], durs[], nkeys, offset;
{
	int i, notfirst = 0;

	if (nkeys-offset <= 0)
		return;
	for (i = offset; i < nkeys; i++) {
	    if (notfirst++)
		fprintf(stream, " & ");
	    if (keys[i] == -1)
	    	fprintf(stream, "r %d", durs[i]+1);
	    else
	    	fprintf(stream, "%s%d %d", 
			pc[keys[i]%12], (keys[i]/12)-1, durs[i]+1);
	}
	fflush(stream);
}
