/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/dx7.h>
# include <carl/mpu.h>
# include <math.h>

# define NOTE_FACTOR		4
# define EIGHTH_NOTE		8

int otty;

main(argc, argv)
	char ** argv;
{
	extern char	*malloc();
	extern struct 	mpu_cmd *get_mpu_cmd();
	struct mpu_cmd *mp;
	int		ch; 
	long 		just = 0,
			offset = 0;
	double 		Mfac = 1.0;
	FILE		*fid;

	otty = isatty(1);

	if ((mp = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) == NULL) {
		perror("malloc");
		exit(1);
	}

	while ((ch = crack(argc, argv, "t|", 1)) != '\0') {
		if (ch == 't') {
				Mfac = sfexpr(arg_option, 1.0);
				if (Mfac != 0.0)
					Mfac = 60.0 / Mfac;
				else
					Mfac = 1.0;
		}
	}
	arg_index = 0;
	while ((ch = crack(argc, argv, "t|j|h", 0)) != '\0') {
		switch (ch) {
			case 't':
				break;
			case 'j':
				just = sfexpr(arg_option, 1.0);
				if (just == 0)
					just = 1; /* smallest grain */
				else
					just = Mfac *
					    MPU_DEFAULT_TICS_PER_SEC
					    * NOTE_FACTOR
					    / just;
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}
	if (just == 0)
		just = 1;	/* smallest grain */

	if (arg_index == argc)
		usage(1);

	if ((fid = fopen(argv[arg_index], "r")) == NULL) {
		perror("fopen");
		exit(1);
	}

	while ((mp = get_mpu_cmd(fid, mp)) != NULL) {
		offset += mp->mpu_time;
		if (mp->cmd_type == CH_KEY_ON || mp->cmd_type == CH_KEY_OFF)
			break;
	}
	rewind(fid);

	while ((mp = get_mpu_cmd(fid, mp)) != NULL) {
		register int i;
		static long time, otime;
		register long jtime;

		time += mp->mpu_time;
		if (mp->cmd_type != CH_KEY_ON && mp->cmd_type != CH_KEY_OFF)
			continue;
		otime = time - offset;
		jtime = otime - (otime % just);
		if (otime % just > just / 2)
			jtime += just;
		ptime(jtime);
		if (mp->time_tag != RT_TCIP) {
			for (i = midi_cmd_in_cont(); 
			     i < midi_cmd_in_arg_cnt()+1; i++) {
				if (otty)
					printf("%x\t", mp->mpu_cmd[i]);
				else
					putchar(mp->mpu_cmd[i]);
			}
		}
		if (otty)
			printf("\n");
	}
	if (!otty) {
		putchar(0);
		putchar(0xf9);
	}
}

ptime(time, cmd_type)
	long time;
	u_char cmd_type;
{
	static long ctime; 
	register long tmp;
	register u_char tc;

	for (tmp = time; tmp - ctime >= MPU_CLOCK_PERIOD; tmp -= MPU_CLOCK_PERIOD)
		if (otty)
			printf("0xf8\n");
		else
			putchar(RT_TCIP);
	tc = tmp - ctime;
	if (otty)
		printf("%d\t", tc);
	else
		putchar(tc);
	ctime += time - ctime;
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s",
"usage: mpujust [flags] mpu_data_file > justified_mpu_data\n",
"flags:\n",
"\t-jD\tset justification to rhythmic duration D\n",
"\t-tN\tset tempo to N beats per minute\n"
);
exit(ex);
}
