#include <stdio.h>
#include <carl/carl.h>
#include <carl/defaults.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/mpu.h>
#include <math.h>

float   timefac = 1.;
int	freq, amp;

main(argc, argv)
	char **argv;
{
	extern char *malloc();
	struct mpu_cmd *mpx;
	FILE *f1;
	int	otty = isatty(1);
	int	ch;
	float	tx = 0.;
	char	px, py;
	char	norm = 0;

	while ((ch = crack(argc, argv, "B|t|fah", 1)) != '\0') {
		switch(ch) {
			case 't':	/* set tempo */
				timefac = sfexpr(arg_option, 1.0) / 60.;
				break;
			case 'f':
				freq++;
				break;
			case 'a':
				amp++;
				break;
			case 'B':
				amp++, freq++;
				break;
			case 'h':
			default:
				usage(0);
		}
	}
	if (argc - arg_index < 1)
		usage(1);

	if ((mpx = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) == NULL){
		perror("malloc");
		exit(1);
	}

	if ((f1 = fopen(argv[arg_index], "r")) == NULL) {
		perror("fopen");
		exit(1);
	}

	while ((mpx = get_mpu_cmd(f1, mpx)) != NULL) {
		if (mpx->mpu_cmd[0] == CH_KEY_ON) {
			int key, vel;
		        
			if (mpx->mpu_cmd[2] != 0) {
				tx += mpx->time_tag;
				key = mpx->mpu_cmd[1];
				vel = mpx->mpu_cmd[2];
				StartNote(tx, key, vel);
			} else {
				int key = mpx->mpu_cmd[1];
				tx += mpx->time_tag;
				CompleteNote(tx, key);
			}
		}
	}
	exit(0);
}

usage(ex)
{
	fprintf(stderr, "usage: mpu2cmus [flags] mpu_data > cmusic_score\n");
	fprintf(stderr, "flags:\n%s%s%s%s",
		"-tMM	set tempo to MM beats per minute\n",
		"-f	convert key index to frequency in Hz\n",
		"-a	convert velocity to amplitude in dB\n",
		"-B	do both -f and -a\n");
	exit(ex);
}

pexit(s)
	char *s;
{
	fprintf(stderr, s);
	exit(1);
}

struct Note {
	float time, dur; 
	int key, vel;
	struct Note *next;
};

struct Note *head = NULL, *current = NULL;

StartNote(time, key, vel)
	float time;
	int key, vel;
{
	struct Note *n;

	if ((n = (struct Note *) malloc(sizeof(struct Note))) == NULL)
		pexit("malloc");
	if (head == NULL) {
		head = n;
		current = head;
	} else {
		current->next = n;
		current = n;
	}
	n->time = time, n->key = key, n->vel = vel, n->next = NULL;
	n->dur = -1.;
}

CompleteNote(time, key)
	float time;
	int key;
{
	struct Note *n;

	for (n = head; n != NULL ; n = n->next) {
		if (key == n->key) {
			PrintNote(n, time);
			Delete(n);
		}
	}
	
}

double Freq(key)
	int key;
{
	double MiddleC = 220. * pow(2., 3./12.);

	return MiddleC * pow(2., (key - 60)/12.);
}

PrintNote(n, time)
	struct Note *n;
	float time;
{
	float beg = n->time / MPU_DEFAULT_TICS_PER_SEC * timefac;
	float dur = (time - n->time) / MPU_DEFAULT_TICS_PER_SEC * timefac;

	printf("note %6.3f x %6.3f ", beg, dur); 
	if (freq)
		printf("%6.3fHz ", Freq(n->key));
	else
		printf("%d ", n->key); 
	if (amp)
		printf("%ddB ", n->vel - 127);
	else
		printf("%d ", n->vel);
	printf("0;\n");
}

Delete(x)
	struct Note *x;
{
	struct Note *n;

	for (n = head; n != NULL ; n = n->next) {
		if (n->next == x) {
			n->next = n->next->next;
			break;
		}
	}
	if (x == head)
		head = head->next;
	if (x == current)
		current = current->next;

}

PrintList()
{
	struct Note *n;

	for (n = head; n != NULL ; n = n->next)
		printf("%6.3f\t%d\t%d\t%6.3f\t%x\n", n->time, n->key, n->vel, n->dur, n->next);
	printf("\n");
	
}
