# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

getvoice(buf, fid)
	u_char	*buf;
	FILE	*fid;
{
	int n, ich, len;

	/* get to SX data */
	while ((ich = getc(fid)) != EOF) {
		if (ich == SX_CMD) {
			ungetc(ich, fid);
			break;
		}
	}
	if (ich == EOF)
		return(-1);
	/* read system exclusive header */
	if ((n = fread(buf, sizeof(u_char), 6, fid)) != 6) {
		perror("getvoice: fread: ");
		return(-1);
	}
	len = (buf[4] << 7) + buf[5];
	if ((buf[2] & 0xf0) != 0) {
		return(-1);
	}
	if (buf[3] == 9)	/* 32-voice bulk dump */
		/* get 4096 data + check_sum + end_of_block */
		return(get_dx7_voice(buf+6, fid, len));
	else
	if (buf[3] == 0)	/* 1-voice bulk dump */
		/* get 155 data + check_sum + end_of_block */
		return(get_dx7_voice(buf+6, fid, len));
	else
		fprintf(stderr, 
		    "mpusendvoice: unknown voice format id=%x\n", buf[3]);
	return(-1);
}

get_dx7_voice(buf, fid, cnt)
	u_char *buf;
	FILE *fid;
{
	extern char *pvname();
	int n, ich, i, cksum = 0;
	u_char uch;

	if ((n = fread(buf, sizeof(u_char), cnt+2, fid)) != cnt+2) {
		perror("fread:");
		return(-1);
	}
	for (i = 0; i < cnt; i++)
		cksum += buf[i];
	cksum = 0x80 - (0x7f & cksum);
	if (buf[cnt] != cksum)
		fprintf(stderr, "warning: %s invalid checksum.\n", 
			pvname(cnt==155?buf+145:buf+118));
	buf[cnt] = cksum;
	/* return header(6), data(155+2 or 4096+2), check_sum and EOB */
	return(6+n);
}

static char *
pvname(name)
	u_char *name;
{
	static char v[11];

	strncpy(v, name, 10);
	v[10] = '\0';
	return(v);
}
