h61473
s 00073/00000/00000
d D 1.1 85/03/28 16:35:11 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <signal.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

/*
 * synth_reset -	end-game or interrupt-level reset of midi synths
 * requires:
 * 	from setup_cmds.c:
 * 	extern int 	set_cnt()	- set position of next byte in buffer
 * 	extern int 	get_cnt()	- report position in buffer
 * 	extern int 	setup_cmds()	- put byte in buffer
 */


synth_reset(sig)
	int sig;
{
	u_char mpu_rst[BUFSIZ];
	char	*mpu =	MPU_DEV_0;
	register int	cnt, mpu_fd;
	int 		track;

	/* open for reading and writing */
	if ((mpu_fd = open(mpu, 2)) == -1) {
		perror("synth_reset:open");
		exit(10);
	}
	set_cnt(0);			/* reset pointer to setup_cmds */
	setup_cmds(mpu_rst, 0xff);	/* reset mpu */
	all_notes_off(mpu_rst);		/* turn off notes */
	dx7_clear(mpu_rst);		/* reset dx7's */
	cnt = get_cnt();

	track = MPU_TR_COM;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1) {
		perror("dx7_reset:ioctl");
		exit(11);
	}
	if (write(mpu_fd, mpu_rst, cnt) != cnt) {
		perror("dx7_reset:write");
		exit(12);
	}
	close(mpu_fd);

	if (sig != -1)
		exit(1);
}

all_notes_off(mpc)
	u_char mpc[];
{
	register int i;

	for (i = 0; i < 16; i++)
		ano_chan(mpc, i);
}

ano_chan(mc, chan)
	u_char mc[];
	int chan;
{
	(void) setup_cmds(mc, 0xd0);	/* mpu want to send data command */
	(void) setup_cmds(mc, CH_CTL | (chan & 0xf));
	(void) setup_cmds(mc, 0xfb);	/* all notes off */
	(void) setup_cmds(mc, 0);	/* dummy  */
}
E 1
