#include <sys/ioctl.h>
#include <sundev/mpuvar.h>

MpuSend(midi,cmds)
/*
** Write the 'cmds' to the 'midi' device.
** 'midi' is a file descriptor obtained with 'open(MidiDevice,2)'
** (for instance), and 'cmds' is a '0'-terminated list of MPU-401 commands.
** For example, before playing notes with 'NoteOn()', 'NoteOff()',
** the device could be initialized with:
** .Cs
** MpuSend(midi, MPU_RESET, MPU_MIDI_THRU_OFF, 0)
** .Ce
** The 'cmds' are buffered up and the whole packet sent in one 'write()'.
*/
{
#define av (char **)(&cmds)
	register i;
	for (i=0; av[i]; i++) MpuSet(av[i]);
	MpuSetTrack(midi,MPU_TR_COM);
	MpuFlush(midi);
#undef av
}
